/*
 * crt0.S -- startup file for m68k-coff
 *
 * Copyright (c) 1995 Cygnus Support
 *
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 * Modifications to this software may be copyrighted by their authors
 * and need not follow the licensing terms described here, provided that
 * the new terms are clearly indicated on the first page of each file where
 * they apply.
 */

	.title "crt0.S for m68k-coff"

/* These are predefined by new versions of GNU cpp.  */

#ifndef __USER_LABEL_PREFIX__
#define __USER_LABEL_PREFIX__ _
#endif

/*
 * some assemblers want a '%', and some want a '$', and some don't 
 * need any at all.
 */
#ifndef __REGISTER_PREFIX__
#define __REGISTER_PREFIX__
#endif

/*
 * some assemblers choke on '#' as an immediate value. As gcc can also
 * use '&', use that in those cases. 
 */
#ifndef __IMMEDIATE_PREFIX__
#define __IMMEDIATE_PREFIX__ #
#endif

/* ANSI concatenation macros.  */
#define CONCAT1(a, b) CONCAT2(a, b)
#define CONCAT2(a, b) a ## b

/* use the right prefix for global labels.  */
#define SYM(x) CONCAT1 (__USER_LABEL_PREFIX__,x)

/* use the right prefix for registers.  */
#define REG(x) CONCAT1 (__REGISTER_PREFIX__,x)

/* use the right prefix for immediate values.  */
#define IMM(x) CONCAT1 (__IMMEDIATE_PREFIX__,x)

/* use the right prefix for register names */
#define d0 REG (d0)
#define d1 REG (d1)
#define d2 REG (d2)
#define d3 REG (d3)
#define d4 REG (d4)
#define d5 REG (d5)
#define d6 REG (d6)
#define d7 REG (d7)
#define a0 REG (a0)
#define a1 REG (a1)
#define a2 REG (a2)
#define a3 REG (a3)
#define a4 REG (a4)
#define a5 REG (a5)
#define a6 REG (a6)
#define fp REG (fp)
#define sp REG (sp)

/*
 * Define an empty environment.
 */
        .data
        .align 2
SYM (environ):
        .long 0

 	.align	2
	.text
	.global SYM (main)
	.global SYM (exit)

/* 
 * these values are set in the linker script, so they must be
 * explicitly named here with the SYM().
 */
	.global __stack
	.global __bss_start
	.global SYM(_end)

/*
 * start -- set things up so the application will run.
 */
SYM (start):
	/* set up stack pointer */	
	moveal  IMM(__stack), sp

	/* set up initial stack frame */
	link	a6, IMM(-8)

/*
 * zerobss -- zero out the bss section
 */
	movel	IMM(__bss_start), d1
	movel	IMM(SYM(_end)), d0
	cmpl	d0,d1
	jbeq	2f
	movl	d1,a0
	subl	d1,d0
1:
	clrb	(a0)+
	dbra	d0,1b
	clrw	d0
	subql	IMM(1),d0
	jbcc	1b
2:

/*
 * call the main routine from the application to get it going.
 * main (argc, argv, environ)
 * we pass argv as a pointer to NULL.
 */
        pea     0
        pea     SYM (environ)
        pea     sp@(4)
        pea     0
	jsr	SYM (main)
	movel	d0, sp@-

/*
 * drop down into exit incase the user doesn't. This should drop
 * control back to the ROM monitor, if there is one.
 */
        jsr     SYM (exit)
