/*
 * bcc.S -- board support for the M68332BCC's CPU32BUG monitor.
 *
 * Copyright (c) 1995 Cygnus Support
 *
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 * Modifications to this software may be copyrighted by their authors
 * and need not follow the licensing terms described here, provided that
 * the new terms are clearly indicated on the first page of each file where
 * they apply.
 */

	.title "cpu32bug.S for m68k-coff"

/* These are predefined by new versions of GNU cpp.  */

#ifndef __USER_LABEL_PREFIX__
#define __USER_LABEL_PREFIX__ _
#endif

#ifndef __REGISTER_PREFIX__
#define __REGISTER_PREFIX__
#endif

#ifndef __IMMEDIATE_PREFIX__
#define __IMMEDIATE_PREFIX__ #
#endif

/* ANSI concatenation macros.  */

#define CONCAT1(a, b) CONCAT2(a, b)
#define CONCAT2(a, b) a ## b

/* Use the right prefix for global labels.  */

#define SYM(x) CONCAT1 (__USER_LABEL_PREFIX__, x)

/* Use the right prefix for registers.  */

#define REG(x) CONCAT1 (__REGISTER_PREFIX__, x)

/* use the right prefix for immediate values.  */
#define IMM(x) CONCAT1 (__IMMEDIATE_PREFIX__,x)

#define d0 REG (d0)
#define d1 REG (d1)
#define d2 REG (d2)
#define d3 REG (d3)
#define d4 REG (d4)
#define d5 REG (d5)
#define d6 REG (d6)
#define d7 REG (d7)
#define a0 REG (a0)
#define a1 REG (a1)
#define a2 REG (a2)
#define a3 REG (a3)
#define a4 REG (a4)
#define a5 REG (a5)
#define a6 REG (a6)
#define fp REG (fp)
#define sp REG (sp)
#define vbr REG (vbr)

	.text
	.global SYM (_exit)
	.global SYM (outln)
	.global SYM (outbyte)
	.global SYM (putDebugChar)
	.global SYM (inbyte)
	.global SYM (getDebugChar)
	.global SYM (havebyte)

	.set	vbr_size, 0x400
	.comm	SYM (vbr_table), vbr_size

/*
 * _exit -- Exit from the application. Normally we cause a user trap
 *          to return to the ROM monitor for another run.
 */
	.align	2
SYM (_exit):
        unlk    a6
        trap IMM(15)
        .word return

/*
 * inbyte -- get a byte from the serial port
 *	d0 - contains the byte read in
 */
	.align	2
SYM (getDebugChar):		/* symbol name used by m68k-stub */
SYM (inbyte):
	link	a6, IMM(-8)
	trap 	IMM(15)
	.word	inchr
	moveb 	sp@, d0
	extbl	d0
	unlk	a6
	rts

/*
 * outbyte -- sends a byte out the serial port
 *	d0 - contains the byte to be sent
 */
	.align	2
SYM (putDebugChar):		/* symbol name used by m68k-stub */
SYM (outbyte):
	link	fp, IMM(-4)
 	moveb	fp@(11), sp@
	trap 	IMM(15)
	.word	outchr
	unlk	fp
	rts

/*
 * outln -- sends a string of bytes out the serial port with a CR/LF
 *	a0 - contains the address of the string's first byte
 *	a1 - contains the address of the string's last byte
 */
	.align	2
SYM (outln):
	link	a6, IMM(-8)
	moveml	a0/a1, sp@
	trap 	IMM(15)
	.word 	outln
	unlk	a6
	rts

/*
 * outstr -- sends a string of bytes out the serial port without a CR/LF
 *	a0 - contains the address of the string's first byte
 *	a1 - contains the address of the string's last byte
 */
	.align	2
SYM (outstr):
	link	a6, IMM(-8)
	moveml	a0/a1, sp@
	trap 	IMM(15)
	.word 	outstr
	unlk	a6
	rts

/*
 * havebyte -- checks to see if there is a byte in the serial port,
 *             returns 1 if there is a byte, 0 otherwise.
 */
SYM (havebyte):
	trap 	IMM(15)
	.word	instat
	beqs	empty
	movel 	IMM(1), d0
	rts
empty:
	movel	IMM(0), d0
	rts

/*
 * These constants are for the M68332BCC's boot monitor.  They
 * are used with a TRAP 15 call to access the monitor's I/O routines.
 * they must be in the word following the trap call.
 */
	.set inchr, 0x0
	.set instat, 0x1
	.set inln, 0x2
	.set readstr, 0x3
	.set readln, 0x4
	.set chkbrk, 0x5

	.set outchr, 0x20
	.set outstr, 0x21
	.set outln, 0x22
	.set write, 0x23
	.set writeln, 0x24
	.set writdln, 0x25
	.set pcrlf, 0x26
	.set eraseln, 0x27
	.set writd, 0x28
	.set sndbrk, 0x29

	.set tm_ini, 0x40
	.set tm_str0, 0x41
	.set tm_rd, 0x42
	.set delay, 0x43

	.set return, 0x63
	.set bindec, 0x64

	.set changev, 0x67
	.set strcmp, 0x68
	.set mulu32, 0x69
	.set divu32, 0x6A
