#include "w89k.h"

void zylons();
void led_putnum();
void delay();

/*
 * outbyte -- shove a byte out the serial port. We wait till the byte 
 */
int
outbyte(byte)
     unsigned char byte;
{
  while ((inp(RS232REG) & TRANSMIT) == 0x0) {  } ;
  return (outp(RS232PORT, byte));
}

/*
 * inbyte -- get a byte from the serial port
 */
unsigned char
inbyte()
{
  while ((inp(RS232REG) & RECEIVE) == 0x0) { };
  return (inp(RS232PORT));
}

/*
 * led_putnum -- print a hex number on the LED. the value of num must be a byte. 
 *		 The max number 15, since the front panel only has 4 LEDs.
 */
void
led_putnum ( num )
char num;
{
  print ("Sorry, no LED's on the WinBond W89k board, using putnum instead\r\n");
  putnum (num);
}

/*
 * zylons -- draw a rotating pattern. NOTE: this function never returns.
 */
void
zylons()
{
  print ("Sorry, no LED's on the WinBond W89k board\r\n");
}

void
delay (x)
     int x;
{
  int  y = 17;
  while (x-- !=0)
    y = y^2;
}
