unsigned
bits (x)
     unsigned long x;
{
  static unsigned char t[] =
    {
      0,1,2,2,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
      6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
      7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
      7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
      8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
      8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
      8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
      8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
    };
  unsigned a;

  a = x <= 0xffff ? (x <= 0xff ? 0 : 8) : (x <= 0xffffff ?  16 : 24);

  return t[x >> a] + a;
}

unsigned
ref_div (n, d)
     unsigned n, d;
{
  int c;
  unsigned q = 0;
  int nbits, dbits;

  nbits = bits(n);
  dbits = bits(d);
  c = nbits - dbits;
  d <<= c;

  while (c >= 0)
    {
      q <<= 1;
      if (n >= d)
	{
	  n -= d;
	  q |= 1;
	}
      d >>= 1;
      c--;
    }

  return q;
}


main ()
{
  unsigned x, y;
  int i;
  for (i = 0; i < 1000000; i++)
    {
      x = mrand48 ();
      y = mrand48 ();
      if (ref_div (x, y) != x / y)
	{
	  printf ("%X %X\n", x, y);
	}
      if ((i & 0xffff) == 0)
	printf ("reps = %d\n", i);
    }
}
