OUTPUT_ARCH(hppa)
ENTRY("$START$")
STARTUP(crt0.o)
INPUT(op50n.o)
SEARCH_DIR(.)
__DYNAMIC  =  0;

/*
 * We don't need to specify an address here, cause when the Oki board
 * downloads an srecord, it fudges the address by 40000.
 */
SECTIONS
{
  . = 0x40000;
  .text :
  {
   CREATE_OBJECT_SYMBOLS
    *(.PARISC.stubs)
    *(.text)
     etext  =  . ;
     _etext  =  . ;
     __CTOR_LIST__ = . ;
     LONG((__CTOR_END__ - __CTOR_LIST__) / 4 - 2)
    *(.ctors)
     LONG(0)
     __CTOR_END__ = . ;
     __DTOR_LIST__ = . ;
     LONG((__DTOR_END__ - __DTOR_LIST__) / 4 - 2)
    *(.dtors)
     LONG(0)
     __DTOR_END__ = . ;
    *(.lit)
    *(.shdata)
  } 
  .data : {
    *(.data)
    CONSTRUCTORS
    edata  =  . ;
    _edata  =  . ;
  } 
  .bss : {
    _bss_start = . ;
    *(.bss)
    *(COMMON)
    end = . ;
    _end = . ;
  }
}
