/*

HP PA-RISC division support for implementations without FP hardware

Uses a special calling convention and register usage convention
r29 = r26 op r25
We're allowed to clobber r1. r31 and the input operands r25 and r26
r31 is used for linkage by the calling routine

*/

#if SPECIAL_CALLING_CONVENTION
#define dividend %r26
#define divisor %r25
#define quotient %r29
#define tmp %r1
#define ret %r31
#else
#define dividend %r26
#define divisor %r25
#define quotient %r28
#define tmp %r1
#define ret %r2
#endif

#if SPECIAL_CALLING_CONVENTION
	.space $TEXT$
	.align 4
	.export $$divI_7
$$divI_7
#else
	.space $TEXT$
	.align 4
	.export milli_divI_7,entry,priv_lev=3,argw0=gr,argw1=gr,rtnval=gr
milli_divI_7
#endif
	.proc
	.callinfo	frame=0,no_calls
	.entry
	b		$$divI
	ldi		7,%r25
	.import		$$divI,MILLICODE
	.exit
	.procend
