/* divU_9

HP PA-RISC division support for implementations without FP hardware

Uses a special calling convention and register usage convention
r29 = r26 op r25
We're allowed to clobber r1. r31 and the input operands r25 and r26
r31 is used for linkage by the calling routine

*/

#define dividend %r26
#define divisor %r25
#define tmp %r1

#if SPECIAL_CALLING_CONVENTION
#define result %r29
#define ret %r31
#else
#define result %r28
#define ret %r2
#endif

#if SPECIAL_CALLING_CONVENTION
	.space $TEXT$
	.align 4
	.export $$divU_9
$$divU_9
#else
	.space $TEXT$
	.align 4
	.export milli_divU_9,entry,priv_lev=3,argw0=gr,argw1=gr,rtnval=gr
milli_divU_9
#endif
	.proc
	.callinfo	frame=0,no_calls
	.entry

	zdep	%r26,28,29,%r29
	sub	%r29,%r26,%r29
	shd	0,%r26,29,%r1
	subb	%r1,0,%r1			/* 111 */

	zdep	%r29,25,26,%r25
	add	%r25,%r29,%r25
	shd	%r1,%r29,26,%r29
	addc	%r29,%r1,%r29		/* 111000111 */

	sh3add	%r25,%r26,%r1
	shd	%r29,%r25,29,%r25
	addc	%r25,0,%r25		/* 111000111001 */

	zdep	%r1,16,17,%r29
	sub	%r29,%r1,%r29
	shd	%r25,%r1,17,%r1
	subb	%r1,%r25,%r1		/* 111000111000111000111000111 */

	sh3add	%r29,%r26,%r0
	shd	%r1,%r29,29,%r29
	addc	%r29,0,%r29		/* 111000111000111000111000111001 */

	bv	0(ret)
	extru	%r29,30,31,result

	.exit
	.procend
