/*
HP PA-RISC division support for implementations without FP hardware

Uses a special calling convention and register usage convention
r29 = r26 op r25
We're allowed to clobber r1. r31 and the input operands r25 and r26
r31 is used for linkage by the calling routine

*/

#if SPECIAL_CALLING_CONVENTION
#define dividend %r26
#define divisor %r25
#define quotient %r29
#define tmp %r1
#define ret %r31
#else
#define dividend %r26
#define divisor %r25
#define quotient %r28
#define tmp %r1
#define ret %r2
#endif

#if SPECIAL_CALLING_CONVENTION
	.space $TEXT$
	.align 4
	.export $$divI
$$divI
#else
	.space $TEXT$
	.align 4
	.export milli_div,entry,priv_lev=3,argw0=gr,argw1=gr,rtnval=gr
milli_div
#endif
	.proc
	.callinfo	frame=0,no_calls
	.entry

	xor		dividend,divisor,quotient	; remember signedness

	comclr,>=	divisor,%r0,%r0			; get absolute values
	sub		%r0,dividend,dividend		; can possibly be avoided
	comclr,>=	dividend,%r0,%r0
	sub		%r0,divisor,divisor

	comb,<		divisor,0,L$largedivisor
	 sub		%r0,divisor,%r1			; clear cy as side-effect
	ds		%r0,%r1,%r0
	addc		dividend,dividend,dividend
	ds		%r0,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	ds		%r1,divisor,%r1
	addc		dividend,dividend,dividend
	comclr,>=	%r1,%r0,%r0
	addl		%r1,divisor,%r1
	comclr,>=	quotient,%r0,%r0	; skip of no need to negate result
	sub		%r0,dividend,dividend
	bv		0(ret)
	copy		dividend,quotient

L$largedivisor
	comclr,<<	dividend,divisor,quotient
	ldi		1,quotient
	bv,n		0(ret)


	.exit
	.procend
