/*
 * crt0.S -- startup file for hppa.
 * 		rob@cygnus.com (Rob Savoye)
 */
	.VERSION "0.2"
	.COPYRIGHT "crt0.o for the PA"

	.DATA

/* 
 * Set up the standard spaces (sections) These definitions come
 * from /lib/pcc_prefix.s.
 */
	.TEXT
	
/*
 * stuff we need that's defined elsewhere.
 */
	.IMPORT main, CODE
	.IMPORT _bss_start, DATA
	.IMPORT _end, DATA
	.IMPORT environ, DATA

/*
 * start -- set things up so the application will run.
 *
 */
        .PROC
        .CALLINFO SAVE_SP, FRAME=48
        .EXPORT $START$,ENTRY
$START$

	/* FIXME: this writes to page zero */
	;; setup the %30 (stack pointer) with some memory
	ldil 	L%_stack+48,%r30
        ldo 	R%_stack+48(%r30),%r30

	;; we need to set %r27 (global data pointer) here too 
	ldil 	L%$global$,%r27
        ldo 	R%$global$(%r27),%r27		; same problem as above

/*
 * zerobss -- zero out the bss section
 */
	; load the start of bss
	ldil 	L%_bss_start,%r4
        ldo 	R%_bss_start(%r4),%r4

	;  load the end of bss
	ldil 	L%_end,%r5
        ldo 	R%_end(%r5),%r5


bssloop
	addi	-1,%r5,%r5			; decrement _bss_end
	stb	%r0,0(0,%r5)			; we do this by bytes for now even
						; though it's slower, it's safer
	combf,=	%r4,%r5, bssloop	
	nop
	
	ldi	1,%ret0

/*
 * Call the main routine from the application to get it going.
 * main (argc, argv, environ)
 * We pass argv as a pointer to NULL.
 */

	bl	main,%r2
	nop

        .PROCEND
/*
 * _exit -- Exit from the application. Normally we cause a user trap
 * 	    to return to the ROM monitor for another run.
 */
	.EXPORT _exit, ENTRY
_exit
	.PROC
	.CALLINFO
	.ENTRY
	
	;; This just causes a breakpoint exception
	break	0x0,0x0
        bv,n    (%rp)
	nop
	.EXIT
	.PROCEND

/*
 * _sr4export -- support for called functions. (mostly for GDB)
 */
	.EXPORT _sr4export, ENTRY
_sr4export:
	.PROC
	.CALLINFO
	.ENTRY

	ble	0(%sr4,%r22)
	copy	%r31,%rp
	ldw	-18(%sr0,%sp),%rp
	ldsid	(%sr0,%rp),%r1
	mtsp	%r1,%sr0
	be,n	0(%sr0,%rp)
	nop
	.EXIT
	.PROCEND


/*
 * Set up some room for a stack. We just grab a chunk of memory.
 * We also setup some space for the global variable space, which
 * must be done using the reserved name "$global$" so "C" code
 * can find it. The stack grows towards the higher addresses.
 */

        .export $global$
$global$
	.BLOCK	0x2000
        .export _stack
_stack
        .BLOCK	0x2000





