// logview.cpp : implementation file

/* We save the logview as a standard editview, and we buffer
   up text from gdb until we get to an idle.  If we see a return
   from the user, then we suck up that line and treat it as input */

#include "stdafx.h"
#include "log.h"
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLogView
extern CGuiApp theApp;
static void redraw_alllogwins()
{ 
redraw_allwins(theApp.m_logTemplate);
}

CFontInfo logview_fontinfo ("Log", redraw_alllogwins);

IMPLEMENT_DYNCREATE(CLogView, CEditView)

CLogView *theone;

CLogView::CLogView()
{
  theone = this;   

  logview_fontinfo.MakeFont();
}

CLogView::~CLogView()
{
 theone = 0;
}


BEGIN_MESSAGE_MAP(CLogView, CEditView)
	//{{AFX_MSG_MAP(CLogView)
	ON_COMMAND(ID_REAL_CMD_BUTTON_SET_FONT, OnSetFont)
	ON_EN_CHANGE(AFX_IDW_PANE_FIRST, OnEditChange)
	ON_WM_SHOWWINDOW()
	ON_WM_KEYDOWN()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



void CLogView::add(const char *s)
{
pending += s;
}

/////////////////////////////////////////////////////////////////////////////
// CLogView drawing

void CLogView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CLogView diagnostics

#ifdef _DEBUG
void CLogView::AssertValid() const
{
	CEditView::AssertValid();
}

void CLogView::Dump(CDumpContext& dc) const
{
	CEditView::Dump(dc);
}
#endif //_DEBUG

void CLogView::Initialize()
{
 logview_fontinfo.Initialize();
}
void CLogView::Terminate() 
{
  logview_fontinfo.Terminate();
}


void CLogView::OnSetFont() 
{
  logview_fontinfo.OnChooseFont();	
  SetFont(&logview_fontinfo.m_font);
}

BOOL CLogView::PreCreateWindow(CREATESTRUCT& cs) 
{
  // TODO: Add your specialized code here and/or call the base class
  
	cs.cx /=2;  
  return CEditView::PreCreateWindow(cs);
}

void CLogView::OnInitialUpdate() 
{
  CRect r;
  // TODO: Add your specialized code here and/or call the base class
  SetFont(&logview_fontinfo.m_font);	

//  GetClientRect(&r);
//  GetParentFrame()->SetWindowPos(0,0,0,r.Width()/2, r.Height(),SWP_NOMOVE);
  CEditView::OnInitialUpdate();
load_where(GetParentFrame(),"LOGWIN");	
}

void CLogView::OnShowWindow(BOOL bShow, UINT nStatus) 
{
  CEditView::OnShowWindow(bShow, nStatus);
}

static char line[100];
int lc;
int nl = 0;
void CLogView::OnEditChange()
{
  CEditView::OnEditChange();
  if (nl) {
    char buf[200];
    static int j;
    nl = 0;
    lc = 0;
    sprintf(buf,"(gdb)  ", j++);
    togdb_command(line+6);


    add (buf);
  }
}

void CLogView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
  OnIdle();
  int i = GetEditCtrl().GetLineCount();
  int z = GetEditCtrl().GetLine(i-1,line, sizeof(line));
  
  if (isalpha(nChar))
    {
      int idx = GetEditCtrl().LineIndex(i-1);
      GetEditCtrl(). SetSel (idx + z, idx+z, TRUE);
    }
  CEditView::OnKeyDown(nChar, nRepCnt, nFlags);
  if (nChar == VK_RETURN)
    {
      /* Suck off last line */
      line[z] = 0;
      nl = 1;
    }
}

void CLogView::OnIdle() 
{
  if (!theone) return; 
  if (theone->pending.GetLength()) 
    { 
      WINDOWPLACEMENT wnp;
      theone->GetWindowPlacement (&wnp); 
      if (wnp.showCmd != SW_SHOWMINIMIZED) 
	{ 
	  int i;
	  while (theone->pending.GetLength()) {
	    i = theone->pending.Find('\n');
	    if (i >= 0)
	      {
		CString l = theone->pending.Left(i);
		theone->GetEditCtrl().SetSel(-1,-1,FALSE); 
		theone->GetEditCtrl().ReplaceSel(l);
		theone->GetEditCtrl().ReplaceSel("\r"); 
		theone->GetEditCtrl().ReplaceSel("\n"); 
		theone->pending = theone->pending.Mid(i+1);
	      }
	    else {
	      /* Scan look for the newlines and change them */
	      theone->GetEditCtrl().ReplaceSel(theone->pending); 
	      theone->pending ="";
	      return ;
	    }
	  }
	} 
    }
}

void CLogView::OnDestroy() 
{
save_where(GetParentFrame(),"LOGWIN");	
	CEditView::OnDestroy();
	
	// TODO: Add your message handler code here
	
}
