// framevie.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"

#include "framevie.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

CFontInfo frame_fontinfo  ("FrameWindow");

#if 0
/////////////////////////////////////////////////////////////////////////////
// CFrameView

IMPLEMENT_DYNCREATE(CFrameView, CView)

CFrameView::CFrameView()
{
m_init = 0;
}

CFrameView::~CFrameView()
{
}

void CFrameView::on_sel_change_name()
{

}

BEGIN_MESSAGE_MAP(CFrameView, CView)
	//{{AFX_MSG_MAP(CFrameView)
	ON_WM_CREATE()
	ON_WM_SIZE()
     ON_LBN_SELCHANGE(ID_REAL_CMD_FRAMENAME_LIST, on_sel_change_name)
	ON_WM_ERASEBKGND()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CFrameView drawing

void CFrameView::OnDraw(CDC* pDC)
{
  CDocument* pDoc = GetDocument();
  CBrush *brush = (CBrush*)(pDC->SelectStockObject(BLACK_BRUSH));
//  CRect bound = m_listbox_rect;
//  bound.InflateRect(2,2);
//  pDC->FrameRect(bound, brush);
//pDC->InvertRect(bound);
//pDC->InvertRect(m_name_listbox_rect);
//pDC->InvertRect(m_listbox2_rect);
}

/////////////////////////////////////////////////////////////////////////////
// CFrameView diagnostics

#ifdef _DEBUG
void CFrameView::AssertValid() const
{
	CView::AssertValid();
}

void CFrameView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFrameView message handlers

 
int CFrameView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
  if (CView::OnCreate(lpCreateStruct) == -1)
    return -1;
   
  m_name_listbox.Create(LBS_NOTIFY|WS_HSCROLL|WS_BORDER|WS_CHILD|WS_VISIBLE|WS_VSCROLL,
			CRect(0,0,0,0), this, ID_REAL_CMD_FRAMENAME_LIST);
  m_data_listbox.Create(LBS_OWNERDRAWFIXED|WS_BORDER|WS_HSCROLL|WS_CHILD|WS_VISIBLE|WS_VSCROLL, 
			CRect(0,0,0,0), this, ID_REAL_CMD_FRAMEDATA_LIST);

 #if 0
  maxdepth.Create(WS_BORDER|WS_HSCROLL|WS_CHILD|WS_VISIBLE|WS_VSCROLL, 
		  CRect(0,0,0,0), this, ID_REAL_CMD_FRAMEDEPTH_LIST);

 #endif
  text.Create("Depth",WS_CHILD|WS_VISIBLE,CRect(0,0,0,0),this);
  maxdepth.AddString("1");
  maxdepth.AddString("2");
  maxdepth.AddString("3");
  maxdepth.AddString("4");
  maxdepth.AddString("5");
  maxdepth.SetCurSel(3);
  return 0;
}
/////////////////////////////////////////////////////////////////////////////
// CFrameName

CFrameName::CFrameName()
{
}

CFrameName::~CFrameName()
{
}


BEGIN_MESSAGE_MAP(CFrameName, CListBox)
	//{{AFX_MSG_MAP(CFrameName)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CFrameName message handlers

void CFrameName::DrawItem( LPDRAWITEMSTRUCT lp ) 
{
  switch (lp->itemAction) 
    {
    case ODA_DRAWENTIRE:
      {
	char bu[200];	
	CFrameInfo *p;	 	
	int x = lp->rcItem.left;
	int y = lp->rcItem.top;
	      
	CDC* pDC = CDC::FromHandle(lp->hDC);	

	if (1) 
	  {
	    pDC->SelectObject(&frame_fontinfo.m_font);
	    pDC->ExtTextOut(x,y, ETO_OPAQUE, &(lp->rcItem),"",0, NULL);
	    if (lp->itemID!= ~0) 
	      {
		p = (CFrameInfo *)GetItemData(lp->itemID);	
		  
		if (p) 
		  {
		    char *filename;
		    int line;
		      
		    struct symtab *sy;
		    struct frame_annotated_info fai;
		    togdb_annotate_info (p , &fai);
		    togdb_fetchloc (p->GetFramePC(), &filename, &line, &sy);
		    sprintf(bu,"%2d %08x %s:%d %s",
			    lp->itemID,
			    p->GetFramePC(), filename,line,
			    fai.funcname);
		    pDC->TextOut(x,y,bu);
		  }
		else 
		  {
		    pDC->TextOut(x,y,"**undef**");
		  }
	      }	
	    else 
	      {
		sprintf(bu,"unspec");
		pDC->TextOut(x,y,bu);
	      }
	  }	      
      }
	    
      break;
	    
    case ODA_FOCUS:
      // Toggle the focus state
      
      //FTYPE::DrawItem( lp) 	;
      ::DrawFocusRect(lp->hDC, &(lp->rcItem));
      break;
      
    case ODA_SELECT:
      //FTYPE::DrawItem(  lp) 	 ;
      // Toggle the selection state
      ::InvertRect(lp->hDC, &(lp->rcItem));
      break;
    default:
      break;
    }
  
}
#if 0
void CFrameName::OnPaint() 
{
  CPaintDC dc(this);	// device context for painting
  CRect f;
  // TODO: Add your message handler code here
  GetClientRect(&f);
  CBrush *brush = (CBrush*)(dc.SelectStockObject(BLACK_BRUSH));
  dc.FrameRect(f, brush);
}
#endif

void CFrameView::RecalcLayout()
{
 CRect client;
 GetClientRect (client);
 
 CRect topbox = client;
 CRect middlebox  =client;
 CRect bottombox  = client;

 /*
   int ycursor = client.bottom / 5;
   if (ycursor < 50) ycursor = 50;
   
   */
 int tenpercent = client.Height() / 10;
 int gap = 10;
 topbox.bottom = tenpercent*2;

 middlebox.top = topbox.bottom;
 middlebox.bottom = tenpercent * 4;

 bottombox.top = middlebox.bottom;

 topbox.InflateRect(-gap*2,-gap);
 middlebox.InflateRect(-gap*2,-gap);  
 bottombox.InflateRect(-gap*2,-gap);  
 
 m_name_listbox.SetWindowPos(NULL,
			     topbox.left, topbox.top,
			     topbox.Width(),
			     topbox.Height(),
			     SWP_DRAWFRAME|SWP_NOZORDER);
 
 maxdepth.SetWindowPos  (NULL,
			 middlebox.left, middlebox.top,
			 middlebox.right - middlebox.left, 
			 middlebox.bottom - middlebox.top,
			 SWP_DRAWFRAME|SWP_NOZORDER);  
 
 m_data_listbox.SetWindowPos(NULL,
			     bottombox.left, bottombox.top,
			     bottombox.Width(),
			     bottombox.Height(),
			     SWP_DRAWFRAME|SWP_NOZORDER);
 
}

void CFrameView::OnSize(UINT nType, int cx, int cy) 
{
 frame_fontinfo.RememberSize((CMDIChildWnd *)GetParent());
 if (nType != SIZE_MINIMIZED && cx > 0 && cy > 0)
   RecalcLayout();
}


void CFrameView::filldata(CFrameInfo *frame)
{

}

void CFrameView::rethink()
{

}
void CFrameView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
  rethink();
}


/////////////////////////////////////////////////////////////////////////////
// CFrameData

CFrameData::CFrameData()
{
}

CFrameData::~CFrameData()
{
}


BEGIN_MESSAGE_MAP(CFrameData, CListBox)
     //{{AFX_MSG_MAP(CFrameData)
     // NOTE - the ClassWizard will add and remove mapping macros here.
     //}}AFX_MSG_MAP
     END_MESSAGE_MAP()
     
     
     /////////////////////////////////////////////////////////////////////////////
     // CFrameData message handlers
     


void CFrameData::DrawItem(LPDRAWITEMSTRUCT lp ) 
{
  switch (lp->itemAction) 
    {
    case ODA_DRAWENTIRE:
      {
	char bu[200];	
	int x = lp->rcItem.left;
	int y = lp->rcItem.top;
	
	CDC* pDC = CDC::FromHandle(lp->hDC);	
	
	pDC->SelectObject(&frame_fontinfo.m_font);
	pDC->ExtTextOut(x,y, ETO_OPAQUE, &(lp->rcItem),"",0, NULL);
	if (lp->itemID!= ~0) 
	  {
	    CSymbol * p = (CSymbol *)GetItemData(lp->itemID);	
//	    DrawItemWorker(pDC, x,y,p);
	  }
      }
      
      break;
      
    case ODA_FOCUS:
      // Toggle the focus state
      
      //FTYPE::DrawItem( lp) 	;
      ::DrawFocusRect(lp->hDC, &(lp->rcItem));
      break;
      
    case ODA_SELECT:
      //FTYPE::DrawItem(  lp) 	 ;
      // Toggle the selection state
      //        ::InvertRect(lp->hDC, &(lp->rcItem));
      break;
    default:
      break;
    }
  
}

void CFrameName::MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct) 
{
  // TODO: Add your code to determine the size of specified item
  
}

void CFrameData::MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct) 
{
  // TODO: Add your code to determine the size of specified item
  
}
/////////////////////////////////////////////////////////////////////////////
// CFrameFrameWnd
#if 0
IMPLEMENT_DYNCREATE(CFrameFrameWnd, CMDIChildWnd)
     
     CFrameFrameWnd::CFrameFrameWnd()
{
  m_init = 0;
}

CFrameFrameWnd::~CFrameFrameWnd()
{
}


BEGIN_MESSAGE_MAP(CFrameFrameWnd, CMDIChildWnd)
     //{{AFX_MSG_MAP(CFrameFrameWnd)
     ON_WM_SIZE()
     ON_WM_SHOWWINDOW()
     //}}AFX_MSG_MAP
     END_MESSAGE_MAP()
     
     
     /////////////////////////////////////////////////////////////////////////////
     // CFrameFrameWnd message handlers
     
     BOOL CFrameFrameWnd::PreCreateWindow(CREATESTRUCT& cs) 
{
  // TODO: Add your specialized code here and/or call the base class
  
  //	fontinfo.SetUp(cs);
  return CMDIChildWnd::PreCreateWindow(cs);
}
#endif

#if 0
void CFrameFrameWnd::OnSize(UINT nType, int cx, int cy) 
{
  CMDIChildWnd::OnSize(nType, cx, cy);
}
#endif

BOOL CFrameName::OnChildNotify(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pLResult) 
{
  // TODO: Add your specialized code here and/or call the base class
  
  return CListBox::OnChildNotify(message, wParam, lParam, pLResult);
}
#if 0
void CFrameFrameWnd::OnShowWindow(BOOL bShow, UINT nStatus) 
{
  CMDIChildWnd::OnShowWindow(bShow, nStatus);
}

#endif

BOOL CFrameView::OnEraseBkgnd(CDC* pDC) 
{
 // TODO: Add your message handler code here and/or call default
 CBrush b (RGB(192,192,192));
 CBrush *old = pDC->SelectObject(&b);
 CRect rect;
 pDC->GetClipBox(&rect);
 pDC->PatBlt(rect.left, rect.top,rect.Width(), rect.Height(), PATCOPY);
 pDC->SelectObject(old);
 return TRUE;	
}



void CFrameView::OnInitialUpdate() 
{
 // TODO: Add your specialized code here and/or call the base class
 
 CView::OnInitialUpdate();
 
 load_where(GetParentFrame(),"FRAME");


}


void CFrameView::OnDestroy() 
{
 save_where(GetParentFrame(),"FRAME");
 CView::OnDestroy();
}


// frameview.cpp : implementation file
//

//#include "stdafx.h"
//#include "gui.h"
//#include "frameview.h"
#endif
	    
/////////////////////////////////////////////////////////////////////////////
// CFrameDialog

IMPLEMENT_DYNCREATE(CFrameDialog, CFormView)

CFrameDialog::CFrameDialog()
	: CFormView(CFrameDialog::IDD)
{
	//{{AFX_DATA_INIT(CFrameDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
remembered  = 0;
}

CFrameDialog::~CFrameDialog()
{
}

void CFrameDialog::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFrameDialog)
	DDX_Control(pDX, IDC_FRAME_NAME, name);
	DDX_Control(pDX, IDC_FRAME_DEPTH, depth);
	DDX_Control(pDX, IDC_FRAME_DATA, data);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFrameDialog, CFormView)
	//{{AFX_MSG_MAP(CFrameDialog)
	ON_LBN_SELCHANGE(IDC_FRAME_NAME, OnSelchangeFrameName)
	ON_WM_DRAWITEM()
	ON_LBN_SELCHANGE(IDC_FRAME_DEPTH, OnSelchangeFrameDepth)
	ON_BN_CLICKED(IDC_FRAME_GOTO, OnFrameGoto)
	ON_WM_SIZE()
	ON_WM_SHOWWINDOW()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////
// CFrameDialog diagnostics

#ifdef _DEBUG
void CFrameDialog::AssertValid() const
{
	CFormView::AssertValid();
}

void CFrameDialog::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFrameDialog message handlers

void CFrameDialog::OnInitialUpdate() 
{
  CFormView::OnInitialUpdate();
  load_where(GetParentFrame(),"FRAME");
  depth.AddString("1");
  depth.AddString("2");
  depth.AddString("3");
  depth.AddString("4");
  depth.AddString("5");
  depth.SetCurSel(3);

  ResizeParentToFit();
rethink();

//name.GetWindowRect(namebox);
//depth.GetWindowRect(depthbox);
//data.GetWindowRect(databox);

}

void CFrameDialog::filldata(CFrameInfo *frame)
{
  data.ResetContent();
  CBlock *block = frame->GetFrameBlock();
  
  while (block != 0)
    {
      dobuild_locals (block, frame);
      
      /* After handling the function's top-level block, stop.
	 Don't continue to its superblock, the block of
	 per-file symbols.  */
      if (block->GetFunction())
	break;
      block = block->GetSuperBlock();
    }	
}

void CFrameDialog::dobuild_locals(CBlock *b,class CFrameInfo * frame)
{
  int nsyms;
  register int i;
  CSymbol *sym;
  
  nsyms = b->GetNSyms();
  
  for (i = 0; i < nsyms; i++)
    {
      sym = b->GetBlockSym (i);
      switch (sym->GetSymbolClass())
	{
	case LOC_LOCAL:
	case LOC_REGISTER:
	case LOC_STATIC:
	case LOC_BASEREG:
	  
	case LOC_REGPARM:
	case LOC_ARG:
	  
	  data.AddString((char *)sym);
	  //	  m_name_listbox.AddString((char *)sym);
	  break;
	  
	default:
	  /* Ignore symbols which are not locals.  */
	  break;
	}
    }
}

char *tostring(int i,CFrameInfo *p)
{
  char bu[100];
  if (p) 
    {
      char *filename;
      int line;
		      
      struct symtab *sy;
      struct frame_annotated_info fai;
      togdb_annotate_info (p , &fai);
      togdb_fetchloc (p->GetFramePC(), &filename, &line, &sy);
      sprintf(bu,"%2d %08x %s:%d %s",
	      i,
	      p->GetFramePC(), filename,line,
	      fai.funcname);
      return strdup(bu);
    }
  else 
    {
      return strdup("**undef**");
    }
}

void CFrameDialog::rethink()
{
  name.ResetContent();
  CFrameInfo *fi;
  int de  ;
  int maxd = depth.GetCurSel()+1;
  for (de  = 0, fi = CFrameInfo::GetCurrentFrame();
       fi && de  < maxd;
       fi = fi->get_prev_frame())
    {	
      name.AddString( tostring(de, fi));
      de++;
    }
  
  filldata(CFrameInfo::GetCurrentFrame());
  UpdateData(1);
}
void CFrameDialog::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
 // TODO: Add your specialized code here and/or call the base class
 
 rethink();
}

void CFrameDialog::OnSelchangeFrameName() 
{
 int level = name.GetCurSel();
 if (level >= 0)
   {
     CFrameInfo *p;	 	
     p  = CFrameInfo::GetCurrentFrame();
     while (level >0)
       {
	 p = p->get_prev_frame();
	 level --;
       }
     filldata(p);
   }

}

#if 0
void CFrameDialog::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lp ) 
{
  switch (lp->itemAction) 
    {
    case ODA_DRAWENTIRE:
      {
	char bu[200];	
	CFrameInfo *p;	 	
	int x = lp->rcItem.left;
	int y = lp->rcItem.top;
	      
	CDC* pDC = CDC::FromHandle(lp->hDC);	

	if (1) 
	  {
	    pDC->SelectObject(&frame_fontinfo.m_font);
	    pDC->ExtTextOut(x,y, ETO_OPAQUE, &(lp->rcItem),"",0, NULL);
	    if (lp->itemID!= ~0) 
	      {
		p = (CFrameInfo *)data.GetItemData(lp->itemID);	
		  
		if (p) 
		  {
		    char *filename;
		    int line;
		      
		    struct symtab *sy;
		    struct frame_annotated_info fai;
		    togdb_annotate_info (p , &fai);
		    togdb_fetchloc (p->GetFramePC(), &filename, &line, &sy);
		    sprintf(bu,"%2d %08x %s:%d %s",
			    lp->itemID,
			    p->GetFramePC(), filename,line,
			    fai.funcname);
		    pDC->TextOut(x,y,bu);
		  }
		else 
		  {
		    pDC->TextOut(x,y,"**undef**");
		  }
	      }	
	    else 
	      {
		sprintf(bu,"unspec");
		pDC->TextOut(x,y,bu);
	      }
	  }	      
      }
	    
      break;
	    
    case ODA_FOCUS:
      // Toggle the focus state
      
      //FTYPE::DrawItem( lp) 	;
      ::DrawFocusRect(lp->hDC, &(lp->rcItem));
      break;
      
    case ODA_SELECT:
      //FTYPE::DrawItem(  lp) 	 ;
      // Toggle the selection state
      ::InvertRect(lp->hDC, &(lp->rcItem));
      break;
    default:
      break;
    }

}
#endif

void type_print(CSymbol *symbol, char *p, CValue *value)
{
  CType *type = symbol->GetType();
  if (type->code == TYPE_CODE_PTR
      || type->code == TYPE_CODE_REF)
    {
      
    }
  switch (type->code) {
  case TYPE_CODE_STRUCT:
    sprintf(p,"struct");
    break;
  case TYPE_CODE_INT:
    sprintf(p, "%d", value->GetInt());
    break;
  case TYPE_CODE_ENUM:
    sprintf(p, "%s (%d)", value->GetEnumName(), value->GetInt());
    break;
  case TYPE_CODE_PTR:
    sprintf(p,"<ptr> %x", value->GetInt());
    break;
  default:
    sprintf(p,"** dunno **");
    break;
  }
}


void showsymbol(CDC *p,int x, int y, CSymbol *symbol)
{
  CValue *value = symbol->ReadVarValue (CFrameInfo::GetCurrentFrame());
  char where[100];
  char where1[100];
  char name[100];
  /* Describe where it is */
  switch (value->GetLVal()) {
  case lval_memory:
    sprintf(where,"%x ", value->GetAddress());
    break;
  case lval_register:
    sprintf(where,"r%d ", value->GetRegno());
    break;
  default:
    sprintf(where,"??");
    break;
  }
  //  sprintf(where1,"frame %x", value->GetFrame());
  sprintf(name,"%s = ", symbol->GetName());
  //  strcat(where, where1);
  strcat(where,  name);
  
  char b[200];
  type_print(symbol, b, value);	
  strcat(where, b);
  p->TextOut(x,y,where);
}

void CFrameDialog::DrawItemWorker(CDC *p,int x, int y, CSymbol *symbol)
{
  showsymbol(p,x,y,symbol);
}

void CFrameDialog::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lp ) 
{
  switch (lp->itemAction) 
    {
    case ODA_DRAWENTIRE:
      {
	char bu[200];	
	int x = lp->rcItem.left;
	int y = lp->rcItem.top;
	
	CDC* pDC = CDC::FromHandle(lp->hDC);	
	
	pDC->SelectObject(&frame_fontinfo.m_font);
	pDC->ExtTextOut(x,y, ETO_OPAQUE, &(lp->rcItem),"",0, NULL);
	if (lp->itemID!= ~0) 
	  {
	    CSymbol * p = (CSymbol *)data.GetItemData(lp->itemID);	
	  showsymbol(pDC, x,y,p);
	  }
      }
      
      break;
      
    case ODA_FOCUS:
      // Toggle the focus state
      
      //FTYPE::DrawItem( lp) 	;
      ::DrawFocusRect(lp->hDC, &(lp->rcItem));
      break;
      
    case ODA_SELECT:
      //FTYPE::DrawItem(  lp) 	 ;
      // Toggle the selection state
      //        ::InvertRect(lp->hDC, &(lp->rcItem));
      break;
    default:
      break;
    }
  
}

void CFrameDialog::OnSelchangeFrameDepth() 
{
  // TODO: Add your control notification handler code here
  rethink();	
}

void CFrameDialog::OnFrameGoto() 
{
  //name.ResetContent();
  CFrameInfo *fi;
  int de  ;
  int want = name.GetCurSel();
  int maxd = depth.GetCurSel()+1;
  for (de  = 0, fi = CFrameInfo::GetCurrentFrame();
       fi && de  < maxd;
       fi = fi->get_prev_frame())
    {	
      if (de == want)
	{
	  theApp_show_at (fi->pc);
	  return;
	}
      de++;
    }
}

void CFrameDialog::OnSize(UINT nType, int cx, int cy) 
{
 CFormView::OnSize(nType, cx, cy);

 if (remembered) {
  CRect databox;
  CRect original;

   /* 
      Make sure that the contents retain their original size and shape
      so we keep the bottom rhc of the data box the same distance from
      the rhbc of he container 
      */
   
   GetClientRect(original);
   data.GetClientRect(databox);
   data.SetWindowPos (0, 0,0,
		      original.Width() - databox_indent.x - databox.left,
		      original.Height() - databox_indent.y - databox.top,
		      SWP_NOMOVE|SWP_NOZORDER);	
   
   
}

}


void CFrameDialog::Initialize()



{
  frame_fontinfo.Initialize();
}


void CFrameDialog::Terminate()
{
  
  frame_fontinfo.Terminate();


}


void CFrameDialog::OnShowWindow(BOOL bShow, UINT nStatus) 
{
#if 0
  CRect databox;
  CRect original;
if (!remembered)
  {
remembered = 1;


      
  data.GetWindowRect(databox);
  GetWindowRect(original);


  databox_indent.x = original.right - databox.right;
  databox_indent.y = original.bottom - databox.bottom;
}
#endif
	CFormView::OnShowWindow(bShow, nStatus);
	
	// TODO: Add your message handler code here
	
}
