#if 0
// bptview.cpp : implementation file
//

#include "stdafx.h"
#include "bptview.h"
#include "bptdoc.h"
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/* There is only one of these, perhaps it should belong
   to the app  ? */
extern CBreakInfoList the_breakinfo_list;

/////////////////////////////////////////////////////////////////////////////
// CBptView

IMPLEMENT_DYNCREATE(CBptView, CFormView)

CBptView::CBptView()
	: CFormView(CBptView::IDD)
{
	//{{AFX_DATA_INIT(CBptView)
	m_newbpt = _T("");
	//}}AFX_DATA_INIT
}

CBptView::~CBptView()
{
}

void CBptView::DoDataExchange(CDataExchange* pDX)
{
  CFormView::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CBptView)
  DDX_Control(pDX, ID_CMD_BUTTON_DISABLE, m_disable_button);
  DDX_Control(pDX, ID_CMD_BUTTON_CLEAR_ALL, m_clearall_button);
  DDX_Control(pDX, ID_CMD_BUTTON_CLEAR_BREAKPOINT, m_clearbutton);
  DDX_Control(pDX, ID_CMD_BUTTON_BREAKPOINT_LIST, m_listbox);
  DDX_Text(pDX, ID_CMD_BUTTON_BREAKPOINT, m_newbpt);
  //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CBptView, CFormView)
     //{{AFX_MSG_MAP(CBptView)
     ON_BN_CLICKED(ID_CMD_BUTTON_CLEAR_BREAKPOINT, OnClearBreakpoint)
     ON_BN_CLICKED(ID_REAL_CMD_BUTTON_SET_BREAKPOINT, OnSetBreakpoint)

     ON_LBN_DBLCLK(ID_CMD_BUTTON_BREAKPOINT_LIST, OnDblclkBreakpointList)
     ON_LBN_SELCANCEL(ID_CMD_BUTTON_BREAKPOINT_LIST, OnSelcancelBreakpointList)
     ON_LBN_SELCHANGE(ID_CMD_BUTTON_BREAKPOINT_LIST, OnSelchangeBreakpointList)
     ON_BN_CLICKED(ID_CMD_BUTTON_DISABLE, OnDisable)
     ON_WM_MEASUREITEM()
     ON_WM_DRAWITEM()
     ON_BN_CLICKED(ID_CMD_BUTTON_CLEAR_ALL, OnClearAll)
     //}}AFX_MSG_MAP
     END_MESSAGE_MAP()
     
     
     
     /////////////////////////////////////////////////////////////////////////////
     // CBptView diagnostics
     
#ifdef _DEBUG
     void CBptView::AssertValid() const
{
  CFormView::AssertValid();
}

void CBptView::Dump(CDumpContext& dc) const
{
  CFormView::Dump(dc);
}
#endif				//_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CBptView message handlers

void CBptView::OnClearBreakpoint() 
{
  int cursel = m_listbox.GetCurSel();
  if (cursel >= 0) {
    the_breakinfo_list.Delete(cursel);
  }
}

void CBptView::OnSetBreakpoint() 
{
  const char *c;
  UpdateData(TRUE);
  c = (LPCTSTR)m_newbpt;
  togdb_bpt_set (c);
  m_newbpt = "";
  UpdateData(FALSE);
}

void CBptView::DoUpdateNewBpt()
{
  char buf[200];
  
  int cursel = m_listbox.GetCurSel();
  
  if (cursel >= 0) 
    {
      CBreakInfo *bi = the_breakinfo_list.GetAt(cursel);
      sprintf(buf,"%s:%d",
	      the_breakinfo_list.GetAt(cursel)->GetSourceFile(),
	      the_breakinfo_list.GetAt(cursel)->GetLineNumber());
      if (bi->GetEnable())
	m_disable_button.SetWindowText("&Disable");
      else
	m_disable_button.SetWindowText("&Enable");
      m_newbpt = buf;
      
    }
  m_disable_button.EnableWindow(cursel >= 0);
  m_clearbutton.EnableWindow(cursel >= 0);
  m_clearall_button.EnableWindow(the_breakinfo_list.GetSize() > 0);
  UpdateData(FALSE);
}

void CBptView::DoUpdateList()
{
  static int tstops[] = {10,20,30,40};
  m_listbox.ResetContent();	
  m_listbox.SetTabStops (4,tstops);
  int i;
  UpdateData(TRUE);
  int size = the_breakinfo_list.GetSize();
  
  
  for (i = 0; i < size; i++) {
    char buf[200];
    CBreakInfo *bi = the_breakinfo_list.GetAt(i);
    if (bi->GetAddress().togdb()) {
      sprintf(buf,"%s\t%d\t%08x\t%s",
	      bi->GetEnable() ? "+" : "-",
	      i,
	      bi->GetAddress(),
	      bi->GetAddrString());
      m_listbox.AddString(buf);
    }
  }
  
  UpdateData(FALSE);
}
void CBptView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
  DoUpdateList();
  DoUpdateNewBpt();
}

void CBptView::OnInitialUpdate() 
{
  // TODO: Add your specialized code here and/or call the base class
  ResizeParentToFit();	
  CFormView::OnInitialUpdate();
  DoUpdateList();
  DoUpdateNewBpt();
  
}

void CBptView::OnDblclkBreakpointList() 
{
  int cursel = m_listbox.GetCurSel();
  if (cursel >= 0) {
    CBreakInfo *bi = the_breakinfo_list.GetAt(cursel);
    /* goto where this line is */
    theApp_show_at (bi->GetAddress());
  }
}

void CBptView::OnSelcancelBreakpointList() 
{
  
  DoUpdateNewBpt();	
}

void CBptView::OnSelchangeBreakpointList() 
{
  DoUpdateNewBpt();
}


void CBptView::OnDisable() 
{
  int cursel = m_listbox.GetCurSel();
  if (cursel >= 0) 
    {
      CBreakInfo *bi = the_breakinfo_list.GetAt(cursel);
      if (bi->GetEnable())
	the_breakinfo_list.Disable(cursel);
      else
	the_breakinfo_list.Enable(cursel);
    }
}

void CBptView::OnClearAll() 
{
  the_breakinfo_list.DeleteAll();
}

#endif
