#include <string.h>
#include <stream.h>
#include <assert.h>

template <class T>
class stack {
  typedef struct _st {
    struct _st * next;
    T            data;
  } st;
  st * root;

public:
// factory methods
  stack()          { root = (st *) 0; }
  ~stack()         { while (root != (st *) 0) {
                       st * s = root;
                       delete root;
                       root = s->next;
                     }
                   }

// class methods
  int isEmpty()    { return root == (st *) 0; }
  void push(T & a) { st * s = root;
                     root = new st;
                     root->data = a;
                     root->next = s;
                   }
  T pop()          { assert(root != (st *) 0);
                     st * s = root->next;
                     T r = root->data;
                     delete root;
                     root = s;
                     return r;
                   }
};
void
intStack()
{
  int i;
  stack <int> si;

  i = 10; si.push(i);
  i = 20; si.push(i);
  i = 30; si.push(i);

  while (!si.isEmpty()) {
    i = si.pop();
    cout << i << '\n';
  }
}

void
stringStack()
{
  typedef struct {
    char str[20];
  } string;
  string s;
  stack <string> sc;

  strcpy(s.str, "first string");  sc.push(s);
  strcpy(s.str, "second string"); sc.push(s);
  strcpy(s.str, "third string");  sc.push(s);

  while (!sc.isEmpty()) {
    s = sc.pop();
    cout << s.str << '\n';
  }
}

int
main()
{
  intStack();
  stringStack();

  return 0;
}
