/* Definitions of target machine for GNU compiler, for SPARClite w/o FPU,
   with flat (single) register window calling convention compatible with
   regular sparcs, and generating COFF object files.
   Copyright (C) 1994 Free Software Foundation, Inc.
   Contributed by Stan Shebs, based on bits from Jim Wilson.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "sparc/litecoff.h"

#undef TARGET_VERSION
#define TARGET_VERSION fprintf (stderr, " (sparclite frw compat)");

/* Enable sparclite and epilogue options.  Do not enable the fpu.  */

#undef TARGET_DEFAULT
#define TARGET_DEFAULT (512+256+128+2)

/* Flat register window model support follows.  */

/* We can't use the normal frame pointer register, because when not using
   save/restore, there is no way to set both the sp and the fp at the same
   time.  This is required since the sp and fp (which is the sp for the
   previous register window) may be used by a trap handler for register
   window overflow/underflow at any time.  This of course only matters because
   we are concerned about compatibility between generic and register windowless
   code.  */

#undef FRAME_POINTER_REGNUM
#define FRAME_POINTER_REGNUM 22

#undef ARG_POINTER_REGNUM
#define ARG_POINTER_REGNUM 22

/* If !TARGET_FPU, then make the fp registers fixed so that they won't
   be allocated.  */

#undef CONDITIONAL_REGISTER_USAGE
#define CONDITIONAL_REGISTER_USAGE				\
do								\
  {								\
    if (! TARGET_FPU)						\
      {								\
	int regno;						\
	for (regno = 32; regno < 64; regno++)			\
	  fixed_regs[regno] = 1;				\
      }								\
     fixed_regs[FRAME_POINTER_REGNUM] = 1;			\
  }								\
while (0)

/* ??? These should be conditionalized somehow.  */
#undef ORDER_REGS_FOR_LOCAL_ALLOC
#undef LEAF_REGISTERS
#undef LEAF_REG_REMAP
#undef LEAF_REG_BACKMAP

/* ??? This should be conditionalized somehow.  */
#undef FRAME_POINTER_REQUIRED
#define FRAME_POINTER_REQUIRED \
  (current_function_calls_alloca || current_function_varargs)
