	.WIDTH	130
;
;(***********************************************************************)
;(*									*)
;(*  	Copyright (C) 1981, 1982 by National Semiconductor Corporation	*)
;(*									*)
;(*    	National Semiconductor Corporation				*)
;(*	2900 Semiconductor Drive					*)
;(*	Santa Clara, California 95051					*)
;(*									*)
;(*	All Rights Reserved						*)
;(* 									*)
;(*	This software is furnished under a license and may be used	*)
;(*	and copied only in accordance with the terms of such license  	*)
;(*	and with the inclusion of the above copyright notice. This 	*)
;(* 	software or any other copies thereof may not be provided or 	*)
;(*	otherwise made available to any other person. No title to and 	*)
;(*	ownership of the software is hereby transferred.		*)
;(*									*)
;(*	The information in this software is subject to change without   *)
;(*	notice and should not be construed as a commitment by National  *)
;(*	Semiconductor Corporation.					*)
;(*									*)
;(*	National Semiconductor Corporation assumes no responsibility 	*)
;(*	for the use or reliability of its software on equipment 	*)
;(*	configurations which are not supported by National 		*)
;(*     Semiconductor Corporation.					*)
;(*									*)
;(***********************************************************************)
;
;
;       PROGRAM     MON16
;
;       VERSION     2.00
;
;       DATE        31 - JAN - 1983
;
;
;
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;
;
;
	.MODULE	MONSUB
;
;     M O N I T O R    S P E C I A L    S U B R O U T I N E S
;		  FILE SUB.ASM    31-JAN-83
;			VERSION 2.00
;
;
;     GLOBAL DEFINITIONS
;
	.IMPORT  REGTB,USX,ISX
;
        .EXPORTP SRDLIN,RDLIN,RDCHR,PRINTA,SPRINTA,PRCHR
        .EXPORTP HXTOBN,BNTOHX,TBSRCH,GETPUT
        .EXPORT  COMPS,HEXAN
;
;       TERMINAL RECORD
	.DSECT
INBUF:	.BLKB	64		; INPUT BUFER
INLM:	.BLKB	4 		; POINTER TO LAST CHARACTER READ
OUTB:	.EQU	INBUF		; OUTPUT BUFFER (SAME AS INPUT )
OUTLM:	.EQU	INLM		; POINTER TO LAST BYTE IN OUTB TO BE PRINTED
TRMRLG:	.EQU	*		; TERMINAL RECORD LENGTH
	.ENDSEG
;
;
;     GLOBAL CONSTANTS
;
STALON:	.EQU	0		; STAND ALONE INDICATOR
TRANSP:	.EQU	1		; TRANSPARENT MODE
TRUE:	.EQU	1		; DEFINE LOGICAL TRUE
FALSE:	.EQU	0		; DEFINE LOGICAL FALSE
TRMA:	.EQU	0		; TERMINAL A
TRMB:	.EQU	1		; TERMINAL B
NSFBR:	.EQU	14		; NUMBER OF SOFTWARE BREAK-POINTS
PSR_U:	.EQU	8		; U BIT IN PSR
PSR_T:	.EQU	1		; T BIT IN PSR
PSR_S:	.EQU	9		; S BIT IN PSR
BPR_BE:	.EQU	29		; BE BIT IN BPR REG OF MMU
BPTC:	.EQU	H'F2		; BPT INSTRUCTION
SIMONIO: .EQU	700000
;
HANDB:	.EQU	0		; HAND_SHAKING BIT OF OPMOD WORD
HANDLF:	.EQU	1		; ON HAND_SHAKING CR ECHO IS LF
ECHOB:	.EQU	2		; ECHO BIT
ECHOLF:	.EQU	3		; FLAG FOR ECHO TO CR BY CR LF
;
;
;     ASCII CHARACTERS
;
;
CR:	.EQU	H'0D 		; RETURN
LF:	.EQU	H'0A 		; LINE FEED
DOT:	.EQU	H'2E 		; DOT
COMMA:	.EQU	H'2C 		; COMMA CHARACTER
SPACE:	.EQU	H'20 		; SPACE CHARACTER
;
;
;     GLOBAL VARIABLES
;
STATIC: .EQU    H'8000
        .STATIC                 ; DEFINE STATIC EREA
;
OPMOD:  .BLKB   1               ; OPERATION MODE VARIABLE
OPHND:	.BLKB	1		; OPERATION MODE HAND_SHAKING
MON_USR: .BLKB  1               ; MONITOR/USER TIME FLAG
PNDF:	.BLKB	1		; PENDING INTERRPTS FLAG
DTRM:   .BLKB   4               ; POINTER TO DEFULT TERMINAL BUFFER
NDTRM:  .BLKB   1               ; #  OF DEFULT TERMINAL
SVCPF:	.BLKB	1		; SVC FLAG FOR READ WRITE ROUTINE FOR MOVUS
ERRTYP: .BLKB   1               ; ENTRY TYPE
L:      .BLKB   1	 	; SAVE COMMAND NUMBER
SCRCH1: .BLKB   4               ; SCRACH 1
SCRCH2: .BLKB   4               ; SCRACH 2
STRTADR: .BLKB  4               ; SAVE RESET ADDRESS
ENDADR:  .BLKB  4               ; SAVE END INTERRUPT ROUTINE ADDRESS
SEREA:
SVFP:   .BLKB   4               ; SAVE FP
SVUS:   .BLKB   4               ; SAVE US
SVIS:   .BLKB   4               ; SAVE IS
SVPC:   .BLKB   4               ; SAVE PC
SVMOD:  .BLKB   4               ; SAVE MOD
SVPSR:  .BLKB   4               ; SAVE PSR
SVR7:   .BLKB   4*7             ; SAVE R
SVR0:   .BLKB   4               ; SAVE R0
;
SVMSR:  .BLKB   4               ; SAVE MSR
TMPPSR:
TMPMSR:	.BLKB	4		; TEMPORAY SAVE MSR
SVBPR0: .BLKB   4               ; SAVE BPR0
SVBPR1: .BLKB   4               ; SAVE BPR1
HEAPP:  .BLKB   4               ; HEAP POINTER
HEAPE:  .BLKB   4               ; HEAP END
HEAPS:  .BLKB   4               ; HEAP BEGIN
;
CONFIG: .BLKB   1               ; CONFIGURATION BYTE
MSRWF:	.BLKB	1		; MSR WRITTEN FLAG
;
MNFP:   .BLKB   4               ; SAVE MONITOR FP
MNMSR:	.BLKB	4		; SAVE MONITOR MSR
MNSP:   .BLKB   4               ; SAVE MONITOR SP
MNSPH:	.BLKB	4		; MONITOR HIGH SP
MNPSR:  .BLKB   2               ; MONITOR PSR
BRKAR:  .BLKB   NSFBR*4         ; SOFT-BPR ARRAY
STEPFLG: .BLKB  1               ; STEP FLAG
ACKFLG: .BLKB   1               ; ACKNOLEDGE FLAGE
CXPFLG: .BLKB   1               ; CXP COMMAND COUNTER
	.BLKB	1		; ** FOR ELAINMENT **
STPCNT: .BLKB   4               ; STEP COUNTER
ACTBRK: .BLKB   4               ; # OF CURRENT BREAK
INS:    .BLKB   NSFBR           ; ARRAY OF BRPR INSTRUCTION SAVE
OLDPC:  .BLKB   8               ; SAVE OLD PC,US,IS,MOD IN CXP COMMAND
ENDPC:	.BLKB	4		; PC OF INSERTED BPT ON STACK
ENDPC1:	.BLKB	4		; PC OF BEGIN WHEN CXP ALSO
CNTRLB:	.BLKB	1		; CNTRL/B CHARACTER STARTS EVERY COMMAND
CNTRLL: .BLKB	1		; CNTRL/L CHARACTER START FAST LOAD MESSAGE
CNTRLS: .BLKB	1		; CNTRL/S CHARACTER HOLD SCREEN
CNTRLQ: .BLKB	1		; CNTRL/Q CHARACTER RESUME SCREEN
STUADD: .BLKB   16              ; STU COMMAND VERIABLE ADDRESS
MONUSR1: .BLKB	1		; TEMP SAVE OF MON_USER FLAG
RSTINT:	.BLKD	1		; SAVE RESET VALUE OF INTBASE
JMPRAM: .BLKD	2
;
TERM1:  .BLKB   TRMRLG          ; TERINAL 1 RECORD
TERM2:  .BLKB   TRMRLG          ; TERMINAL 2 RECORD
        .ENDSEG
STACKL:	.EQU	H'200		; STACK EREA END RELATIVE TO START OF SB
;
;
;	USART  CONSTANTS
;
IOBEG:	.EQU	H'C00000	; IO BEGIN ADDRESS
USRTCS:	.EQU	2		; USRT CONTROL & STATUS PORT
USRTCS2: .EQU	USRTCS+H'40	; USRTB ADDRESS
DATAP:	.EQU	0		; USRT DATA INPUT OUTPUT PORT
OUT_RDY: .EQU	0		; TX-RDY BIT OF STATUS WORD
IN_RDY:	.EQU	1		; RX-RDY BIT OF STATUS
;
;
;    S R D L I N     (STANDARD READ LINE PROCEDURE )
;
;
LINLIM:	.EQU	60		; MAX NUMBER OF CHARACTERS IN INPUT LINE
;
SRDLIN: .PROC
	.VAR	[R0,R1]
	.BEGIN
	CMPQB	STALON,OPMOD	; IF OPMOD=TRANSPARENT
	BEQ	SRDLIN2:W	; THEN
	BSR	TRANSR:W	;   TRANSR;
	ADDR	INBUF(R7),R5	;   DTRM.SCN:=1;
	BR	LWRLP		; ELSE
SRDLIN2:
	MOVXBW	(-LINLIM),TOS
   	MOVB	NDTRM,TOS	;   RDLIN (-LINLIM,NDTRM,INBUF)
	ADDR	INBUF(R7),TOS			
	SPRD	MOD,TOS		;{FOR CXP}		
	BSR	RDLIN
	ADDR	INBUF(R7),R5	;   DTRM.SCN :=1
	MOVZWD	TOS,INLM(R7)
	ADDD	R5,INLM(R7)	;   DTRM.INLM:=RDN
;
; TURN ALL LOWER CASE LETTERS IN COMMAND LINE TO UPPER
;
LWRLP:	MOVD	R5,R0		; FOR I := 1 TO N {NUBER OF BYTES READ}
LWR0:	CHECKB	R1,LWRCB,0(R0);   BEGIN
	BFS	LWR1		;     IF INBUF [I] <= 'a' <= 'z'
	SUBB	'a'-'A',0(R0)	;       THEN INBUF [I] := INBUF [I]-'a'+'A'
LWR1:	ADDQD	1,R0		;   END
	CMPD	R0,INLM(R7)
	BLT	LWR0
	.ENDPROC
LWRCB:	.BYTE	'z','a'		; LIMITS OF UPPER AND LOWER LETTERS
;
;
;    R D L I N       ( READ LIN PROCEDURE  )
;
;	LOCAL CONSTANTS
;
;
ENDLIN:	.EQU	CR			; END OF LINE CHARACTER
DELETE:	.EQU	8			; BACK SPACE CHARACTER
;
;
;	ARGUMENTS DEFINITIONS
;
;
RDLIN:	.PROC				; PROCEDURE DEFINITION
RDN:	.BLKW				; RDN : INTEGER*2 MAX # OF BYTES
RDTRM:	.BLKB				; RDTRM : INTEGER*1 TERMINAL #
RDVEC:	.BLKD				; VAR RDVEC : CHAR[1..RDN]
;
;	LOCAL VARIABLES
;
	.RETURNS
	.BLKW				; RETURN # OF READ BYTES
	.VAR	[R1,R2,R3]
	.BEGIN
	MOVQB	FALSE,R1		; READLNF:=FALSE
	CMPQW	0,RDN			; IF RDN<= THEN
   	BLE	RDLINA		; BEGIN
	MOVQB	TRUE,R1			;   READLNF:=TRUE;
	NEGW	RDN,RDN			;   RDN:=-RDN;
					; END
RDLINA:	MOVQD	0,R2			; N:=0
					; REPEAT
RDLIN1:	MOVQW	TRUE,TOS		; {RDCHR (CHR,FALSE,RDTRM)}
	MOVB	RDTRM,TOS
	SPRD	MOD,TOS
	BSR	RDCHR:W
	ADJSPB	-1			; {REMOVE ENDF}
	MOVB	TOS,R3			; CHR:=RDCHR (FALSE,RDTRM);
   	MOVB	RDTRM,TOS
   	BSR	DOECHO:W		; DOECHO(CHR,RDTRM)
	CMPB	DELETE,R3		; IF CHR:=DELETE
	BNE	RDLIN2		;  THEN
	CMPQB	TRUE,R1			;   IF READLNF
	BNE	RDLIN2		;    THEN
	CMPQD	0,R2			;     IF N> 0
	BGE	RDLIN2		;	THEN
	ADDQD	-1,RDVEC		;	  N:=N-1;
	ADDQD	-1,R2			; ELSE
	BR	RDLIN1			; BEGIN
RDLIN2:
;	MOVB	R3,0(RDVEC)		;    VEC(N):=CHR;
   	CMPQB	TRUE,SVCPF		;    IF CALLED FROM SVC THEN
   	BNE	RDLIN3
   	MOVB	R3,SCRCH2		;       VEC(N) := CHR; {MOVSU}
   	MOVSUB	SCRCH2,0(RDVEC)
   	BR	RDLIN4		;    ELSE
RDLIN3:	MOVB	R3,0(RDVEC)		;       VEC(N) := CHR   {MOV}
RDLIN4:	ADDQD	1,RDVEC			;    N:=N+1;
	ADDQW	1,R2			; END;
	CMPW	RDN,R2			; UNTIL
   	BLE	RDLINEX		;     (N>=RDN)
	CMPQB	TRUE,R1			;   OR (READLNF AND (CHR=ENDLIN))
	BNE	RDLIN1
	CMPB	R3,ENDLIN
	BNE	RDLIN1
RDLINEX:
	MOVW	R2,RDN			; RDLIN:=N
	.ENDPROC
;
;    D O E C H O  ( EC_CHR,EC_TRM)
;        EC-CHR  INPUT : BYTE IN R3 {CHAR TO BE ECHO}
;	 EC_TRM  INPUT : BYTE  {TERMINAL NUMBER}
;    FUNCTION  - CHECK IF ECHOB OF THIS TERMINAL ON THEN ECHO
;		 IF EC_CHR IS BACK_SPACE ECHO WITH SPACE TO
;		 IF EC_CHR IS CR AND ECHOLF BIT ON ECHO WITH CR LF
;
;
DOECHO:	.PROC		; PROCEDURE DOECHO (EC_CHR,EC_TRM : BYTE)
EC_TRM:	.BLKB
        .RETURNS
   	.VAR	[R1,R3]
   	.BEGIN
   	MOVB	OPHND,R1	; {SAVE OPMOD OF TERM IN R1 BITS 0..3}
   	CMPQB	TRMA,EC_TRM
   	BEQ	EC2
   	LSHB	-4,R1
EC2:	TBITB	ECHOB,R1	; IF ECHO THEN
   	BFC	ECEX:W		; BEGIN
EC3:   	MOVQB	TRUE,TOS
   	MOVB	R3,TOS
   	MOVB	EC_TRM,TOS	;   PRCHR (TURE,EC_CHR,EC_TRM)
   	SPRD	MOD,TOS
   	BSR	PRCHR:W
   	CMPQB	TRUE,TOS	;   {ADJAST STACK}
   	CMPB	R3,CR		;   IF EC_CHR=CR THEN
   	BNE	EC4
   	TBITB	ECHOLF,R1	;     AND ECHOLF ON
   	BFC	ECEX		;   THEN ECHO WITH LF
   	MOVB	LF,R3
   	BR	EC3
EC4:	CMPB	DELETE,R1	;   IF EC_CHR=DELETE THEN
   	BNE	ECEX		;   BEGIN
   	MOVB	SPACE,R3
   	BR	EC3		;     ECHO WITH SPASE
ECEX:
   	.ENDPROC
;
;
;    R D C H R      ( DUMMY READ CHAR PROCEDURE )
;
;
RDCHR:	.PROC		; PROCEDURE RDCHR (WAIT,TRM)
RD_CHR:	.BLKB			; PROCEDURE VALUE
RD_WAIT: .BLKB			; WAIT/NOWAIT FLAG
RD_TRM:	.BLKB			; TERMINAL NUMBER
	.RETURNS
	.BLKW			; RETURN CHR,CHR_RDY FLAG
	.VAR	[R1,R2]
	.BEGIN
	MOVD	USRTCS+IOBEG,R1	; R1: ADDRESS OF TRMINAL A
   	CMPQB	TRMA,RD_TRM	; IF TRMINAL_NUM<> 0 THEN
   	BEQ	RDCHRLP
	MOVD	USRTCS2+IOBEG,R1 ; R1: ADDRESS OF TRMINAL B
RDCHRLP:			; DO WHILE IN_RDY=0 AND RD_WAIT=TRUE
	TBITB	IN_RDY,0(R1)	;   INPUT IN_RDY
	BFS	RDCHR3	
;	BR	RDCHR3	; *** FOR DEBUG ONLY ***
	CMPQB	TRUE,RD_WAIT
	BEQ	RDCHRLP		; END;
	BR	RDCHREX
RDCHR3:	MOVB	(DATAP-USRTCS)(R1),RD_CHR ; RDCHR:=USART DATA
	MOVQB	TRUE,RD_WAIT	; RD_WAIT:=TRUE
RDCHREX:
	.ENDPROC
;
;
;	 T R A N S P A R E N T     M O D E    R E A D
;
;
TRANSR: .PROC
	.VAR	[R1,R2,R6]
TRSCMD:	.BLKW				; TRSCOM : ARRAY OF BOOLEAN
SVTRM2:	.BLKD				; SVTRM2 : INTEGER {TERM2 ADDRESS}
SVTRM1:	.BLKD				; SVTRM1 : INTEGER {TERM1 ADDRESS}
TRSC:	.BLKW				; TRSC	: ARRAY OF INTEGER*1 {COUNTERS}
	.BEGIN
   	MOVQW	0,TRSCMD		; TRSCMD[1] := 0 TRSCMD[2] := 0
	MOVQW	0,TRSC			; TRSC[1]:=0; TRSC[2]:=0;
	ADDR	TERM1,SVTRM1		; SVTRM1:=ADDRESS OF TERM1;
	ADDR	TERM2,SVTRM2		; SVTER2:=ADDRESS OF TERM2;
	MOVQD	0,R1			; TERM:=0
					; REPEAT
TRS1:	XORB	1,R1			;   TERM:=NEXT TERM
TRS2:	MOVQW	FALSE,TOS
	MOVB	R1,TOS			;   RDCHR (CHR,FALSE,ENDF,TERM);
	SPRD	MOD,TOS
	BSR	RDCHR
	CMPQB	TRUE,TOS		;   {R2:=CHR}
	MOVB	TOS,R3			;   IF ENDF THEN
	BNE	TRS1			;   BEGIN
	CMPQB	TRUE,TRSCMD[R1:B]	;     IF NOT TRSCMD[TERM]
	BEQ	TRS7			;     THEN
TRS3:   CMPB    CNTRLB,R3		;        ELSE
	BNE	TRS5			;          IF CHR=CONTROL X THEN
	MOVQB	TRUE,TRSCMD[R1:B]	;	      TRSCMD[TERM]:=TRUE
	BR	TRS1			;	    ELSE
TRS5:	XORB	1,R1
	MOVQB	TRUE,TOS
	MOVB	R3,TOS			;	      PRCHR(TRUE,CHR,NEXT TERM)
	MOVB	R1,TOS			;        END;
	SPRD	MOD,TOS
	BSR	PRCHR:W			;     END
	CMPQB	TRUE,TOS		;   {POP PR_READY}
	BR	TRS2			;   ELSE
TRS7:	MOVB	R1,TOS			;     DOECHO (TERM,CHR)
   	BSR	DOECHO
	MOVD	SVTRM1[R1:D],R7		;     {R7:=POINTER TO TERM-BUFFER}
	CMPB	R3,DELETE		;     IF CHR=DELETE THEN
	BNE	TRS9			;     BEGIN
	CMPQB	0,TRSC[R1:B]		;       IF CONT[TERM]>0
	BGE	TRS1			;       THEN
	ADDQD	-1,TRSC[R1:B]		;	  TRSC[TERM]:=TRSC[TERM]-1;
	BR	TRS1			;     END
TRS9:	ADDR	INBUF(R7),R6		;     ELSE
	MOVZBD	TRSC[R1:B],TOS		;     BEGIN
	ADDD	TOS,R6			;	INBUF[TERM,TRSC[TERM]]:=CHR;
	MOVB	R3,0(R6)
	MOVD	R6,INLM(R7)		;	INLM[TERM]:=TRSC[TERM];
	ADDQB	1,TRSC[R1:B]		;	TRSC[TERM]:=TRSC[TERM]+1;
	CMPB	ENDLIN,R3		;     END;
	BEQ	TRS10			; UNTIL (CHR=ENDLIN)
	CMPB	LINLIM,TRSC[R1:B]	;      OR (TRSC[TERM]>LINLIM);
	BGT	TRS1
TRS10:	MOVD	R7,DTRM			; DTRM:=TERM {SET DEFAULT TERMINAL}
	MOVB	R1,NDTRM
TRSEX:
	.ENDPROC
;
;  SKIP ON SPACE SUBROUTINE
;
COMP1:	ADDQD	1,R5			; DTRM.SCN:=DTRM.SCN+1;
COMPS:	CMPB	R5,INLM(R7)		; WHILE DRTM.SCN<DTRM.INLM
	BGE	COMPEX
	CMPB	0(R5),SPACE		;   AND INBUF(DTRM.SCN):=SPACE
	BEQ	COMP1			;     DTRM.SCN:=DTRM.SCN+1;
COMPEX:	RET	0			; END WHILE
;
;
;	P R I N T A
;
;	PRINT ARRAY PROCEDURE
;
; 	CALLING SEQUENCE PRINTA (ARRP,ENDP,PRTRM)
;	   ARRP  - POINTER TO ARRAY TO BE PRINTED
;	   ENDP  - POINTER TO LAST BYTE TO BE PRINTED
;	   PRTRM - # OF TERMINAL TO PRINT ON
;	   HND   - BOOLEAN FLAG IF HAND-SHAKING NEDDED
;
; LOCAL CONSTANTS
;
PRINTE:	.EQU	0		; END OF LINE INDICATOR
;
PRINTA: .PROC
ARRP:	.BLKD			; VAR: ARRAY OF CHR
ENDP:	.BLKD			;  POINTER
PRTRM:	.BLKB			;  INTEGER [0..1]
        .RETURNS
	.VAR	[R1,R2,R3,R4,R5,R6]
	.BEGIN
	MOVD	ARRP,R1		; R1:=POINTER TO PRINT ARRAY
   	MOVB	OPHND,R2	; R2:= OPMOD [PRTRM]
   	CMPQB	TRMA,PRTRM
   	BEQ	PRNTLP
   	LSHB	-4,R2
PRNTLP:
;	MOVB	0(R1),R4
   	CMPQB	TRUE,SVCPF	; IF SVCF THEN
   	BNE	PRNX1
   	MOVUSB	0(R1),SCRCH2	;     GET NEXT BYTE FROM USER SPACE
   	MOVB	SCRCH2,R4
   	BR	PRNT2		; ELSE
PRNX1: 	MOVB	0(R1),R4	;     GET NEXT CHAR FROM SUPERVISOR SPACE
PRNT2:	MOVQB	FALSE,R6	;    CNTS_FLAGE := 0
CNTS1:	MOVQW	FALSE,TOS	;    RDCHR (FALSEM,CHAR,PRTRM) READ NO WAIT
	MOVB	PRTRM,TOS
	SPRD	MOD,TOS
	BSR	RDCHR
	MOVB	TOS,R5		;    {POP FIRTST ARGUMENT }
	TBITB	0,R5		;    F := CHAR READY
	MOVB	TOS,R5		;    R5 := CHAR
	CMPQB	TRUE,R6		;    IF CNTS_FLAG = FALSE
	BEQ	CNTS2		;      THEN
	BFC	PRNX2		;	 IF NO CHAR READY GO TO PRINT
	CMPB	CNTRLS,R5	;        ELSE IF CHAR<> CNTRLS GO TO PRINT
	BNE	PRNX2		; 	      ELSE
	MOVQB	TRUE,R6		;                SNTS-FLAG := TRUE
	BR	CNTS1		;		 GO TO READ NEXT CHAR
CNTS2:	BFC	CNTS1		;    ELSE IF NO CHAR GO TO READ CHAR AGAIN
	CMPB	CNTRLQ,R5	;         ELSE
	BNE	CNTS1		;	    IF CHAR <> CNTRLS GO TO READ CHAR
				;           ELSE END OF /S/Q GO TO PRINT
PRNX2:	MOVB	FALSE,TOS	; GO TO EXIT
	MOVB	R4,TOS		;   PRCHR(TRUE,M(ARRP),PRTRM)
	MOVB	PRTRM,TOS
	SPRD	MOD,TOS
	BSR	PRCHR:W		;   {REMOVE ENDF FROM STACK}
	CMPQB	TRUE,TOS	; END
	BNE	PRNT2:W		; IF OUTPUT IS STILL GOING ON
PRNX3: 	CMPB	R4,CR		; IF (HAND[PRTRM] AND M[ARRP]=CR]
   	BNE	PRNT8		; THEN
   	TBITB	HANDB,R2	; BEGIN
   	BFC	PRNT5
   	MOVQB	0,R3
PRECHO:	MOVQW	TRUE,TOS	;    RDCHR (CHR,FALSE,RDTRM)
	MOVB	PRTRM,TOS
	SPRD	MOD,TOS
	BSR	RDCHR
   	CMPQB	0,TOS		;   {REMOVE ENDF FROM STACK}
   	CMPB	CR,TOS
   	BNE	PRNT4
   	TBITB	HANDLF,R2	;    IF HND[PRTRM] WAIT TO CR
   	BFC	PRNT5
   	MOVQB	1,R3
   	BR 	PRECHO
PRNT4:	CMPB	LF,-1(SP)
	BNE	PRECHO		; END
   	CMPQB	1,R3
   	BNE	PRECHO
PRNT5:	TBITB	ECHOLF,R2	; IF ECHOLF[PRTRM] THEN
   	BFC	PRNT8		; BEGIN
   	MOVB	LF,R4		;   ECHO WITH LF
   	BR	PRNT2		; END;
PRNT8: 	ADDQD	1,R1
	CMPD	R1,ENDP		;  REPEAT UNTILE ARRP>ENDP
	BGE	PRTAEX
	BR	PRNTLP
PRTAEX:
	.ENDPROC
;
;
;	S P R I N T A
;	STANDARD CALL TO PRINTA PROCEDURE
;
;	FUNCTION - PRINT OUTPUT BUFFER OF CURRENTLY WORKING TERMINAL
;
;	PARAMETERS - NONE
;
;	LOCAL VARIABLES - NONE
;
;
SPRINTA:
	ADDR	OUTB(R7),TOS
	MOVD	R6,TOS		; PRINTA (DTRM.OUTB,DTRM.OUTLM,DTRM)
	MOVB	NDTRM,TOS
	SPRD	MOD,TOS
	BSR	PRINTA
	RXP	0
;
;
;
;	P R C H R    ( PRINT CHARACTER )
;
;	FUNCTION - SEND ONE CHARACTER TO TERMINAL
;
;	CALLING SEQUENCE PRCHR(ENDF,WAIT,CHR,TRM)
;
;	 ENDF/WAIT	
;	 	BOOLEANO  IN/OUT ON INPUT FLAGE WAIT TO END OF OPERATION
;				 OR REURN
;				 ON OUTPUT INDICATES END OF OPERATION
;	 CHR  - CHARACTER INPUT  CHARACTER TO BE PRINTED
;	 TRM  - INTEGER   INPUT  TERMINAL NUMBER
;
PRCHR:	 .PROC
WAIT_PR: .BLKB			; WAIT : BOOLEAN
CHR_PR:	 .BLKB			; ASCII CHR
TRM_CHR: .BLKB			; TERMINAL NUMBER
	.RETURNS
	.BLKB			; OUTPUT WAIT WAIT:BOOLEAN
	.VAR	[R1,R2]
	.BEGIN
	MOVD	USRTCS+IOBEG,R1	; R1: ADDRESS OF TRMINAL A
   	CMPQB	TRMA,TRM_CHR	; IF TRMINAL_NUM<> 0 THEN
   	BEQ	PRCHRLP
	MOVD	USRTCS2+IOBEG,R1 ; R1: ADDRESS OF TRMINAL B
PRCHRLP: TBITB	OUT_RDY,0(R1)	; IF TX-RDY = 0
	BFS	PRCHR3	; THEN
;	BR	PRCHR3		; *** DEBUG ONLY ***
	CMPQB	FALSE,WAIT_PR	;   IF WAIT THEN REPET
	BNE	PRCHRLP
	BR	PRCHREX		;   ELSE WAIT:=FALSE
PRCHR3:	MOVB	CHR_PR,(DATAP-USRTCS)(R1)
	MOVQB	TRUE,WAIT_PR	; ELSE WRITE(DATA-PORT,CHR)
PRCHREX:
	.ENDPROC
;
;
;	H X T O B N  (HEXA-DECIMAL TO BINARY)
;
;
HXTOBN: .PROC
WORD_HB: .BLKD	; WORD_HB : DINTEGER
EXRR_HB: .BLKB		; EXRR : INTEGER
VECP_HB: .BLKD	; VECP : VAR :POINTER
ENDP_HB: .BLKD	; ENDP : POINTER
	.RETURNS
	.BLKB	9
	.VAR	[R0,R1,R4]
	.BEGIN
	MOVQD	0,R4		; WORD:=0
	MOVQB	TRUE,EXRR_HB	; EXRR:= TRUE
HTBLP:	ADDR	HEXAN+15:W,R1	; (* R1:= ADDRESS HEXAN+16 *)
	MOVZBD	16,R0		; I:=17 (* I IN R0 *)
;	SKIP	*** USE STRING INSTRUCTION ***
;	BFC	HTBEX
;
HTB1:	CMPB	0(VECP_HB),0(R1)	; IF M(VECP)<>HEXAN[I]
	ADDQD	-1,R0			; THEN
	BEQ	HTBF1
	CMPQD	0,R0			;    IF I=0 THEN EXIT
	BEQ	HTBEX
	ADDQD	-1,R1			;    ELSE I:=I-1
	BR	HTB1
HTBF1:	ASHD	4,R4
	ADDD	R0,R4		; WORD:=WORD*16+I
	MOVQB	FALSE,EXRR_HB	; EXRR:=FALSE
HTB2:	ADDQD	1,VECP_HB	; VECP:=VECP+1
	CMPD	VECP_HB,ENDP_HB ; UNTILE VECP>= ENDP
   	BLE	HTBLP
HTBEX:	MOVD	R4,WORD_HB
	.ENDPROC
HEXAN:	.BYTE	"0123456789ABCDEF"
;
;
;	B N T O H X   (BINARY TO HEX-DECIMAL CONVERSION)
;
;
BNTOHX: .PROC
WORD_BH: .BLKD	; WORD : DINTEGER
N_BH:	 .BLKB		; N : INTEGER
TYPE_BH: .BLKB		; TYPE : INTEGER[0..2]
         .RETURNS
	 .VAR	[R1,R2]
	 .BEGIN
BTHLP:	MOVZBD	N_BH,R2 ; (* R2:=VECP *)
	CMPQD	0,R2	;  WHILE N>0 DO
	BGE	BTHEX
	ADDQD	-1,R2
	ASHD	2,R2	; R2:=(N-1)*4 (* BIT FIELD *)
;
; **** RUN C ERROR ***
;
;	EXTB	R2,WORD_BH,TOS,4 ; R2:= N-TH HEXA DIGIT OF WORD
;   	MOVB	TOS,R2
;
	EXTB	R2,WORD_BH,R2,4 ; R2:= N-TH HEXA DIGIT OF WORD
	CMPQB	0,R2
	BNE	BTH2	; IF R2:=0 AND N>1 THEN
	CMPQB	1,N_BH	
	BEQ	BTH2
	CMPQB	1,TYPE_BH ; CASE TYPE OF
	BGT	BTH2	  ;   <1 PUT LEADING ZEROS
	BLT	BTH4	  ;   >1 SUPRESS LEADING ZEROS
	MOVB	" ",0(R6) ;   =1 INSERT SPACE FOR LEADING ZEROS
	BR	BTH3
BTH2:	MOVB	HEXAN[R2:B],0(R6) ; M(VECP):=HEXAN[R2]
	MOVQB	0,TYPE_BH
BTH3:	ADDQD	1,R6	; VECP:=VECP+1
BTH4:	ADDQB	-1,N_BH	; N:=N-1
	BR	BTHLP
BTHEX:
	.ENDPROC
;
;
;	T B S R C H  (TABLE SEREACH PROCEDURE )
;
;
TBSRCH: .PROC
TABADR:	.BLKD		; TABADDR : POINTER
LENGTH:	.BLKB		; LENGTH : INTEGER
	.RETURNS
EXITF:	.BLKB		; EXITF : BOOLEAN
	.VAR
	.BEGIN
	MOVQD	0,R2		; I:=0
				; REPEAT
SRCHL:	CMPW	0(TABADR)[R2:W],0(R5)
	BEQ	SRFND		;  IF TAB(I_I+1)<>INBUF(I_I+1)
	CMPB	0(TABADR)[R2:W],0(R5); THEN IF TAB(I)=INBUF(I)
	BNE	SRC2		;	    THEN
	CMPB	1(TABADR)[R2:W],SPACE;		IF TAB(I+1):=SPACE
	BEQ	SRFND2	;		 GOTO FOUND;
SRC2:	ADDQD	1,R2		;      ELSE
	CMPB	R2,LENGTH	;	I:=I+1;
	BLT	SRCHL		; UNTIL I=LENGTH;
	MOVQB	FALSE,EXITF	; EXITF:=FALSE;
	MOVQD	0,R2
	BR	SRCHEX
SRFND:	ADDQD	1,R5		; DTRM.SCN:=DTRM.SCN+1;
SRFND2:	ADDQD	1,R5		; DTRM.SCN:=DTRM.SCN+1;
	MOVQB	TRUE,EXITF	; EXITF:=TRUE
	BSR	COMPS		; COMPS  {COMPRESS SPACE}
SRCHEX:
	.ENDPROC
;
;
;	G E T P U T     P R O C E D U R E
;
;	FUNCTION - GET REGISTER OR MEMORY VALUE TO R1
;		   PUT REGISTER OR MEMORY VALUE FROM R1
;
;		   REGISTER IS ONE OF :
;		   PC,US,IS,INTB,SB,FP,MOD,PSR,MSR,EADD,PTB,PF,
;		   SC,BPR,BCNT,REAL-MSR,SP,FL,FSR,R,F,FSR,CFG,SOFT-BPR
;		   HEAP-START,HEAP-END,HEAP-POINTER
;
;		   MEMORY IS : BYTE WORD DOUBLE
;
;		   R2 CONTAINS REGISTER # (OR MEMORY)
;
;	CALLING SEQUENCE GETPUT (GET_PUT,TYPE,N,VALUE)
;	      GETPUT -  0 GET
;			1 PUT
;	      TYPE   -	REGISTER TYPE (IN R2)
;	      N      -	REGISTER NUMBER
;	      VALUE  -  VALUE GET (OR PUT) IN R1
;
GETI:	.EQU	0			; GET INDICATOR
PUTI:	.EQU	1			; PUT INDICATOR
MMSRC:	.EQU	15			; MMSR NUMBER IN REGTB
;
GETPUT: .PROC
GET_PUT: .BLKB				; GET-PUT : INTEGET [0..1]
N_GP:	 .BLKD				; N	  : DINTEGER
         .RETURNS
	 .VAR	[R0,R3]
TEMP:	.BLKD				; TEMPORARY
	 .BEGIN
	MOVQW	0,SVMOD+2		; CLEAR UN EXISTING PART OF MOD
	MOVD	N_GP,R0
	MOVQD	0,R3
	CMPQB	GETI,GET_PUT		; (* SET CC IF OPERATION IS GET *)
	EXTSB	REGTB[R2:D],R3,0,4	; GET OPERATION TYPE
;	EXTSB	REGTB[R2:D],R3,3	; GET OPERATION TYPE
LGP:	CASEW	CASE_GP[R3:W]		; CASE OF OPERATIN NUMBER
CASE_GP: .WORD	GMPUL-LGP		; MPU OPERATION
	 .WORD	GMMUL-LGP		; MMU   "
	 .WORD	GSPL-LGP		; SP    "
	 .WORD	GFPUL-LGP		; FPU   "
	 .WORD	GFSRL-LGP		; FSR   "
	 .WORD	PCFGL-LGP		; CFG   "
	 .WORD	GML-LGP			; MEMORY "
	 .WORD	BRL-LGP			; SOFT-BREAK
   	 .WORD  GMSRL-LGP		; MSR
   	 .WORD  INTBL-LGP		; INTBASE
GMSRL:	SMR	MSR,SCRCH1	; TRAP IF NO MMU
GMPUL:	NEGD	R0,R0
BRL:	MULD	4,R0
	MOVZBD	REGTB+3[R2:D],R3
	ADDD	R3,R0		;    R0:=REGTB.OFFSET+4*R0
GMPUL2:	ADDR	SEREA[R0:B],R0
   	CMPQB	-2,REGTB+2[R2:D]
   	BNE	GMPUL3	; IF REGTB.L2=-2 THEN  {HEAP AND SB INDIRECT
   	MOVD	0(R0),R0	;    R0  := M[R0]        READ}
   	MOVB	26,R2		;  *** REGTB DEFINITION ***
   	BR	GML:W
GMPUL3:	CMPQB	GETI,GET_PUT
	BNE	PMPUL		; IF GET COMMAND THEN
	MOVD	0(R0),R1	;    R1:=SEREA[REGTB.OFFSET]
	BR	GPREX:W
PMPUL:	MOVD	R1,0(R0)	; ELSE  SEREA[REGTB.OFFSET]:=R1;
	BR	GPREX:W
;
; GET PUT SP
;
GSPL:	MOVB	USX+3,R0
	TBITB	PSR_S,SVPSR	; IF PSR_S THEN
	BFS	GMPUL2		;    R0:=US-OFFSET
	MOVB	ISX+3,R0	; ELSE
	BR	GMPUL2		;    R0:=IS-OFF_SET
;
; GET PUT INTBASE
;
INTBL:	BNE	INTB4		; IF GET THEN
   	SPRD	INTBASE,R1	;  R1 := INTBASE
   	BR	GPREX:W		; ELSE
INTB4: 	LPRD	INTBASE,R1	;    INTBASE := R1;
   	BR	GPREX:W
;
; GET PUT FPU REG
;
MOVFI1: MOVF	F0,4(SP)
MOVFI2: MOVF	4(SP),F0
;
GFPUL:	MOVD	R1,TOS		;MOVE DATA TO STACK
   	BNE	PFPUL		; IF GET THEN
   	MOVD	MOVFI1,JMPRAM	; COPT MOVFF INS TO RAM
;
; *** 16032 REV F BUG ***
;
	MOVQD	3,R3
   	INSB	R3,R0,JMPRAM+2,5;   CHANGE GEN 1
   	BR	GFPU4		; ELSE
PFPUL: 	MOVD	MOVFI2,JMPRAM	; COPT MOVFF INS TO RAM
;
; *** 16032 REV F BUG ***
;
	MOVQD	6,R3
   	INSB	R3,R0,JMPRAM+1,5	;   CHANGE GEN 2
GFPU4:	MOVW	RET0,JMPRAM+4	; COPY RET 0 INS
   	JSR	JMPRAM		; EXECUTE MOVFF INS
GFPU6:	MOVD	TOS,R1		; COPY FROM STACK TO R1
   	BR	GPREX:W
;
;
; GET PUT FSR
;
;
GFSRL:	BNE	PFSRL		; IF GET THEN
	SFSR	TOS		;   MOVE FSR TO STACK
   	BR	GFPU6		; ELSE
PFSRL:	MOVD	R1,TOS		; MOVE R1 TO FSR VIA STACK
   	LFSR	TOS
   	BR	GPREX:W
;
; GET PUT MMU REG
;
; C.P.U. BUG ****
;
;SMRL:	SMR	BPR0,R1		; SMR INSTRUCTION
;LMRL:	LMR	BPR0,R1		; LMR INSTRUCTION
;
SMRL:	SMR	BPR0,TEMP		; SMR INSTRUCTION
LMRL:	LMR	BPR0,TEMP		; LMR INSTRUCTION
RET0:	RET	0		; RET 0 INSTRUCTION
;
GMMUL:	MOVD	R1,TEMP
   	MOVD	SMRL,JMPRAM	; IF GETPUT:=GET THEN
	BEQ	MMUL2		;    COPY SMR TO RAM
	MOVD	LMRL,JMPRAM	; ELSE COPY LMR TO RAM
   	CMPB 	MMSRC,R2	; IF MMSR THEN
   	BNE	MMUL2		;   MNMSR := R1;
   	MOVD	R1,MNMSR
MMUL2:	ADDB	REGTB+3[R2:D],R0 ;R0:=N+REGTB.OFFSET
MMUL3:	MOVW	RET0,JMPRAM+4	; COPY RET 0
;	 *** INSS REG F CPU BUG ***
;
;	INSSB	R0,JMPRAM+1,7,4	; INSET REG NUMBER
;
   	LSHW    7,R0
   	ANDW	H'F87F,JMPRAM+1
   	ORW	R0,JMPRAM+1
;
	JSR	JMPRAM		; JUMP TO RAM
   	MOVD	TEMP,R1
	BR	GPREX:W
;
; GET PUT CFG
;
PCFGL:	MOVD	R1,R0		; (* MOVE OPERAND TO R0 *)
	BEQ	GCFG		; IF GETPUT=PUT THEN
	MOVB	R1,CONFIG	;   CONFIG:=R1
	MOVD	SCFGL,JMPRAM	;   COPY SETCFG INSTRUCTION TO RAM
	BR	MMUL3		;   GOTO MMUL2
SCFGL:	SETCFG	[]		; (* SETCFG INSTRUCTIN *)
   	NOP			; *** SMR X,RN BUG ***
GCFG:	MOVZBD	CONFIG,R1	; ELSE R1:=CONFIG;
	BR	GPREX:W
;
; GET PUT MEMORY
;
GML:	CMPQB	GETI,GET_PUT	; IF GET THEN
   	BNE	PML		;   CLEAR R1
   	MOVQD	0,R1
PML:	MOVD	R1,SCRCH2
   	MOVB	REGTB+3[R2:D],R3	; GET B W D INDICATOR
	ADDB	GET_PUT,R3	; R3:= B W D +GET_PUT
GMCASE:	CASEB	GM2[R3:B]	; CASE OF (B W D ) + GET_PUT
GM2:	.BYTE	GB-GMCASE		; GET BYTE
	.BYTE	PB-GMCASE		; PUT BYTE
	.BYTE	GW-GMCASE		; GET WORD
	.BYTE	PW-GMCASE		; PUT WORD
	.BYTE	GD-GMCASE		; GET DOUBLE WORD
	.BYTE	PD-GMCASE		; PUT DOUBLE  WORD
GB:	MOVUSB	0(R0),SCRCH2	; R1:=M(ADDR) *** MOVUS ***
	BR	GPRE1
PB:	MOVSUB	SCRCH2,0(R0)	; M(ADDR):=R1 *** MOVSU ***
	BR	GPREX
GW:     MOVUSW  0(R0),SCRCH2    ; R1:=M(ADDR) *** MOVUS ***
        BR      GPRE1
PW:	MOVSUW	SCRCH2,0(R0)	; M(ADDR):=R1 *** MOVSU ***
	BR	GPREX
GD:	MOVUSD	0(R0),SCRCH2	; R1:=M(ADDR) *** MOVUS ***
GPRE1: 	MOVD	SCRCH2,R1
	BR	GPREX
PD:	MOVSUD	SCRCH2,0(R0)	; M(ADDR):=R1 *** MOVSU ***
GPREX:
	.ENDPROC
