	PAGE	,132
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;***	DCOPY - Disk Copy Utility
;
;	This program copies a source disk to a destination
;	disk, on a track by track bases. The destination
;	disk is formatted first.
;
;	SYNTAX: DISKCOPY[/V][ s: d:]
;		DISKCOMP[ s: d:]
;
;	s: is the source drive, and d: is the destination
;	drive. The drives are checked for compatability by
;	comparing there loader tables.
;
;	LAST MODIFIED:	11/1/82 Brian Barnes
;		better compatibility checking
;
;	9/26/83 - RJM
;		  Modified for the Z150 computer, different
;		  compatibility checking.
;	Version 2.03 - Do not verify loader in case date stamping is active
;	Version 2.04 - BIOS 2.0 moved to 70H
;	Version 2.05 - 5/11/84 Fix Z150FMT.ASM to format partitions
;		       with bad sectors.
;	Version 2.06 - 5/14/84 Change head settle time in ZLOAD.ASM for Shugart drives
;	Version 2.07 - 9/7/84 Z150FMT.ASM (V1.08) changed to get sector
;		       per track info. from controller
;	Version 2.08 - 9/21/84 Z150FMT.ASM (V1.09) changed:
;			1) Verify winchester disk only when using /V switch
;			2) Clear winchester partition directory
;			3) Check if MAP program is installed
;	Version 2.09 - 10/13/84 Corrected problem in Z150FMT.ASM which
;			caused double sided floppies to be verified as if
;			they were single sided.
;	Version 2.10 - 10/18/84 Corrected problem in Z150FMT.ASM which caused
;			bad sectors on winchesters to be reported as one
;			greater than the true bad sector.
;	Version 2.11 - 10/23/84 Corrected problem in Z150FMT.ASM which caused
;			"Format Failure to occur when the format module was
;			loaded at certain addresses near 64kb memory boundries.
;	Version 2.12 - 3/15/85 Corrected problem in Z150FMT.ASM which did not 
;			correctly handle bad sectors > 7FFFH.
;	Version 2.13 - 8/5/85 Link in Z150FMT to reset disk system after format
;			error.
;	Version 2.14 - 8/20/85 Z150FMT v1.15.
;		       1/6/86 - Added SYNTREX signon


FALSE	EQU	0
TRUE	EQU	NOT FALSE

ZENITH	=	TRUE
NBI	=	FALSE
SYNTREX	=	FALSE
 
MAXSECSIZ	EQU 512		;Max sector size can handle

WINCH_MBYTE	EQU	0F8H	; Winchester media byte

	INCLUDE	..\COMMONS\MSDOS.DEF
	INCLUDE	..\COMMONS\Z150BIOS.DEF
	INCLUDE	..\COMMONS\Z150ROM.DEF
	INCLUDE	..\COMMONS\LOADER.DEF
	INCLUDE ..\COMMONS\DRIVERS.DEF

;	Interrupt function calls

SVC	MACRO	ARG
	MOV	AH,ARG
	INT	21H
	ENDM


;*	Entry Point

CODE	SEGMENT	BYTE PUBLIC 'PROG'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

  IF NOT DCOMP
	EXTRN	DRIVE:BYTE,SWITCHMAP:WORD,SWITCHCOPY:WORD
	EXTRN	DSKINIT:NEAR,DSKFMT:NEAR
  ENDIF

	ORG	100H		;Will be a .COM file

BEGIN:	MOV	SP,OFFSET STACK	;Set up local stack
	MOV	BYTE PTR VERFLG,0

	MOV	DX,OFFSET SIGNON
	SVC	DOSF_OUTSTR

;	Get the maximum drive letter

	SVC	DOSF_GETDISK
	MOV	DL,AL
	SVC	DOSF_SELDISK
	ADD	AL,'A'-1
	MOV	LET1,AL			; Update messages for drive prompts
	MOV	LET2,AL

;	Determine the number of floppys in the system for compatibility check

	INT	EQUIPMENT_INTR
	ROL	AL,1
	ROL	AL,1
	AND	AL,3
	JNZ	SKIP
	INC	AL
SKIP:
	INC	AL
	MOV	NUM_FLOPPY,AL

;	Get free space information

  IF DCOMP
	MOV	BX,OFFSET STACK
	MOV	CX,4
	SHR	BX,CL
	INC	BX
	MOV	AX,BX
	MOV	BX,CS
	ADD	BX,AX
  ELSE
	MOV	WORD PTR SWITCHMAP,0
	CALL	DSKINIT
  ENDIF

;	BX = first free paragraph

	MOV	FREPAR,BX
	MOV	SI,PHD_MEMSIZE
	MOV	BX,[SI]		;BX = Max Ram value
	MOV	CX,0FFFFH
	SUB	BX,FREPAR
	CMP	BX,1000H
	JNB	BEGIN1		;If more than 64K free

;	BX = free paragraphs available

	MOV	AX,BX		;Move to cx
	MOV	CX,4
	SHL	AX,CL
	MOV	CX,AX
BEGIN1:
	MOV	FRESIZ,CX		;Set free size

;	FREPAR = first free paragraph, CX = bytes in paragraph

	MOV	BX,FREPAR
	MOV	AX,CS
	SUB	BX,AX			; BX = # of paragraphs up to first
	MOV	AX,CX
	MOV	CL,4
	SHR	AX,CL
	INC	AX			; AX = # of paragraphs free
	ADD	BX,AX			; BX = total # of paragraphs needed
	MOV	AH,DOSF_SETBLK
	INT	21H			; Set it in

   IF NOT DCOMP
;	See if switch on line

	MOV	SI,081H		;DMA address
SOB1:
	CMP	BYTE PTR [SI],' '
	JNZ	SOB2
	INC	SI
	JMP	SOB1
SOB2:
	MOV	AH,DOSF_CHROP
	XOR	AL,AL
	INT	21H		;Read switch character
	MOV	AL,[SI]
	CMP	AL,DL		;Was it the switch character
	JNZ	BEGIN2
HAVSW:
	MOV	AL,[SI+1]
	CMP	AL,'V'
	JZ	BEGIN1A
	CMP	AL,'v'
	JNZ	BEGIN2		;Had /, but no V

;	Had a /V

BEGIN1A:
	MOV	BYTE PTR VERFLG,1	;Set verify
   ENDIF
BEGIN2:

;	See if parameters given

	MOV	SI,PHD_FCB1
	MOV	AL,[SI]		;AL = given drive
	TEST	AL,AL
	JZ	GETDRV		;Must get drives

;	Source drive on command line

	DEC	AL
	MOV	SDRV,AL		;Save source drive

;	Now get destination drive

	MOV	SI,PHD_FCB2
	MOV	AL,[SI]		;AL = dest drive
	TEST	AL,AL
	JZ	GETDRVD		;Get dest drive from user

	DEC	AL
	MOV	DDRV,AL		;Save dest drive
	MOV	BYTE PTR MODE,1	;Set mode flag
	JMP	MAIN		;Main control loop

SAMDRV:	MOV	DX,OFFSET BADDRV
	SVC	DOSF_OUTSTR
	MOV	SP,OFFSET STACK

;	User must be prompted for source drive

GETDRV:	MOV	DX,OFFSET SPROMPT
	SVC	DOSF_OUTSTR	;Print user prompt
	MOV	AL,DOSF_DRCINE
	SVC	DOSF_CONINF
	CALL	MCU
	CALL	VRFDRV
	JC	BADSDRV
	PUSH	AX
	MOV	DL,AL
	SVC	DOSF_CONOUT
	POP	AX
	SUB	AL,'A'
	MOV	SDRV,AL		;Set it in
	CALL	CRLF

;	Now get destination drive name

GETDRVD: MOV	DX,OFFSET DPROMPT
	SVC	DOSF_OUTSTR
	MOV	AL,DOSF_DRCINE
	SVC	DOSF_CONINF
	CALL	MCU
	CALL	VRFDRV
	JC	BADDDRV
	PUSH	AX
	MOV	DL,AL
	SVC	DOSF_CONOUT
	POP	AX
	SUB	AL,'A'
	MOV	DDRV,AL
	MOV	BYTE PTR MODE,0	;Set mode = 0
	CALL	CRLF
	JMP	MAIN		;Main loop

;*	CRLF - Print CR/LF

CRLF:	MOV	DX,OFFSET CRLFMSG
	SVC	DOSF_OUTSTR
	RET

;*	VRFDRV - Verify drive name
;
;	Verify AL between 'A' and 'H' if WINCH or
;	'A' and 'D' if NOT WINCH
;

VRFDRV:
	CMP	AL,'A'
	JC	VRFDRV1
	CMP	AL,LET1		; Check against maximum drive letter
	JA	VRFDRV1
	CLC
	RET
VRFDRV1:
	STC
	RET

;*	BADxDRV - Bad Drive Name
;
;	Beep and get new name
;

BADSDRV:
	MOV	DL,7
	SVC	DOSF_CONOUT
	JMP	GETDRV
BADDDRV:
	MOV	DL,7
	SVC	DOSF_CONOUT
	JMP	GETDRVD

;	Data for initialization routines

IF	ZENITH
  IF NOT DCOMP
SIGNON	DB	0DH,0AH,'             DISKCOPY version 2.14'
  ELSE
SIGNON	DB	0DH,0AH,'             DISKCOMP version 2.14'
  ENDIF
	DB	0DH,0AH,'Copyright(C) 1984, Zenith Data Systems Corporation'
	DB	0DH,0AH,0AH,'$'
ENDIF

IF	NBI
  IF NOT DCOMP
SIGNON	DB	0DH,0AH,'  DISKCOPY version 2.14'
  ELSE
SIGNON	DB	0DH,0AH,'  DISKCOMP version 2.14'
  ENDIF
	DB	0DH,0AH,'(C)Copyright NBI, Inc. 1984'
	DB	0DH,0AH,0AH,'$'
ENDIF

IF	SYNTREX
  IF NOT DCOMP
SIGNON	DB	0DH,0AH,'     DISKCOPY version 2.14'
  ELSE
SIGNON	DB	0DH,0AH,'     DISKCOMP version 2.14'
  ENDIF
	DB	0DH,0AH,'(C)Copyright SYNTREX, Inc. 1986'
	DB	0DH,0AH,0AH,'$'
ENDIF


  IF DCOMP
MORMSG	DB	0DH,0AH,'Do you wish to compare more disks (Y/N)? <N> $'
  ELSE
MORMSG	DB	0DH,0AH,'Do you wish to copy another disk (Y/N)? <N> $'
  ENDIF

CRLFMSG DB	0DH,0AH,'$'

BADDRV	DB	0DH,0AH,'Drives specified must not'
	DB	' be the same',0DH,0AH,'$'

  IF DCOMP
SPROMPT DB	0DH,'Source1 drive name? (A-'
LET1	DB	' )   :',8,8,'$'
DPROMPT DB	0DH,'Source2 drive name? (A-'
LET2	DB	' )   :',8,8,'$'
  ELSE
SPROMPT DB	0DH,'Source drive name? (A-'
LET1	DB	' )   :',8,8,'$'
DPROMPT DB	0DH,'Destination drive name? (A-'
LET2	DB	' )   :',8,8,'$'
  ENDIF


LINE	DB	7,7 DUP (?)
SDRV	DB	?		;Z-DOS drive number
DDRV	DB	?		;Z-DOS drive number
MODE	DB	?		;=1 if command line taken
FREPAR	DW	?
FRESIZ	DW	?
SECCNT	DW	?		;Number of sectors on disk
SECSIZ	DW	?		;Bytes/sector on disk
CURSEC	DW	?		;Current sector
VERFLG	DB	?		;=1 if to verify
NUM_FLOPPY DB	0		; Number of floppies in the system
	PAGE
;**	MAIN - Main Loop
;
;	MAIN is the main loop. It initializes
;	the destination drive, and then copies
;	the source to the destination.
;


MAIN:

;	Check drive validity

	MOV	AL,SDRV
	CMP	AL,DDRV
	JNZ	MAIN0		;Ok, Continue
	JMP	SAMDRV		;Error, Bail out

MAIN0:
MAIN1:
	CALL	PROMPT
   IF NOT DCOMP
	CALL	FORMAT
	JNC	MAIN2
	CALL	FERR		;Format Error
	JMP	SHORT MAIN4
MAIN2:
	CALL	COPY
	JNC	MAIN3
	CALL	CERR		;Copy error
	JMP	SHORT MAIN4
MAIN3:
	CMP	BYTE PTR VERFLG,1
	JNZ	MAIN4		;No /V
   ENDIF
	CALL	VERIFY
	JNC	MAIN4
	CALL	VERR		;Verify error
MAIN4:

	CMP	BYTE PTR MODE,1	;See if from command line
	JZ	MAIN6		;If so, exit now

;	No command line, prompt for more

	MOV	DX,OFFSET MORMSG
	SVC	DOSF_OUTSTR
	MOV	DX,OFFSET LINE
	SVC	DOSF_INSTR
	CALL	CRLF
	MOV	AL,LINE+2
	CMP	AL,'Y'
	JZ	DOMORE		;If Y continue
	CMP	AL,'y'
	JZ	DOMORE
	JMP	SHORT MAIN6

;	Do more diskettes

DOMORE:
	JMP	GETDRV


;	User did not say Y

MAIN6:
;	All done, Exit out

	XOR	AL,AL
	INT	20H

	PAGE
;*	MCU - Map Character to Upper
;
;	MCU maps character in AL to upper case
;

MCU:	CMP	AL,'a'
	JB	MCU1		;Too low
	CMP	AL,'z'
	JA	MCU1		;Too high

;	Map from lower to upper

	SUB	AL,'a'-'A'
MCU1:	RET

;*	Disk I/O Subroutines
;


;*	RDSRC - Read source disk
;
;	ENTRY:	CX	=	Amount
;		DX	=	Logical sector
;
;	EXIT:	Data read at FREPAR:0
;
;	USES:	ALL
;

RDSRC:	PUSH	DS
	MOV	BX,FREPAR
	MOV	DS,BX
	XOR	BX,BX
	MOV	AL,CS:SDRV
	INT	25H		;Read it

;	Check errors

	JC	RDSRC1

;	No error

	POPF
	POP	DS
	CLC
	RET

RDSRC1:
	POPF
	POP	DS
	MOV	DX,OFFSET RDSERR
	SVC	DOSF_OUTSTR
	STC
	RET


;*	WTDST - Write Destination
;
;	WTDST writes the buffer to the destination disk
;

WTDST:
	PUSH	DS
	MOV	BX,FREPAR
	MOV	DS,BX
	XOR	BX,BX

	MOV	AL,CS:DDRV
	INT	26H			;Do write

;	Check for errors

	JC	WTDST1			;If errors

;	No errors

	POPF
	POP	DS
	CLC
	RET

;	Errors

WTDST1:
	POPF
	POP	DS
	MOV	DX,OFFSET WTDERR
	SVC	DOSF_OUTSTR
	STC
	RET

;*	RDDST - Read destination
;
;	CX = COUNT, DX = SECTOR, BX = ADDRESS
;

RDDST:
	PUSH	DS
	PUSH	BX
	MOV	BX,FREPAR
	MOV	DS,BX			;Set par address
	POP	BX
	MOV	AL,CS:DDRV
	INT	25H			;read them

;	Check errors

	JC	RDDST1			;If errors
	POPF
	POP	DS
	CLC
	RET

RDDST1:
	POPF
	POP	DS
	MOV	DX,OFFSET RDDERR
	SVC	DOSF_OUTSTR
	STC
	RET

;*	Error messages for disk i/o
;

  IF DCOMP
RDSERR	DB	0DH,0AH,'Read error on source1 drive',0DH,0AH,'$'
RDDERR	DB	0DH,0AH,'Read error on source2 drive',0DH,0AH,'$'
  ELSE
RDSERR	DB	0DH,0AH,'Read error on source drive',0DH,0AH,'$'
RDDERR	DB	0DH,0AH,'Read error on destination drive',0DH,0AH,'$'
  ENDIF
WTDERR	DB	0DH,0AH,'Write error on destination drive',0DH,0AH,'$'

;*	PROMPT - Get disks from user
;

PROMPT:	MOV	AL,SDRV
	ADD	AL,'A'
	MOV	PROMPTA,AL
	MOV	AL,DDRV
	ADD	AL,'A'
	MOV	PROMPTB,AL
	MOV	DX,OFFSET PROMPT0
	SVC	DOSF_OUTSTR
PROMPT1:
	SVC	DOSF_CONIN
	CMP	AL,0DH
	JNZ	PROMPT1
	RET

  IF DCOMP
PROMPT0 DB	0DH,0AH,'Place the source1 disk in '
PROMPTA DB	'x and the source2 disk in '
  ELSE
PROMPT0 DB	0DH,0AH,'Place the source disk in '
PROMPTA DB	'x and the destination disk in '
  ENDIF
PROMPTB DB	'x.',0DH,0AH,'Press RETURN when ready.',0DH,0AH,'$'

;***	FORMAT - Format user diskette
;
;	FORMAT Verifies the validity of the source
;	and destination diskettes, and then formats
;	the desired disk.
;

   IF NOT DCOMP
FORMAT:

;	Log in source, and set SECCNT and SECSZ appropriately
	CALL	LOGS			; AL returns with FAT id
	JC	FORMAT3

;	Set appropriate format flags

	TEST	AL,FAT_ID_DS		; Check for double sided disk
	JNZ	FORMAT1
	OR	SWITCHMAP,4		;Set in /M single sided
FORMAT1:
	TEST	AL,FAT_ID_8		; Check for 8 sectors per track
	JZ	FORMAT2
	OR	SWITCHMAP,32		;Set the /8 switch
FORMAT2:
	MOV	AL,DDRV
	MOV	DRIVE,AL
	MOV	DX,SWITCHMAP
	MOV	SWITCHCOPY,DX
	AND	DX,0FFFFH-2		;Mask out /C switch
	PUSH	DX			;Save our switch map
	CALL	DSKINIT			;Initialize diskette

;	Did DSKINIT alter our switch setting?

	POP	DX
	MOV	BX,SWITCHMAP
	AND	BX,0FFFFH-2		;Mask out his /C switch
	CMP	BX,DX
	JNZ	FORMAT3			;Yes, he did!

;	SI points to his loader table

	MOV	DI,DISK_BPB_OFFSET
	PUSH	ES
	MOV	BX,FREPAR
	MOV	ES,BX
	CALL	CHKTYP			;Check disk types, 'nz' set if
	POP	ES			; different
	JNZ	FORMAT3

;	Are the same, Go ahead and format this guy

	MOV	DX,OFFSET FORMATING
	SVC	DOSF_OUTSTR
	CALL	DSKFMT			;Format the drive
					; 'C' set by DSKFMT for return
	RET

;	Incompatable media

   ENDIF

FORMAT3:
	MOV	DX,OFFSET ICMEDIA
	SVC	DOSF_OUTSTR
	STC
	RET

ICMEDIA DB	0DH,0AH,'Incompatible media. Can not continue.'
	DB	0DH,0AH,'$'

   IF NOT DCOMP
	PAGE
;*	CHKTYP - Check Type
;
;	CHKTYP checks the source at ES:DI and DS:SI for
;	compatibility. 'nz' set if not compatible
;
;

CHKTYP:

;	The following checks are made:
;
;		1. If the media bytes are different, disks are incompatible
;		2. If media bytes are the same and not WINCH_MBYTE (a
;		   winchester partition) then disks are compatible.
;		3. If both are winchesters then they are compatible only if
;		   the loaders are identical from BPB_SECSZ to BPB_FATSECS

;	Check if both are 5 1/4" floppies, if so then compatible

	MOV	AL,CS:NUM_FLOPPY
	CMP	AL,CS:SDRV
	JBE	CT1
	CMP	AL,CS:DDRV
	JA	CT_GOOD
CT1:
	MOV	AL,BPB_MBYTE[SI]
	CMP	AL,ES:BPB_MBYTE[DI]
	JNZ	CT_BAD			; If different, incompatible
	CMP	AL,WINCH_MBYTE
	JNZ	CT_GOOD			; If not winchester, compatible
	MOV	CX,BPB_FATSECS-BPB_SECSZ	; Check loader
	CLD
	REPZ	CMPSB
	RET
CT_GOOD:
	SUB	AL,AL			; Set 'Z' flag, compatible
	RET
CT_BAD:
	MOV	AL,1
	OR	AL,AL			; Clear 'Z' flag, incompatible
	RET

	PAGE
;*	COPY - Copy disk data
;
;	COPY copies the data from the source disk
;	to the destination disk
;

COPY:
	MOV	DX,OFFSET COPYING
	SVC	DOSF_OUTSTR

	XOR	DX,DX
	MOV	CURSEC,DX		;Start at sector 0
	MOV	DX,SECCNT
	MOV	SECLFT,DX		;Set number left to go

;	Log in destination drive

	CALL	LOGD

;	Loop here to copy more sectors

COPY1:
	MOV	DX,CURSEC		;DX = current sector
	CMP	SECCNT,DX		;See if we did them all
	JNZ	COPY2			;Nope

;	Did all the sectors without error

	CLC
COPY0:
	RET

;	Copy a group of sectors

COPY2:
	STC
	CALL	CTCNT			;Compute transfer count
	MOV	CX,TRNCNT		;CX = count
	MOV	DX,CURSEC
	CALL	RDSRC			;Read the source
	JC	COPY0			;If errors

;	Have read some, now write it

	MOV	CX,TRNCNT
	MOV	DX,CURSEC
	CALL	WTDST			;Write to dest
	JC	COPY0

;	Have copied all sectors, update CURSEC

	MOV	CX,TRNCNT
	ADD	CURSEC,CX
	JMP	COPY1			;Now copy more

   ENDIF

VERIFY:
	MOV	DX,OFFSET VERIFYING
	SVC	DOSF_OUTSTR

	CALL	LOGS
	JNC	VERIFY0A
	JMP	VERR
VERIFY0A:
	CALL	LOGD			;Log in destination

VERIF1A:
	MOV	DX,1			; Start after loader
	MOV	CURSEC,DX		; Set current to 0
	MOV	DX,SECCNT
	MOV	SECLFT,DX		; Set sectors left to go
	DEC	SECLFT			; Do not compare loader because
					;  of date stamping

;	Loop to read and compare more data

VERIFY1:
	MOV	DX,CURSEC
	CMP	SECCNT,DX
	JNZ	VERIFY2			;If not all done

	CLC
VERIFY0:
	RET

;	Read next chunk

VERIFY2:
	CLC
	CALL	CTCNT
	MOV	DX,CURSEC
	MOV	CX,TRNCNT		;Set up registers
	CALL	RDSRC
	JC	VERIFY0

;	Source read, now read in destination

	MOV	CX,TRNCNT
	MOV	DX,CURSEC
	MOV	BX,TRNSIZ		;Amount read above
	CALL	RDDST			;Read dest
	JC	VERIFY0

;	Was able to read them all, now compare

	PUSH	DS
	PUSH	ES
	MOV	BX,FREPAR
	MOV	DS,BX			; Set up segments
	MOV	ES,BX
	XOR	SI,SI			; Source at this segment
	MOV	DI,CS:TRNSIZ		; Destination at transfer size
	MOV	CX,CS:TRNSIZ		; Compare transfer size bytes
	CLD
CUROK:
	REPZ	CMPSB			;See if match
	POP	ES
	POP	DS
	STC
	JNZ	VERIFY0			;Nope

;	Bump current sector value

	MOV	CX,TRNCNT
	ADD	CURSEC,CX
	JMP	SHORT VERIFY1		;Do again

	PAGE
;*	Error Handlers
;

   IF NOT DCOMP
FERR:
	MOV	DX,OFFSET FMSG
	JMP	SHORT ERROR
	RET
CERR:
	MOV	DX,OFFSET CMSG
	JMP	SHORT ERROR
	RET
   ENDIF

VERR:
	MOV	DX,OFFSET VMSG
ERROR:
	SVC	DOSF_OUTSTR
	CALL	CRLF
	RET

   IF NOT DCOMP
FORMATING DB	0DH,0AH,'Formatting destination...$'
COPYING DB	0DH,0AH,'Copying...$'
FMSG	DB	0DH,0AH,'Format Failure on destination drive.$'
CMSG	DB	0DH,0AH,'Disk copy failure$'
   ENDIF
VMSG	DB	0DH,0AH,'Disk verify failure$'
VERIFYING DB	0DH,0AH,'Verifying...$'

;*	CTCNT - Compute transfer count
;
;	CTCNT computes the number of sectors that can fit
;	in RAM, leaving that value at TRNCNT
;
;	If CY is set, use all available ram, otherwise
;	only 1/2 of available ram
;

CTCNT:
	PUSHF
	MOV	AX,FRESIZ
	XOR	DX,DX
	MOV	CX,SECSIZ
	POPF
	JC	CTCNT0
	SHR	AX,1			;Cut RAM in half
CTCNT0:
	DIV	CX			;Divide space by sec size

;	AX = number of sectors that i can use

	CMP	SECLFT,AX		;See if that many left
	JB	CTCNT1
	JMP	SHORT CTCNT2

;	Can read all thats left

CTCNT1:	MOV	AX,SECLFT
CTCNT2:	SUB	SECLFT,AX
	MOV	TRNCNT,AX

;	Compute transfer size in bytes

	MOV	CX,SECSIZ
	MUL	CX

;	Result in DX:AX

	MOV	TRNSIZ,AX

	RET

TRNSIZ	DW	?
TRNCNT	DW	?
SECLFT	DW	?

;	Number of sectors in each floppy disk format
FLOPPY_SECTORS	LABEL	WORD
	DW	9*40		; fat id FCH
	DW	9*40*2		; fat id FDH
	DW	8*40		; fat id FEH
	DW	8*40*2		; fat id FFH

;*	LOGS - Log in source drive
;
;	LOGS logs in the source drive, sets SECCNT to the number
;	of sectors on the disk, set SECSZ to the sector size
;	of the disk and returns the FAT ID of the disk in AL
;

LOGS:
;	Get a FAT id for this disk

	PUSH	DS
	MOV	DL,SDRV
	INC	DL
	SVC	DOSF_GFATA+1
	MOV	AL,DS:[BX]		; Get FAT id
	POP	DS

;	If it is a floppy 5 1/4" disk we have known parameters

	MOV	DL,SDRV
	CMP	DL,NUM_FLOPPY
	JNB	LOGS1			; Jump if not floppy drive

;	Floppy disk in drive, set up known parameters

	PUSH	AX
	AND	AX,3			; Get last 2 bits of FAT id
	ROL	AL,1			; Make word index
	MOV	BX,AX
	MOV	AX,FLOPPY_SECTORS[BX]	; Get the number of sectors
	MOV	SECCNT,AX		; Save locally
	MOV	SECSIZ,SEC_SIZE		; Also save known sector size
	POP	AX
	CLC				; Show good return
	RET

;	Not a floppy drive, check loader

LOGS1:

;	Read loader sector
	SUB	DX,DX
	MOV	CX,1
	CALL	RDSRC
	JC	LOGS2

;	Get disk info. from loader table

	PUSH	DS
	PUSH	BX
	PUSH	SI
	MOV	BX,FREPAR		; Address loader
	MOV	DS,BX
	MOV	SI,DISK_BPB_OFFSET
	MOV	AX,BPB_SECS[SI]		; Get number of sectors on the disk
	MOV	CS:SECCNT,AX		; Save locally
	MOV	AX,BPB_SECSZ[SI]	; Get sector size
	MOV	CS:SECSIZ,AX		; Save locally
	MOV	AL,BPB_MBYTE[SI]	; Return media byte
	POP	SI
	POP	BX
	POP	DS
	CLC
LOGS2:
	RET

;	LOGD - This routine performs a similar task as LOGS
;	except only the FAT id is returned in AL

LOGD:
	PUSH	DS
	MOV	DL,BYTE PTR DDRV
	INC	DL
	SVC	DOSF_GFATA+1
	MOV	AL,DS:[BX]		; Return FAT id
	POP	DS
	RET

;*	data areas

	DB	256 DUP (?)
STACK	LABEL	NEAR

CODE	ENDS
	END	BEGIN

