
/*
	Z150ROM.H - ROM definitions
*/

/*
		RESTRICTED RIGHTS LEGEND
		------------------------
	
	    "Use, duplication, or disclosure by the
	Government is subject to restrictions as set forth
	in paragraph (b) (3) (B) of the Rights in Technical
	Data and Computer Software clause in DAR
	7-104.9(a).  Contractor/manufacturer is Zenith
	Data Systems Corporation of Hilltop Road, St.
	Joseph, Michigan 49085.
*/

#define ROM_DATA 	0x40	/* Segment of ROM data */
#define PRINT_TIME_OUT	0x78	/* Offset of printer time out values */
#define SERIAL_TIME_OUT	0x7c	/* Offset of serial time out values */


/*
	I N T E R R U P T   V E C T O R   D E F I N I T I O N S
*/
#define	ZERO_DIVIDE_INTR	0x0	/* Divide by zero vector */

#define	SINGLE_STEP_INTR	0x1	/* Single-step (TRACE) vector */

#define	NMI_INTR		0x2	/* Non-maskable vector */

#define	BREAKPOINT_INTR 	0x3	/* Breakpoint vector */

#define	OVERFLOW_INTR		0x4	/* Overflow vector */

#define	PRINT_SCREEN_INTR	0x5	/* Print-screen vector */

#define	RES5_INTR		0x6	/* Reserved interrupt 5 */

#define	RES4_INTR		0x7	/* Reserved interrupt 4 */

#define	TIME_CLOCK_INTR 	0x8	/* System clock vector */

#define	KEYBOARD_INTR		0x9	/* Keyboard vector */

#define	RES3_INTR		0xa	/* Reserved interrupt 3 */

#define	RES2_INTR		0xb	/* Reserved interrupt 2 */

#define	COMMUNICATIONS_INTR	0xc	/* Communications vector */

#define	RES1_INTR		0xd	/* Reserved interrupt 1 */

#define	DISK_INTR		0xe	/* Disk hardware vector */

#define	PRINTER_INTR		0xf	/* Printer vector */

#define	VIDEO_IO_INTR		0x10	/* Video I/O vector */
#define	 VIO_MODE		 0x0	/*  Set mode of video screen */
#define	 VIO_SCT		 0x1	/*  Set cursor type */
#define	 VIO_SCP		 0x2	/*  Set cursor position0 */
#define	 VIO_RCP		 0x3	/*  Read cursor position */
#define	 VIO_RPP		 0x4	/*  Read light pen position */
#define	 VIO_SDP		 0x5	/*  Select display page */
#define	 VIO_SPU		 0x6	/*  Scroll page up */
#define	 VIO_SPD		 0x7	/*  Scroll page down */
#define	 VIO_RAC		 0x8	/*  Read attribute/character */
#define	 VIO_WAC		 0x9	/*  Write attribute/character */
#define	 VIO_WCO		 0xa	/*  Write character only */
#define	 VIO_SCPL		 0xb	/*  Set color pallette */
#define	 VIO_WDOT		 0xc	/*  Write dot */
#define	 VIO_RDOT		 0xd	/*  Read dot */
#define	 VIO_WTT		 0xe	/*  Write teletype */
#define	 VIO_CVS		 0xf	/*  Current video state */

#define	EQUIPMENT_INTR		0x11	/* Configuration check vector */

#define	MEMORY_SIZE_INTR	0x12	/* Determine memory size vector */

#define	DISK_IO_INTR		0x13	/* Disk software I/O call vector */
#define	 DIO_RESET		 0x0	/*  Reset disk system */
#define	 DIO_STATUS		 0x1	/*  Read system status */
#define	 DIO_READ		 0x2	/*  Read sectors */
#define	 DIO_WRITE		 0x3	/*  Write sectors */
#define	 DIO_VERIFY		 0x4	/*  Verify sectors */
#define	 DIO_FMTTRACK		 0x5	/*  Format track */
/* Fixed disk I/O only */
#define	 DIO_FMTBAD		 0x6	/*  Format bad track */
#define	 DIO_FMTDRIVE		 0x7	/*  Format drive */
#define	 DIO_GETPARMS		 0x8	/*  Get disk parameters */
#define	 DIO_SETPARMS		 0x9	/*  Set disk parameters */
#define	 DIO_RDLONG		 0xa	/*  Read long */
#define	 DIO_WRTLONG		 0xb	/*  Write long */
#define	 DIO_SEEK		 0xc	/*  Seek */
#define	 DIO_ARESET		 0xd	/*  Alternate reset */
#define	 DIO_RDBUF		 0xe	/*  Read sector buffer */
#define	 DIO_WRTBUF		 0xf	/*  Write sector buffer */
#define	 DIO_TSTRDY		 0x10	/*  Test drive ready */
#define	 DIO_HOME		 0x11	/*  Home the arm */
#define	 DIO_RAMTST		 0x12	/*  Test controller RAM */
#define	 DIO_DRVTST		 0x13	/*  Drive test */
#define	 DIO_CTRLTST		 0x14	/*  Controller test */

#define	SERIAL_IO_INTR		0x14	/* Serial I/O call vector */
#define	 SIO_INIT		 0x0	/*  Initialize serial ports */
#define	 SIO_WRITE		 0x1	/*  Write a character */
#define	 SIO_READ		 0x2	/*  Read a character */
#define	 SIO_STATUS		 0x3	/*  Get status */

#define	CASSETTE_INTR		0x15	/* Cassette I/O call vector */

#define	KEYBOARD_IO_INTR	0x16	/* Keyboard I/O call vector */
#define	 KIO_READ		 0x0	/*  Read a character */
#define	 KIO_LOOK		 0x1	/*  Look for a character ready */
#define	 KIO_STATUS		 0x2	/*  Get shift status */

#define	PRINTER_IO_INTR 	0x17	/* Printer I/O call vector */
#define	 PIO_WRITE		 0x0	/*  Write to the line printer */
#define	 PIO_INIT		 0x1	/*  Initialize the printer */
#define	 PIO_STATUS		 0x2	/*  Get printer status */

#define	IO_PARMS_INTR		0x18	/* I/O parameters pointer */

#define	BOOT_INTR		0x19	/* Re-boot vector */

#define	TIME_OF_DAY_INTR	0x1a	/* Set/get time-of-day vector */
#define	 TOD_GET		 0x0	/*  Get time of day */
#define	 TOD_SET		 0x1	/*  Set time of day */

#define	BREAK_INTR		0x1b	/* Keyboard break vector */

#define	USER_CLOCK_INTR 	0x1c	/* User clock-driven routine vector */

#define	VIDEO_PARMS_INTR	0x1d	/* Video (CRT) parameters vector */

#define	DISK_PARMS_INTR 	0x1e	/* Disk parameters vector */

#define	USER_FONT_INTR		0x1f	/* User font pointer vector */
