/*
    FIXED.H - This file contains information about the Z150
	fixed disk and controller card.
*/

/*
		RESTRICTED RIGHTS LEGEND
		------------------------
	
	    "Use, duplication, or disclosure by the
	Government is subject to restrictions as set forth
	in paragraph (b) (3) (B) of the Rights in Technical
	Data and Computer Software clause in DAR
	7-104.9(a).  Contractor/manufacturer is Zenith
	Data Systems Corporation of Hilltop Road, St.
	Joseph, Michigan 49085.
*/

#define DPB_POINTER	0x41		/* Fixed disk parameter pointer */

#define NUM_PART	4		/* Number of partitions in partition table*/
#define NUM_FIXED	8		/* Number of possible fixed disks */
#define NUM_ASSIGN	4		/* Number of DOS partitions allowed */
#define DOS_ID		1		/* Operating system ID for DOS partition */
#define UNALLOC_ID	0		/* O.S. ID for unallocated partition */
#define MAX_PART	(1L << 16)	/* Maximum partition size */


#define RESERVED	1		/* Number of reserved sectors */
#define SECTOR_SIZE	512		/* Sector size of fixed disk */
#define INTERLEAVE	5		/* Interleave factor for formatting */
#define MAX_DOS_PART	((long)(1 << 25))	/* Max DOS partition size */
#define MAX_SPT		17		/* Sectors per track on fixed disk */
#define NFATS		2		/* Number of fats on fixed disk */
#define MBYTE		0xf8		/* Media byte of fixed disk */

#define NUM_RETRY	1		/* Number of retries on disk I/O */

/* Define the disk parameter block used by the winchester ROM */
struct dpb
{
    unsigned max_cylinder;		/* Maximum value for cylinder */
    char max_heads;			/* maximum number of heads */
    unsigned reduced_write;		/* Reduced write current cylinder */
    unsigned write_precomp;		/* Write pre-comp cylinder */
    char max_burst;			/* ECC burst length */
    char control;
    char standard_time_out;		/* Standard time out value */
    char format_time_out;		/* Format time out value */
    char check_time_out;		/* Drive check time out value */
    char zero[4];			/* Reserved (must be zero) */
};


/* Define a head, cylinder and sector structure for ROM calls */
struct hcs
{
    char head;			/* Head corresponds to DH register */
    char sec;			/* Sector corresponds to CL register */
    char cyl;			/* Cylinder corresponds to CH register */
};

/* Define a partition table entry */
struct p_ent
{
    char boot_flag;		/* Boot flag entry */
    struct hcs begin_hcs;	/* Beginning of part. head, cyl., sector */
    char os_id;			/* Boot flag entry */
    struct hcs end_hcs;		/* End of part. head, cyl., and sector */
    long rel_sec;		/* Relocation sector */
    long part_size;		/* Partition size */
};


/* Define a partition table */
struct part_tbl
{
    struct p_ent part_entry[NUM_PART];
    unsigned signature;		/* Table signature (i.e. 55AA) */
};

