PAGE ,132

;**************************************
;
;	MAP
;		This program allows the user of MS-DOS version 2
;		to reassign drive specifications.
;		ex.:
;			MAP A=C
;
;		In this example any subsequent references to drive
;		A: will be actually made to drive C:.
;
;	        Multiple assignments are allowed on the same line:
;
;			MAP A=C B=C D=C
;
;		This example would cause all references to drives
;		A:, B:, and D: to be treated as references to drive
;		C:.
;
;		If the MAP command line is empty:
;
;			MAP
;
;		all drive references are reset.
;
;	Written by: HLC
;
;	Date: June 5, 1984
;
;	Version: 2.00 (first  release)
;
;	REVISION HISTORY:
;
;		bcb 06/29/84	-	Command line for Z-100 mode
;
;		RJM 10/25/84 - Version 2.04 MAP no longer stays resident
;				on a MAP ? command.
;
;		RESTRICTED RIGHTS LEGEND
;
;	"Use, duplication, or disclosure by the Government 
;	is subject to restrictions as set forth in paragraph
;	(b) (3) (B) of the Rights in Technical Data and
;	Computer Software clause in DAR 7-104.9(a).
;	Contractor/Manufacturer is
;	Zenith Data Systems Corp. of
;	Hilltop rd.
;	St. Joseph, Michigan 49085
;**************************************

CODE	SEGMENT BYTE PUBLIC
	ASSUME	CS:CODE, DS:CODE, ES:CODE, SS:CODE

FALSE		=	0
TRUE		=	NOT FALSE

;	Set the following to TRUE for Z-100 mode, else false

Z_100		=	FALSE		;assemble for Z-100 mode
NBI		=	FALSE		; Assemble for NBI

   IF Z_100
	.XLIST
	INCLUDE	\DEVEL\DOS20\INC\DEFMS.ASM
	INCLUDE	\DEVEL\DOS20\INC\DEFDOSI.ASM
	.LIST
   ELSE
	.XLIST
	INCLUDE ..\COMMONS\MSDOS.DEF		;MS-DOS definitions
	.LIST
   ENDIF

FUNC_REQ_ADR	=	DOSI_FUNC*4	;address of function request interrupt
ADR_ADR		=	DOSI_ADREAD*4	;address of absolute disk read interrupt
ADW_ADR		=	DOSI_ADWRITE*4	;address of absolute disk write interrupt

;***************************************
;
; This code remains resident
;
;***************************************

	ORG	100H
MAP:
	JMP	MAP_STRT		;jump to MAP program start

FR_HDLR:
	JMP	FR_STRT			;jump to function request handler

ADR_HDLR:
	JMP	ADR_STRT		;jump to absolute disk read handler

ADW_HDLR:
	JMP	ADW_STRT		;jump to absolute disk write handler

; Data area

MAP_ID	=	(OFFSET $-OFFSET FR_HDLR)
	DB	'MAP'			;ID's this program as MAP
DEF_DRV 	DB	?		;default drive as viewed by user (A=0, B=1...)
TBL_SEG		DW	?		;segment value of table
MAP_LIM		DB	00		;highest legal physical drive name
DRV_SWAP	DB	FALSE		;was drive spec swapped?
DRV_SPEC	DB	?		;original drive specification
DRV_OFF		DW	?		;orig. drive spec offset
DRV_SEG		DW	?		;orig. drive spec segment
DRV_SWAP_2	DB	FALSE		;save area for 2nd set of drive info
DRV_SPEC_2	DB	?
DRV_SEG_2	DW	?
DRV_OFF_2	DW	?
DMA_SWAP	DB	FALSE
DMA_SEG		DW	?		;segment value of disk transfer addr.
DMA_OFF		DW	?		;offset value of disk transfer addr.
FG_SAV		DW	?		;PSW flags save area
SP_SAV		DW	?		;stack pointer save area
CS_SAV		DW	?		;CS: save area
IP_SAV		DW	?		;IP save area
AX_SAV		DW	?		;AX save area
BX_SAV		DW	?		;BX save area
DX_SAV		DW	?		;DX save area
SI_SAV		DW	?		;SI save area

; mapping table:  physical drive, temp physical drive
; the temp physical drive is used until command line syntax is verfied
MAP_TBL	DB	'A','A'
	DB	'B','B'
	DB	'C','C'
	DB	'D','D'
	DB	'E','E'
	DB	'F','F'
	DB	'G','G'
	DB	'H','H'
	DB	'I','I'
	DB	'J','J'
	DB	'K','K'
	DB	'L','L'
	DB	'M','M'
	DB	'N','N'
	DB	'O','O'
	DB	'P','P'
	DB	'Q','Q'
	DB	'R','R'
	DB	'S','S'
	DB	'T','T'
	DB	'U','U'
	DB	'V','V'
	DB	'W','W'
	DB	'X','X'
	DB	'Y','Y'
	DB	'Z','Z'
TBL_SIZ	=	(OFFSET $ - OFFSET MAP_TBL)/2	;number of table entries

OLD_FUNC_REQ LABEL DWORD
OFR_OFF	DW	?			;orig function request offset
OFR_SEG	DW	?			;orig function request segment

OLD_ADR LABEL DWORD
OADR_OFF DW	?			;orig absolute disk read offset
OADR_SEG DW	?			;orig absolute disk read segment

OLD_ADW LABEL DWORD
OADW_OFF DW	?			;orig absolute disk write offset
OADW_SEG DW	?			;orig absolute disk write segment

HEAP_TABLE	LABEL	WORD
	DD	32*4 DUP (0)		;32 calls deep
TOP_HEAP	LABEL	WORD		;Defines the end of the heap

HEAP_PTR	DW	OFFSET HEAP_TABLE	;Pointer to current entry

FR_JMP	DW	OFFSET FR_EXIT_50	;function request AH=00
	DW	OFFSET FR_EXIT_50	;function request AH=01
	DW	OFFSET FR_EXIT_50	;function request AH=02
	DW	OFFSET FR_EXIT_50	;function request AH=03
	DW	OFFSET FR_EXIT_50	;function request AH=04
	DW	OFFSET FR_EXIT_50	;function request AH=05
	DW	OFFSET FR_EXIT_50	;function request AH=06
	DW	OFFSET FR_EXIT_50	;function request AH=07
	DW	OFFSET FR_EXIT_50	;function request AH=08
	DW	OFFSET FR_EXIT_50	;function request AH=09
	DW	OFFSET FR_EXIT_50	;function request AH=0A
	DW	OFFSET FR_EXIT_50	;function request AH=0B
	DW	OFFSET FR_EXIT_50	;function request AH=0C
	DW	OFFSET FR_EXIT_50	;function request AH=0D
	DW	OFFSET FR_0E		;function request AH=0E
	DW	OFFSET FR_200		;function request AH=0F
	DW	OFFSET FR_200		;function request AH=10
	DW	OFFSET FR_1112		;function request AH=11
	DW	OFFSET FR_1112		;function request AH=12
	DW	OFFSET FR_200		;function request AH=13
	DW	OFFSET FR_200		;function request AH=14
	DW	OFFSET FR_200		;function request AH=15
	DW	OFFSET FR_200		;function request AH=16
	DW	OFFSET FR_200		;function request AH=17
	DW	OFFSET FR_EXIT_50	;function request AH=18
	DW	OFFSET FR_19		;function request AH=19
	DW	OFFSET FR_EXIT_50	;function request AH=1A
	DW	OFFSET FR_EXIT_50	;function request AH=1B
	DW	OFFSET FR_100		;function request AH=1C
	DW	OFFSET FR_EXIT_50	;function request AH=1D
	DW	OFFSET FR_EXIT_50	;function request AH=1E
	DW	OFFSET FR_100		;function request AH=1F
	DW	OFFSET FR_EXIT_50	;function request AH=20
	DW	OFFSET FR_200		;function request AH=21
	DW	OFFSET FR_200		;function request AH=22
	DW	OFFSET FR_200		;function request AH=23
	DW	OFFSET FR_200		;function request AH=24
	DW	OFFSET FR_EXIT_50	;function request AH=25
	DW	OFFSET FR_EXIT_50	;function request AH=26
	DW	OFFSET FR_200		;function request AH=27
	DW	OFFSET FR_200		;function request AH=28
	DW	OFFSET FR_EXIT_50	;function request AH=29
	DW	OFFSET FR_EXIT_50	;function request AH=2A
	DW	OFFSET FR_EXIT_50	;function request AH=2B
	DW	OFFSET FR_EXIT_50	;function request AH=2C
	DW	OFFSET FR_EXIT_50	;function request AH=2D
	DW	OFFSET FR_EXIT_50	;function request AH=2E
	DW	OFFSET FR_EXIT_50	;function request AH=2F
	DW	OFFSET FR_EXIT_50	;function request AH=30
	DW	OFFSET FR_EXIT_50	;function request AH=31
	DW	OFFSET FR_100		;function request AH=32
	DW	OFFSET FR_EXIT_50	;function request AH=33
	DW	OFFSET FR_EXIT_50	;function request AH=34
	DW	OFFSET FR_EXIT_50	;function request AH=35
	DW	OFFSET FR_100		;function request AH=36
	DW	OFFSET FR_EXIT_50	;function request AH=37
	DW	OFFSET FR_EXIT_50	;function request AH=38
	DW	OFFSET FR_300		;function request AH=39
	DW	OFFSET FR_300		;function request AH=3A
	DW	OFFSET FR_300		;function request AH=3B
	DW	OFFSET FR_300		;function request AH=3C
	DW	OFFSET FR_300		;function request AH=3D
	DW	OFFSET FR_EXIT_50	;function request AH=3E
	DW	OFFSET FR_EXIT_50	;function request AH=3F
	DW	OFFSET FR_EXIT_50	;function request AH=40
	DW	OFFSET FR_300		;function request AH=41
	DW	OFFSET FR_EXIT_50	;function request AH=42
	DW	OFFSET FR_300		;function request AH=43
	DW	OFFSET FR_44		;function request AH=44
	DW	OFFSET FR_EXIT_50	;function request AH=45
	DW	OFFSET FR_EXIT_50	;function request AH=46
	DW	OFFSET FR_100		;function request AH=47
	DW	OFFSET FR_EXIT_50	;function request AH=48
	DW	OFFSET FR_EXIT_50	;function request AH=49
	DW	OFFSET FR_EXIT_50	;function request AH=4A
    IF Z_100
	DW	OFFSET FR_4B		;function request AH=4B
    ELSE
	DW	OFFSET FR_EXIT_50	;function request AH=4B
    ENDIF
	DW	OFFSET FR_EXIT_50	;function request AH=4C
	DW	OFFSET FR_EXIT_50	;function request AH=4D
	DW	OFFSET FR_300		;function request AH=4E
	DW	OFFSET FR_EXIT_50	;function request AH=4F
	DW	OFFSET FR_EXIT_50	;function request AH=50
	DW	OFFSET FR_EXIT_50	;function request AH=51
	DW	OFFSET FR_EXIT_50	;function request AH=52
	DW	OFFSET FR_EXIT_50	;function request AH=53
	DW	OFFSET FR_EXIT_50	;function request AH=54
	DW	OFFSET FR_EXIT_50	;function request AH=55
	DW	OFFSET FR_56		;function request AH=56
	DW	OFFSET FR_EXIT_50	;function request AH=57


FR_STRT:
; This is the Function Request Handler (stays resident).
; Any function requests which designate a drive name must
; be translated according to the map table.
; CAUTION! DS may not be what we expect.

	STI				;keep those interrupts com'in
	POP	CS:IP_SAV		;save orig IP
	POP	CS:CS_SAV		;save orig CS:
	POP	CS:FG_SAV		;save orig flags
	MOV	CS:SP_SAV,SP		;save orig stack pointer
	MOV	CS:AX_SAV,AX		;save orig func request
	MOV	CS:SI_SAV,SI		;save orig SI

; determine if we even bother to map this particular func request
	CMP	AH,58H
	JB	FR_STRT_10		;yes we do
	JMP	FR_EXIT_50		;no we don't
FR_STRT_10:
; determine proper entry into jump table
	MOV	AL,AH
	XOR	AH,AH
	MOV	SI,AX
	SHL	SI,1	
	JMP	WORD PTR CS:[FR_JMP + SI]  ;jump to appropriate routine



FR_0E:
;***************************************
; This is a special case for function request AH=0EH
; Assumption: DL= drive number (A=0, B=1...)

	MOV	CS:DEF_DRV,DL
	MOV	AL,DL
	CALL	DR_XLATE
	MOV	DL,AL
	JMP	FR_EXIT_50


FR_19:
;***************************************
; This is a special case for function request AH=19H
; Assumption: return drive in AL

	MOV	AL,CS:DEF_DRV
	MOV	CS:BYTE PTR AX_SAV,AL
	JMP	FR_EXIT_30


FR_1112:
;***************************************
; This is a special case for function requests AH=11H
; and AH=12H.
; Assumption: DS:DX ptr to unopened FCB
	PUSH	ES			;preserve registers
	PUSH	BX
	MOV	AH,DOSF_GETDMA
	PUSHF
	CALL	CS:DWORD PTR OLD_FUNC_REQ  ;call orig function request handler
	MOV	CS:DMA_SEG,ES		;save DMA segment value
	MOV	CS:DMA_OFF,BX		;save DMA offset value	
	MOV	CS:DMA_SWAP,TRUE	;indicate FCB at DMA needs fixup later
	POP	BX
	POP	ES
	JMP	FR_200


FR_44:
;***************************************
; This is a special case for function request AH=44
; assumption: BL contains 0=default, 1=A, 2=B ...
	MOV	CS:BX_SAV,BX		;save orig BX value
	MOV	AX,CS:AX_SAV		;get orig AX value
	CMP	AL,04			;BL is meaningful only if AL= 4 or 5
	JE	FR_44a
	CMP	AL,05
	JE	FR_44a
	JMP	FR_EXIT_50		;AL is not =4 or =5
FR_44a:
	MOV	AL,BL
	OR	AL,AL			;default drive?
	JNZ	FR_44b			;  no
	MOV	AL,CS:DEF_DRV
	INC	AL			;(1=A, 2=B ...)
FR_44b:
	DEC	AL			;(0=A, 1=B ...)
	CALL	DR_XLATE		;translate with map table
	INC	AL			;(1=A, 2=B ...)
	MOV	BL,AL
	MOV	AX,CS:AX_SAV
	MOV	SI,CS:SI_SAV
	MOV	SP,CS:SP_SAV
	PUSH	CS:FG_SAV		;set-up flags on stack
	CALL    CS:DWORD PTR OLD_FUNC_REQ   ;call orig func request handler
; save flags and return value(s)
	MOV	CS:AX_SAV,AX		;save return value
	MOV	BX,CS:BX_SAV		;restore orig BX value
	PUSHF
	POP	CS:FG_SAV
	JMP	FR_EXIT_30		;done

FR_56:
;***************************************
; This is a special case for function request AH=56
; Assumption: DS:DX & ES:DI are pointers to pathnames	
	MOV	CS:DRV_SEG,DS		;save 1st orig drive spec segment
	MOV	CS:DRV_OFF,DX		;save 1st orig drive spec offset
	MOV	CS:DRV_SEG_2,ES		;save 2nd orig drive spec segment
	MOV	CS:DRV_OFF_2,DI		;save 2nd orig drive spec offset

	MOV	SI,DX
	MOV	AX,DS:[SI]		;get 1st 2 bytes of pathname
	CMP	AH,':'			;is it a drive name?
	JNE	FR_56a			;  no
	MOV	CS:DRV_SPEC,AL
	MOV	CS:DRV_SWAP,TRUE
	CALL	TO_UPPER		;insure upper case
	SUB	AL,41H			;convert to drive number
	CALL	DR_XLATE		;translate with map table
	ADD	AL,41H			;convert to drive name
	MOV	BYTE PTR [SI],AL
FR_56a:
	MOV	AX,ES:[DI]		;get 1st 2 bytes of 2nd pathname
	CMP	AH,':'			;is it a drive name?
	JNE	FR_56b			;  no
	MOV	CS:DRV_SPEC_2,AL
	MOV	CS:DRV_SWAP_2,TRUE
	CALL	TO_UPPER		;insure upper case
	SUB	AL,41H			;convert to drive number
	CALL	DR_XLATE		;translate with map table
	ADD	AL,41H			;convert to drive name
	MOV	ES:BYTE PTR [DI],AL
FR_56b:
	JMP	FR_EXIT			;done


FR_100:
;***************************************
; This expects DL to contain 0=default, 1=A, 2=B etc
	MOV	CS:DX_SAV,DX		;save orig DX value
	MOV	AL,DL
	OR	AL,AL			;default drive?
	JNZ	FR_110			;  no
	MOV	AL,CS:DEF_DRV		;get default drive # (0=A, 1=B...)
	INC	AL			;(1=A, 2=B ...)
FR_110:
	DEC	AL			;(0=A, 1=B ...)
	CALL	DR_XLATE		;translate with map table
	INC	AL			;(1=A, 2=B ...)
	MOV	DL,AL
; execute original function request handler
	MOV	AX,CS:AX_SAV		;restore orig func request
	MOV	SI,CS:SI_SAV
	MOV	SP,CS:SP_SAV
	PUSH	CS:FG_SAV		;set-up flags on stack
	CALL    CS:DWORD PTR OLD_FUNC_REQ   ;call orig func request handler
; save flags and return value(s)
	PUSHF
	POP	CS:FG_SAV		;save return flags
	MOV	CS:AX_SAV,AX		;save return value
	MOV	DX,CS:DX_SAV		;restore orig DX value
	JMP	FR_EXIT_30		;done

FR_200:
;***************************************
; This expects DS:DX to point to an FCB where the 1st 
; byte is 0=default, 1=A, 2=B etc.
	MOV	SI,DX
	MOV	AL,BYTE PTR [SI]	;get 1st FCB character
	CMP	AL,0FFH			;is it an extended FCB?
	JNE	FR_210			;  no
	ADD	SI,07			;  yes... make 7 byte adjustment
	MOV	AL,BYTE PTR [SI]	;get drive spec
FR_210:
	MOV	CS:DRV_SPEC,AL		;save original drive spec
	MOV	CS:DRV_OFF,SI		;save drive spec offset
	MOV	CS:DRV_SEG,DS		;save drive spec segment
	OR	AL,AL			;default drive?
	JNZ	FR_220			;  no
	MOV	AL,CS:DEF_DRV		;get default drive # (0=A, 1=B...)
	INC	AL			;(1=A, 2=B ...)
FR_220:
	DEC	AL			;(0=A, 1=B ...)
	CALL	DR_XLATE		;translate with map table
	INC	AL			;(1=A, 2=B ...)
	MOV	BYTE PTR [SI],AL	;swap drive specs
	MOV	CS:DRV_SWAP,TRUE	;indicate swap was made
	JMP	FR_EXIT			;done

FR_300:
;***************************************
; This expects DS:DX to point to a pathname string. The 1st
; 2 bytes may or may not designate a drive name.
	MOV	CS:DRV_OFF,DX		;save orig path offset
	MOV	CS:DRV_SEG,DS		;save orig path segment

	MOV	SI,DX
	MOV	AX,DS:[SI]		;get 1st 2 bytes of pathname
	CMP	AH,':'			;is it a drive name?
	JNE	FR_310			;  no
	MOV	CS:DRV_SPEC,AL
	MOV	CS:DRV_SWAP,TRUE
	CALL	TO_UPPER		;insure upper case
	SUB	AL,41H			;convert to drive number
	CALL	DR_XLATE		;translate with map table
	ADD	AL,41H			;convert to drive name
	MOV	BYTE PTR [SI],AL
FR_310:
	JMP	FR_EXIT			;done

    IF Z_100
FR_4B:
;***************************************
; This expects DS:DX to point to a pathname string. The 1st
; 2 bytes may or may not designate a drive name. This version
; simply jumps to the OS. It is used only for function 4BH

	MOV	SI,DX
	MOV	AX,DS:[SI]		;get 1st 2 bytes of pathname
	CMP	AH,':'			;is it a drive name?
	JE	FR_4BXN			;  no
	JMP	FR_EXIT_50		;Just let the DOS deal with it

;	Insure there is room in the heap for this guy

FR_4BXN:
	CMP	CS:WORD PTR HEAP_PTR,OFFSET TOP_HEAP	;Heap full?
	JNE	FR_4B1			;If room.

;	No room in the heap, return memory error to user

	MOV	CS:WORD PTR AX_SAV,DOSE_NORAM
	PUSH	CS:WORD PTR FG_SAV
	POPF
	STC				;Force carry set
	PUSHF
	POP	CS:WORD PTR FG_SAV	;Save user flags
	JMP	FR_EXIT_30		;And return error to caller

;	There is room in the heap for this guy

FR_4B1:
	CALL	TO_UPPER		;insure upper case
	MOV	AH,AL			;Save original value
	SUB	AL,41H			;convert to drive number
	CALL	DR_XLATE		;translate with map table
	ADD	AL,41H			;convert to drive name
	MOV	BYTE PTR [SI],AL	;Drive has been mapped
	
;	Drive letter has been translated, save user info on his stack

	PUSH	CS:CS_SAV
	PUSH	CS:IP_SAV		;Set user regs back on stack
	PUSH	DS
	PUSH	SI			;Save DS:SI = drive pointer
	PUSH	AX			;Save drive letter informatio

;	Now save the users ss/sp values on the heap

	MOV	SI,CS:HEAP_PTR		;Get pointer to heap
	MOV	CS:[SI],SS
	MOV	CS:[SI+2],SP		;Save them here
	ADD	CS:WORD PTR HEAP_PTR,4		;Used up 4 more bytes
	MOV	AX,CS:AX_SAV
	MOV	SI,CS:SI_SAV		;Restore SI and AX to user regs
	PUSHF				;Fake an INT to the OS
	CALL	CS:DWORD PTR OLD_FUNC_REQ	;Call the OS

;	Return back to here at end of EXEC Call

	MOV	CS:AX_SAV,AX		;Save users AX return reg
	LAHF				;Save flags here
	MOV	CS:SI_SAV,SI		;Save current SI value
	SUB	CS:WORD PTR HEAP_PTR,4
	SAHF
	MOV	SI,CS:HEAP_PTR
	MOV	SS,CS:[SI]
	MOV	SP,CS:[SI+2]		;Restore users stack
	POP	AX			;AH = original drive spec
	POP	SI			;SI = offset of drive spec
	POP	DS			;DS = user DS value
	MOV	DS:BYTE PTR [SI],AH	;Restore drive letter
	MOV	SI,CS:SI_SAV
	MOV	AX,CS:AX_SAV
FR_4BX1	PROC	FAR
	RET
FR_4BX1	ENDP
    ENDIF

FR_EXIT:
;***************************************
; restore registers and execute original function request handler
	MOV	AX,CS:AX_SAV		;restore orig func request
	PUSH	CS:FG_SAV		;set-up flags on stack
	CALL    CS:DWORD PTR OLD_FUNC_REQ   ;call orig func request handler
; save flags and return value(s)
	PUSHF
	POP	CS:FG_SAV		;save return flags
	MOV	CS:AX_SAV,AX		;save return value
; restore original drive specs if necessary
	PUSH	ES			;preserve registers
	PUSH	BX
	CMP	CS:DRV_SWAP,TRUE  	;was a swap done?
	JNE	FR_EXIT_10		;no
	MOV	CS:DRV_SWAP,FALSE
	MOV	AL,CS:DRV_SPEC		;get orig drive spec
	MOV	ES,CS:DRV_SEG		;get orig drive spec segment
	MOV	BX,CS:DRV_OFF		;get orig drive spec offset
	MOV	BYTE PTR ES:[BX],AL	;replace orig drive spec
FR_EXIT_10:
	CMP	CS:DRV_SWAP_2,TRUE 	;was a second swap made?
	JNE	FR_EXIT_20		;no
	CMP	CS:DRV_SWAP_2,FALSE
	MOV	AL,CS:DRV_SPEC_2	;get orig drive spec
	MOV	ES,CS:DRV_SEG_2		;get orig drive spec segment
	MOV	BX,CS:DRV_OFF_2		;get orig drive spec offset
	MOV	BYTE PTR ES:[BX],AL	;replace orig drive spec
FR_EXIT_20:
	CMP	CS:DMA_SWAP,TRUE	;FCB at DMA need fixing?
	JNE	FR_EXIT_28		;no
	MOV	CS:DMA_SWAP,FALSE
	MOV	ES,CS:DMA_SEG		;get DMA segment value
	MOV	SI,CS:DMA_OFF		;get DMA offset value
	MOV	AL,BYTE PTR ES:[SI]	;get 1st FCB character
	CMP	AL,0FFH			;is it an extended FCB?
	JNE	FR_EXIT_22		;  no
	ADD	SI,07			;  yes... make 7 byte adjustment
FR_EXIT_22:
	MOV	AL,CS:DRV_SPEC		;get orig drive spec
	OR	AL,AL			;was it default?
	JNZ	FR_EXIT_26		;no
FR_EXIT_24:
	MOV	AL,CS:DEF_DRV		;get default drive spec (0=A, 1=B...)
	INC	AL			;(1=A, 2=B,...)
FR_EXIT_26:
	MOV	BYTE PTR ES:[SI],AL	;fix-up drive spec in resultant FCB
FR_EXIT_28:
	POP	BX
	POP	ES
FR_EXIT_30:
	MOV	AX,CS:AX_SAV
	MOV	SI,CS:SI_SAV
	MOV	SP,CS:SP_SAV
	PUSH	CS:FG_SAV
	PUSH	CS:CS_SAV
	PUSH	CS:IP_SAV
FR_EXIT_40:
	IRET				;thats all folks
FR_EXIT_50:
	MOV	AX,CS:AX_SAV
	MOV	SI,CS:SI_SAV
	MOV	SP,CS:SP_SAV
	PUSH	CS:FG_SAV
	PUSH	CS:CS_SAV
	PUSH	CS:IP_SAV
FR_EXIT_60:
	JMP	CS:DWORD PTR OLD_FUNC_REQ  ;never return


ADR_STRT:
	CALL	DR_XLATE		;translate drive # in AL
	JMP	CS:DWORD PTR OLD_ADR	;done

ADW_STRT:
	CALL	DR_XLATE		;translate drive # in AL
	JMP	CS:DWORD PTR OLD_ADW	;done



;***************************************
;
; DR_XLATE
;
;	 This routine translates a drive number 
; 	 according to the state of the drive table.
;
;	ENTRY:	AL = original drive number (0=A, 1=B etc)
;
;	EXIT:	AL = translated drive number (0=A, 1=B etc)
;
;		All other registers preserved
;***************************************
DR_XLATE PROC NEAR
	PUSH	DS
	PUSH	ES
	PUSH	BX

	MOV	ES,CS:TBL_SEG		;locate map table
	XOR	BX,BX
	MOV	BL,AL
	SHL	BX,1
	MOV	AL,BYTE PTR ES:[MAP_TBL + BX]   ;translate
	SUB	AL,41H			;convert to drive number

	POP	BX
	POP	ES
	POP	DS
	RET
DR_XLATE ENDP


;***************************************
;
;	TO_UPPER
;
;		This routine insures the character in
;		AL is upper case.
;
;	ENTRY: AL = character (either upper or lower case)
;
;	EXIT:  AL = character (upper case)
;
;***************************************
TO_UPPER PROC NEAR
	CMP	AL,5BH			;is it upper case already?
	JB	TO_UP_10		;yes
	SUB	AL,20H			;convert to upper case
TO_UP_10:
	RET
TO_UPPER ENDP


;***************************************
;
; The following code will never stay resident
;
;***************************************
MAP_END_RES LABEL BYTE			;end of resident code section

DEF_FLG		DB	FALSE

	IF	NOT NBI
MAP_MSG		DB	13,10,'                 '
		DB	'MAP version 2.04',13,10
		DB	'Copyright(C) 1984 Zenith Data Systems Corporation',13,10
		DB	'$'
	ENDIF

	IF	NBI
MAP_MSG		DB	13,10,'     '
		DB	'MAP version 2.04',13,10
		DB	'Copyright(C) NBI, Inc. 1984',13,10
		DB	'$'
	ENDIF

MAP_RES		DB	FALSE		;does MAP stay resident?
VER_ERR_MSG	DB	13,10,'Incorrect DOS version',13,10,10,'$'
PAR_ERR_MSG	DB	13,10,'Invalid parameter',13,10,10,'$'
HELP_SCN	DB	13,10,10

	IF	NOT NBI
		DB	'                           '
		DB	'MAP Version 2.04',13,10
		DB	'          '
		DB	'Copyright(C) 1984 Zenith Data Systems Corporation',13,10,10
	ENDIF

	IF	NBI
		DB	'     '
		DB	'MAP Version 2.04',13,10
		DB	'Copyright(C) NBI, Inc. 1984',13,10,10
	ENDIF

		DB	'MAP instructs the operating system to use a different drive from that',13,10
		DB	'specified by an application program for disk operations. That is, MAP',13,10
		DB	'is used to remap system drive name assignments.    If entered without',13,10
		DB	'any parameters, MAP resets normal system drive assignments.',13,10,10
    IF Z_100
		DB	'Syntax:  MAP [d:u [...]]',13,10,10
    ELSE
		DB	'Syntax:  MAP [x=y [...]]',13,10,10
    ENDIF
		DB	'Multiple drives can be remapped with one command;  however,  the  MAP',13,10
		DB	'command  line  should not exceed 127 characters  in  length.   Use  a',13,10
    IF Z_100
		DB	'space,  comma, semicolon, or tab to seperate pairs of drive names and',13,10
		DB	'unit numbers.  Drive names may be entered in uppercase, lowercase, or',13,10
		DB	'both, and must be followed by a colon.',13,10,10
    ELSE
		DB	'space,  comma,  semicolon,  or  tab to separate pairs of drive names.',13,10
		DB	'Drive names may be entered in uppercase, lowercase, or both, and need',13,10
		DB	'not be followed by a colon.',13,10,10
    ENDIF
		DB	'Examples:',13,10,10
		DB	'The following command causes all references to drives A,  B, and D to',13,10
    IF Z_100
		DB	'be redirected to drives C, C, and E respectively:     MAP A:2 B:2 D:4',13,10,10
    ELSE
		DB	'be redirected to drives C, C, and E respectively:     MAP A=C B=C D=E',13,10,10
    ENDIF
		DB	'The  following command resets drive mappings to their original states',13,10
    IF Z_100
		DB	'(any previous remapping of drives invoked with MAP is cancelled): MAP$'
    ELSE
		DB	'(any previous remapping or redirection of drives invoked with MAP  is',13,10
		DB	'cancelled):    MAP'
		DB	'$'
    ENDIF
MAP_CL		DB	128 DUP (0)	;local command line copy
		DB	128 DUP (?)	;local stack area
STACK_TOP LABEL WORD

MAP_STRT:
; Welcome to the MAP program

	MOV	SP,OFFSET STACK_TOP
	PUSH	BX
	PUSH	CX
	PUSH	SI
	PUSH	DI
	PUSH	ES

	MOV	BX,80H			;locate command line...skip count
	CALL	SKIP_SP			;get next character
	CMP	AL,'?'			;does user want help screen?
	JNE	MAP_STRTA		;no
	JMP	MAP_HELP		;yes...lets play teacher

MAP_STRTA:
; Lets introduce ourselves

    IF NOT Z_100
	PUSH	AX
	PUSH	DX
	MOV	DX,OFFSET MAP_MSG	;locate sign-on message
	MOV	AH,09
	INT	21H			;display it
	POP	DX
	POP	AX
    ENDIF


	MOV	CX,128			;move command line into local area
	MOV	SI,080H
	MOV	DI,OFFSET MAP_CL
	MOV	AX,CS
	MOV	ES,AX
	CLD
	REP	MOVSB
	MOV	DS,AX

; Check if we have been previously loaded

	XOR	AX,AX
	MOV	ES,AX
	MOV	BX,FUNC_REQ_ADR		;locate function request interrupt
	MOV	DI,OFFSET MAP_ID
	ADD	DI,ES:[BX]		;grab intr. offset
	MOV	ES,ES:[BX+2]		;grab intr. segment
	CMP	BYTE PTR ES:[DI],'M'
	JNE	MAP_10			;MAP was'nt loaded before
	CMP	BYTE PTR ES:[DI+1],'A'
	JNE	MAP_10			;MAP was'nt loaded before
	CMP	BYTE PTR ES:[DI+2],'P'
	JNE	MAP_10			;MAP was'nt loaded before
	MOV	TBL_SEG,ES		;locate table that was loaded before
	JMP	MAP_30			;this is not MAP's 1st loading

MAP_10:
; This is the 1st loading
; So lets do some initialization

; Save original function request vector
	
	MOV	ES,AX
	MOV	AX,ES:[BX]
	MOV	OFR_OFF,AX		;save offset value
	MOV	AX,ES:[BX+2]
	MOV	OFR_SEG,AX		;save segment value

; Save original absolute disk read vector

	MOV	BX,ADR_ADR
	MOV	AX,ES:[BX]
	MOV	OADR_OFF,AX		;save offset value
	MOV	AX,ES:[BX+2]
	MOV	OADR_SEG,AX		;save segment value

; Save original absolute disk write vector

	MOV	BX,ADW_ADR
	MOV	AX,ES:[BX]
	MOV	OADW_OFF,AX		;save offset value
	MOV	AX,ES:[BX+2]
	MOV	OADW_SEG,AX		;save segment value

; Check the DOS version number

	MOV	AH,DOSF_GETVER
	INT	DOSI_FUNC		;get version number
	CMP	AL,02			;is DOS at least a version 2 ?
	JAE	MAP_20			;yes...continue initialization
	JMP	MAP_VER_ERR		;jump to version error handler

MAP_20:
; Determine number of drives in system

	MOV	AH,DOSF_GETDISK
	INT	DOSI_FUNC		;get default drive # (0=A, 1=B...)
	MOV	DL,AL			;set-up for next function
	MOV	DEF_DRV,AL		;record current default drive
	MOV	AH,DOSF_SELDISK
	INT	DOSI_FUNC		;get number of drives
	ADD	AL,40H			;convert it to a drive name
	MOV	MAP_LIM,AL		;save it

; Indicate that the data area & Function Request Handler
; will remain resident upon program termination.
; Also, use the local table for subsequent changes

	MOV	MAP_RES,TRUE	
	MOV	TBL_SEG,DS

	CLI				;lets not be interrupted now
	
; Set up our own function request handler in intr. 21H

	XOR	AX,AX
	MOV	ES,AX
	MOV	BX,FUNC_REQ_ADR		;get address of interrupt
	MOV	ES:[BX],OFFSET FR_HDLR	;set-up our handler's offset
	MOV	ES:[BX+2],CS		;set-up our handler's segment

; Set up our own absolute disk read handler in intr. 25H

	MOV	BX,ADR_ADR		;get address of interrupt
	MOV	ES:[BX],OFFSET ADR_HDLR	;set-up our handler's offset
	MOV	ES:[BX+2],CS		;set-up our handler's segment

; Set up our own absolute disk write handler in intr. 26H

	MOV	BX,ADW_ADR		;get address of interrupt
	MOV	ES:[BX],OFFSET ADW_HDLR	;set-up our handler's offset
	MOV	ES:[BX+2],CS		;set-up our handler's segment

	STI				;re-enable interrupts

MAP_30:
; Lets inspect the command line with which MAP was invoked

	MOV	BX,OFFSET MAP_CL	;locate command line...skip count
MAP_31:
	CALL	SKIP_SP			;get next character

MAP_40:
	CMP	AL,0DH			;empty command line?
	JNE	MAP_50			;no...lets look it over
   IF Z_100
	CALL	RESET_TBL
	JMP	MAP_EXIT
   ELSE
	JMP	RESET_TBL		;return table to boot time state
   ENDIF
MAP_50:
   IF Z_100

;	Swallow it if it is only a /Z

	CMP	AL,'/'			; Switch?
	JNZ	MAP_50Z1		;  Nope, ignore it
	CALL	SKIP_SP			; Get next
	CALL	RANGE_CK		; Map it to upper if a drive
	CMP	AL,'Z'
	JNZ	MAP_PAR_ERR		; Oops

;	Had a /Z, clear up the table

	PUSH	BX
	CALL	RESET_TBL
	POP	BX
	JMP	MAP_31			;And keep looking
MAP_50Z1:
    ENDIF
	MOV	CH,AL			;CH= logical drive (unverified)
	CALL	SKIP_SP			;get next character
	CMP	AL,':'			;is it part of drive designation?
    IF Z_100
	JNE	MAP_PAR_ERR		;First one must have colon
    ELSE
	JNE	MAP_60			;  no...what could it be?
    ENDIF
	CALL	SKIP_SP			;  yes...skip it
MAP_60:
    IF Z_100
	ADD	AL,'A'-'0'		; Make it a drive letter
    ELSE
	CMP	AL,'='			;is it an equal sign?
	JNE	MAP_PAR_ERR		;no...error
	CALL	SKIP_SP			;get next character
    ENDIF
	MOV	CL,AL			;CL= physical drive (unverified)
	CALL	PARM_CK			;verify these drive designations
	JC	MAP_PAR_ERR		;sorry...bad parameters
	CALL	SET_TEMP		;make temporary table changes
	CALL	SKIP_SP			;get next character
    IF NOT Z_100
	CMP	AL,':'			;part of drive designation?
	JNE	MAP_70			; no
	CALL	SKIP_SP			; yes...skip it
    ENDIF
MAP_70:
	CMP	AL,','			;is it a comma?
	JE	MAP_80			;yes
	CMP	AL,';'			;is it a semi-colon?
	JE	MAP_80			;yes
	CMP	AL,09H			;is it a tab?
	JE	MAP_80			;yes
	CMP	AL,0DH			;end of command line?
	JNE	MAP_50			;no
	JMP	SET_TBL			;yes...make changes to table
MAP_80:
	CALL	SKIP_SP			;skip valid separator
	JMP	MAP_50 

MAP_PAR_ERR:
; This issues a message indicating an invalid parameter on
; the command line after resetting the temp area of the drive table

	MOV	DX,OFFSET PAR_ERR_MSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC		;output message string
    IF Z_100
	CALL	RESET_TEMP
	JMP	MAP_EXIT
    ELSE
	JMP	RESET_TEMP		;reset temp portion of table
    ENDIF

MAP_VER_ERR:
; This issues a message indicating incorrect MS-DOS version

	MOV	DX,OFFSET VER_ERR_MSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC		;output message string
	JMP	MAP_EXIT

RESET_TBL:
; This routine resets the table back to the state it was in 
; at boot time

; First check if this is a first time call for MAP. If so, reset the
; interrupt vectors.
	CMP	MAP_RES,TRUE		;is this a first time call?
	JNE	RES_TBL_10		;no
; This is a 1st time call
	MOV	MAP_RES,FALSE		;insure no resident code
	XOR	AX,AX
	MOV	ES,AX
	CLI				;don't bother me now
	MOV	BX,FUNC_REQ_ADR		;locate function request intr.
	MOV	AX,OFR_OFF
	MOV	ES:[BX],AX		;restore offset
	MOV	AX,OFR_SEG
	MOV	ES:[BX+2],AX		;restore segment
	MOV	BX,ADR_ADR		;locate absolute disk read intr.
	MOV	AX,OADR_OFF
	MOV	ES:[BX],AX		;restore offset
	MOV	AX,OADR_SEG
	MOV	ES:[BX+2],AX		;restore segment
	MOV	BX,ADW_ADR		;locate absolute disk write intr.
	MOV	AX,OADW_OFF
	MOV	ES:[BX],AX		;restore offset
	MOV	AX,OADW_SEG
	MOV	ES:[BX+2],AX		;restore segment
	STI				;re-enable interrupts

RES_TBL_10:
	MOV	ES,TBL_SEG		;get table segment value
	MOV	DI,OFFSET MAP_TBL	;get table offset value
; make sure logical default drive and physical default drive agree
	XOR	AX,AX
	MOV	AL,ES:DEF_DRV		;get logical default drive
	MOV	DL,AL
	MOV	SI,DI
	SHL	AX,1
	ADD	SI,AX			;SI=logical drive's table entry
	MOV	AL,DL
	ADD	AL,41H			;convert to drive letter
	CMP	ES:BYTE PTR [SI+1],AL	;physical=logical?
	JE	RES_TBL_15		;yes
	MOV	AH,DOSF_SELDISK		;no...make the logical the default
	PUSHF
	CALL	ES:DWORD PTR OLD_FUNC_REQ
RES_TBL_15:
	MOV	CL,TBL_SIZ		;get table size
	MOV	AL,041H			;AL='A'
RES_TBL_20:
	MOV	BYTE PTR ES:[DI],AL	;reset physical
 	DEC	CL
	JZ	RESET_TEMP		;end of table...now do temp
	ADD	DI,02			;locate next table entry
	INC	AL			;increment to next drive name
	JMP	RES_TBL_20

SET_TBL:
; This routine updates the physical drive values of the table with
; the values stored in the temp portion of the table. 

	MOV	ES,TBL_SEG		;get table segment value
	MOV	DI,OFFSET MAP_TBL	;get table offset value
	MOV	CL,TBL_SIZ		;get table size
SET_TBL_10:
	MOV	AL,BYTE PTR ES:[DI+1]	;pick-up temp value
	MOV	BYTE PTR ES:[DI],AL	;store value
	DEC	CL
	JZ	MAP_EXIT		;done
	ADD	DI,02			;locate next table entry
	JMP	SET_TBL_10		;update next entry

RESET_TEMP:
; This routine restores the temp portion of the table to the
; state described in the physical drive portion of the table.

	MOV	ES,TBL_SEG		;get table segment value
	MOV	DI,OFFSET MAP_TBL	;get table offset value
	MOV	CL,TBL_SIZ		;get table size
RES_TEMP_10:
	MOV	AL,BYTE PTR ES:[DI]	;get physical value
	MOV	BYTE PTR ES:[DI+1],AL	;restore temp value
	DEC	CL
    IF Z_100
	JZ	RES_TEMP_20
    ELSE
	JZ	MAP_EXIT		;done
    ENDIF
	ADD	DI,02			;locate next table entry
	JMP	RES_TEMP_10
    IF Z_100
RES_TEMP_20:
	RET
    ENDIF

MAP_HELP:
; The user has requested the displaying of the help screen

	MOV	DX,OFFSET HELP_SCN	;locate help screen
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC		;display it

MAP_EXIT:
; Check if the default drive was mapped
	CMP	DEF_FLG,TRUE
	JNE	MAP_EXIT_10		;default drive was not mapped
	MOV	ES,TBL_SEG
	MOV	AL,ES:DEF_DRV
	CALL	DR_XLATE
	MOV	DL,AL
	MOV	AH,DOSF_SELDISK
	PUSHF
	CALL	ES:DWORD PTR OLD_FUNC_REQ
MAP_EXIT_10:
; We exit 1 of 2 ways depending whether or not we stay resident

	POP	ES
	POP	DI
	POP	SI
	POP	CX
	POP	BX

	CMP	MAP_RES,FALSE		;do we stay resident?
	JE	MAP_EXIT_NRES		;no
	MOV	DX,OFFSET MAP_END_RES	;locate last byte + 1
	INT	DOSI_TERMR		;resident exit
MAP_EXIT_NRES:
	INT	DOSI_TERM		;non-resident exit

;***************************************
;
; SET_TEMP 
;
; This routine sets the temp portion of the table according
; to the parameters found in the current command line.
; These values will remain temporary until the command line's
; syntax can be verified.
;
;	ENTRY: CH = Logical drive value
;	       CL = Physical drive value
;	
;	EXIT:  NONE
;
;	USES: AX,ES,DI
;***************************************

SET_TEMP PROC NEAR
	MOV	ES,TBL_SEG		;get table segment value
	MOV	DI,OFFSET MAP_TBL	;get table offset value
	SUB	CH,041H			;calculate proper table entry offset
	CMP	CH,ES:DEF_DRV		;was default drive mapped
	JNE	SET_TEMP_10		;no
	MOV	DEF_FLG,TRUE		;yes
SET_TEMP_10:
	SHL	CH,1
	XOR	AX,AX
	MOV	AL,CH
	ADD	DI,AX
	MOV	BYTE PTR ES:[DI+1],CL	;update temp value
	RET	
SET_TEMP ENDP


;***************************************
;
; SKIP_SP
;
;	This routine searches through the command line
;	until a non-space character is encountered.
;
;	ENTRY:	BX = Current position in command line
;
;	EXIT:	BX = Non-space character's position in
;		     command line
;		AL = Non-space character found
;
;***************************************

SKIP_SP PROC	NEAR
SKIP_SP_10:
	INC	BX			;look at next character
	CMP	BYTE PTR [BX],' '	;is it a space?
	JNE	SKIP_SP_20		;no...time to leave
	JMP	SKIP_SP_10		;keep looking
SKIP_SP_20:
	MOV	AL,BYTE PTR [BX]	;pick-up character
	RET
SKIP_SP ENDP


;***************************************
;
; PARM_CK
;
;	This routine checks the current command line
;	character to see if it is a valid drive 
;	designation. A valid drive must not be greater
;	than the number of drives in the system.
;
;	ENTRY:	CH = logical drive designation
;		CL = physical drive designation
;
;	EXIT:	PSW.C is set if current character is invalid.
;
;***************************************

PARM_CK PROC NEAR
	PUSH	ES
	PUSH	AX
; insure physical character is upper case
	MOV	AL,CL
	CALL	RANGE_CK
	MOV	CL,AL
	JC	PARM_CK_20		;invalid physical drive designation
; insure logical character is upper case
	MOV	AL,CH
	CALL	RANGE_CK
	MOV	CH,AL
	JC	PARM_CK_20		;invalid logical drive designation
; insure physical drive designation is within system limits
	MOV	ES,TBL_SEG
	MOV	AL,ES:MAP_LIM		;get system drive limit
	CMP	CL,AL			;is physical drive within limits?
	JA	PARM_CK_10		; no
	CMP	CH,AL			;is logical drive within limits?
	JA	PARM_CK_10		; no
	CLC				; yes...indicate no errors
	JMP	PARM_CK_20
PARM_CK_10:
	STC				;indicate invalid parameter
PARM_CK_20:
	POP	AX
	POP	ES
	RET
PARM_CK ENDP

;***************************************
;
;  RANGE_CK
;	This routine insures that lower case letters
;	are translated to upper case. If they are already
;	upper case, nothing is done. If they are out of 
;	the acceptable range, an error condition is
;	indicated.
;
;	ENTRY:	AL = character to be inspected
;
;	EXIT:	AL = translated character if no error,
;		     otherwise, the original character.
;		PSW.C is set if an error condition exists.
;
;***************************************
RANGE_CK PROC	NEAR
	
; check if character is already in upper case
	CMP	AL,'A'
	JB	RNG_CK_20		;error
	CMP	AL,'Z'
	JB	RNG_CK_10		;already upper case...just leave

; check if character needs lower/upper case translation
	CMP	AL,'a'
	JB	RNG_CK_20		;error
	CMP	AL,'z'
	JA	RNG_CK_20		;error

; convert lower case to upper case
	SUB	AL,20H

RNG_CK_10:
; indicate no errors
	CLC
	JMP	RNG_CK_EXIT

RNG_CK_20:
; indicate an error condition
	STC
RNG_CK_EXIT:
	RET
RANGE_CK ENDP


CODE	ENDS
	END	MAP

