Page	60,132
Title	-Disk Boot Routines
;
;
;	Copyright (c) 1983
;	Zenith Data Systems
;	St. Joseph, Michigan
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;	Last Update 30_Dec_85
;
;
%Out	Boot.asm
page
;----------------------------------------------------------------------
; Equates (20_May_85)
;--------------------
;
; Include Files
;--------------
;	Rom.lit
;	Intr.lit
;	IO.lit
;	Keyboard.lit
;	Disk.lit
;
	.xlist
	Include	../Rom/Rom.lit
	Include ../Rom/Intr.lit
	Include ../IO/IO.lit
	Include ../IO/Keyboard.lit
	Include	Disk.lit
	.list

page
;======================================================================
Monitor_Segment Segment Word Public
;==================================
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing

; Include Files
;--------------
;	Disk.ext
;
	.xlist
	Include Disk.ext
	.list

	extrn	Disk_Read:Near
	extrn	Display_Disk_Error:Near
	extrn	DS_to_Rom_Data:Near

page
;----------------------------------------------------------------------
Boot_Interrupt Proc Far; (1_Jul_85)
;----------------------------------
;	Boot_Interrupt is called to actually boot an operating system
; driver from disk, and to transfer control to it.  If errors are
; encountered, it will print out an error message and transfer control 
; to the MFM150 monitor instead.
;	This routine will not return to the caller.
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing
Public	Boot_Interrupt

	call	DS_to_Rom_Data		;DS:= Rom Data
	call	Disk_Boot		;Attempt to read boot code from disk
	jnc	Bi1			;If (Boot Error eq True)

	jmp	Display_Disk_Error	;	Display Error then World Map
Bi1:	mov	dl,Boot_Drive		;Get boot drive as parm to boot code
	mov	dh,0			;Set head number to 0
	jmp	Boot_Code		;Boot successful, transfer to O.S.

Boot_Interrupt	EndP

page
;----------------------------------------------------------------------
Disk_Boot Proc Near; (7_Aug_85)
;------------------------------
;	Disk_Boot reads the boot information from the specified drive
; into memory at 'BOOT_CODE'.  If an error occurs during the read,
; an error flag and code will be returned to the caller.  The disk
; booted is contained in the 'BOOT_DRIVE' global variable.  Also
; note that, unlike the other disk routines, this routine automatically
; performs retries in the event of disk errors.
;
; Output:
;	CY: Error flag.  If an error occurs during the boot, then 
;	    the carry flag will be set.
;	AH: Error code.  If the carry flag is set, then AH will
;	    contain a disk error code as documented for the GET_DISK
;	    STATUS call.  As an additional status, an error code of
;	    00H upon return means that the boot was aborted by the
;	    user entering an ESCAPE or SHIFT-BREAK.
;	    If the carry flag is reset upon return, then the contents
;	    of AH will not be informative.
;
Public	Disk_Boot

	PushReg	<bx,cx,dx,si,di,es>
	sti				;Permit disk interrupts to occur
	cld				;Use forward string moves
	mov	di,3			;Outer loop retries

Db1:	mov	si,5			;Inner loop retries
Db2:	mov	bx,Interrupt_Segment	;Point BX to the disk boot segment
	mov	es,bx
	mov	bx,Offset Boot_Code	;Point now to the actual boot buffer
	mov	dl,Boot_Drive		;Set boot drive in DL
	mov	dh,0			;Set side (head) to 0
	mov	cx,(0 Shl 8) Or 1	;Read track 0, sector 1
	mov	ax,(2 Shl 8) Or 1	;Set up to read one sector
	int	Disk_IO_Intr		;Read the boot sector
	jnc	Db4			;Read worked OK - return

	push	ax
	mov	ah,0			;Reset disk controller/drives
	int	Disk_IO_Intr
	pop	ax

	cmp	ah,80h
	jz	Db3

	dec	si			;Decrement retry count
	jnz	Db2			;Try again if not 0

Db3:	dec	di
	jnz	Db1
	stc				;Set error flag

Db4:	PopReg	<es,di,si,dx,cx,bx>
	ret

Disk_Boot	EndP

Monitor_Segment EndS
		End
