Page	60,132
Title	-System Functions
;
;	Copyright (c) 1983
;	Zenith Data Systems
;	St. Joseph, Michigan
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;	Last Update 8_Jul_85
;
;
%Out	Sys.asm
page
;----------------------------------------------------------------------
; Equates (31_May_85)
;--------------------
;
; Include Files
;--------------
;
;	Rom.lit
;	Intr.lit
;	Sys.lit
;	Disk.lit
;	IO.lit
;	Video.lit
;
	.xlist
	Include	..\Rom\Rom.lit
	Include	..\Rom\Intr.lit
	Include	..\Rom\Sys.lit
	Include ..\Disk\Disk.lit
	Include	..\IO\IO.lit
	Include ..\Video\Video.lit
	.list

page
;======================================================================
Rom_Data Segment At (40H)
;========================
;
	extrn	Drive_Motor_Count:Byte
	extrn	Drive_Status:Byte

Rom_Data	EndS

page
;======================================================================
Monitor_Segment Segment Word Public
;==================================
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing, ss:Nothing


; Include Files
;--------------
;	Sys.ext
;	Disk.ext
;	Video.ext

	.xlist
	Include	..\Rom\Sys.ext
	Include	..\Disk\Disk.ext
	Include ..\Video\Video.ext
	.list

	extrn	Delay:Near

;----------------------------------------------------------------------
; Fixed Data Area
;----------------
;
Public	Printer_Base	;Base printer port addresses
Printer_Base	dw	3BCh
		dw	378h
		dw	278h

Public	Serial_Base	;Base serial port addresses
Serial_Base	dw	3F8h
		dw	2F8h

page
;----------------------------------------------------------------------
DS_to_Rom_Data Proc Near; (1_Jul_85)
;-----------------------------------
;	1) This routine sets the DS register to the Rom Data Segment (40h)
;	2) This routine has been implemented so that, by the addition of
;	   a flag, the rom data segment could be redirected to another
;	   area of memory.
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing, ss:Nothing
Public	DS_to_Rom_Data

	push	dx
	mov	dx,Rom_Data
	mov	ds,dx			;DS:= Rom Data Segment
	pop	dx
	ret				;Return

DS_to_Rom_Data	EndP


;----------------------------------------------------------------------
Get_Memory_Size_Interrupt Proc Far; (1_Jul_85)
;---------------------------------------------
;	1) Get_Memory_Size_Interrupt returns the amount of memory in the 
;	   system. The actual amount of memory is determined at power up - 
;	   this is set by dip switches.
;	2) Exit Register Values
;		AX -> Size of memory in K bytes. (ie, 64 = 40H = 64 Kbytes)
;
Assume	cs:Monitor_Segment, ds:Rom_Data, es:Nothing, ss:Nothing
Public	Get_Memory_Size_Interrupt

	push	ds
	call	DS_to_Rom_Data		;DS:= Rom Data
	mov	ax,Memory_Size		;Retrieve the size of memory
	pop	ds
	iret

Get_Memory_Size_Interrupt EndP

page
;----------------------------------------------------------------------
Poll_Memory_Size Proc Near; (29_May_85)
;--------------------------------------
;	1) Poll_Memory_Size is called in the cost reduced machine
;	   configuration to determine the amount of available memory by
;	   polling all system memory in 64K chunks.
;	2) Exit Register Values:
;		AX -> Memory size in K bytes
;
Public	Poll_Memory_Size

	PushReg	<bx,cx,es>
	pushf				;Save the current interrupt enable status
	cli				;Keep interrupts out here!
	mov	bx,0			;Start with the base 64K
	mov	cx,bx			;Set starting count to 0
PMS1:	mov	es,bx			;Point ES to this segment
	mov	al,Byte Ptr es:[0]	;Get a byte from this segment
	mov	ah,al			;Save it in AH
	not	al			;Complement the byte
	mov	Byte Ptr es:[0],al	;Write the inverted byte to memory
	xchg	ah,Byte Ptr es:[0]	;Write original byte, get status of write
	xor	al,ah			;Did the first write operation take?
	jnz	PMS2			;No, check for memory errors

	mov	al,ah			;Get the inverted byte again
	not	al			;Convert it to the original byte
	xor	al,Byte Ptr es:[0]	;Did the second write work?
	jz	PMS4			;Yes - continue scanning

PMS2:	push	cx			;No, save the current memory size
	mov	ch,0
	mov	cl,8			;Set repeat count to 8 bits/byte
	mov	ah,0			;Set bad-bit count to 0
PMS3:	shl	al,1			;Get a bit into the carry flag
	adc	ah,0			;If set, increment bad bit count
	loop	PMS3			;Check all 8 bits

	cmp	ah,1			;Did more than 1 bit fail?
	pop	cx			;[Restore the memory size]
	ja	PMS5			;Yes - done scanning memory

PMS4:	add	bx,1000h		;Point to the next memory segment
	add	cx,64			;Include this bank in memory size
	jmp	PMS1			;Continue till at end of memory

PMS5:	mov	ax,cx			;Get the global memory size in AX
	popf				;Restore old interrupt-enable status
	cmp	ax,128 * K		;Have we found at least 128K?
	jae	PMS6			;Yes - go with this configuration

	mov	ax,128 * K		;No, there's at least 128K here!
PMS6:	PopReg	<es,cx,bx>
	ret

Poll_Memory_Size EndP

page
;----------------------------------------------------------------------
Set_IO_Configuration Proc Near; (8_Jul_85)
;-----------------------------------------
;	Set_IO_Configuration determines the number of peripherals
; attached to the system, and records the information in the global
; variable 'IO_CONFIG'.  See the Get_IO_Configuration routine for
; more details regarding the values recorded in this variable.
;
Public	Set_IO_Configuration

	PushReg	<ax,bx,cx,dx,di>	;Save registers

	mov	ah,0			;Clear number of printers to 0
	mov	bx,0			;Point to the base printer addresses
	mov	di,bx			;Point to the output addresses array
	mov	cx,Printer_Ports	;Number of printers to be checked
SIOC1:	mov	dx,cs:Printer_Base[bx]	;Get the base addr of a printer port

	mov	al,0AAh			;Write an alternating bit pattern...
	out	dx,al			;...to the printer port as an ID
	push	bx			;Make sure bus doesn't retain data
	in	al,dx			;Re-read printer port data
	pop	bx			;Clean up stack
	cmp	al,0AAh			;Is there a valid port here?
	jnz	SIOC2			;No, try the next port

	mov	Printer_Table[di],dx	;Yes - place the port addr in table
	add	di,Type Printer_Table	;Point to the next output spot
	inc	ah			;Increment printer count
SIOC2:	add	bx,Type Printer_Base	;Point to the next printer port
	loop	SIOC1			;Loop until all printers checked

	mov	al,0			;Extend printer count to a word
	mov	cl,6			;Get shift count to put in right spot
	shl	ax,cl			;Adjust the printer count
	push	ax			;Save the current I/O configuration

	mov	bx,0			;Point to bases of serial ports
	mov	di,bx			;Point to output array
	mov	cx,Serial_Ports		;Number of serial ports to check
	mov	ah,0			;Clear number of serial ports to 0
SIOC3:	mov	dx,cs:Serial_Base[bx]	;Get the base addr of an RS-232 port
	add	dx,2			;Point to the interrupt ID register
	in	al,dx			;Read the interrupt ID
	and	al,Serial_Intr_Mask	;Is there a serial card here?
	jnz	SIOC4			;No, try the next port

	sub	dx,2			;Yes - point back to the base port
	mov	Serial_Table[di],dx	;Place port address in array
	add	di,Type Serial_Table	;Point to the next output location
	inc	ah			;Increment serial port count
SIOC4:	add	bx,Type Serial_Base	;Point to the next serial port
	loop	SIOC3			;Loop until all ports checked out

	mov	al,0			;Extend serial port count to a word
	shl	ax,1			;Place port count in right bits
	pop	cx			;Get old I/O config in CX

	or	cx,ax			;OR in printer and serial counts
	mov	dx,Game_Base		;Point to the base port of game card

	in	al,dx			;Read the card's port
	and	al,Game_Card_Mask	;Is a valid port here (no ADC)?
	jnz	SIOC5			;No, continue

	or	cx,Game_Flag		;Yes - flag game card in IO_CONFIG
SIOC5:	mov	ax,IO_Config		;Get the old I/O configuration
	and	ax,Game_Flag		;Isolate the game card bit
	or	cx,ax			;If game card was there, it still is!

	call	Read_Dip_Switches	;Read the system config switches
	or	cl,ah			;Place DIP switch #1 data in config
	or	cl,00101100b		;Force -- 64k System Ram and 80x25 cga
	mov	IO_Config,cx		;Record global variable

	PopReg	<di,dx,cx,bx,ax>	;Restore registers
	ret				;Return

Set_IO_Configuration EndP

page
;----------------------------------------------------------------------
Get_IO_Config_Interrupt Proc Far; (1_Jul_85)
;-------------------------------------------
;	Get_IO_Config_Interrupt returns the current status of peripherals
; attached to the system at power-up (the configuration is actually
; determined then).
;
; Output:
;	AX: Current I/O device configuration, as follows:
;		Bits 14-15:	Number of printers attached to system
;		Bit 13:		Currently unused
;		Bit 12:		Game I/O board in system
;		Bits 9-11:	Number of RS-232 ports in system
;		Bit 8:		Currently unused
;		Bit 6-7:	Number of 5-1/4" disks.  If these
;				bits are 0, and bit 0 = 1, then 4
;				drives are currently connected.
;		Bit 4-5:	Initial video mode, as follows:
;				00:	Fast 80x25 Graphics mode
;				01:	40x25 Color card mode
;				02:	80x25 Color card mode
;				03:	80x25 Monochrome card mode
;		Bit 2-3:	Amount of RAM up to 64K:
;				00:	16K RAM
;				01:	32K RAM
;				02:	48K RAM
;				03:	64K RAM
;		Bit 1:		8087 attached to the system
;		Bit 0:		Floppy drives connected
;
Public	Get_IO_Config_Interrupt

	Push	ds
	call	DS_to_Rom_Data		;DS:= Rom Data
	mov	ax,IO_Config		;Get the I/O configuration word
	Pop	ds
	iret				;Return

Get_IO_Config_Interrupt EndP

page
;----------------------------------------------------------------------
Read_Dip_Switches Proc Near; (1_Jul_85)
;--------------------------------------
;	Read_DIP_Switches is used to read the values of the system
; configuration switches 1 and 2.
;
; Output:
;	AH: Value for DIP switch 1, as follows:
;		Bit 6-7:	Number of 5-1/4" disks.  If these
;				bits are 0, and bit 0 = 1, then 4
;				drives are currently connected.
;		Bit 4-5:	Initial video mode, as follows:
;				00:	80x25 Graphics mode
;				01:	40x25 Text mode
;				02:	80x25 Text mode
;				03:	80x25 Monochrome mode
;		Bit 2-3:	Amount of RAM up to 64K:
;				00:	16K RAM
;				01:	32K RAM
;				02:	48K RAM
;				03:	64K RAM
;		Bit 1:		8087 numeric coprocessor attached
;		Bit 0:		Floppy drives connected
;	AL: Value for DIP switch 2, as follows:
;		Bit 7:		Video refresh rate select:
;				0:	60 Hertz display
;				1:	50 Hertz display
;		Bit 5-6:	Boot drive select:
;				00:	No auto-boot
;				01:	5-1/4" Drive 0 auto-boot
;				10:	Winchester Drive 0 auto-boot
;				11:	Reserved
;		Bit 0-4:	System memory size (in 32K byte increments).
;				This value does NOT include the first
;				64K of RAM memory (ie, a value of 8 equals
;				8*32=256K of ADDITIONAL RAM - indicating a
;				system total of 256K + 64K = 320K).
;
Public	Read_Dip_Switches

	PushReg	<bx,cx>
	in	al,Sys_Ctrl_Port	;Read the hardware control port
	mov	bl,al			;Save the status of the port
	mov	al,Read_Switch_A	;Get the I/O command to read DIP sws
	out	Sys_Ctrl_Port,al	;Enable DIP switches

	in	al,Sys_Switch_2		;Place value for Switch #2A in AL
	and	al,Switch_2_Mask	;Mask out all but switch data
	mov	bh,al			;Save data in BH
	mov	al,Read_Switch_B	;Get code to read other half of SW #2
	out	Sys_Ctrl_Port,al	;Turn on Switch #2, part B

	in	al,Sys_Switch_2		;Read Switch #2, bits 4-7
	mov	cl,4			;Get shift to put in high nibble
	shl	al,cl
	or	bh,al			;OR in to get all of Switch #2 in AL
	mov	al,bl			;Get the control port again
	out	Sys_Ctrl_Port,al	;Restore the control port status

	push	ds			;On Morrow machine, memory is already determined
	call	DS_to_Rom_Data		;DS:= Rom Data
	mov	ax,Bus_Memory_Size	;Get memory size
	pop	ds

	mov	cl,5			;Turn into 32K chunks
	shr	ax,cl
	or	al,0 Shl 7 + 01 Shl 5	;Add in 60 hz and boot floppy for good measure
	mov	ah,bh
	or	ah,1			;Add in Floppy's attached for good measure
	PopReg	<cx,bx>
	ret				;Return

Read_Dip_Switches EndP

Monitor_Segment	EndS
		End
