Page	60,132
Title	-Telephone Dialer and Appointment Utilities
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;	Last Update 16_May_85
;
;	
%Out	Putil.asm
page
;----------------------------------------------------------------------
; Equates
;--------
;
; Include Files
;--------------
;	Rom.lit
;	icon.lit
;	Pequ.lit
;	Pdata.lit
;
	.xlist
	Include	..\Rom\Rom.lit
	Include	Icon.lit
	Include	Pequ.lit
	Include	Pdata.lit
	.list

.SALL
RW	MACRO
	CALL	BATRW
	ENDM

RO	MACRO
	CALL	BATRO
	ENDM

page
;======================================================================
PhNovRam Segment At (0F110h)
;===========================
;	1) Phone and Appointment Scheduler Variables in NovRam
;	2) Use the routines RHOLE and RERASE to allocate and de-allocate from
;	   RAMBOT up to the end of battery RAM.

	Extrn	CHKSUM: Byte	; Checksum on battery RAM contents
	Extrn	ALMTIME: Word	; Time of next alarm Hi-Byte=hour, Lo-Byte=min.
	Extrn	ALMYR: Byte	; Year as offset from 1985 (i.e. 1986 = 1)
	Extrn	ALMMD: Word	; Month and day
	Extrn	ALMPEND: Byte	; Alarm pending counter
	Extrn	AREACD: Byte	; Current area code
	Extrn	PREFIX: Byte	; Dial prefix up to 11 digit prefix
	Extrn	CALTIM: Byte	; Call time (hrs, min, sec)
	Extrn	REDIAL: Byte	; Re-dial number ( 64 char re-dial buffer)
	Extrn	RAMTOP: Word	; Pointer to first byte of stored data
	Extrn	APP1ST: Word	; Pointer to first appointment record
	Extrn	RAMBOT: Byte	; Starting location of stored data

PhNovRam	EndS

page
;======================================================================
Monitor_Segment Segment Word Public
;==================================
;
Assume	cs:Monitor_Segment, ds:PhNovRam, es:PhNovRam

	extrn	dflags:byte
	extrn	System_Setup:word
	extrn	beep:near
	extrn	Put_String:Near
	extrn	Put_String_n:Near
	extrn	Put_String_Imm:Near
	extrn	Put_chr:Near
	extrn	Put_Ascii:Near
	extrn	Put_Ascii_Word:Near
	extrn	R_W_RTC_RAM:Near
	extrn	Distim:near

	; Publics used by phone and appointment
	Public	BATRO
	Public	BATRW
	Public	BLANK
	Public	CI
	Public	CISTAT
	Public	CO
	Public	CURSOR
	Public	DISHR
	Public	DISHRS
	Public	DISMIN
	Public	KEYS
	Public	No_Zero_Supp
	Public	Zero_Supp
	Public	REMAIN
	Public	RERASE
	Public	RHOLE
	Public	RSIZE
	Public	RSUM
	Public	SCLEAR
	Public	Set_Norm_Att
	Public	Set_Rev_Att
	Public	Str_Out
	Public	Str_Out_Cur
	Public	UPPER

Subttl	-I/O
page
;--------------------------------------------------------------------------
; Move Cursor
;
;	On entry: DH = row
;		  DL = column
;----------------------

CURSOR:
	MOV	CURPOS[BP],DX	; Store cursor
	PUSH	BX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	XOR	BH,BH		; Move cursor
	MOV	AH,2
	INT	10H
	POP	BP
	POP	DI
	POP	SI
	POP	BX
	RET


;--------------------------------------------------------------------
;Set Dlags to indicate suppression of zeroes
;----------------
Zero_Supp:
	push	ax
	push	ds
	mov	ax,Monitor_Segment
	mov	ds,ax
Assume	ds:Monitor_Segment
	or	dflags, Zer_Sup	; turn on suppression of zeroes
	pop	ds
Assume	ds:PhNovRam
	pop	ax
	ret

;------------------------------------------------------------------------
;Set dflags to not suppress zeroes
;-----------------

No_Zero_Supp:
	push	ax
	push	ds
	mov	ax,Monitor_Segment
	mov	ds,ax
Assume	ds:Monitor_Segment
	and	dflags, NOT Zer_Sup	; turn on suppression of zeroes
	pop	ds
Assume	ds:PhNovRam
	pop	ax
	ret

;--------------------------------------------------------------------------
; Str_Out	Outputs the string pointed to by si in Normal video.
;		Cursor Position unchanged.
;-----------------------

Str_Out:
	push	bx
	push	cx
	push	dx
	mov	bl,normal
	call	Put_String
	pop	dx
	pop	cx
	pop	bx
	ret

;-------------------------------------------------------------------------
; Str_Out_Cur	Outputs the string pointed to by SI, and sets new cursor
;		position after displaying string.
;--------------------

Str_Out_Cur:
	push	bx
	push	cx
	push	dx
	mov	bl,normal
	call	Put_String
	call	cursor
	pop	dx
	pop	cx
	pop	bx
	ret



;---------------------------------------------------------------------------
; Reverse Video
;-----------------

Set_Rev_Att:
	MOV	BYTE PTR VIDATT[BP],reverse
	RET

;---------------------------------------------------------------------------
; Normal Video
;------------------

Set_Norm_Att:
	MOV	BYTE PTR VIDATT[BP],normal
	RET

;---------------------------------------------------------------------------
; Console Output at Cursor
;
;	On entry: AL contains char
;--------------------

CO:
	PUSH	BX
	PUSH	CX
	PUSH	DX

	MOV	BL,VIDATT[BP]	; Get current video attributes & cursor spot
	MOV	DX,CURPOS[BP]
	call	put_chr
	CALL	CURSOR
	POP	DX
	POP	CX
	POP	BX
	RET

;---------------------------------------------------------------------------
; Blank at Cursor
;
;	On entry: CX contains number of blanks
;
;	On exit:  Cursor position unchanged
;----------------------

BLANK:
	JCXZ	BLAN1

	PUSH	BX
	PUSH	CX
	MOV	BL,VIDATT[BP]	; Get current video attributes

	PUSH	SI
	PUSH	DI
	PUSH	BP
	XOR	BH,BH		; Write blanks to screen
	MOV	AX,0920H
	INT	10H
	POP	BP
	POP	DI
	POP	SI
	POP	CX
	POP	BX
BLAN1:	RET

;---------------------------------------------------------------------------
; Clear Screen
;
;	On exit:  Screen cleared to blanks
;		  Cursor at (0,0)
;-------------------

SCLEAR:
	PUSH	DX		; Cursor to home position
	XOR	DX,DX
	CALL	CURSOR
	POP	DX

	PUSH	BX
	PUSH	SI
	PUSH	DI
	MOV	BL,normal	; Normal video
	MOV	VIDATT[BP],BL
	PUSH	BP
	mov	ax,2		; Clear whole screen
	INT	10H
	POP	BP
	POP	DI
	POP	SI
	POP	BX
	RET


;---------------------------------------------------------------------------
; Console Input
;
;	On exit: AX contains key scan code
;-------------------------

CI:
	TEST	BYTE PTR TIMER[BP],1 ; No timer running?
	JZ	CI1
	CMP	[CALTIM],-1
	JZ	CI1

CI0:	CALL	CISTA0		; Wait for console char
	JZ	CI0

CI1:	PUSH	SI
	PUSH	DI
	XOR	AH,AH		; Get next char from keyboard
	INT	16H
	POP	DI
	POP	SI

	MOV	KEYCHR[BP],AX	; Store char

CI2:	RET

;---------------------------------------------------------------------------
; Console Status Check
;
;	On exit:  NZ if char pending
;------------------------

CISTAT:
	TEST	BYTE PTR TIMER[BP],1 ; No timer running?
	JZ	CISTA1
	CMP	[CALTIM],-1
	JZ	CISTA1

CISTA0:	CALL	DISTIM		; Display call timer

CISTA1:	PUSH	SI
	PUSH	DI
	MOV	AH,1		; Char pending?
	INT	16H
	POP	DI
	POP	SI
	RET

page
SUBTTL	Utilities

;-------------------------------------------------------------------------
; Set Battery RAM Read/Write or Read/Only (16_May_85)
;----------------------------------------------------
;	1) On exit:  All registers and flags preserved.
;
BATRO:	push	ax
	mov	al,0		; disable NovRam Writes
	jmp	Short BATCHG

BATRW:	push	ax		; Enable NovRam Writes
	mov	al,1

BATCHG:	pushf
	call	R_W_RTC_RAM	; enable / Disable NovRam
	popf
	pop	ax
	ret

page
;----------------------------------------------------------------------------
; Size Battery RAM
;
;	On exit:  AL is non-zero if RAM is corrupt
;		  Z flag reflects AL
;		  AH contains number of 256 byte pages
;		  RAMHI -> topmost battery RAM address plus 1
;		  ES & DS -> battery RAM base
;---------------------
PUBLIC	RSIZE

RSIZE:
	MOV	AX,PhNovRam	; Set up segments for accessing Phone NovRam
	MOV	DS,AX
	MOV	ES,AX

	push	bx
	push	cx
	MOV	BYTE PTR RAMCHG[BP],1 ; Indicate RAM change
	call	Set_NRam_Size

	MOV	AX,CX
	XCHG	AH,AL
	MOV	RAMHI[BP],AX	
	MOV	AL,[BX]		; Get checksum at location zero
	INC	BX

RSIZ2:	SUB	AL,[BX]		; Subtract byte from checksum
	INC	BL
	JNZ	RSIZ2
	INC	BH		; After 1st page, only use last byte of page
	DEC	BL
	LOOP	RSIZ2
	OR	AL,AL		; If checksum was bad
	JZ	RSIZ6		; then
RSIZ3:	PUSH	AX		
	CALL	BEEP		; Beep to indicate error
	RW
	XOR	DI,DI		; Zero RAM
	MOV	CX,RAMHI[BP]
	CLD
	XOR	AX,AX		; store 0's in RAM
	REP	STOSB

; Now, put default data in NovRam

	MOV	DI,OFFSET RAMBOT	; Always start with #1 and #2 phone numbers
	MOV	BX,OFFSET RSIZ7		; point to default data
RSIZ4:	MOV	AL,CS:[BX]		; get a byte
	CMP	AL,'$'			; if End of data
	JZ	RSIZ5			; then leave
	MOV	[DI],AL			; else, store data
	INC	BX			; next byte
	INC	DI			; next location in NovRam
	JMP	SHORT RSIZ4		; loop

RSIZ5:	MOV	[RAMTOP],DI	; point to Top of used RAM + 1
	DEC	DI		; Address of first appointment
	MOV	[APP1ST],DI
	MOV	AX,-1		; No alarm or call timer
	MOV	[ALMTIME],AX
	MOV	[CALTIM],AL
	RO
	CALL	RSUM		; New checksum
	POP	AX

RSIZ6:	OR	AL,AL		; set flag to indicate Ram status (good / bad)
	pop	cx
	pop	bx
	RET

RSIZ7:	DB	4," #1 ",0,4," #2 ",0,0,-1,"$" ; Initialization data


page
;-----------------------------------------------------------------------
;
; Checksum Battery RAM
;
;	On entry: DS -> battery RAM
;
;	On exit:  AL contains new checksum
;---------------------

RSUM:
	PUSH	BX
	PUSH	CX
	call	Set_NRam_Size
	INC	BX		; Add rest of first page
	XOR	AL,AL
RSU0:	ADD	AL,[BX]
	INC	BL
	JNZ	RSU0

	DEC	BL		; Then one byte from succeeding pages
	INC	BH
	LOOP	RSU0

	RW
	MOV	[CHKSUM],AL	; Store checksum
	RO
	POP	CX
	POP	BX
	RET

;-------------------------------------------------------------------------
; Set_NRam_Size: Used by Rsum and Rsize to get the amount of NovRam 
;		in the system, and to clear bx
;
;-------------------
Set_NRam_Size:
	MOV	CL,MAXBAT/256	; # of pages of battery ram
	xor	bx,bx		; clear bx
	XOR	CH,CH		; CX=# of pages of Nram
	ret
	

page
;-------------------------------------------------------------------------
; Make Hole in Battery RAM
;
;	On entry: CX contains size of hole
;		  SI -> where hole is to be created
;
;	On exit:  CY is set if successful
;--------------------

RHOLE:
	STC			; Zero size hole?
	JCXZ	RHOL1

	MOV	AX,[RAMTOP]	; Would address go beyond end of RAM?
	ADD	AX,CX
	CMP	AX,RAMHI[BP]
	JAE	RHOL1

	PUSH	CX		; Move data up to make room
	PUSH	SI
	PUSH	DI
	RW
	MOV	[RAMTOP],AX
	MOV	DI,AX
	DEC	DI
	SUB	AX,CX
	MOV	CX,AX
	SUB	CX,SI
	MOV	SI,AX
	DEC	SI
	STD

RHOL0:	REP	MOVSB		; Move bytes
	RO

	MOV	BYTE PTR RAMCHG[BP],1 ; RAM change
	POP	DI
	POP	SI
	POP	CX
	STC
RHOL1:	RET


page
;----------------------------------------------------------------------------
; Erase in Battery RAM
;
;	On entry: CX contains size of erasure
;		  SI -> spot where erasure to begin
;------------------------------

RERASE:
	JCXZ	RHOL1		; No erasure?

	MOV	AX,[RAMTOP]	; Top of RAM moves down
	RW
	SUB	[RAMTOP],CX

	PUSH	CX		; Move data down to erase
	PUSH	SI
	PUSH	DI
	MOV	DI,SI
	ADD	SI,CX
	SUB	AX,SI
	MOV	CX,AX
	CLD
	JMP	SHORT RHOL0

page
;----------------------------------------------------------------------------
; Display How Much Battery RAM Remaining
;--------------------------

REMAIN:
	SHR	BYTE PTR RAMCHG[BP],1	; No RAM change?
	JNC	REMAI0			; if Ram hasn't changed, don't bother updating
	PUSH	DX			; else
	PUSH	SI
	PUSH	CURPOS[BP]		; Save current cursor location
	
	MOV	DX,REMCUR[BP]		; Get cursor address for displaying ram
	call	cursor			; set cursor position for status display
	MOV	DL,VIDATT[BP]		; Save video attribute
	call	Set_Norm_Att		; set to use normal video
	MOV	AX,RAMHI[BP]		; compute remaining RAM
	SUB	AX,[RAMTOP]		; AX = # of free bytes in NovRam
	call	Zero_Supp		; suppress zeroes
	CALL	DISWRD			; and display it
	push	bx
	push	cx
	push	dx
	mov	dx,curpos[bp]
	mov	bl,normal
	
					; select cursor position for mssg
	push	di
	CALL	Put_String_Imm
	DB	" bytes free",eos
	pop	di
	call	cursor
	pop	dx
	pop	cx
	pop	bx
	mov	vidatt[bp],dl		; restore attribute

	POP	DX			; Restore cursor
	CALL	CURSOR
	POP	SI
	POP	DX
REMAI0:	RET


page
;----------------------------------------------------------------------------
; Dispatch on Keystroke
;
;	On entry: BX -> dispatch table
;
; Note that this is NOT a subroutine.  Enter by JMPing here.  BX destroyed.
;--------------------------

KEYS:
	PUSH	CX

KEYA:	CALL	CI		; Get a char
	OR	AL,AL		; Function key?
	JZ	KEY0
	XOR	AH,AH

KEY0:	MOV	CX,CS:[BX]	; Get next char in table

	JCXZ	KEY1		; End of table?

	CMP	AX,CX		; Match?
	JZ	KEY1

	ADD	BX,4		; Next in table
	JMP	SHORT KEY0

KEY1:	POP	CX
	JMP	WORD PTR CS:[BX+2] ; Execute

page
;---------------------------------------------------------------------------
; Display Number
;
;	Entries: DISBYT to display byte from AL
;		 DISWRD to display word from AX
;		 DISMIN to display minutes from AL
;		 DISHRS to display am/pm hours from AL
;		 DISHR  to display hours from AL
;	ON ENTRY: DX = Position
;		  Ax or al contain data
;------------------------

DISHRS:
	CMP	AL,12		; AM?
	JB	DISHR0

	SUB	AL,12		; PM

DISHR0:	OR	AL,AL		; Non-zero?
	JNZ	DISHR

	MOV	AL,12		; 0:XX -> 12:XX

DISHR:
Dismin:
disbyt:
Out_Byte:
	push	bx
	push	cx
	push	dx
	push	ds
	push	si
	push	di
	mov	bx,Monitor_Segment
	mov	ds,bx
	mov	bl,Vidatt[bp]
	mov	dx,Curpos[bp]
	call	Put_Ascii	; put out digits
	call	cursor
	pop	di
	pop	si
	pop	ds
	pop	dx
	pop	cx
	pop	bx
	ret


DISWRD:
	push	bx
	push	cx
	push	dx
	push	ds
	push	si
	push	di
	mov	bx,Monitor_Segment
	mov	ds,bx
	mov	bl,Vidatt[bp]
	mov	dx,Curpos[bp]
	call	Put_Ascii_Word	; put out digits
	call	cursor
	pop	di
	pop	si
	pop	ds
	pop	dx
	pop	cx
	pop	bx
	ret

page
;----------------------------------------------------------------------------
; Convert Lower Case to Upper
;
;	On entry: AL contains char
;
;	On exit:  AL contains upper case char
;--------------------

UPPER:
	CMP	AL,'a'
	JB	UPPE0
	CMP	AL,'z'
	JA	UPPE0
	XOR	AL,00100000B
UPPE0:	RET


;---------------------------------------------------------------------------
; Reverse Video Bar
;
;	On entry: DX contains cursor address of bar
;		  AL contains size of bar
;
;	On exit:  Cursor at start of bar
;----------------------

REVBAR:				; Reverse video bar
Public	REVBAR

	PUSH	CX
	MOV	CL,AL
	XOR	CH,CH
	CALL	CURSOR
	CALL	Set_Rev_Att
	CALL	BLANK
	CALL	CURSOR
	CALL	Set_Norm_Att
	POP	CX
	RET

Monitor_Segment	Ends
	end
