
ROM_DATA	SEGMENT	AT 40H
	EXTRN	PAGE_SIZE:WORD
ROM_DATA	ENDS

	EXTRN	PAGE_MAP:BYTE
	EXTRN	PAGE_BASE:WORD
	EXTRN	PAGE_START:WORD
	EXTRN	VIDEO_SEGMENT:WORD
	EXTRN	NUMBER_OF_PAGES:BYTE

ASSUME	CS:MONITOR_SEGMENT, DS:ROM_DATA


;	INIT_PAGE_MAP: This routine will initialize the page map.
;
INIT_PAGE_MAP	PROC	NEAR
	PUBLIC	INIT_PAGE_MAP

	PUSHREG	<BX>
	MOV	BL,NUMBER_OF_PAGES	;Get the number of pages
	DEC	BL
	MOV	BH,0			;in BX
IP1:	MOV	PAGE_MAP[BX],BL		;One to one mapping for starters
	DEC	BL			;Bump the index
	JNS	IP1
	POPREG	<BX>
	RET

INIT_PAGE_MAP	ENDP




;	MAP_PAGE: This routine will map the given display page
;		to the true "memory index" page.
;
;	Input:	AL - Page number
;
;	Output:	AL - True "memory index" page number
;
MAP_PAGE	PROC	NEAR
	PUBLIC	MAP_PAGE

	PUSH	BX

	MOV	BL,NUMBER_OF_PAGES	;Search map for NUMBER_OF_PAGES
	DEC	BL
	MOV	BH,0			;Search starting at 0

;	Locate the page in physical memory

MP1:	CMP	PAGE_MAP[BX],AL		;Is this where the page is?
	JZ	MP2			;Yes, return it
	DEC	BL			;No, check the next one
	JNS	MP1
	MOV	BL,0
MP2:
	MOV	AL,BL			;Return the page number in the correct register

	POP	BX			;Restore BX
	RET

MAP_PAGE	ENDP



;	SWAP_PAGE(Page_Number): This routine will swap the selected logical
;		video page with physical page 0.
;
;	ENTRY:	AL - Logical page to swap
;
;	EXIT:	None
;
SWAP_PAGES	PROC	NEAR
	PUBLIC	SWAP_PAGES

	PUSHREG	<AX,BX,SI>

	SUB	AH,AH
	MOV	SI,AX
	SHL	SI,1
	
	CALL	MAP_PAGE		;Map the Logical page to a physical page

	CALL	SWAP_MEMORY		;Swap the pages in memory

	MOV	BL,AL			;Turn the page number into an index
	SUB	BH,BH

;	Swap all page associated variables

	MOV	AL,PAGE_MAP		;Show the new page mapping
	XCHG	AL,PAGE_MAP[BX]		;Swap page 0 with the selected page
	MOV	PAGE_MAP,AL


	MOV	BL,PAGE_MAP[BX]
	SHL	BX,1			;Make into a word index

	MOV	AX,PAGE_BASE[SI]	;Swap the page base
	XCHG	AX,PAGE_BASE[BX]
	MOV	PAGE_BASE[SI],AX

	MOV	AX,PAGE_START[SI]		;Swap the page start
	XCHG	AX,PAGE_START[BX]
	MOV	PAGE_START[SI],AX

	POPREG	<SI,BX,AX>
	RET

SWAP_PAGES	ENDP





SWAP_MEMORY	PROC	NEAR
	PUBLIC	SWAP_MEMORY

	PUSHREG	<AX,BX,CX,DX,SI>

;	Determine the page offset

	SUB	AH,AH			;Get the page1 number
	MOV	CX,PAGE_SIZE		; and determine offset
	MUL	CX
	MOV	BX,AX

;	Swap the pages, 1 word at a time

	PUSH	ES
	MOV	ES,VIDEO_SEGMENT

	MOV	SI,0
	SHR	CX,1			;Make a word count
SP1:
	MOV	AX,ES:[SI]
	XCHG	AX,ES:[SI+BX]
	MOV	ES:[SI],AX
	ADD	SI,2
	LOOP	SP1

	POP	ES

	POPREG	<SI,DX,CX,BX,AX>
	RET

SWAP_MEMORY	ENDP

ASSUME	DS:NOTHING

