;**********************************************************************
;		     K E Y B O A R D   T A B L E S
;
; 	The following four tables are used by the keyboard routine
; to encode the scan codes into the correct values.  For most of
; the entries in this table, the code generated by the key is shown.  
; For those with the high-order bit (80H) set, the value represented 
; in the lower 7 bits will be returned as a second character, following
; a null (00H) value.  Also, values marked with a plus-sign prior to 
; a hex value represent shift and lock keys - these do not actually 
; generate key codes, but rather are processed by the keyboard routine.  
; In this case the value which follows the plus sign corresponds to
; the bit used by this key in the SHIFT_STATUS variable.  Finally, 
; some of the keys contain special values which are directly 
; converted into extended characters (this is done when the output 
; value must be greater than 7FH) - for these characters, the 'EXT_FLAG' 
; bit will be set in the 'KEY_TYPE' array.
;
; NOTE:  Values with 'nul' represent invalid keyboard combinations.
;	 For these values, no keyboard code will be generated.
;**********************************************************************

;**********************************************************************
;		 B A S E   C A S E   K E Y   T A B L E
;**********************************************************************
KEY_TABLE EQU THIS BYTE
	PUBLIC	KEY_TABLE
	DB	 nul			;Keycode 0 not used
	DB	 1BH, '1', '2', '3', '4', '5', '6', '7'
	DB	 '8', '9', '0', '-', '=', 08H, 09H, 'q'
	DB	 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o'
	DB	 'p', '[', ']', 0DH,+04H, 'a', 's', 'd'
	DB	 'f', 'g', 'h', 'j', 'k', 'l', ';', 27H
	DB	 '`',+02H, '\', 'z', 'x', 'c', 'v', 'b'
	DB	 'n', 'm', ',', '.', '/',+01H, '*',+08H
	DB	 ' ',+40H,0BBH,0BCH,0BDH,0BEH,0BFH,0C0H
	DB	0C1H,0C2H,0C3H,0C4H,+20H,+10H,0C7H,0C8H
	DB	0C9H, '-',0CBH, nul,0CDH, '+',0CFH,0D0H
	DB	0D1H,080H,0D3H, 0DH



;**********************************************************************
;	      S H I F T E D   M O D E   K E Y   T A B L E
;**********************************************************************
SHIFT_TABLE EQU THIS BYTE
	PUBLIC	SHIFT_TABLE
	DB	 nul
	DB	 1BH, '!', '@', '#', '$', '%', '^', '&'
	DB	 '*', '(', ')', '_', '+', 08H, 8FH, 'Q'
	DB	 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O'
	DB	 'P', '{', '}', 0DH,+04H, 'A', 'S', 'D'
	DB	 'F', 'G', 'H', 'J', 'K', 'L', ':', '"'
	DB	 '~',+02H, '|', 'Z', 'X', 'C', 'V', 'B'
	DB	 'N', 'M', '<', '>', '?',+01H,0B7H,+08H
	DB	 ' ',+40H,0D4H,0D5H,0D6H,0D7H,0D8H,0D9H
	DB	0DAH,0DBH,0DCH,0DDH,+20H,+10H, '7', '8'
	DB	 '9', '-', '4', '5', '6', '+', '1', '2'
	DB	 '3', '0', '.', 0DH



;**********************************************************************
;		 C T R L   M O D E   K E Y   T A B L E
;**********************************************************************
CTRL_TABLE EQU THIS BYTE
	PUBLIC	CTRL_TABLE
	DB	 nul
	DB	 1BH, nul, 83H, nul, nul, nul, 1EH, nul
	DB	 nul, nul, nul, 1FH, nul, 7FH, nul, 11H
	DB	 17H, 05H, 12H, 14H, 19H, 15H, 09H, 0FH
	DB	 10H, 1BH, 1DH, 0AH,+04H, 01H, 13H, 04H
	DB	 06H, 07H, 08H, 0AH, 0BH, 0CH, nul, nul
	DB	 nul,+02H, 1CH, 1AH, 18H, 03H, 16H, 02H
	DB	 0EH, 0DH, nul, nul, nul,+01H,0F2H,+08H
	DB	 ' ', nul,0DEH,0DFH,0E0H,0E1H,0E2H,0E3H
	DB	0E4H,0E5H,0E6H,0E7H,+20H,0C6H,0F7H, nul
	DB	 84H, nul,0F3H, nul,0F4H, nul,0F5H, nul
	DB	0F6H, nul, nul, 0AH



;**********************************************************************
;		  A L T   M O D E   K E Y   T A B L E
;**********************************************************************
ALT_TABLE EQU THIS BYTE
	PUBLIC	ALT_TABLE
	DB	 nul
	DB	 nul,0F8H,0F9H,0FAH,0FBH,0FCH,0FDH,0FEH
	DB	0FFH, 80H, 81H, 82H, 83H, 7FH, nul, 90H
	DB	 91H, 92H, 93H, 94H, 95H, 96H, 97H, 98H
	DB	 99H, nul, nul, 0AH,+04H, 9EH, 9FH,0A0H
	DB	0A1H,0A2H,0A3H,0A4H,0A5H,0A6H, nul, nul
	DB	 nul,+02H, nul,0ACH,0ADH,0AEH,0AFH,0B0H
	DB	0B1H,0B2H, nul, nul, nul,+01H, nul,+08H
	DB	 ' ',+40H,0E8H,0E9H,0EAH,0EBH,0ECH,0EDH
	DB	0EEH,0EFH,0F0H,0F1H,+20H,+10H, 07H, 08H
	DB	 09H, nul, 04H, 05H, 06H, nul, 01H, 02H
	DB	 03H,0FFH, nul, nul



;**********************************************************************
;		       K E Y   T Y P E   T A B L E
;
;	The following table is used to determine how to process each
; key of the matrix.  Each entry represents a single key, and is bit-
; mapped as follows:
;		Bit 7: Extended ALT flag.  Key value in ALT table is
;		       contained in full 8 bits.
;	 	Bit 6: CTRL-override flag.  Used to flag special keys
;		       which change their usage in CTRL mode.
;		Bit 5: SHIFT-override flag.  Used to flag control keys
;		       which become 'normal' keys in shift mode.
;		Bit 4: PAD_TYPE.  Used to flag the keys in the
;		       numeric pad.
;		Bit 3: LOCK_TYPE.  Indicates that the key is a locking
;		       key, as in CAPS LOCK, NUM LOCK, INSERT etc.
;		Bit 2: CTRL_TYPE.  Indicates that a key is a 'control'
;		       key, as in SHIFT, CTRL, or ALT.
;		Bit 1: ALPHA_TYPE.  Set for letters (A-Z).
;		Bit 0: DIGIT_TYPE.  Used to flag digits.
;**********************************************************************
KEY_TYPE EQU THIS BYTE
	PUBLIC	KEY_TYPE
	DB	 00H
	DB	 00H, 00H, 00H, 00H, 00H, 00H, 00H, 00H
	DB	 00H, 80H, 80H, 80H, 80H, 00H, 00H, 02H
	DB	 02H, 02H, 02H, 02H, 02H, 02H, 02H, 02H
	DB	 02H, 00H, 00H, 00H, 04H, 02H, 02H, 02H
	DB	 02H, 02H, 02H, 02H, 02H, 02H, 00H, 00H
	DB	 00H, 04H, 00H, 02H, 02H, 02H, 02H, 02H
	DB	 02H, 02H, 00H, 00H, 00H, 04H, 00H, 04H
	DB	 00H, 48H, 00H, 00H, 00H, 00H, 00H, 00H
	DB	 00H, 00H, 00H, 00H, 48H, 48H, 11H, 11H
	DB	 11H, 10H, 11H, 11H, 11H, 10H, 11H, 11H
	DB	 11H, 39H, 10H, 10H
