page	60,132
Title	Clock Interface for MsDos 2.11
;
;	Copyright 1985
;	Morrow Designs, Inc.
;	San Leandro, Ca.
;	Last Update 23_Apr_85
;
;----------------------------------------------------------------------
; Equates and Sturcture Definitions (22_Apr_85)
;----------------------------------------------
;
; Return Status Masks
;--------------------
;
Done	equ	0000000100000000b	;Operation Complete
Busy	equ	0000001000000000b	;Device is Busy
Error	equ	1000000000000000b	;Error Bit

; Io Data Packet Structure Definition
;------------------------------------
;
Io_Packet	Struc
	CmdLen  db	0		;Length of this Command
	Unit	db	0		;Sub Unit Specifier
	Cmd	db	0		;Command Code
	Status  dw	0		;Status
		dd	0
		dd	0
	Media	db	0		;Media Descriptor
	Trans	dd	0		;Transfer Address Lo Word
	Count	dw	0		;Count of Blocks or Characters
	Start	dw	0		;First Block to Transfer
Io_Packet	EndS

page
;======================================================================
Rtc_Driver Segment Word
;======================
;
Assume	cs:Rtc_Driver, ds:Nothing, es:Nothing, ss:Nothing

;----------------------------------------------------------------------
; Fixed Data Area (22_Apr_85)
;----------------------------
;
Clock_Header Label Far
;---------------------
;
	dd	-1			;Link to Next Field
	dw	1000000000001000b	;Attribute Field (Char_Device, Clock$)
	dw	Strategy		;Strategy Entry
	dw	Interrupt		;Interrupt Entry
	db	'CLOCK$'		;Device Name


Vector_Table Label Word
;----------------------
;
	dw	Command_Init		;0  Initialize
	dw	Command_Error		;1  Media Check
	dw	Command_Error		;2  Build Bpb
	dw	Command_Error		;3  IoCtl Input
	dw	Time_Read		;4  Input
	dw	Device_Busy		;5  NonDestructive Input (no wait)
	dw	Exit			;6  Input Status
	dw	Exit			;7  Input Flush
	dw	Time_Write		;8  Output
	dw	Time_Write		;9  Output (with Verify)
	dw	Exit			;10 Output Status
	dw	Exit			;11 Output Flush
	dw	Command_Error		;12 IoCtl Output
Function_Max equ (($-Vector_Table)/2)-1	;Last Function Number


Month_List Label Word
;--------------------
;
	db	31,28,31,30,31,30	;Normal Year
	db	31,31,30,31,30,31

	db	31,29,31,30,31,30	;Leap Year
	db	31,31,30,31,30,31


PtrSav  dd	0			;Save Location for Io_Packet Pointer

page
;----------------------------------------------------------------------
Strategy Proc Far; (23_Apr_85)
;-----------------------------
;
Assume	cs:Rtc_Driver, ds:Nothing, es:Nothing, ss:Nothing

	mov	Word Ptr cs:[PtrSav+0],bx
	mov	Word Ptr cs:[PtrSav+2],es
	ret				;Return

Strategy	EndP

;----------------------------------------------------------------------
Interrupt Proc Far; (24_Apr_85)
;------------------------------
;
Assume	cs:Rtc_Driver, ds:Nothing, es:Nothing, ss:Nothing

	push	ax
	push	bx
	push	cx
	push	dx
	push	di
	push	si
	push	ds
	push	es
	push	bp
	lds	bx,cs:[PtrSav]		;DS:BX:= Address of Io_Packet
	mov	al,[bx.Cmd]		;AL:= Function Number
	cmp	al,Function_Max		;If (Function Number out of Range)
	jle	IrSk1

	mov	al,Function_Max		;	AL:= Last Function (ret error)
IrSk1:	shl	al,1			;AL:= Word Offset to Function Vector
	mov	ah,0
	mov	si,Offset Vector_Table	;SI:= Base of Function Vector Table
	add	si,ax			;SI:= Pointer to Desired Function
	call	cs:[si]			;Go do Command
	pop	bp
	pop	es
	pop	ds
	pop	si
	pop	di
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret				;Return

Interrupt	EndP

page
;----------------------------------------------------------------------
Exit Proc Near; (22_Apr_85)
;--------------------------
;	1) This operation simply sets The Return Status to Done
;
Assume	cs:Rtc_Driver, ds:Nothing, es:Nothing, ss:Nothing

	mov	[bx.Status],Done	;Return Done Status
	ret				;Return

Exit	EndP

;----------------------------------------------------------------------
Device_Busy Proc Near; (22_Apr_85)
;---------------------------------
;	1) This entry point sets the done and busy bits in the status word.
;
Assume	cs:Rtc_Driver, ds:Nothing, es:Nothing, ss:Nothing

	mov	[bx.Status],Done+Busy	;Return Done and Busy Status
	ret				;Return

Device_Busy	EndP

;----------------------------------------------------------------------
Command_Error Proc Near; (22_Apr_85)
;-----------------------------------
;	1) This entry point sets the done and error bits in the status
;	   entry and sets the error type to Unknown Command.
;
Assume	cs:Rtc_Driver, ds:Nothing, es:Nothing, ss:Nothing

	mov	[bx.Status],Error+Done+3;AH:= Error Return Status
	ret				;Return

Command_Error	EndP

page
;----------------------------------------------------------------------
Time_Write Proc Near; (24_Apr_85)
;--------------------------------
;	1) This routine converts the System's date (given in days since
;	   1_Jan_84) into Current Year, Month and Day. This information is
;	   then passed to the Time_of_Day_Intrrupt routine to set the rtc.
;	2) Entry Register Values:
;		DS -> Segement Base containing the Request Header Block
;		BX -> Offset to the Base of the Request Header Block
;
Assume	cs:Rtc_Driver, ds:Nothing, es:Nothing, ss:Nothing

	push	bx
	les	di,[bx.Trans]		;ES:DI:= Transfer Address
	mov	ax,es:[di]		;AX:= System's Days Since 1 Jan 80

	mov	cx,1980 - 1		;CX:= Beginning Year - 1
	inc	ax			;(Correction for 1/1/80)
Tl1:	inc	cx			;Loop	Next Year
	mov	bx,365			;	BX:= Days in Year
	test	cl,3
	jnz	Tl2			;	If (This is a Leap Year)
	inc	bx			;		Add an Extra Day
Tl2:	sub	ax,bx			;	AX:= Current Year - Days/Year
	jz	T121			; fix to catch last day of year
	jnc	Tl1			;Until (Year Underflows)

T121:	add	ax,bx			;(Restore AX:= Days Since Jan 1)
	call	Get_Month_Ptr		;BX:= Offset to the Month Table

	mov	dh,0			;DH:= Month
Tl3:	inc	dh			;Repeat	DH:= Next Month
	inc	bx			;	BX:= Next Month Table Entry
	sub	al,cs:[bx]
	sbb	ah,0			;	AX:= Days Left - Days this Mo.
	jc	t14
	cmp	ax,0			; if last day of month, fix up
	jnz	Tl3

T14:	add	al,cs:[bx]		;(Restore AL:= Days This Month)
	mov	dl,al			;DL:= Day (DH:= Month, CX:= Year)
	mov	ah,02Bh			;AH:= Set Date Function
	int	1Ah			;Set the Year, Month and Day

	mov	cx,es:[di+2]		;CH:= Hours, CL:= Minutes
	mov	dx,es:[di+4]		;DH:= Seconds, DL:= 1/100's of Seconds
	mov	ah,02Dh			;AH:= Set Time Function
	int	1Ah			;Set the Hour, Minute, Sec, .001 Sec

	pop	bx
	mov	[bx.Count],6		;Transferred 6 bytes
	mov	[bx.Status],Done	;Set the Done Flag
	ret				;Return

Time_Write	EndP

page
;----------------------------------------------------------------------
Time_Read Proc Near; (24_Apr_85)
;-------------------------------
;
Assume	cs:Rtc_Driver, ds:Nothing, es:Nothing, ss:Nothing

	push	bx
Rt0:	les	di,[bx.Trans]		;ES:DI:= Transfer Address

	mov	ah,02Ah			;AH:= Get Date Function
	int	1Ah
	mov	ax,-1			;Get in Days Since 1/1/80
	mov	bx,1980
	jmp	Short Rt3

Rt1:	add	ax,365			;Loop	365 more days
	test	bl,3			;	Leap Year ??
	jnz	Rt2

	inc	ax
Rt2:	inc	bx			;	Next Year
Rt3:	cmp	bx,cx
	jc	Rt1

	call	Get_Month_Ptr
Rt4:	inc	bx			;Loop
	dec	dh			;	January ??
	jz	Rt5			;	Done ??

	add	al,cs:[bx]
	adc	ah,0
	jmp	Rt4

Rt5:	add	al,dl			;add days
	adc	ah,0
	mov	es:[di],ax
	mov	ah,02Ch			;get time
	int	1Ah
	test	al,al			;Day Changed?
	jnz	Rt0

	mov	es:[di+2],cx		;Store Values
	mov	es:[di+4],dx
	pop	bx
	mov	[bx.Count],6		;Transferred 6 bytes
	mov	[bx.Status],Done	;Set the Done Flag
	ret				;Return

Time_Read	EndP

page
;----------------------------------------------------------------------
Get_Month_Ptr Proc Near; (22_Apr_85)
;-----------------------------------
;
Assume	cs:Rtc_Driver, ds:Nothing, es:Nothing, ss:Nothing

	mov	bx,Offset Month_List-1	;add months
	test	cl,3			;Leap Year ??
	jnz	Gm9

	add	bx,12
Gm9:	ret

Get_Month_Ptr	EndP

;----------------------------------------------------------------------
Command_Init Proc Near; (22_Apr_85)
;----------------------------------
;
Assume	cs:Rtc_Driver, ds:Nothing, es:Nothing, ss:Nothing

	mov	Word Ptr [bx.Trans],Offset Command_Init
	mov	Word Ptr [bx.Trans+2],cs
	mov	[bx.Status],Done	;Set the Done Flag
	ret				;Return

Command_Init	EndP


Rtc_Driver	EndS
		End	Clock_Header
