/************************************************************************/
/*									*/
/*	File:								*/
/*		PP7.C	Error message routines.				*/
/*									*/
/*	Name:								*/
/*		PP - A preprocessor, principally for the C language.	*/
/*									*/
/*	Written by:							*/
/*			Gary Oliver					*/
/*			3420 NW Elmwood Dr.				*/
/*			PO Box 826					*/
/*			Corvallis, Oregon 97339				*/
/*			(503)758-5549					*/
/*									*/
/*	This program is hereby placed in the public domain.  This means	*/
/*	you can do anything you want with it including selling it!	*/
/*	As a point of warning however: If you remove my name from the	*/
/*	source code your ancestors may show up to haunt you...		*/
/*									*/
/*	Functions contained within this module:				*/
/*									*/
/*		end_of_file		Fatal for Unexpected EOF.	*/
/*		fatal			Print FATAL diagnostic.		*/
/*		illegal_symbol		Print illegal symbol diagnostic.*/
/*		out_of_memory		Fatal for out of memory.	*/
/*		perr			Print a diagnostic.		*/
/*		pmsg			Print a warning.		*/
/*									*/
/************************************************************************/

#include "pp.h"

/************************************************************************/
/*									*/
/*	end_of_file							*/
/*									*/
/*	Print fatal "Unexpected EOF." message.				*/
/*									*/
/************************************************************************/
end_of_file()
    {
    fatal("Unexpected EOF.");
    }

/************************************************************************/
/*									*/
/*	fatal								*/
/*									*/
/*	Print standard error message to standard output and abort.	*/
/*									*/
/************************************************************************/
fatal(s)
  char *s;
    {
    pmsg("FATAL: %s", s);
    exit(1);
    }

/************************************************************************/
/*									*/
/*	illegal_symbol							*/
/*									*/
/*	Print error message with Token as illegal symbol name.		*/
/*									*/
/************************************************************************/
illegal_symbol()
    {
    perr("Illegal symbol name \"%s\".", Token);
    }

/************************************************************************/
/*									*/
/*	out_of_memory							*/
/*									*/
/*	Print fatal "Out of memory." message.				*/
/*									*/
/************************************************************************/
out_of_memory()
    {
    fatal("Out of memory.");
    }

/************************************************************************/
/*									*/
/*	perr								*/
/*									*/
/*	Print standard error message to standard output and count it.	*/
/*									*/
/************************************************************************/
/*VARARGS1*/
perr(s1, s2, s3)
  char *s1, *s2, *s3;
    {
    pmsg(s1, s2, s3);		/* Print the message */
    Errors++;			/* Count the error */
    }

/************************************************************************/
/*									*/
/*	pmsg								*/
/*									*/
/*	Print message to standard output.				*/
/*									*/
/*	Note:	If the file stack is < 0, then all files have been	*/
/*		popped off the stack.  Use 0 (the original file name.)	*/
/*									*/
/************************************************************************/
/*VARARGS1*/
pmsg(s1, s2, s3)
  char *s1, *s2, *s3;
    {
    printf("\"%s\", %d: ",		/* Un*x "standard" format */
	Filestack[Filelevel >= 0 ? Filelevel : 0]->f_name, Line);
    printf(s1, s2, s3);
    printf("\n");
    }
                                                                 