;
;	KAYMODEM PATCH
;
;		ALLOWS USER TO SPECIFY:
;			baud rate, word length, stop bits, pairity
;			for the Z-80 SIO/DART
;
;	WRITTEN: 03/01/83
;	     BY: Wayne E. Campeau
;	    FOR: Anchor Computer Systems
;
;	USE:	This program is to be patched into the MODEM7 program
;		available frome either the CP/M Users Group or the
;		Special Interest Group (SIG).
;		Some simple changes need to be made for the program to
;		run alone (Remove the REENTRY patch).
;
;-------------------------------------------------------------------------

WBOOT	EQU	0000H		;DEFINE WARM BOOT ADDRESS
BDOS	EQU	0005H		;DEFINE BDOS ENTRY POINT
LOADPT	EQU	0100H		;DEFINE CP/M LOAD POINT
REENTRY	EQU	LOADPT+0036H	;DEFINE PROGRAM RE-ENTRY POINT INTO MODEM7

;-------------------------------------------------------------------------

;	CP/M DOS CALL NUMBERS

CONIN	EQU	1		;DEFINE CONSOLE INPUT CALL
CONOUT	EQU	2		;DEFINE CONSOLE OUTPUT CALL
DIRIO	EQU	6		;DEFINE DIRECT CONSOLE I/O CALL
PMSG	EQU	9		;DEFINE PRINT MESSAGE DOS COMMAND

;--------------------------------------------------------------------------

;	CHARACTER DEFFINITIONS

CNTRL$C	EQU	3		;DEFINE CTRL-C CHAR (^C)
CR	EQU	13		;CARRIAGE RETURN
LF	EQU	10		;LINE FEED
ESC	EQU	27		;ESCAPE CHAR (^[)

;------------------------------------------------------------------------

;	PORT DEFFINITIONS

SIO$CONTROL	EQU	6	;SIO STATUS/COMMAND PORT
BAUD$PORT	EQU	0	;BAUD RATE CONTROLER PORT

;========================================================================

;	BEGINING OF PROGRAM

	ORG	LOADPT		;ORG AT THE START OF THE PROGRAM
	JMP	PATCH		;

;=========================================================================

;	MAIN BODY OF PROGRAM IS BEYOND THE END OF THE MODEM7 PROGRAM

	ORG	LOADPT+2900H	;ORG AT THE END OF THE PROGRAM
				;(DELETE FOR STAND ALONE)

PATCH:				;
	LXI	SP,STACK	;DEFINE OUR OWN TEMP. STACK
	CALL	CLS		;CLEAR THE SCREEN
	CALL	BAUD		;GET THE BAUD RATE
	CALL	CLS		;CLEAR THE SCREEN
	CALL	CONFIG		;GET THE CHANNEL CONFIG
	CALL	PROGRAM		;PROGRAM THE CHANNEL
	CALL	CLS		;CLEAR THE SCREEN
	XRA	A		;CLEAR A.
	JMP	REENTRY		;JUMP BACK INTO THE MODEM7 PROGRAM
				;(CHANGE TO A JMP WBOOT FOR STAND ALONE)

;==========================================================================

;	SUBROUTINES

CLS:	;CLEAR THE SCREEN

	MVI	C,DIRIO		;
	MVI	E,ESC		;LEAD-IN
	CALL	BDOS		;
				;
	MVI	C,DIRIO		;
	MVI	E,'*'		;
	CALL	BDOS		;CLEAR CODE
	RET			;RETURN

;-------------------------------------------------------------------------

BAUD:	CALL	PRINT$BAUD	;PRINT THE BAUD-RATE PROMPT
	MVI	B,6		;SET THE MAX NUMBER OF SELECTIONS
	CALL	GET$SEL		;GET THE USERS SELECTION
	STA	BAUD$RATE	;SET THE BAUD RATE
	RET

CONFIG:
	CALL	BITS$MENU	;
	CALL	STOP$MENU	;
	CALL	PAIRITY$MENU	;
	RET			;

BITS$MENU:
	CALL	PRINT$BITS	;PRINT THE WORD LENGTH PROMPT
	MVI	B,3		;SET THE MAX NUMBER OF SELECTIONS
	CALL	GET$SEL		;GET THE USERS SELECTION
	STA	WORD$LENGTH	;SET THE WORD LENGTH
	RET			;

STOP$MENU:
	CALL	PRINT$STOPS	;PRINT THE STOP BITS PROMPT
	MVI	B,2		;SET THE MAX NUMBER OF SELECTIONS
	CALL	GET$SEL		;GET THE USERS SELECTION
	STA	STOP$BITS	;SET THE STOP BITS
	RET			;

PAIRITY$MENU:
	CALL	PRINT$PAIRITY	;PRINT THE PAIRITY PROMPT
	MVI	B,2		;SET THE MAX NUMBER OF SELECTIONS
	CALL	GET$SEL		;GET THE USERS SELECTION
	STA	PAIRITY		;SET THE PAIRITY
	RET			;


PRINT$BAUD:
	LXI	D,BAUD$MSG
	MVI	C,PMSG
	JMP	BDOS		;PRINT THE BAUD-RATE PROMPT & RETURN

PRINT$BITS:
	LXI	D,BIT$MSG
	MVI	C,PMSG
	JMP	BDOS		;PRINT THE WORD LENGTH PROMPT & RETURN

PRINT$STOPS:
	LXI	D,STOP$MSG
	MVI	C,PMSG
	JMP	BDOS		;PRINT THE STOP-BITS PROMPT & RETURN

PRINT$PAIRITY:
	LXI	D,PAIRITY$MSG
	MVI	C,PMSG
	JMP	BDOS		;PRINT THE PAIRITY PROMPT & RETURN

GET$SEL:
	PUSH	B		;SAVE THE MAX NUMBER OF SELECTIONS

WAIT:
	MVI	C,DIRIO
	MVI	E,0FFH		;SET FOR INPUT
	CALL	BDOS		;
	ORA	A		;CHECK FOR CHAR READY
	JZ	WAIT		;IF NOT READY THEN WAIT

	POP	B		;GET THE MAX VALUE.
	INR	B		;INC THE MAX VALUE.
	ANI	7FH		;STRIP THE PAIRITY BIT.

	CPI	CNTRL$C		;IS IT A BREAK?
	JZ	WBOOT		;YEP, ABORT.

	SBI	'0'		;SUBTRACT ASCII OFFSET OF '0'
	JM	DEFAULT		;IF UNDER-FLOW THE USE DEFAULT (0)
				;ELSE,
	CMP	B		;COMPARE THE CHAR TO IT
	JC	ECHO$SEL	;IF CHAR <= MAX THEN ECHO THE SELECTION & RET
				;ELSE,
DEFAULT:
	XRA	A		;SET A=0
ECHO$SEL:
	PUSH	PSW		;SAVE THE ANSWER
	ADI	'0'		;ADD THE ASCII OFFSET OF '0' TO MAKE CHAR PRINTABLE
	MVI	C,DIRIO		;SET THE BDOS FUNCTION
	MOV	E,A		;PUT THE CHAR IN E.
	CALL	BDOS		;PRINT IT
	POP	PSW		;RESTORE THE CHAR.
	RET			;RETURN

;-------------------------------------------------------------------------

PROGRAM:			;PROGRAM THE I/O CHANNEL
	LDA	BAUD$RATE	;
	LXI	H,BAUD$TBL	;
	CALL	LOOKUP		;
	OUT	BAUD$PORT	;

	MVI	A,18H		;LOAD RESET CODE
	OUT	SIO$CONTROL	;RESET THE SIO CHANNEL
	MVI	A,10H		;LOAD RESET STATUS INTERUPTS CODE
	OUT	SIO$CONTROL	;RESET THEM
				;
	MVI	A,4		;ADDRESS REG. 4
	OUT	SIO$CONTROL	;
	LDA	STOP$BITS	;GET THE NUMBER OF STOP BITS,
	LXI	H,STOPS$TBL	;
	CALL	LOOKUP		;
	MOV	B,A		;SAVE FOR LOGICAL OR..
				;
	LDA	PAIRITY		;GET THE PAIRITY MODE..
	LXI	H,PAIRITY$TBL	;
	CALL	LOOKUP		;
	ORA	B		;OR THE COMMAND WORDS FOR STOP BITS AND
				;PAIRITY MODE TOGETHER.
	OUT	SIO$CONTROL	;NOW SEND THE COMBINED COMMAND WORD.
				;
	MVI	A,3		;ADDRESS REG. 3
	OUT	SIO$CONTROL	;
	LDA	WORD$LENGTH	;LOAD THE Rx WORD LENGTH
	LXI	H,BITS$TBL2	;
	CALL	LOOKUP		;
	OUT	SIO$CONTROL	;
				;
	MVI	A,5		;ADDRESS REG. 5
	OUT	SIO$CONTROL	;
	LDA	WORD$LENGTH	;LOAD THE Tx WORD LENGTH
	LXI	H,BITS$TBL1	;
	CALL	LOOKUP		;
	OUT	SIO$CONTROL	;
				;
	MVI	A,1		;ADDRESS REG. 1
	OUT	SIO$CONTROL	;
	MVI	A,00000010B	;ENABLE Tx.
	OUT	SIO$CONTROL	;
	RET			;

LOOKUP:
	ADD	L
	MOV	L,A
	MVI	A,0
	ADC	H
	MOV	H,A
	MOV	A,M
	RET

;-------------------------------------------------------------------------

BAUD$MSG:
DB '       *** KAYPRO-II  MODEM  PROGRAM ***        VERS. 2.0',	CR,LF
DB								CR,LF
DB '           Anchor Computer Systems',			CR,LF
DB '           323 1st. Ave. So.',				CR,LF
DB '           Seattle, WA    98104',				CR,LF
DB								CR,LF
DB '           (206) 621-9307  Voice',				CR,LF
DB '           (206) 621-8665  Data',				CR,LF
DB								CR,LF
DB '                  0.  300',					CR,LF
DB '                  1.  600',					CR,LF
DB '                  2. 1200',					CR,LF
DB '                  3. 2400',					CR,LF
DB '                  4. 4800',					CR,LF
DB '                  5. 9600',					CR,LF
DB '                  6. 19.2K',				CR,LF
DB								CR,LF
DB '          Choose one of the above BAUD RATES:(0-6)',	CR,LF
DB								CR,LF
DB '          Any other key will set 300 BAUD.',		CR,LF
DB								CR,LF
DB '                  WHAT IS YOUR SELECTION ?'
DB '$'

BIT$MSG:
DB								CR,LF
DB '          Choose one of the following WORD LENGTHS:',	CR,LF
DB								CR,LF
DB '                    0.  8 BITS',				CR,LF
DB '                    1.  7 BITS',				CR,LF
DB '                    2.  6 BITS',				CR,LF
DB '                    3.  5 BITS',				CR,LF
DB								CR,LF
DB '                 WHAT IS YOUR SELECTION?'
DB '$'

STOP$MSG:
DB								CR,LF
DB '         Choose from the following STOP BITS:',		CR,LF
DB								CR,LF
DB '                    0.  1   STOP BIT ',			CR,LF
DB '                    1.  1.5 STOP BITS',			CR,LF
DB '                    2.  2   STOP BITS',			CR,LF
DB								CR,LF
DB '                  WHAT IS YOUR SELECTION?'
DB '$'

PAIRITY$MSG:
DB								CR,LF
DB '        Choose from the following PAIRITY SELECTIONS:',	CR,LF
DB								CR,LF
DB '                    0.  NO   PAIRITY',			CR,LF
DB '                    1.  EVEN PAIRITY',			CR,LF
DB '                    2.  ODD  PAIRITY',			CR,LF
DB								CR,LF
DB '                   WHAT IS YOUR SELECTION?'
DB '$'

;---------------------------------------------------------------------------

;	SIO CONTROL-WORD TABLES

BAUD$TBL:	DB	5,6,7,10,12,14,15
BITS$TBL1:	DB	11101000B,11001000B,10101000B,10001000B	;REG 5
BITS$TBL2:	DB	11000001B,01000001B,10000001B,00000001B	;REG 3
STOPS$TBL:	DB	01000100B,01011000B,01001100B		;REG 4
PAIRITY$TBL:	DB	01000000B,01000011B,01000001B		;REG 4


;	SELECTIONS MADE BY USER

BAUD$RATE:	DB	0	;
WORD$LENGTH:	DB	0	;
STOP$BITS:	DB	0	;
PAIRITY:	DB	0	;

;---------------------------------------------------------------------------

	DS	100H		;RESERVE SOME STACK SPACE
STACK	EQU	$		;SET STACK HERE

	END	LOADPT		;

