	
 

$constant ON  = 1
$constant OFF = 0

$constant CLEAR = 0
$constant BLACK = 1
$constant GREEN = 2
$constant LTGREEN = 3
$constant BLUE = 4
$constant LTBLUE = 5
$constant DKRED = 6
$constant CYAN = 7
$constant RED = 8
$constant LTRED = 9
$constant YELLOW = 10
$constant LTYELLOW = 11
$constant DKGREEN = 12
$constant MAGENTA = 13
$constant GRAY = 14
$constant WHITE = 15
$constant READ_ADDR = 1
$constant WRITE_ADDR = 0
$constant READRAM = 1
$constant WRITERAM = 0

$constant VDPDATA = 30  : REM  VDPDATA = 10 for BigBoard
$constant VDPCNTL = 31  : REM  VDPCNTL = 11 for BigBoard
$constant SYSPORT = 1ch

$constant PGTBASE = 0
$constant SGTBASE = 1800h
$constant PNTBASE = 1c00h
$constant SATBASE = 1f00h
$constant PCTBASE = 2000h

$constant PGTLENGTH = 1800h
$constant SGTLENGTH = 0400h
$constant PNTLENGTH = 0300h
$constant SATLENGTH = 0100h
$constant PCTLENGTH = 1800h

$constant RAMSTART  = 0
$constant RAMLENGTH = 3800h
$constant COLORPORT = 87h
$constant MODEPORT = 81h
$constant KEYPORT = 5
procedure vdpram ( address, mode = integer )
     var read_mask, write_mask = integer
     read_mask = 03fh
     write_mask = 040h
     out VDPCNTL, address
     if ( mode ) then
   out VDPCNTL, (address / 100h) and read_mask
     else
   out VDPCNTL, (address / 100h) or write_mask
end of vdpram
function mod ( x, y = integer ) = integer
end = x - (x / y) * y

procedure plot ( x, y,color = integer ) : REM  bullet-proof version
     var bit, pixaddr,coloradd, i, j = integer
     if (x < 0 or x > 255 or y < 0 or y > 191) then begin
   print "Error: Argument ("; x; ","; y; ") to ";
   print "plot out of range."
     end of if
     else begin
coloradd = pctbase + 8 * ((x / 8) + 32 * (y / 8)) + MOD(y, 8)
vdpram coloradd, WRITERAM
j = mod(y, 8)
j = 8 - j
for i = j to 8
out VDPDATA, color
next i
   bit = 2 ^ (7 - mod(x, 8))
   pixaddr = PGTBASE + 8 * (x / 8 + 32 * (y / 8)) + mod(y, 8)
   vdpram pixaddr, READRAM
   x = inp( VDPDATA )
   x = x or bit
 vdpram pixaddr, WRITERAM 
 out VDPDATA, x
     end of else
end of plot
procedure horline(x, y, h, v,color = integer)
     var xbar, ybar, i = integer

     xbar = (x + h + 1) / 2
     ybar = (y + v + 1) / 2
     for i = x to xbar
   plot i, ((v - y) * (i - x)) / (h - x) + y,color
     next
     for i = xbar to h
   plot i, ((v - ybar) * (i - xbar)) / (h - xbar) + ybar,color
     next
end of horline
 


procedure vertline(x, y, h, v, color = integer)
     var xbar, ybar, i = integer

     xbar = (x + h + 1) / 2
     ybar = (y + v + 1) / 2
     for i = y to ybar
   plot x + ((h - x) * (i - y)) / (v - y), i,color
     next
     for i = ybar to v
   plot xbar + ((h - xbar) * (i - ybar)) / (v - ybar), i,color
     next
end of vertline



procedure line ( x, y, h, v, color = integer )
     if (x = h and y = v) then
   plot x, y, color
     else begin
   if (abs(y - v) < abs(h - x)) then begin
        if (x < h) then
      horline x, y, h, v, color
        else
      horline h, v, x, y, color
   end
   else begin
        if (y < v) then
      vertline x, y, h, v, color
        else
      vertline h, v, x, y, color
   end
     end
end of line

dim char a(10)

procedure graphinit
     var i = integer
     REM -- BigBoarders should include the
     REM -- graphics ON     statement here

     a[0] = 002h
     a[1] = 0c2h
     a[2] = 007h
     a[3] = 0ffh
     a[4] = 003h
     a[5] = 03eh
     a[6] = 003h
     a[7] = 000h

     for i = 0 to 7
   out VDPCNTL, a[i]
   out VDPCNTL, 80h + i
     next

end of graphinit



procedure graphclear
     var i = integer
     vdpram RAMSTART, WRITE_ADDR
     for i = 1 to RAMLENGTH
   out VDPDATA, 0
     next
end of graphclear
procedure clearpnt
 var i = integer
     vdpram PNTBASE, WRITE_ADDR
     for i = 0 to PNTLENGTH - 1
   out VDPDATA, i
     next
end of clearpnt
var yes = char
VAR p1,p2,p3,p4,p5,p6,p7,p8=integer 
files r(128)
open #0;"TEXT.OUT"
var srecord,record =integer
input "Is this a COLD start",yes
if yes = "Y" then graphinit rem WAKE-UP memory
0start record = 10 
print chr(26)
print chr$(27);chr$(61);chr$(44);chr$(72)
print "                            L O A D I N G  M E M O R Y ! !"
var dis = integer 
dis = 0
srecord = record
out vdpcntl, 082h
out vdpcntl, 081h
graphclear  rem set memory to zeroes
clearpnt
var fcolor = integer
out vdpcntl, BLUE
out vdpcntl, colorport
var i = integer
fcolor = white * 10h + black
vdpram pctbase, write_addr
for i = 1 to pctlength
out vdpdata, fcolor
next i
out vdpcntl, 0c2h
out vdpcntl, 081h
var r = real
var x0,y0 = integer
print chr(26)
input "Radius of Shape",r
input "Y Coordinates",y0
input "X Coordinates",x0
var ans = char
GOTO 0start2
var title = string:32
0resrt input "Title of Chart--not to exceed 32 chracters",title
gosub 0title
0resrt input "Do you wish to start again?",ans
if ans = "Y" then goto 0start
close #0 
print "File Closed"
end
0start2 var f1,f2 = real
f1=6.283 rem 2 pi
f2=.06283 rem 2 pi / 100
var th,tx,xn,yn=real
var x,y=fixed
var x1,y1=real       
var vx,vy=real     
var pt = STRING 
var ptx=INTEGER 
var n1=integer
var ni= integer
var ex = char 
x1=x0+r 
y1=y0
var tp=integer 
tx=0  
tp=0
input "# of slices",ni
for n1 = 1 to ni
0retry input "input %",pt
tp=tp+pt
if tp > 100 THEN goto 0try
input "explode ??",ex 
IF ex = "Y" then gosub 4000
if ex = "Y" then gosub 3000
if ex # "Y" then gosub 1000
var sx,sy = integer
th=tp * f2
x = x0 + r * cos(th)
y = y0 - r * sin(th)
fcolor = white * 10h + black 
line x0,y0,x,y,fcolor
gosub 0text
gosub 0label
next n1
goto 0resrt
0try tp=tp-pt 
print "% to high retry"   
goto 0retry
1000 var f1x,tp2=real
tp2=tp / 100
f1x = f1 * tp2
th =tx
repeat
begin
xn = x0 + r * cos(th)  
yn = y0 - r * sin(th)  
line x1,y1,xn,yn,fcolor  
x1=xn  
y1=yn
th = th + f2
end
until th > f1x
th = th - f2
tx = th
return
4000 var rd =real      
rd = 10      
th = (tp - (pt / 2)) * f2        
vx = x0 + rd * cos(th)
vy = y0 - rd * sin(th)
th = (tp - pt) * f2 
gosub 8000
x1=x
y1=y
th = tp * f2
gosub 8000
return
3000 rem complete the arc
var f2x = real        
tp2 = tp / 100
f1x = f1 * tp2
f2x = f2 * tp2
FOR th = tx to f1x step f2x
xn = vx + r * cos(th)
yn = vy - r  * sin(th)
line x1,y1,xn,yn,fcolor
X1=xn
y1=yn
next th   
x1 = x0 + r * cos(th) 
y1 = y0 - r * sin(th)
tx=th
return
8000
x = vx + r * cos(th)
y = vy - r * sin(th)
line vx,vy,x,y,fcolor
return
0text
var tcoloraddr,tcolor,trd,textaddr=integer
ptx =pt
record =srecord
tcolor = yellow * 10h + black
trd = r - 9        
if ex = "Y" then trd = trd + rd
th = (tp - (pt / 2)) * f2
record = record + 1   
x = x0 + trd * cos(th)
y = y0 - trd * sin(th)
gosub 0read
gosub 0txtaddr
gosub 0textr 
srecord =record
return
0label 
tcolor = green * 10h + black
var record2,num=integer 
dis = dis + 32
num = left$(pt,1)
textaddr = pgtbase + 8 * (282 + dis)
tcoloraddr = textaddr + 2000h
gosub 0textr
record = 38
gosub 0read
textaddr = pgtbase + 8 * (283 + dis)
tcoloraddr = textaddr + 2000h
gosub 0textr
record = num + 1
if ptX < 10 then goto 0rcd
gosub 0read
textaddr = pgtbase + 8 * (284 + dis) 
tcoloraddr = textaddr + 2000h
gosub 0textr
0rcd if ptx > 09 then num = right$(pt,1)
record = num + 1
gosub 0read
textaddr = pgtbase + 8 * (285 + dis)
tcoloraddr = textaddr + 2000h
gosub 0textr
textaddr = pgtbase + 8 * (286 + dis)
tcoloraddr = textaddr + 2000h
record = 37
gosub 0read
GOSUB 0textr
return
0textr 
vdpram tcoloraddr, writeram
for i = 0 to 7
out vdpdata, tcolor
next i
vdpram textaddr, writeram
out vdpdata,p1
out vdpdata,p2
out vdpdata,p3
out vdpdata,p4
out vdpdata,p5
out vdpdata,p6
out vdpdata,p7
out vdpdata,p8
return
0read if record2 = record then goto 0nxtr
0read read #0,record;p1,p2,p3,p4,p5,p6,p7,p8
0nxtr record2 = record 
return
0txtaddr
textaddr = pgtbase + 8 * (x / 8 + 32 * (y / 8))
tcoloraddr = pctbase + 8 * (x / 8 + 32 * (y /8))
return
0title
var tnum =integer
var file = string
file = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ%=abcdefghijklmnopqrstuvwxyz$()<>?#+"
TNUM = len(title)
var  strpos = integer
strpos = 48 - (tnum  / 2)  rem center title
var loop1 = integer
tcolor = WHITE * 10h + black
for loop1 = 1 to tnum
textaddr = pgtbase + 8 * (strpos + loop1)
tcoloraddr = textaddr + 2000h
var letter = string:1
letter = MID$(title,loop1,1)
record =instr(1,file,letter)
if record = 0 then gosub 0space
else gosub 0read
gosub 0textr
next loop1
return
0space
p1 = 00h
p2=00h
p3=00h
p4=00h
p5=00h
p6=00h
p7=00h
p8=00h 
return

