/*  VDP Pacman   game initiallization routines    */
/*      29 December 1983    Version 2.1 DLB       */

#define EXTERN extern

#include "stdio.h"
#include "pacdefs.h"

extern int pacloc[], mnstloc[];

#ifdef BIGBOARD
#define CLREOS 17
#else
#define CLREOS 23
#endif


init()
{
    register i;

    score = 0;
    pacptr = &monst[0];
    goldcnt = GOLDCNT;
    newman = FIRSTMAN;
    delay = 62 * ticks;
   
    strcpy(initbrd[0], "################################");
    strcpy(initbrd[1], "################################");
    strcpy(initbrd[2], "################################");
    strcpy(initbrd[3], "##..............#..............#");
    strcpy(initbrd[4], "##.####.#######.#.#######.####.#");
    strcpy(initbrd[5], "##%####.#######.#.#######.####%#");
    strcpy(initbrd[6], "##.............................#");
    strcpy(initbrd[7], "##.####.##.###########.##.####.#");
    strcpy(initbrd[8], "##......##......#......##......#");
    strcpy(initbrd[9], "#######.#######.#.#######.######");
    strcpy(initbrd[10],"#######.##.............##.######");
    strcpy(initbrd[11],"#######.##.###########.##.######");
    strcpy(initbrd[12],"       ....#         #....      ");
    strcpy(initbrd[13],"#######.##.###########.##.######");
    strcpy(initbrd[14],"#######.##.............##.######");
    strcpy(initbrd[15],"#######.##.###########.##.######");
    strcpy(initbrd[16],"##..............#..............#");
    strcpy(initbrd[17],"##.####.#######.#.#######.####.#");
    strcpy(initbrd[18],"##%...#......... .........#...%#");
    strcpy(initbrd[19],"#####.#.##.###########.##.#.####");
    strcpy(initbrd[20],"##......##......#......##......#");
    strcpy(initbrd[21],"##.############.#.############.#");
    strcpy(initbrd[22],"##.............................#");
    strcpy(initbrd[23],"################################");


    strcpy(board[0], "################################");
    strcpy(board[1], "################################");
    strcpy(board[2], "################################");
    strcpy(board[3], "##..............#..............#");
    strcpy(board[4], "##.####.#######.#.#######.####.#");
    strcpy(board[5], "##%####.#######.#.#######.####%#");
    strcpy(board[6], "##.............................#");
    strcpy(board[7], "##.####.##.###########.##.####.#");
    strcpy(board[8], "##......##......#......##......#");
    strcpy(board[9], "#######.#######.#.#######.######");
    strcpy(board[10],"#######.##.............##.######");
    strcpy(board[11],"#######.##.###########.##.######");
    strcpy(board[12],"       ....#         #....      ");
    strcpy(board[13],"#######.##.###########.##.######");
    strcpy(board[14],"#######.##.............##.######");
    strcpy(board[15],"#######.##.###########.##.######");
    strcpy(board[16],"##..............#..............#");
    strcpy(board[17],"##.####.#######.#.#######.####.#");
    strcpy(board[18],"##%...#......... .........#...%#");
    strcpy(board[19],"#####.#.##.###########.##.#.####");
    strcpy(board[20],"##......##......#......##......#");
    strcpy(board[21],"##.############.#.############.#");
    strcpy(board[22],"##.............................#");
    strcpy(board[23],"################################");

    
    for(mcnt = 0; mcnt < MAXMONSTER + 1; mcnt++)	{
	vdpram((SATBASE + 3) + (4 * mcnt), WRITE);
	out(VDPDATA, CLEAR);
    }
    for(i = 0; i < MAXMONSTER - 1; i++)
	pntmap(mnstloc[i], BLANK);
    for(i = 0; i < (MAXPAC - 1); i++)
	pntmap(pacloc[i], BLANK);
    goldinit();
    update();
    printf("%c%c%c%c%cHigh score to date: %u%c\nBy %s.", 
			    27, '=', 47, 32, CLREOS, hscore, '0', winner);
    srand();
}


#define CLRSCRN 26

instruct()
{
    putchar(CLRSCRN);
    printf("\n\t\t\t  P A C M A N\n\n\t\tVersion 2.1\t12/29/83 DLB");

#ifndef JOYSTICK

    printf("\n\n\tEnter key for LEFT :");
    left = keyset();
    printf("\n\t\t\tRIGHT :");
    right = keyset();
    printf("\n\t\t\tUP :");
    up = keyset();
    printf("\n\t\t\tDOWN :");
    down = keyset();

#endif

    printf("\n\n\tEnter key for QUIT :");
    quit = keyset();
    printf("\n\t\t\tSUSPEND :");
    suspend = keyset();
    setlevel();
}

setlevel()
{
    printf("%c%c%c%c%cDifficulty Level (0 - 9) :", 27, '=', 45, 32, CLREOS);
    ticks = 57 - keyset();
    ticks &= 0x0f;
}


keyset()
{
    int keyhit;

    while(!(keyhit = keyboard()))
	;
    putchar(' ');
    if(keyhit < 32)	{
	putchar('^');
	putchar(keyhit + 0x40);
    }
    else putchar(toupper(keyhit));
    return toupper(in(KBDPORT) ^ KEYMASK);
}


static int goldy[18] = {179, 178, 115, 114, 51, 50,
		 173, 172, 171, 170, 169, 168, 45, 44, 43, 42, 41, 40};


reinit()

{

    register locx, locy;
    int i, tmp, color;



    for(locy = 0; locy < BRDY; locy++)

	for(locx = 0; locx < BRDX; locx++)
	    board[locy][locx] = initbrd[locy][locx];

    treasval = 0;
    killscore = KILLSCORE;
    goldcnt = GOLDCNT;
    potion = FALSE;
    dieflag = FALSE;

    delay -= (delay / 5);

    for(mcnt = 0; mcnt < MAXMONSTER + 1; mcnt++)	{
	vdpram((SATBASE + 3) + (4 * mcnt), WRITE);
	out(VDPDATA, CLEAR);
    }
    for(i = 0; i < 18; i++)
	pixcolor(0, goldy[i], BLACK, BLACK);

    goldinit();
    color = LTYELLOW;
    for(tmp = 0; tmp < 5; tmp++)	{
	sleep(25);
	for(i = 0; i < 6; i++)
	    pixcolor(0, goldy[i], color, BLACK);
	color = (color == LTYELLOW) ? BLACK : LTYELLOW;
    }
    for(i = 6; i < 18; i++)
	pixcolor(0, goldy[i], WHITE, BLACK);
    sleep(80);
}



pixcolor(x, y, color1, color0)	
int color1, color0;
unsigned x, y;
{
    unsigned pixaddr;
    
    color0 += (color1 *= 0x10);
    y = 191 - y;
    pixaddr = 8 * (32 * (y / 8) + x / 8) + y % 8 + 0x2000;
    vdpram(pixaddr, WRITE);
    out(VDPDATA, color0);
}


int goldarray[GOLDCNT] = {
    98, 99,100,101,102,103,104,105,106,107,108,109,110,111,113,114,115,116,
    117,118,119,120,121,122,123,124,125,126,130,135,143,145,153,158,167,175,
    177,185,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,
    210,211,212,213,214,215,216,217,218,219,220,221,222,226,231,234,246,249,
    254,258,259,260,261,262,263,266,267,268,269,270,271,273,274,275,276,277,
    278,281,282,283,284,285,286,295,303,305,313,327,330,331,332,333,334,335,
    336,337,338,339,340,341,342,345,359,362,374,377,391,392,393,394,406,407,
    408,409,423,426,438,441,455,458,459,460,461,462,463,464,465,466,467,468,
    469,470,473,487,490,502,505,514,515,516,517,518,519,520,521,522,523,524,
    525,526,527,529,530,531,532,533,534,535,536,537,538,539,540,541,542,546,
    551,559,561,569,574,579,580,581,583,584,585,586,587,588,589,590,591,593,
    594,595,596,597,598,599,600,601,603,604,605,613,615,618,630,633,635,642,
    643,644,645,646,647,650,651,652,653,654,655,657,658,659,660,661,662,665,
    666,667,668,669,670,674,687,689,702,706,707,708,709,710,711,712,713,714,
    715,716,717,718,719,720,721,722,723,724,725,726,727,728,729,730,731,732,
    733,734};

int potionarray[] = {162, 190, 578, 606};

#define GOLDLOC	(char)32
#define PTLOC	(char)64


goldinit()
{
    register i;
    for(i = 0; i < GOLDCNT; i++)	{
	vdpram(PNTBASE + goldarray[i], WRITE);
	out(VDPDATA, GOLDLOC);
    }
    for(i = 0; i < 4; i++)		{
	vdpram(PNTBASE + potionarray[i], WRITE);
	out(VDPDATA, PTLOC);
    }
}
