/* copyright (c) 1982	Peter Baker */

/* dump - dump an object (binary) file in hex, optionally preceded by an
          address.
   format:	dump [-an -b -c -gn -wn] fname [options] [fname] ...
   	where:	-an selects an address preceding each line of hex starting at n
			-b clear bit7 on ascii dump but not on hex
			-c dump characters (ascii) at the end of each line
			-gn groups the hex every n bytes. (default = 4)
			-wn sets the width to n bytes per line
			n is some decimal number
*/

#include <stdio.h>

#define MAXWIDTH	100	/* maximum number of bytes on a line */

unsigned staddr;		/* starting address */
int aflag = 0;			/* 0 if no addresses, 1 if addresses req'd */
int b7flag = 0;			/* 0 if leave bit 7 alone on display */
int cflag = 0;			/* 0 if no ascii chars, 1 if req'd */
int gcnt = 0;			/* 0 for no group count, > 0 for spec'd grouping */
int width = 32;			/* default of 32 bytes per line */

main( argc, argv )
int argc;
char **argv;
{
	static FILE fd;
	static int curarg;			/* current argument count */
	
	curarg = 1;			/* start with 1st actual arg */
	while( --argc > 0 )
	{
		while( *argv[curarg] == '-' )
		{
			switch( *(argv[curarg]+1) )
			{
				case 'A':
				case 'a':	aflag++;
							staddr = atoi( argv[curarg]+2 );
							break;
				case 'B':
				case 'b':	b7flag++;
							break;
				case 'C':
				case 'c':	cflag++;
							break;
				case 'G':
				case 'g':	gcnt = atoi( argv[curarg]+2 );
							break;
				case 'W':
				case 'w':	width = atoi( argv[curarg]+2 );
							if( width > MAXWIDTH )
							{
								printf( "\nmaximum width = %d\n", MAXWIDTH );
								width = 32;
							}
							break;
				default:	usage();
			}
			curarg++;
			argc--;
		}
		if( argc < 1 )
		{
			usage();		/* no filename for the argument */
		}
		if( ( fd = fopen( argv[curarg], "rb" ) ) != NULL )
		{
			dump( fd );
			fclose( fd );
		}
		else
		{
			printf( "\ndump cannot open %s\n", argv[curarg] );
		}
		curarg++;
	}
}

dump( fd )
register FILE fd;
{
	static char byte, bytstr[MAXWIDTH+1];
	static int pos;			/* current position in byte string */
	static unsigned addr;

	addr = staddr;
	pos = 0;
	putchar( '\n' );
	if( aflag )
		putaddr( addr );
	while( ( byte = getc( fd ) ) != EOF )
	{
		if( gcnt && ( ( pos % gcnt ) == 0 ) )
		{
			if( pos > 0 )			/* don't do it at the beginning of line */
			{
				putchar( ' ' );		/* a space is a reasonable separator */
			}
		}
		bytstr[pos++] = printable( byte );
		printf( "%2x", byte & 0xff );
		if( pos == width )
		{
			if( cflag )
			{
				bytstr[pos] = '\0';		/* terminate the string */
				printf( "  %s", bytstr );
			}
			pos = 0;
			putchar( '\n' );
			if( aflag )
				putaddr( addr );
		}
		addr++;
	}
	if( cflag && ( pos > 0 ) )
	{
		bytstr[pos] = '\0';
		printf( "\t%s", bytstr );
	}
	putchar( '\n' );
}

putaddr( hexad )
unsigned hexad;
{
		printf( "%4x: ", hexad );
}

usage()
{
	printf( "\nUsage: dump [-an -b -c -gn -wm] fname [options] [fname] ..." );
	printf( "\n       where: -an selects addresses preceding each line" );
	printf( " starting at n" );
	printf( "\n              -b  reset bit 7 on character dump" );
	printf( "\n              -c  character dump at end of each hex line" );
	printf( "\n              -gn groups the hex every n bytes" );
	printf( "\n              -wn set the width to n bytes per line" );
	printf( "\n              n is a decimal in any of the above" );
	putchar( '\n' );
	exit( 1 );
}

/* isprint - is the character a printable character. */
isprint( c )
char c;
{
	return ( ( c >= ' ' ) && ( c <= '~' ) ) ? true : false;
}

/* convert c to a printable character, reset bit 7 if req'd */
printable( c )
char c;
{
	if( b7flag )
	{
		c &= 0x7f;		/* clear bit7 */
	}
	return ( isprint( c ) ) ? c : '.';
}
tf( "\t%s", bytstr );
	}
	putchar( '\n' );
}

putaddr( hexad )
unsigned hexad;
