/* copyright (c) 1982	Peter Baker */

/*
 * Truncate lines at the specified column.  Default = 80.
 */

#include <stdio.h>

#define NEWLINE '\n'
#define TAB '\t'

static int TABSIZE = 8;

main(argc,argv)
char **argv;
int argc;
{
	int len, i, col;
	char c;
	len=80;
	if(argc>1)
	{
		i=atoi(argv[1]);
		if( i < 0 )
			i = -i;
		len = ( i<1 ? 1 : i );
	}
	col = 1;
	while( (c = getchar()) != EOF )
	{
		if( col <= len )
			putchar(c);
		else
			if( c == NEWLINE )
				putchar(c);
		switch (c)
		{
			case TAB : 		col = nexttab( col ); 	break;
			case NEWLINE:	col = 1;				break;
			default : col++;
		}
	}
}

nexttab( col )
int col;
{
	int i;

	i = (col-1) % TABSIZE;
	if( i == 0 )
		return col + TABSIZE;
	else
		return (TABSIZE-1) + col;
}
                                                                                                     