; "8080 FIG-FORTH FOR THE KAYPRO II" 	LIST	DBG 
; FROM FIG-FORTH RELEASE 1.1 
; THIS PUBLIC DOMAIN SOFTWARE IS PROVIDED THROUGH THE COURTESY OF THE
; FORTH INTEREST GROUP, P.O. BOX 1105, SAN CARLOS CA 94070.
; FURTHER DISTRIBUTION MUST INCLUDE THIS NOTICE.
;
; ALL OTHER CODE IS THE FAULT OF :
;
;	Bob Bumala
;	955 N. California
;	Palo Alto, California 94303
;
;		* and *
;
;	Kevin Appert
;	( address $+123SO )
;
;
FIGREL	EQU	1	; FIG RELEASE #
FIGREV	EQU	1	; FIG REV LEV
USRVER	EQU	6	; USER VERSION NUMBER
;
; USERVER 1 - FIRST OK 
; USERVER 2 - FIXED SOME BUGS
; USERVER 3 - 
; USERVER 4 - ADDED TWO DISK CAPABILITY
; USERVER 5 - ADDED VECTORED EXICUTION OF EMIT AND KEY
; USERVER 6 - REMOVED OPEN AND CLOSE
;
;
;		CP/M 
;
OPENF	EQU	000FH	; OPEN FILE
CLOSF	EQU	0010H	; CLOSE FILE
MAKEF	EQU	0016H	; MAKE FILE
RESDSK	EQU	000CH	; RESET DISK SYSTEM
NIOS	EQU	0005H	; FDOS
;
;		ASCII SPECIAL CHARACTORS
;
ABL	EQU	20H	; SPACE
ACR	EQU	0DH	; CARRIAGE RETURN
ADOT	EQU	02EH	; PERIOD
BELL	EQU	07H	; (^G)
BSIN	EQU	07FH	; BACKSPACE (RUBOUT)
BSOUT	EQU	08H	; BACKSPACE (^H)
DLE	EQU	10H	; (^P)
LF	EQU	0AH	; LINE FEED
FF	EQU	0CH	; FORM FEED (^L)
;
;		MEMORY ALLOCATION
;
NSCR	EQU	8	; NUMBER OF 1024 DB SCREENS AVAILABLE
KBBUF 	EQU	1024 	; DATA BYTES PER DISK BUFFER
US	EQU	40H	; USER VARIABLE SPACE
RTS	EQU	0A0H	; RETURN STACK AND TERM BUFF SPACE
;
EM	EQU	0B000H	; TOP OF MEMORY +1
CO	EQU	KBBUF+4	; DISK BUFFER + 2 HEADER + 2 TAIL
NBUF	EQU	NSCR*400H/KBBUF ; NUMBER OF BUFFERS 
BUF1	EQU	EM-CO*NBUF	; ADDR FIRST DISK BUFFER
INITRO	EQU	BUF1-US		; (RO)
INITSO	EQU	INITRO-RTS	; (SO)
	 
;
;
	ORG	100H
ORIG	NOP
	JMP	CLD	; COLD START
	NOP
	JMP 	WRM	; WARM START
	DB	FIGREL
	DB	FIGREV
	DB 	USRVER
	DB	0EH	; IMPLEMENTATION ATTRIBUTES
	DW	TASK-7 	; TOPMOST DW IN FORTH VOCABULARY
	DW	BSIN	
	DW	INITRO
;
;--------------FOLLOWING USED BY COLD---------------------
; (MUST BE IN SAME ORDER AS USER VARIABLES)
	DW	INITSO
	DW	INITRO
	DW	INITSO
	DW	20H	; INIT WIDTH
	DW	01H	; INIT WARNING
	DW 	INITDP	; INIT FENCE
	DW	INITDP	; INIT DP
	DW	FORTH+6 ; INIT VOC-LINK
	DW	PEMIT	; EMIT VECTOR
	DW	PKEY	; KEY VECTOR
;
;--------------END OF DATA USED BY COLD--------------------
;
	DW	5H,0B320H	;	PROCESSOR IN RAD-36,32 BIT
;
;--------------FORTH REGISTERS ----------------------------
;
UP	DW	INITRO	; USER AREA POINTER
RPP	DW	INITRO 	; RETURN STACK POINTER
;
;
	 
;
;-------------DEBUG SUPPORT--------------------------------
;
BIP	DW	0	; BREAKPOINT ON IP VALUE
;
TNEXT	LXI	H,BIP
	MOV	A,M
	CMP 	C
	JNZ	TNEXT1
	INX	H
	MOV	A,M
	CMP	B
	JNZ	TNEXT1
BREAK	NOP
	NOP
	NOP
TNEXT1	LDAX	B
	INX	B
	MOV	L,A
	JMP	NEXT+3
;
;----------THE EVERPOPULAR --NEXT-- THE FORTH ADDRESS INTERPRETER
;          ( POST INCREMENTING VERSION )
;
DPUSH	PUSH	D
HPUSH	PUSH	H
NEXT	LDAX	B
	INX	B
	MOV	L,A
	LDAX	B
	INX	B
	MOV	H,A
NEXT1	MOV	E,M	;  WAS NEXT1: IN FIG LISTING
	INX	H
	MOV	D,M
	XCHG
	PCHL
;
	 
;
;
;******************************************************************************
;******************************************************************************
;***			THE FORTH DICTIONARY				*******
;******************************************************************************
;******************************************************************************
;
;
DP0:	DB	83H	;LIT
	DB 	'LI'
	DB	'T'+80H
	DW	0	; LFA = 0 IS END OF DICTIONARY
LIT 	DW	$+2
	LDAX	B
	INX	B
	MOV	L,A
	LDAX	B
	INX	B
	MOV	H,A
	JMP	HPUSH
;
	DB	87H	;EXECUTE
	DB	'EXECUT'
	DB	'E'+80H
	DW	LIT-6
EXEC	DW	$+2
	POP	H
	JMP	NEXT1
;
	DB	86H	;BRANCH
	DB	'BRANC'
	DB	'H'+80H
	DW	EXEC-0AH
BRAN	DW	$+2	
BRAN1	MOV	H,B
	MOV	L,C
	MOV	E,M
	INX	H
	MOV	D,M
	DCX	H
	DAD	D
	MOV	C,L
	MOV	B,H
	JMP	NEXT
;
	DB	87H	;0BRANCH
	DB	'0BRANC'
	DB	'H'+80H
	DW	BRAN-9
ZBRAN	DW	$+2
	POP	H
	MOV	A,L
	ORA	H
	JZ	BRAN1
	INX	B
	INX	B
	JMP NEXT
;
	DB	86H	;LOOP
	DB	'(LOOP'
	DB	')'+80H
	DW	ZBRAN-0AH
XLOOP	DW	$+2
	LXI	D,1
XLOO1	LHLD	RPP
	MOV	A,M
	ADD	E
	MOV	M,A
	MOV	E,A
	INX	H
	MOV	A,M
	ADC	D
	MOV	M,A
	INX	H
	INR	D
	DCR	D
	MOV	D,A
	JM	XLOO2
	MOV	A,E
	SUB	M
	MOV	A,D
	INX	H
	SBB	M
	JMP	XLOO3
XLOO2	MOV	A,M
	SUB	E
	INX	H
	MOV	A,M
	SBB	D
;
XLOO3	JM	BRAN1
	INX	H
	SHLD	RPP
	INX	B
	INX	B
	JMP	NEXT
;
	DB	87H	;(+LOOP)
	DB	'(+LOOP'
	DB	')'+80H
	DW	XLOOP-9
XPLOO	DW	$+2
	POP	D
	JMP	XLOO1
;
	DB	84H	;(DO)
	DB	'(DO'
	DB	')'+80H
	DW	XPLOO-0AH
XDO	DW	$+2
	LHLD	RPP
	DCX	H
	DCX	H
	DCX	H
	DCX	H
	SHLD	RPP
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
	POP	D
	INX	H
	MOV	M,E
	INX	H
	MOV	M,D
	JMP	NEXT
	DB	81H	; I
	DB	'I'+80H
	DW	XDO-7
IDO	DW	$+2
	LHLD	RPP
	MOV	E,M
	INX	H
	MOV	D,M
	PUSH	D
	JMP	NEXT
;
	DB	85H	; DIGIT
	DB	'DIGI'
	DB	'T'+80H
	DW	IDO-4
DIGIT	DW	$+2
	POP	H
;
	POP	D
	MOV	A,E
	SUI	30H
	JM	DIGI2
	CPI	0AH
	JM	DIGI1
	SUI	7
	CPI	0AH
	JM	DIGI2
;
DIGI1	CMP	L
	JP	DIGI2
	MOV	E,A
	LXI	H,1
	JMP	DPUSH
;
DIGI2	MOV	L,H
	JMP	HPUSH
;
	DB	86H	; (FIND)
	DB	'(FIND'
	DB	')'+80H
	DW	DIGIT-8
PFIND	DW	$+2
	POP	D
PFIN1	POP	H
	PUSH	H
	LDAX	D
	XRA	M
	ANI	3FH
	JNZ	PFIN4
;
PFIN2	INX	H
	INX	D
	LDAX	D
	XRA	M
	ADD	A
	JNZ	PFIN3
	JNC	PFIN2
	LXI	H,5
	DAD	D
	XTHL
;
PFIN6	DCX	D
	LDAX	D
	ORA	A
	JP	PFIN6
	MOV	E,A
	MVI	D,0
	LXI	H,1
	JMP	DPUSH
;ABOVE NF NOT A MATCH, TRY ANOTHER
PFIN3	JC	PFIN5
PFIN4	INX	D
	LDAX	D
	ORA	A
	JP	PFIN4
PFIN5	INX	D
	XCHG
	MOV	E,M
	INX	H
	MOV	D,M
	MOV	A,D
	ORA	E
	JNZ	PFIN1
;
	POP	H
	LXI	H,0
	JMP	HPUSH
;
	DB	87H	; ENCLOSE
	DB	'ENCLOS'
	DB	'E'+80H
	DW	PFIND-9
ENCL	DW	$+2
	POP	D
	POP	H
	PUSH	H
	MOV	A,E
	MOV	D,A
	MVI	E,0FFH
	DCX	H
;
ENCL1	INX	H
	INR	E
	CMP	M
	JZ	ENCL1
;
	MVI	D,0
	PUSH	D
	MOV	D,A
	MOV	A,M
	ANA	A
	JNZ	ENCL2
	MVI	D,0
	INR	E
	PUSH	D
	DCR	E
	PUSH	D
	JMP	NEXT
;
;
ENCL2	MOV	A,D
	INX	H
	INR	E
	CMP	M
	JZ	ENCL4
	MOV	A,M
	ANA	A
	JNZ	ENCL2
;
ENCL3	MVI	D,0
	PUSH	D
	PUSH	D
	JMP	NEXT
;
ENCL4	MVI	D,0
;
	PUSH	D
	INR	E
;
	PUSH	D
	JMP	NEXT
;
	DB	84H	;EMIT
	DB	'EMI'
	DB	'T'+80H
	DW	ENCL-0AH
EMIT	DW	DOCOL
	DW	TEMIT
	DW	AT
	DW	EXEC
	DW	ONE,OUTT
	DW	PSTOR,SEMIS
;
	DB	83H	; KEY
	DB	'KE'
	DB	'Y'+80H
	DW	EMIT-7
KEY	DW	DOCOL
	DW 	TKEY
	DW	AT
	DW	EXEC
	DW 	SEMIS
;
	DB	89H	; ?TERMINAL
	DB	'?TERMINA'
	DB	'L'+80H
	DW 	KEY-6
QTERM	DW	$+2
	LXI	H,0
	JMP	PQTER
;
	DB	82H	;CR
	DB	'C'
	DB	'R'+80H
	DW	QTERM-0CH
CR	DW	DOCOL
	DW 	LIT,13
	DW	EMIT
	DW	LIT,10
	DW	EMIT
	DW	SEMIS
;
	DB	85H	; CMOVE
	DB	'CMOV'
	DB	'E'+80H
	DW	CR-5	
CMOVE	DW	$+2
	MOV	L,C
	MOV	H,B
	POP	B
	POP	D
	XTHL
;
	JMP	CMOV2
CMOV1	MOV	A,M
	INX	H
	STAX	D
	INX	D
	DCX	B
CMOV2	MOV	A,B
	ORA	C
	JNZ	CMOV1
	POP	B
	JMP	NEXT
;
	DB 	82H	; U*
	DB	'U'	
	DB	'*'+80H
	DW	CMOVE-8
USTAR	DW	$+2
	POP	D
	POP	H
	PUSH	B
	MOV	B,H
	MOV	A,L
	CALL	MPYX
;
	PUSH	H
	MOV	H,A
	MOV	A,B
	MOV	B,H
	CALL	MPYX
;
	POP	D
	MOV	C,D
;
;
	DAD	B
	ACI	0
	MOV	D,L
	MOV	L,H
	MOV	H,A
	POP	B
	PUSH	D
	JMP	HPUSH
;
;-------------------------MULTIPLY PRIMITIVE-----------------------------------
;
MPYX	LXI	H,0
	MVI	C,8
MPYX1	DAD	H
	RAL
	JNC	MPYX2
	DAD	D
	ACI	0
MPYX2	DCR	C
	JNZ	MPYX1
	RET
;
	DB	82H	; U/
	DB	'U'	
	DB	'/'+80H
	DW	USTAR-5
USLAS	DW	$+2
	LXI	H,4
	DAD	SP
	MOV	E,M
	MOV	M,C
	INX	H
	MOV	D,M
	MOV	M,B
	POP	B
	POP	H
	MOV	A,L
	SUB	C
	MOV	A,H
	SBB	B
	JC	USLA1
	LXI	H,0FFFFH
	LXI	D,0FFFFH
	JMP	USLA7
USLA1	MVI	A,16
USLA2	DAD	H
	RAL	
	XCHG
	DAD	H
	JNC	USLA3
	INX	D
	ANA	A
USLA3	XCHG
	RAR
	PUSH	PSW
	JNC	USLA4
	MOV	A,L
	SUB	C
	MOV	L,A
	MOV	A,H
	SBB	B
	MOV	H,A
	JMP	USLA5
USLA4	MOV	A,L
	SUB	C
	MOV	L,A
	MOV	A,H
	SBB	B
	MOV	H,A
	JNC	USLA5
	DAD	B
	DCX	D
USLA5	INX	D
USLA6	POP	PSW
	DCR	A
	JNZ	USLA2
USLA7	POP	B
	PUSH	H
	PUSH	D
	JMP	NEXT
;
	DB	83H	; AND
	DB 	'AN'
	DB 	'D'+80H
	DW	USLAS-5
ANDD	DW 	$+2
	POP	D
	POP	H
	MOV	A,E
	ANA	L
	MOV	L,A
	MOV	A,D	
	ANA	H
	MOV	H,A
	JMP	HPUSH
;
	DB	82H	;	OR
	DB	'O'	
	DB	'R'+80H
	DW	ANDD-6
ORR	DW	$+2
	POP	D
	POP	H
	MOV	A,E
	ORA	L
	MOV	L,A
	MOV	A,D
	ORA	H
	MOV	H,A
	JMP	HPUSH
;
	DB	83H	;	XOR
	DB	'XO'
	DB	'R'+80H
	DW	ORR-5
XORR	DW	$+2
	POP	D
	POP	H
	MOV	A,E
	XRA	L
	MOV	L,A
	MOV	A,D
	XRA	H
	MOV	H,A
	JMP	HPUSH
;
	DB	83H	;	SP@
	DB	'SP'
	DB	'@'+80H
	DW	XORR-6
SPAT	DW	$+2
	LXI	H,0
	DAD	SP
	JMP	HPUSH
;
	DB	83H	;SP STORE
	DB	'SP'
	DB	'!'+80H
	DW	SPAT-6
SPSTO	DW	$+2
	LHLD	UP
	LXI	D,6
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	SPHL
	JMP	NEXT
;
	DB	83H	;	RP@
	DB	'RP'
	DB	'@'+80H
	DW	SPSTO-6
RPAT	DW	$+2
	LHLD	RPP
	JMP	HPUSH
;
	DB	83H
	DB	'RP'
	DB	'!'+80H
	DW	RPAT-6
RPSTO	DW	$+2
	LHLD	UP
	LXI	D,8
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	SHLD	RPP
	JMP	NEXT
;
	DB	82H	;	;S
	DB	';'
	DB	'S'+80H
	DW	RPSTO-6
SEMIS	DW	$+2
	LHLD	RPP
	MOV	C,M
	INX	H
	MOV	B,M	
	INX	H
	SHLD	RPP
	JMP	NEXT
;
	DB	85H	;	LEAVE
	DB	'LEAV'
	DB	'E'+80H
	DW	SEMIS-5
LEAVE	DW	$+2
	LHLD	RPP
	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	MOV	M,E
	INX	H
	MOV	M,D
	JMP	NEXT
;
	DB	82H	;	>R
	DB	'>'
	DB	'R'+80H
	DW	LEAVE-8
TOR	DW	$+2
	POP	D
	LHLD	RPP
	DCX	H
	DCX	H
	SHLD	RPP
	MOV	M,E
	INX	H
	MOV	M,D
	JMP	NEXT
;
	DB	82H	;	R>
	DB	'R'
	DB	'>'+80H	
	DW	TOR-5
FROMR	DW	$+2
	LHLD	RPP
	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	SHLD	RPP
	PUSH	D
	JMP	NEXT
;
	DB	81H	; 	R
	DB	'R'+80H
	DW	FROMR-5
RR	DW	IDO+2
;
	DB	82H	;	0=
	DB	'0'
	DB	'='+80H
	DW	RR-4
ZEQU	DW	$+2
	POP	H
	MOV	A,L
	ORA	H
	LXI	H,0
	JNZ	ZEQU1
	INX	H
ZEQU1	JMP	HPUSH
;
	DB	82H	;	0<
	DB	'0'
	DB	'<'+80H
	DW	ZEQU-5
ZLESS	DW	$+2
	POP	H
	DAD	H
	LXI	H,0
	JNC	ZLESS1
	INX	H
ZLESS1	JMP	HPUSH
;
	DB	81H	;	+
	DB	'+'+80H
	DW	ZLESS-5
PLUS	DW	$+2
	POP	D
	POP	H
	DAD	D
	JMP	HPUSH
;
	DB	82H	;	D+
	DB	'D'
	DB	'+'+80H
	DW	PLUS-4
DPLUS	DW	$+2
	LXI	H,6
	DAD	SP
	MOV	E,M
	MOV	M,C
	INX	H
	MOV	D,M
	MOV	M,B
	POP	B
	POP	H
	DAD	D
	XCHG
	POP	H
	MOV	A,L
	ADC	C
	MOV	L,A
	MOV	A,H
	ADC	B
	MOV	H,A
	POP	B
	PUSH	D
	JMP	HPUSH
;
	DB	85H	;	MINUS
	DB	'MINU'
	DB	'S'+80H
	DW	DPLUS-5
MINUS	DW	$+2
	POP	H
	MOV	A,L
	CMA
	MOV	L,A
	MOV	A,H
	CMA
	MOV	H,A
	INX	H
	JMP	HPUSH	
;
	DB	86H	;	DMINUS
	DB	'DMINU'
	DB	'S'+80H
	DW	MINUS-8
DMINU	DW	$+2
	POP	H
	POP	D
	SUB	A
	SUB	E
	MOV	E,A
	MVI	A,0
	SBB	D
	MOV	D,A
	MVI	A,0
	SBB	L
	MOV	L,A
	MVI	A,0
	SBB	H
	MOV	H,A
	PUSH	D
	JMP	HPUSH
;
	DB	84H	;	OVER
	DB	'OVE'
	DB	'R'+80H
	DW	DMINU-9
OVER	DW	$+2
	POP	D
	POP	H
	PUSH	H
	JMP	DPUSH
;
	DB	84H	;	DROP
	DB	'DRO'
	DB	'P'+80H
	DW	OVER-7
DROP	DW	$+2
	POP	H
	JMP	NEXT
;
	DB	84H	;	SWAP
	DB	'SWA'
	DB	'P'+80H
	DW	DROP-7
SWAP	DW	$+2
	POP	H
	XTHL
	JMP	HPUSH
;
	DB	83H	;	DUP
	DB	'DU'
	DB	'P'+80H
	DW	SWAP-7
DUP	DW	$+2
	POP	H
	PUSH	H
	JMP	HPUSH
;
	DB	84H	;	2DUP
	DB	'2DU'
	DB	'P'+80H
	DW	DUP-6
TDUP	DW	$+2
	POP	H
	POP	D
	PUSH	D
	PUSH	H
	JMP	DPUSH
;
	DB	82H	;	+STORE
	DB	'+'
	DB	'!'+80H
	DW	TDUP-7
PSTOR	DW	$+2
	POP	H
	POP	D
	MOV	A,M
	ADD	E
	MOV	M,A
	INX	H
	MOV	A,M
	ADC	D
	MOV	M,A
	JMP	NEXT
;
	DB	86H	;	TOGGLE
	DB	'TOGGL'
	DB	'E'+80H
	DW	PSTOR-5
TOGGL	DW	$+2
	POP	D
	POP	H
	MOV	A,M
	XRA	E
	MOV	M,A
	JMP	NEXT
;
	DB	81H	;	@
	DB	'@'+80H
	DW	TOGGL-9
AT	DW	$+2
	POP	H
	MOV	E,M
	INX	H
	MOV	D,M
	PUSH	D
	JMP	NEXT
;
	DB	82H	;	C@
	DB	'C'
	DB	'@'+80H
	DW	AT-4
CAT	DW	$+2
	POP	H
	MOV	L,M
	MVI	H,0
	JMP	HPUSH
;
	DB	82H	;	2@
	DB	'2'
	DB	'@'+80H
	DW	CAT-5
TAT	DW	$+2
	POP	H
	LXI	D,2
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	PUSH	D
	LXI	D,-3
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	PUSH	D
	JMP	NEXT
;
	DB	81H	;	STORE (PRONOUNCED STORE)
	DB	'!'+80H
	DW	TAT-5
STORE	DW	$+2
	POP	H
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
	JMP	NEXT
;
	DB	82H	;	CSTORE
	DB	'C'
	DB	'!'+80H
	DW	STORE-4
CSTOR	DW	$+2
	POP	H
	POP	D
	MOV	M,E
	JMP	NEXT
;
	DB	82H	;	2 STORE
	DB	'2'
	DB	'!'+80H
	DW	CSTOR-5
TSTOR	DW	$+2
	POP	H
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
	INX	H
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
	JMP	NEXT
;
	DB	0C1H	;	COLON
	DB	':'+80H
	DW	TSTOR-5
COLON	DW	DOCOL
	DW	QEXEC
	DW	SCSP
	DW	CURR
	DW	AT
	DW	CONT
	DW	STORE
	DW	CREAT
	DW	RBRAC
	DW	PSCOD
DOCOL	LHLD	RPP
	DCX	H
	MOV	M,B
	DCX	H
	MOV	M,C
	SHLD	RPP
	INX	D
	MOV	C,E
	MOV	B,D
	JMP	NEXT
;
	DB	0C1H	;	SEMICOLON
	DB	';'+80H
	DW	COLON-4
SEMI	DW	DOCOL
	DW	QCSP
	DW	COMP
	DW	SEMIS
	DW	SMUDG
	DW	LBRAC
	DW	SEMIS
;
	DB	84H	;	NOOP
	DB	'NOO'
	DB	'P'+80H
	DW	SEMI-4
NOOP	DW	DOCOL
	DW	SEMIS
;
	DB	88H	;	CONSTANT
	DB	'CONSTAN'
	DB	'T'+80H
	DW	NOOP-7
CONS	DW	DOCOL
	DW	CREAT
	DW	SMUDG
	DW	COMMA
	DW	PSCOD
DOCON	INX	D	
	XCHG
	MOV	E,M
	INX	H
	MOV	D,M
	PUSH	D
	JMP	NEXT
;
	DB	88H	;	VARIABLE
	DB	'VARIABL'
	DB	'E'+80H
	DW	CONS-0BH
VARB	DW	DOCOL
	DW	CONS
	DW	PSCOD
DOVAR	INX	D
	PUSH	D
	JMP	NEXT
;
	DB	84H	;	USER
	DB	'USE'
	DB	'R'+80H
	DW	VARB-0BH
USER	DW	DOCOL
	DW	CONS
	DW	PSCOD
DOUSE	INX	D
	XCHG	
	MOV	E,M
	MVI	D,0
	LHLD	UP
	DAD	D
	JMP	HPUSH
;
	DB	81H	;	0 ( THE NUMBER ZERO)
	DB	'0'+80H
	DW	USER-7
ZERO	DW	DOCON
	DW	0
;
	DB	81H	;	1
	DB	'1'+80H
	DW	ZERO-4
ONE	DW	DOCON
	DW	1
;
	DB	81H	;	2
	DB	'2'+80H
	DW	ONE-4
TWO	DW	DOCON
	DW	2
;
	DB	81H	;	3
	DB	'3'+80H
	DW	TWO-4
THREE	DW	DOCON
	DW	3
;
	DB	82H	;	BL
	DB	'B'
	DB	'L'+80H
	DW	THREE-4
BL	DW	DOCON
	DW	20H
;
	DB	83H	;	C/L
	DB	'C/'
	DB	'L'+80H	
	DW	BL-5
CSLL	DW	DOCON
	DW	64
;
	DB	85H	;	FIRST
	DB	'FIRS'
	DB	'T'+80H
	DW	CSLL-6
FIRST	DW	DOCON
	DW	BUF1
;
	DB	85H	;	LIMIT
	DB	'LIMI'
	DB	'T'+80H
	DW	FIRST-8
LIMIT	DW	DOCON
	DW	EM
;
	DB	85H	;	B/BUF
	DB	'B/BU'
	DB	'F'+80H
	DW	LIMIT-8
BBUF	DW	DOCON
	DW	KBBUF
;
	DB	85H
	DB	'B/SC'
	DB	'R'+80H
	DW	BBUF-8
BSCR	DW	DOCON
	DW	400H/KBBUF
;
	DB	87H	;	+ORIGIN
	DB	'+ORIGI'
	DB	'N'+80H
	DW	BSCR-8
PORIG	DW	DOCOL
	DW	LIT
	DW	ORIG
	DW	PLUS
	DW	SEMIS
;
;-------------------------USER VARIABLES--------------------------------------
;
	DB	82H	;	S0
	DB	'S'
	DB	'0'+80H
	DW	PORIG-0AH
SZERO	DW	DOUSE
	DW	6
;
	DB	82H	;	R0
	DB	'R'
	DB	'0'+80H
	DW	SZERO-5
RZERO	DW	DOUSE
	DW	8
;
	DB	83H	;	TIB
	DB	'TI'
	DB	'B'+80H
	DW	RZERO-5
TIB	DW	DOUSE
	DB	0AH
;
	DB	85H	;	WIDTH
	DB	'WIDT'
	DB	'H'+80H
	DW	TIB-6
WIDTH	DW	DOUSE
	DB	0CH
;
	DB	87H	;	WARNING
	DB	'WARNIN'
	DB	'G'+80H
	DW	WIDTH-8
WARN	DW	DOUSE
	DB	0EH
;
	DB	85H	;	FENCE
	DB	'FENC'
	DB	'E'+80H
	DW	WARN-0AH
FENCE	DW	DOUSE
	DB	10H
;
	DB	82H	;	DP
	DB	'D'
	DB	'P'+80H
	DW	FENCE-8
DP	DW	DOUSE
	DB	12H
;
	DB	88H	;	VOC-LINK
	DB	'VOC-LIN'
	DB	'K'+80H
	DW	DP-5
VOCL	DW	DOUSE
	DW	14H
;
	DB	83H	;	BLK
	DB	'BL'
	DB	'K'+80H
	DW	VOCL-0BH
BLK	DW	DOUSE
	DB	16H
;
	DB	82H	;	IN
	DB	'I'
	DB	'N'+80H
	DW	BLK-6
INN	DW	DOUSE
	DB 	18H
;
	DB	83H	;	OUT
	DB	'OU'
	DB	'T'+80H
	DW	INN-5
OUTT	DW	DOUSE
	DB	1AH
;
	DB	83H	;	SCR
	DB	'SC'
	DB	'R'+80H
	DW	OUTT-6
SCR	DW	DOUSE
	DB	1CH
;
	DB 	86H	;	OFFSET	
	DB	'OFFSE'
	DB	'T'+80H
	DW	SCR-6
OFSET	DW	DOUSE
	DB	1EH
;
	DB	87H	;	CONTEXT
	DB	'CONTEX'
	DB	'T'+80H
	DW	OFSET-9
CONT	DW	DOUSE
	DB	20H
;
	DB	87H	;	CURRENT
	DB	'CURREN'
	DB	'T'+80H
	DW	CONT-0AH
CURR	DW	DOUSE
	DB	22H
;
	DB	85H	;	STATE
	DB	'STAT'
	DB	'E'+80H
	DW	CURR-0AH
STATE	DW	DOUSE
	DB	24H
;
	DB	84H	;	BASE
	DB	'BAS'
	DB	'E'+80H
	DW	STATE-8
BASEE	DW	DOUSE
	DB	26H
;
	DB	83H	;	DPL
	DB	'DP'
	DB	'L'+80H
	DW	BASEE-7
DPL	DW	DOUSE	
	DB	28H
;
	DB	83H	;FLD
	DB	'FL'
	DB	'D'+80H
	DW	DPL-6
FLD	DW	DOUSE
	DB	2AH
;
	DB	83H	;	CSP
	DB	'CS'
	DB	'P'+80H
	DW	FLD-6
CSPP	DW	DOUSE
	DB	2CH
;
	DB	82H	;	R#
	DB	'R'
	DB	'#'+80H
	DW	CSPP-6
RNUM	DW	DOUSE
	DB	2EH
;
	DB	83H	;	HLD
	DB	'HL'
	DB	'D'+80H
	DW	RNUM-5
HLD	DW	DOUSE
	DW	30H
;
	DB	85H	;	TEMIT
	DB	'TEMI'
	DB	'T'+80H
	DW	HLD-6
TEMIT	DW	DOUSE
	DB	32H
;
	DB	84H
	DB	'TKE'
	DB	'Y'+80H
	DW	TEMIT-8
TKEY	DW	DOUSE
	DB	34H
;
;
;-------------------------END OF USER VARIABLES--------------------------------
;
	DB	82H	;	1+
	DB	'1'
	DB	'+'+80H
	DW	TKEY-7 
ONEP	DW	DOCOL
	DW	ONE
	DW	PLUS
	DW	SEMIS
;
	DB	82H	;	2+
	DB	'2'
	DB	'+'+80H
	DW	ONEP-5
TWOP	DW	DOCOL
	DW	TWO
	DW	PLUS
	DW	SEMIS
;
	DB	84H	;	HERE
         DB	'HER'
	DB	'E'+80H
	DW	TWOP-5
HERE	DW	DOCOL
	DW	DP
	DW	AT
	DW	SEMIS
;
	DB	85H	;	ALLOT
	DB	'ALLO'
	DB 	'T'+80H
	DW	HERE-7
ALLOT	DW	DOCOL
	DW	DP
	DW	PSTOR
	DW	SEMIS
;
	DB	81H	;	,
	DB	','+80H
	DW	ALLOT-8
COMMA	DW	DOCOL
	DW	HERE
	DW	STORE
	DW	TWO
	DW	ALLOT
	DW	SEMIS
;
	DB	82H	;	C,
	DB	'C'
	DB	','+80H
	DW	COMMA-4
CCOM	DW	DOCOL
	DW	HERE
	DW	CSTOR
	DW	ONE
	DW	ALLOT
	DW	SEMIS
;
;--------------------------SUBROUTINE USED BY - AND <
;
SSUB	MOV	A,L	
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A
	RET
;
	DB	81H	;	-  (AS IN SUBTRACTION)
	DB	'-'+80H
	DW	CCOM-5
SUBB	DW	$+2
	POP	D
	POP	H
	CALL	SSUB
	JMP	HPUSH
;
	DB	81H	;	=
	DB	'='+80H
	DW	SUBB-4
EQUAL	DW	DOCOL
	DW	SUBB
	DW	ZEQU
	DW	SEMIS
;
	DB	81H	;	<
	DB	'<'+80H
	DW	EQUAL-4
LESS	DW	$+2
	POP	D
	POP	H
	MOV	A,D
	XRA	H
	JM	LES1
	CALL	SSUB
LES1	INR	H
	DCR	H
	JM	LES2
	LXI	H,0
	JMP	HPUSH
LES2	LXI	H,1
	JMP	HPUSH
;
	DB	82H	;	U<	(UNSIGNED <)
	DB	'U'
	DB	'<'+80H
	DW	LESS-4
ULESS	DW	DOCOL,TDUP
	DW	XORR,ZLESS
	DW	ZBRAN
	DW	ULES1-$
	DW	DROP,ZLESS
	DW	ZEQU
	DW	BRAN
	DW	ULES2-$
ULES1	DW	SUBB,ZLESS
ULES2	DW	SEMIS
;
	DB	81H	;	>
	DB	'>'+80H
	DW	ULESS-5
GREAT	DW	DOCOL
	DW	SWAP
	DW	LESS
	DW	SEMIS
;
	DB	83H	;	ROT
	DB	'RO'
	DB	'T'+80H
	DW	GREAT-4
ROT	DW	$+2
	POP	D
	POP	H
	XTHL
	JMP	DPUSH
;
	DB	85H	;	SPACE
	DB	'SPAC'
	DB	'E'+80H
	DW	ROT-6
SPACE	DW	DOCOL
	DW	BL
	DW	EMIT
	DW	SEMIS
;
	DB	84H	;	-DUP
	DB	'-DU'
	DB	'P'+80H
	DW	SPACE-8
DDUP	DW	DOCOL
	DW	DUP
	DW	ZBRAN
	DW	DDUP1-$
	DW	DUP
DDUP1	DW	SEMIS
;
	DB	88H	;	TRAVERSE
	DB	'TRAVERS'
	DB	'E'+80H
	DW	DDUP-7
TRAV	DW	DOCOL
	DW	SWAP
TRAV1	DW	OVER
	DW	PLUS
	DW	LIT
	DW	7FH
	DW	OVER
	DW	CAT
	DW	LESS
	DW	ZBRAN
	DW	TRAV1-$
	DW	SWAP
	DW	DROP
	DW	SEMIS
;
	DB	86H	;	LATEST
         DB	'LATES'
	DB	'T'+80H
	DW	TRAV-0BH
LATES	DW	DOCOL
	DW	CURR
	DW	AT
	DW	AT
	DW	SEMIS
;
	DB	83H	;	LFA
	DB	'LF'
	DB	'A'+80H
	DW	LATES-9
LFA	DW	DOCOL
	DW	LIT
	DW	4
	DW	SUBB
	DW	SEMIS
;
	DB	83H	;	CFA
	DB	'CF'
	DB	'A'+80H
	DW	LFA-6
CFA	DW	DOCOL
	DW	TWO
	DW	SUBB
	DW	SEMIS
;
	DB	83H	;	NFA
	DB	'NF'	
	DB	'A'+80H
	DW	CFA-6
NFA	DW	DOCOL
	DW	LIT
	DW	5
	DW	SUBB
	DW	LIT
	DW	-1
	DW	TRAV
	DW	SEMIS
;
	DB	83H	;	PFA
	DB	'PF'
	DB	'A'+80H
	DW	NFA-6
PFA	DW	DOCOL
	DW	ONE
	DW	TRAV
	DW	LIT
	DW	5
	DW	PLUS
	DW	SEMIS
;
	DB	84H	;	STORE CSP
	DB	'!CS'
	DB	'P'+80H
	DW	PFA-6
SCSP	DW	DOCOL
	DW	SPAT
	DW	CSPP
	DW	STORE
	DW	SEMIS
;
	DB	86H	;	?ERROR
	DB	'?ERRO'
	DB	'R'+80H
	DW	SCSP-7
QERR	DW	DOCOL
	DW	SWAP
	DW	ZBRAN
	DW	QERR1-$
	DW	ERROR
	DW	BRAN
	DW	QERR2-$
QERR1	DW	DROP
QERR2	DW	SEMIS
;
	DB	85H	;	?COMP
	DB	'?COM'
	DB	'P'+80H
	DW	QERR-9
QCOMP	DW	DOCOL
	DW	STATE
	DW	AT
	DW	ZEQU
	DW	LIT
	DW	11H
	DW	QERR
	DW	SEMIS
;
	DB	85H	;	?EXEC
	DB	'?EXE'
	DB	'C'+80H
	DW	QCOMP-8
QEXEC	DW	DOCOL
	DW	STATE
	DW	AT
	DW	LIT
	DW	12H
	DW	QERR
	DW	SEMIS
;
	DB	86H	;	?PAIRS
	DB	'?PAIR'
	DB	'S'+80H
	DW	QEXEC-8
QPAIR	DW	DOCOL
	DW	SUBB
	DW	LIT
	DW	13H
	DW	QERR
	DW	SEMIS
;
	DB	84H	;	?CSP
	DB	'?CS'
	DB	'P'+80H
	DW	QPAIR-9
QCSP	DW	DOCOL
	DW	SPAT
	DW	CSPP
	DW	AT
	DW	SUBB
	DW	LIT
	DW	14H
	DW	QERR
	DW	SEMIS
;
	DB	88H	;	?LOADING
	DB	'?LOADIN'
	DB	'G'+80H
	DW	QCSP-7
QLOAD	DW	DOCOL
	DW	BLK
	DW	AT
	DW	ZEQU
	DW	LIT
	DW	16H
	DW	QERR
	DW	SEMIS
;
	DB	87H	;	COMPILE
	DB	'COMPIL'
	DB	'E'+80H
	DW	QLOAD-0BH
COMP	DW	DOCOL
	DW	QCOMP
	DW	FROMR
	DW	DUP
	DW	TWOP
	DW	TOR
	DW	AT
	DW	COMMA
	DW	SEMIS
;
	DB	0C1H	;	[
	DB	'['+80H
	DW	COMP-0AH
LBRAC	DW	DOCOL
	DW	ZERO
	DW	STATE
	DW	STORE
	DW	SEMIS
;
	DB	81H	;	]
	DB	']'+80H
	DW	LBRAC-4
RBRAC	DW	DOCOL
	DW	LIT,0C0H
	DW	STATE,STORE
	DW	SEMIS
;
	DB	86H	;	SMUDGE
	DB	'SMUDG'
	DB	'E'+80H
	DW	RBRAC-4
SMUDG	DW	DOCOL
	DW	LATES
	DW	LIT
	DW	20H
	DW	TOGGL
	DW	SEMIS
;
	DB	83H	;	HEX
	DB	'HE'
	DB 	'X'+80H
	DW	SMUDG-9
HEX	DW	DOCOL
	DW	LIT
	DW	10H
	DW	BASEE
	DW	STORE
	DW	SEMIS
;
	DB	87H	;	DECIMAL
	DB	'DECIMA'
	DB	'L'+80H
	DW	HEX-6
DEC	DW	DOCOL
	DW	LIT
	DW	0AH
	DW	BASEE
	DW	STORE
	DW	SEMIS
;
	DB	87H	;	(;CODE)
	DB	'(;CODE'
	DB	')'+80H
	DW	DEC-0AH
PSCOD	DW	DOCOL
	DW	FROMR
	DW	LATES
	DW	PFA
	DW	CFA
	DW	STORE
	DW	SEMIS
;
	DB	0C5H	;	;CODE
	DB	';COD'
	DB	'E'+80H
	DW	PSCOD-0AH
SEMIC	DW	DOCOL
	DW	QCSP
	DW	COMP
	DW	PSCOD
	DW	LBRAC
SEMI1	DW	NOOP	;	( ASSEMBLER )
	DW	SEMIS
;
	DB	87H	;	<BUILDS    (CREATE IN 79 STANDARD FORTH)
	DB	'<BUILD'
	DB	'S'+80H
	DW	SEMIC-8
BUILD	DW	DOCOL
	DW	ZERO
	DW	CONS
	DW	SEMIS
;
	DB	85H	;	DOES>
	DB	'DOES'
	DB	'>'+80H
	DW	BUILD-0AH
DOES	DW	DOCOL
	DW	FROMR
	DW	LATES
	DW	PFA
	DW	STORE
	DW	PSCOD
DODOE	LHLD	RPP
	DCX	H
	MOV	M,B
	DCX	H
	MOV	M,C
	SHLD	RPP
	INX	D
	XCHG
	MOV	C,M
	INX	H
	MOV	B,M
	INX	H
	JMP	HPUSH
;
	DB	85H	;	COUNT
	DB	'COUN'
	DB	'T'+80H
	DW	DOES-8
COUNT	DW	DOCOL
	DW	DUP
	DW	ONEP
	DW	SWAP
	DW	CAT
	DW	SEMIS
;	
	DB	84H	;	TYPE
	DB	'TYP'
	DB	'E'+80H
	DW	COUNT-8
TYPE	DW	DOCOL
	DW	DDUP
	DW	ZBRAN
	DW	TYPE1-$
	DW	OVER
	DW	PLUS
	DW	SWAP
	DW	XDO
TYPE2	DW	IDO
	DW	CAT
	DW	EMIT
	DW	XLOOP
	DW	TYPE2-$
	DW	BRAN
	DW	TYPE3-$
TYPE1	DW	DROP
TYPE3	DW	SEMIS
;
	DB	89H	;	-TRAILING
	DB	'-TRAILIN'
	DB	'G'+80H
	DW	TYPE-7
DTRAI	DW	DOCOL
	DW	DUP
	DW	ZERO
	DW	XDO
DTRA1	DW	OVER
	DW	OVER
	DW	PLUS
	DW	ONE
	DW	SUBB
	DW	CAT
	DW	BL
	DW	SUBB
	DW	ZBRAN
	DW	DTRA2-$
	DW	LEAVE
	DW	BRAN
	DW	DTRA3-$
DTRA2	DW	ONE
	DW	SUBB
DTRA3	DW	XLOOP
	DW	DTRA1-$
	DW	SEMIS
;
	DB	84H	;	(.")
	DB	'(."'	
	DB	')'+80H
	DW	DTRAI-0CH
PDOTQ	DW	DOCOL
	DW	RR
	DW	COUNT
	DW	DUP
	DW	ONEP
	DW	FROMR
	DW	PLUS
	DW	TOR
	DW	TYPE
	DW	SEMIS
;
	DB	0C2H	;	."
	DB	'.'
	DB	'"'+80H
	DW	PDOTQ-7
DOTQ	DW	DOCOL
	DW	LIT
	DW	22H	
	DW	STATE
	DW	AT
	DW	ZBRAN
	DW	DOTQ1-$
	DW	COMP	
	DW	PDOTQ
	DW	DWD
	DW	HERE
	DW	CAT
	DW	ONEP
	DW	ALLOT
	DW	BRAN
	DW	DOTQ2-$
DOTQ1	DW	DWD
	DW	HERE
	DW	COUNT
	DW	TYPE
DOTQ2	DW	SEMIS
;
	DB	86H	;	EXPECT
	DB	'EXPEC'
	DB	'T'+80H
	DW	DOTQ-5
EXPEC	DW	DOCOL
	DW	OVER
	DW	PLUS
	DW	OVER
	DW	XDO
EXPE1	DW	KEY
	DW	DUP
	DW	LIT
	DW	0EH
	DW	PORIG
	DW	AT
	DW	EQUAL
	DW	ZBRAN
	DW	EXPE2-$
	DW	DROP
	DW	DUP
	DW	IDO
	DW	EQUAL
	DW	DUP
	DW	FROMR
	DW	TWO
	DW	SUBB
	DW	PLUS
	DW	TOR
	DW	ZBRAN
	DW	EXPE6-$
	DW	LIT
	DW	BELL
	DW	BRAN
	DW	EXPE7-$
EXPE6	DW	LIT
	DW	BSOUT
EXPE7	DW	BRAN
	DW	EXPE3-$
EXPE2	DW	DUP
	DW	LIT
	DW	0DH
	DW	EQUAL
	DW	ZBRAN
	DW	EXPE4-$
	DW	LEAVE
	DW	DROP
	DW	BL
	DW	ZERO
	DW	BRAN
	DW	EXPE5-$
EXPE4	DW	DUP
EXPE5	DW	IDO
	DW	CSTOR
	DW	ZERO
	DW	IDO
	DW	ONEP
	DW	STORE
EXPE3	DW	EMIT
	DW	XLOOP
	DW	EXPE1-$
	DW	DROP
	DW	SEMIS
;
	DB	85H	;	QUERY
	DB	'QUER'
	DB	'Y'+80H
	DW	EXPEC-9
QUERY	DW	DOCOL
	DW	TIB	
	DW	AT
	DW	LIT
	DW	50H
	DW	EXPEC
	DW	ZERO
	DW	INN
	DW	STORE
	DW	SEMIS
;
	DB	0C1H	;	0 (NULL)
	DB	80H
	DW	QUERY-8
NULL	DW	DOCOL
	DW	BLK
	DW	AT
	DW	ZBRAN
	DW	NULL1-$
	DW	ONE
	DW	BLK
	DW	PSTOR
	DW	ZERO
	DW	INN
	DW	STORE
	DW	BLK
	DW	AT
	DW	BSCR
	DW	ONE	
	DW	SUBB
	DW	ANDD
	DW	ZEQU
	DW	ZBRAN
	DW	NULL2-$
	DW	QEXEC
	DW	FROMR
	DW	DROP
NULL2	DW	BRAN
	DW	NULL3-$
NULL1	DW	FROMR
	DW	DROP
NULL3	DW	SEMIS
;
	DB	84H	;	FILL
	DB	'FIL'
	DB	'L'+80H
	DW	NULL-4
FILL	DW	$+2
	MOV	L,C
	MOV	H,B
	POP	D
	POP	B
	XTHL
	XCHG
FILL1	MOV	A,B
	ORA	C
	JZ	FILL2
	MOV	A,L
	STAX	D
	INX	D
	DCX	B
	JMP	FILL1
FILL2	POP	B
	JMP	NEXT
;
	DB	85H	;	ERASE
	DB	'ERAS'
	DB	'E'+80H
	DW	FILL-7
ERASEE	DW	DOCOL
	DW	ZERO
	DW	FILL
	DW	SEMIS
;
	DB	86H	;	BLANKS
	DB	'BLANK'
	DB	'S'+80H
	DW	ERASEE-8
BLANKK	DW	DOCOL
	DW	BL
	DW	FILL
	DW	SEMIS
;
	DB	84H	;	HOLD
	DB	'HOL'
	DB	'D'+80H
	DW	BLANKK-9
HOLD	DW	DOCOL
	DW	LIT
	DW	-1
	DW	HLD
	DW	PSTOR
	DW	HLD
	DW	AT
	DW	CSTOR
	DW	SEMIS
;
	DB	83H	;	PAD
	DB	'PA'
	DB	'D'+80H
	DW	HOLD-7
PAD	DW	DOCOL
	DW	HERE
	DW	LIT
	DW	44H
	DW	PLUS
	DW	SEMIS
;
	DB	84H	;	DWD
	DB	'WOR'
	DB	'D'+80H
	DW	PAD-6
DWD	DW	DOCOL
	DW	BLK
	DW	AT
	DW	ZBRAN
	DW	DW1-$
	DW	BLK
	DW	AT
	DW	BLOCK
	DW	BRAN
	DW	DW2-$
DW1	DW	TIB
	DW	AT
DW2	DW	INN
	DW	AT
	DW	PLUS
	DW	SWAP
	DW	ENCL
	DW	HERE
	DW	LIT
	DW	22H
	DW	BLANKK
	DW	INN
	DW	PSTOR
	DW	OVER
	DW	SUBB
	DW	TOR
	DW	RR
	DW	HERE
	DW	CSTOR
	DW	PLUS
	DW	HERE
	DW	ONEP
	DW	FROMR
	DW	CMOVE
	DW	SEMIS
;
	DB	88H	;	(NUMBER)
	DB	'(NUMBER'
	DB	')'+80H
	DW	DWD-7
PNUMB	DW	DOCOL
PNUM1	DW	ONEP	
	DW	DUP
	DW	TOR
	DW	CAT
	DW	BASEE
	DW	AT
	DW	DIGIT
	DW	ZBRAN
	DW	PNUM2-$
	DW	SWAP
	DW	BASEE
	DW	AT
	DW	USTAR
	DW	DROP
	DW	ROT
	DW	BASEE
	DW	AT
	DW	USTAR
	DW	DPLUS
	DW	DPL
	DW	AT
	DW	ONEP
	DW	ZBRAN
	DW	PNUM3-$
	DW	ONE
	DW	DPL
	DW	PSTOR
PNUM3	DW	FROMR
	DW	BRAN
	DW	PNUM1-$
PNUM2	DW	FROMR
	DW	SEMIS
;
	DB	86H	;	NUMBER
	DB	'NUMBE'
	DB	'R'+80H
	DW	PNUMB-0BH
NUMB	DW	DOCOL
	DW	ZERO
	DW	ZERO
	DW	ROT
	DW	DUP
	DW	ONEP
	DW	CAT
	DW	LIT
	DW	2DH
	DW	EQUAL
	DW	DUP
	DW	TOR
	DW	PLUS
	DW	LIT
	DW	-1
NUMB1	DW	DPL
	DW	STORE
	DW	PNUMB
	DW	DUP
	DW	CAT
	DW	BL
	DW	SUBB
	DW	ZBRAN
	DW	NUMB2-$
	DW	DUP
	DW	CAT
	DW	LIT
	DW	2EH
	DW	SUBB
	DW	ZERO
	DW	QERR
	DW	ZERO
	DW	BRAN
	DW	NUMB1-$
NUMB2	DW	DROP
	DW	FROMR
	DW	ZBRAN
	DW	NUMB3-$
	DW	DMINU
NUMB3	DW	SEMIS
;
	DB	85H	;	-FIND
	DB	'-FIN'
	DB	'D'+80H
	DW	NUMB-9
DFIND	DW	DOCOL
	DW	BL
	DW	DWD
	DW	HERE
	DW	CONT
	DW	AT
	DW	AT
	DW	PFIND
	DW	DUP
	DW	ZEQU
	DW	ZBRAN
	DW	DFIN1-$
	DW	DROP
	DW	HERE
	DW	LATES
	DW	PFIND
DFIN1	DW	SEMIS
;
	DB	87H	;	(ABORT)
	DB	'(ABORT'
	DB	')'+80H
	DW	DFIND-8
PABOR	DW	DOCOL
	DW	ABORT
	DW	SEMIS
;
	DB	85H	;	ERROR
	DB	'ERRO'
	DB	'R'+80H
	DW	PABOR-0AH
ERROR	DW	DOCOL
	DW	WARN
	DW	AT
	DW	ZLESS
	DW	ZBRAN
	DW	ERRO1-$
	DW	PABOR
ERRO1	DW	HERE
	DW	COUNT
	DW	TYPE
	DW	PDOTQ
	DB	2
	DB	'? '
	DW	MESS
	DW	SPSTO
;		**************NOTE CHAGE FROM FIG MODEL*********
;	DW	INN,AT,BLK,AT
	DW	BLK,AT
	DW	DDUP
	DW	ZBRAN
	DW	ERRO2-$
	DW	INN,AT
	DW	SWAP
ERRO2	DW	QUIT	
;
	DB	83H	;	ID.
	DB	'ID'
	DB	'.'+80H
	DW	ERROR-8
IDDOT	DW	DOCOL
	DW	PAD
	DW	LIT
	DW	20H
	DW	LIT
	DW	5FH
	DW	FILL
	DW	DUP
	DW	PFA
	DW	LFA
	DW	OVER
	DW	SUBB
	DW	PAD
	DW	SWAP
	DW	CMOVE
	DW	PAD
	DW	COUNT
	DW	LIT
	DW	1FH
	DW	ANDD
	DW	TYPE
	DW	SPACE
	DW	SEMIS
;
	DB	86H	;	CREATE
	DB	'CREAT'
	DB	'E'+80H
	DW	IDDOT-6
CREAT	DW	DOCOL
	DW	DFIND
	DW	ZBRAN
	DW	CREA1-$
	DW	DROP
	DW	NFA
	DW	IDDOT
	DW	LIT
	DW	4
	DW	MESS
	DW	SPACE
CREA1	DW	HERE
	DW	DUP
	DW	CAT
	DW	WIDTH
	DW	AT
	DW	MIN
	DW	ONEP
	DW	ALLOT
	DW	DUP
	DW	LIT
	DW	0A0H
	DW	TOGGL
	DW	HERE
	DW	ONE
	DW	SUBB
	DW	LIT
	DW	80H
	DW	TOGGL
	DW	LATES
	DW	COMMA
	DW	CURR
	DW	AT
	DW	STORE
	DW	HERE
	DW	TWOP
	DW	COMMA
	DW	SEMIS
;
	DB	0C9H	;	[COMPILE]
	DB	'[COMPILE'
	DB	']'+80H
	DW	CREAT-9
BCOMP	DW	DOCOL
	DW	DFIND
	DW	ZEQU
	DW	ZERO
	DW	QERR
	DW	DROP
	DW	CFA
	DW	COMMA
	DW	SEMIS
;
	DB	0C7H	;	LITERAL
	DB	'LITERA'
	DB	'L'+80H
	DW	BCOMP-0CH
LITER	DW	DOCOL
	DW	STATE
	DW	AT
	DW	ZBRAN
	DW	LITE1-$
	DW	COMP
	DW	LIT
	DW	COMMA
LITE1	DW	SEMIS
;
	DB	0C8H	;	DLITERAL
	DB	'DLITERA'
	END


	DW	AT
	DW	Z