/* ZODEM.C */
/* 31-May-84 */
#define	MAJREV	1	/* major revision number */
#define	MINREV	2	/* minor revision number  14-Jul-84 */

/* changes, most recent first
V 1.2 14-Jul-84 Added call to setnoc(), which disables Z-dos check for
				control-C, also added #define at the begining of ZODEMKEY.C
				to be sure that all getchar()'s use getkey()
				Fixed zodemdir(), and F8 function to correctly handle
				single letter file names RJB.
V 1.1 08-Jul-84 Fixed split screen baud rate display, added 'F8' directory
				display, stopped display of sector-number in proto-recv when
				view is on. R.J.Bono
V 1.0 07-Jun-84 fixed bugs in protocol & non-protocol send, sending extra bytes
				changed format of baud rate selection
				reset default DOS baud rate when exiting ZODEM
			***  RELEASED TO >>>NON-PROFIT<<< PUBLIC DOMAIN *** R.J.Bono
V 0.9 31-May-84	fixed problem with run external program option for DOS 2.0 R.J.Bono
*/

/**************************************************************************/
/*		ZODEM
		compiled under DeSmet-C running under Z-dos  (MS-dos)
		for the Z100
		by:
		Richard Bono
		WA1WMB
		19 Commonwealth Avenue
		North Andover, Ma. 01845
		ALL RIGHTS RESERVED
		November 1983
*/

/*
		referenced:

		lmodem - little modem program
				from BYTE, November 1983, page 414
		by
		Jack M. Wierda & Roderick W. Hart (original cmodem13.c)
		&
		David D. Clark  (original lmodem.c)
*/
/**************************************************************************/

#include	<zodemdef.h>

char		ViewMode, BFlag, KbData, MoData, tflag, filtrlf;
char		AsciiFlg, ShowTrans, ShowRecv, View, Echo, funckey;
char		ansr, split, Recho;
char		Bufr[BUFSIZ];	/* receive & transmit buffer */
char		Bufbuf[BUFSIZ];	/* buffer text mode buffer */
char		FileName[65];	/* room for DOS vers 2 filenames */
char		BFileName[65];	/* buffer file name */
int		userfor;	/* color that the user wants his text */
int		userbak;	/* color that the user wants his background */
int		promptlin;
int		Fd, tdelay, BFd;
int		lfcount;
int		charaddr, lineaddr;
int		ascbaud, baudot, figs;	/* user's baudrate, baudot & figures flag */
int		dosbaud;	/* baudrate of DOS when entering ZODEM */
unsigned	TxtPtr;


main(argc,argv)
int	argc;
char	*argv[];
{

int	bad1, bad2;


bad1 = bad2 = FALSE;
userfor = CYAN;
userbak = BLACK;

if (argc > 1) {
	switch (*argv[1]) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
				userfor = (*argv[1] - '0');
				break;
			default:
				bad1 = TRUE;
				break;
	}
	if (argc > 2) {
		switch (*argv[2]) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
				userbak = (*argv[2] - '0');
				break;
			default:
				bad2 = TRUE;
				break;
		}
	}
}
if ((userfor == userbak) || bad1 || bad2) {
	co(7);
	color(CYAN, BLACK);
	cls();
	printf("ZODEM:\n\t Invalid color options: %S", argv[1]);
	if (argc > 2)
		printf(" %s\n", argv[2]);
	printf("\n\n\n Arguments to ZODEM are text color & background color!\n");
	printf("\n\n\tTry: ZODEM 6 1\n");
	printf("\n\n\t\t0 = Black\n\t\t1 = Blue\n\t\t2 = Red\n\t\t3 = Magenta");
	printf("\n\t\t4 = Green\n\t\t5 = Cyan\n\t\t6 = Yellow\n\t\t7 = White\n");
	printf("\nIt is illegal to have both the text and the background the same color!\n");
	exit(1);
}

setnoc();	/* **** do NOT allow user's control-C to abort ANYTHING */

printf("%cv", ESC);	/* enable wrap at end of line */
 /* sign on */
	cls();
	rev();
	color(YELLOW, BLACK);
	printf("    ZODEM ");
	color(CYAN, BLACK);
	printf(" - a remote communications program.  By: Rich Bono WA1WMB");
	printf("  Vers. %1d.%1d  \n", MAJREV, MINREV);
	nor();
	delay(100);

/* set up default values */
	AsciiFlg = ShowRecv = ShowTrans = tflag = BFlag = View = filtrlf = FALSE;
	Recho = Echo = split = baudot = figs = FALSE;
	funckey = ~FALSE; /* start in function key mode */
	TxtPtr = 0;
	lfcount = 0;
	charaddr = 1;	/* start user characters at position 1 */
	lineaddr = 1;	/* start user screen at line 1 */
	promptlin = 1;
	tdelay = 0;	/* turn-around delay set to 0 */
	ViewMode = KbData = NULL;
	dosbaud = auxcnfg(ERR);	/* set up default user's baudrate */
	ascbaud = dosbaud;	/* start ZODEM baud rate the same */

	color(userfor, userbak);
	cleanscr();
	printf("\n\nUse the HELP key for intructions!\n\n");
	initializemodem();

	/* the I/O loop */
	/* get a character from the keyboard */

	while (ctsready() && (KbData != BREAK)) {

		if (csts()) {	/* get any char at kbd */
			if (funckey)
				KbData = getkey(); /* decode function keys */
			else
				KbData = ci();	/* pass function keys */
			zodemkey(KbData);	/* handle key kit */
		}

	/* get a character from the AUX port */

		if (minprdy()) {
			MoData = mcharinp();

			if ((Recho) && (!split)) {
				mcharout(MoData);
				/* when in echo mode, auto LF on CR */
			/*	if (MoData == CR)
					mcharout(LF); */
			}
			if (BFlag && (TxtPtr < BUFSIZ))
				Bufbuf[TxtPtr++] = MoData;
			else if (BFlag) {
				mcharout(XOFF);
				write(BFd, Bufbuf, TxtPtr);
				TxtPtr = 0;
				Bufbuf[TxtPtr++]=MoData;
				mcharout(XON);
			}
			if (MoData == LF) {
				if (split) {
					lfcount++;
					if (lfcount >= 12) {
						lfcount = 12;
						curaddr(1, 13);
						deline();
						if (BFlag)
							curaddr(2, 24);
						else
							curaddr(1, 24);
					} else {
						co(MoData);
					}
				} else {
					co(MoData);
				}
			} else
				co(MoData);
		/*	if ((MoData == CR) && Echo && !split)
				co(LF); */

			if (BFlag) {
				if (MoData == LF) {
					cursav();
					co(CR);
					rev();
					co('{');	/* show buffer active */
					nor();
					curres();
				}
				if (MoData == CR) {
					co(ESC);
					co('C');	/* cursor forward */
				}
			}


		}
	}
	if (TxtPtr) {
		Bufbuf[TxtPtr] = CTRLZ;
		write(BFd, Bufbuf, 1 + (TxtPtr));
		close(BFd);
		color(BLACK, CYAN);
		begprompt();
		printf("Buffer auto-saved as %s", BFileName);
		color(CYAN, BLACK);
		endprompt();
	}
printf("%cz", ESC);	/* set back to power up defaults */
auxcnfg(dosbaud);	/* restore DOS baud rate to it's default */
printf("\n\n\t*BREAK* exiting from ZODEM!\n\n");
exit(0);
}

/* end of ZODEM.C */
