h48610
s 00043/00124/00021
d D 1.3 82/09/13 13:01:20 ross 3 2
c New mx driver header file.
e
s 00000/00000/00145
d D 1.2 82/09/13 11:05:29 ross 2 1
c 
e
s 00145/00000/00000
d D 1.1 82/09/13 10:17:31 ross 1 0
e
u
U
t
T
I 1
D 3
#define	NGROUPS		10	/* number of mpx files permitted at one time */
#define	NCHANS		20	/* number of channel structures */
#define	NPORTS		30	/* number of channels to i/o ports */
#define	CNTLSIZ		10
#define	NLEVELS		4
#define	NMSIZE		50	/* max size of mxlstn file name */

E 3
/*
D 3
 * header returned on read of mpx
E 3
I 3
 *   New multiplexed file driver   --   Ross Nealon.
E 3
 */
D 3
struct	rh {
	short	index;
	short	count;
	short	ccount;
};
E 3

D 3
/*
 * head expected on write of mpx
 */
struct	wh {
	short	index;
	short	count;
	short	ccount;
	char	*data;
};
E 3
I 3
#define		NCHAN		64		/* max # of chans */
#define		NMXCHAN		16		/* max chans/mx file */
#define		NMXF		5		/* max # of multiplexed files */
E 3

D 3
struct	mx_args {
	char	*m_name;
	int	m_cmd;
	int	m_arg[3];
};
E 3
I 3
#define		MXMAGIC		0x77112233	/* unlikely data pattern */
E 3

I 3
#define		MXTHRESH	1		/* max data msgs buffered */
#define		MXMAXMSG	512		/* max size of message */
E 3

D 3
#ifdef KERNEL
/*
 * internal structure for channel
 */
E 3
I 3
#define		DEAD(dev)	(minor(dev) == NMXF)
E 3

D 3
struct chan {
	short	c_flags;
	char	c_index;
	char	c_line;
	struct	group	*c_group;
	struct	file	*c_fy;
	struct	tty	*c_ttyp;
	struct	clist	c_ctlx;
	int	c_pgrp;
	struct	tty	*c_ottyp;
	char	c_oline;
	union {
		struct	clist	datq;
	} cx;
	union {
		struct	clist	datq;
		struct	chan	*c_chan;
	} cy;
	struct	clist	c_ctly;
};
E 3

D 3
struct schan {
	short	c_flags;
	char	c_index;
	char	c_line;
	struct	group	*c_group;
	struct	file	*c_fy;
	struct	tty	*c_ttyp;
	struct	clist	c_ctlx;
	int	c_pgrp;
};
E 3
I 3
struct	mxf	{				/* multiplexed file */
	short	mx_flags;			/* mode of this mx file */
	short	mx_nchan;			/* chans open/active */
	struct	mxchan	*mx_chan[NMXCHAN];	/* pointers into chan table */
	struct	inode	*mx_ip;			/* incode inode for mx file */
	};
E 3

I 3
struct	hdr	{				/* data record header */
	short	hd_index;			/* chan number */
	short	hd_msg;				/* msg from mx driver */
	short	hd_length;			/* length of data message */
	};
E 3

D 3
/*
 * flags
 */
#define	INUSE	01
#define COPEN	02
#define	XGRP	04
#define	YGRP	010
#define	WCLOSE	020
#define	ISGRP	0100
#define	BLOCK	0200
#define	EOTMARK	0400
#define	SIGBLK	01000
#define	BLKMSG	01000
#define	ENAMSG	02000
#define	WFLUSH	04000
#define	NMBUF	010000
#define	PORT	020000
#define	ALT	040000
E 3
I 3
struct	mxmsg	{
	struct	hdr	m_h;			/* message header */
	struct	mxmsg	*m_link;		/* chain */
	char	m_data[ ];			/* following data pattern */
	};
E 3

D 3
#endif
E 3
I 3
struct	message	{				/* data message format */
	struct	hdr	hd;			/* header: who sent it */
	char	data[ ];			/* form of message data */
	};
E 3


I 3
#define		MXALLOC		0x0001		/* chan struct is used */
#define		MXTTY		0x0002		/* chan connection is to tty */
#define		MXCLOSED	0x0040		/* closef already done */
#define		MXSLEEP		0x0080		/* someone sleeping here */
#define		MXERROR		0x0400		/* chan error occurred */
E 3


D 3





E 3
/*
D 3
 * mpxchan command codes
E 3
I 3
 *   System call function
E 3
 */
D 3
#define	MPX	5
#define	MPXN	6
#define	CHAN	1
#define JOIN	2
#define EXTR	3
#define	ATTACH	4
#define	CONNECT	7
#define	DETACH	8
#define	DISCON	9
#define DEBUG	10
#define	NPGRP	11
#define	CSIG	12
#define PACK	13
E 3
I 3
#define		MXSCREATE	1		/* sys call - create */
#define		MXSATTACH	2		/* sys call - attach */
#define		MXSDETACH	3		/* sys call - detach */
E 3

D 3
#define NDEBUGS	30
/*
 * control channel message codes
 */
#define M_WATCH 1
#define M_CLOSE 2
#define	M_EOT	3
#define	M_OPEN	4
#define	M_BLK	5
#define	M_UBLK	6
#define	DO_BLK	7
#define	DO_UBLK	8
#define	M_IOCTL	12
#define	M_SIG	14
E 3

D 3

E 3
/*
D 3
 * debug codes other than mpxchan cmds
E 3
I 3
 *   Control messages
E 3
 */
D 3
#define MCCLOSE 29
#define MCOPEN	28
#define	ALL	27
#define SCON	26
#define	MSREAD	25
#define	SDATA	24
#define	MCREAD	23
#define MCWRITE	22

E 3
I 3
#define		M_DATA		0		/* normal data message */
#define		M_WATCH		1		/* wanting to open */
#define		M_CLOSE		2		/* has closed chan */
#define		M_EOF		3		/* end-of-file occured */
#define		M_IOCTL		4		/* ioctl sys call */
E 3
E 1
