/*
 *   Device driver information block.
 */
struct	dskmap	{
	int	dm_offset;			/* block offset */
	int	dm_size;			/* number of blocks */
	};

/*
 *   I/O driver time out structure.
 */
struct	iotimer	{
	time_t	iot_time;			/* when request placed */
	long	iot_duratn;			/* how long to allow to idle */
	int	(*iot_fn)();			/* called on time out */
	int	iot_arg;			/* with this arg */
	};

/*
 *   I/O device driver control block.
 */
struct	inf	{
	short	inf_addr;			/* device address */
	short	inf_cntl;			/* controller address */
	short	inf_ncntl;			/* controller minor dev# */
	short	inf_selch;			/* channel address */
	short	inf_nselch;			/* channel minor dev# */

	short	inf_cyl;			/* cylinder number */
	short	inf_head;			/* head number */
	short	inf_sector;			/* sector number */
	short	inf_flags;			/* preparatory flags */
	short	inf_errcnt;			/* error retrys */

	short	inf_ccyl;			/* current cylinder number */
	short	inf_active;			/* activity state */
	short	inf_dir;			/* arm direction */
	short	inf_dn;				/* disc number for monitoring */
	short	inf_dev;			/* for i/o time out timer */

	long	inf_type;			/* type of device */
	long	inf_sad;			/* channel start address */
	long	inf_ead;			/* channel end address */
	long	inf_fad;			/* channel final address */
	long	inf_last;			/* last place/cyl/block */
	long	inf_nblk;			/* size of transfer */

	char		*inf_actf;		/* I/O queue for this pass */
	char		*inf_actl;		/* I/O queue - last buffer */
	char		*inf_actv;		/* current active "buffer" */
	char		*inf_nxtf;		/* next pass queue */
	char		*inf_nxtl;		/* next pass last buffer */
	struct	dskmap	inf_map[8];		/* subdisc map */

	long	inf_count;			/* general counter */
	short	inf_hd;				/* list tracker */
	short	inf_tl;				/* " */
	short	inf_daddr;			/* mux'd address */
	short	inf_dmsg;			/* message code */
	char	inf_data[8];			/* general data buffer */
	};


struct	cntltab		{
	int		c_state;		/* state of controller */
	struct	inf	*c_inf;			/* inf structure of active i/o */
	struct	selchq	c_scq;			/* channel queue */
	};


#define		NRETRY		10		/* default number of retrys */
#define		DIR_IN		1		/* towards spindle or forward */
#define		DIR_OUT		-1		/* away from spindle or backward */

/*
 *   Synchronizing states.
 *	For the controller table.
 */
#define		C_IDLE		0		/* controller idle */
#define		C_BUSY		1		/* controller busy */
#define		C_AGAIN		2		/* seek completed early */

/*
 *   Device activity states.
 */
#define		DNRDY		-1		/* disc not ready */
#define		DNACT		0		/* disc not active */
#define		WSTART		1		/* waiting to start operation */
#define		WALT		2		/* waiting for alt channel */
#define		WSEEK		3		/* waiting for seek to complete */
#define		WSELCH		4		/* waiting for selch */
#define		WSIO		5		/* waiting to start i/o */
#define		WIO		6		/* waiting for i/o */
#define		WRELEASE	7		/* i/o done */
#define		WRESTORE	8		/* waiting for reset */
#define		WSERVO		9		/* waiting for servo offset */


/*
 *   Codes for error handler.
 */
#define		DEVICE		0		/* device address */
#define		CONTROLLER	1		/* device controller */
#define		CHANNEL		2		/* device channel */
#define		DEV000		3		/* restore - error already called */


/*
 *   Seek position codes.
 *	- Must be invalid cylinder numbers.
 */
#define		OFFCYL		-1		/* heads not loaded, or unknown position */
#define		SEEKING		-2		/* known to be moving */


/*
 *   Common Device/Controller interrupt control commands
 */
#define		DISABLE		0x80		/* queue, but don't deliver */
#define		ENABLE		0x40		/* pass interrupts */
#define		DISARM		0xc0		/* DISABLE|ENABLE */


/*
 *   State variables.
 */
extern	int	ncntl;
extern	int	nselch;
extern	struct	cntltab	cntltab[ ];
extern	struct	buf	rawbuf[ ];

extern	int	ndevs;
extern	struct	iotimer	iotimer[ ];
