/*
 * Auto-driver channel control block
 */

struct ccb {
	short	cc_ccw;		/* channel command word */
	short	cc_cnt0;	/* buffer 0 count */
	char	*cc_buf0;	/* buffer 0 end address */
	short	cc_chk;		/* check word */
	short	cc_cnt1;	/* buffer 1 count */
	char	*cc_buf1;	/* buffer 1 end address */
	char	*cc_tab;	/* translate table address */
	short	cc_subr;	/* subroutine entry address */
	short	cc_pad;
};

extern struct ccb	ccb[];	/* defined in L.s (addresses must be <64K) */

/*
 * Command word bits
 */

#define	CCEX	0x80		/* execute */
#define	CCWR	0x04		/* write */
#define	CCRD	0x00		/* read */
#define CCFAST	0x01		/* fast mode */


/*
 *   Auto channel driver options.
 */
#define		CC_OFF		0x0
#define		CC_OUTPUT	0x1
#define		CC_INPUT	0x2
#define		CC_SELCH	0x4
#define		CC_IO		(CC_INPUT|CC_OUTPUT)
#define		CC_DMA		(CC_SELCH|0x8)
#define		CC_SELIN	(CC_SELCH|CC_INPUT)
#define		CC_SELOUT	(CC_SELCH|CC_OUTPUT)
#define		CC_SELIO	(CC_SELCH|CC_IO)
