/*
 *   Information about a device waiting to use a selector channel
 */
struct	selchq	{
	int	(*sq_sstart)();		/* startup routine when selch is free */
	int	(*sq_sintr)();		/* selch interrupt routine */
	struct	selchq	*sq_forw;	/* next device waiting for channel */
	long	sq_param;		/* parameter to pass to sintr() */
	};

struct	selchtab	{
	struct	selchq	*sc_actf;
	struct	selchq	*sc_actl;
	};


/*
 *   Selector channel commands
 */
#define	STOP		0x48
#define	GO		0x50
#define	READ_GO		0x70
#define SELCHBSY	0x08
#define	RDEXAD		0x40
#define	SELSTAT		0x04
#define	SELCHMM		0x20
#define	SELCHPF		0x10
