#include	<stdio.h>

/*
 *   MCS8400 501 complement typeface font maker.
 *
 *	Supply the widths in 501 order (118 values), and the name
 *	of the font (argv[1]), and this will make the troff font
 *	width table (ftXX.c), and the mcs compensator table (wdXX.c).
 */

int	ft[256-32];				/* troff ft table */
int	wd[1+118];				/* compensator */
char	name[16]	=	"XX";
char	ftname[16]	=	"ftXX.c";
char	wdname[16]	=	"wdXX.c";
FILE	*WD, *FT, *IN;				/* file descriptors */

char	*wdchar[1+118]	=	{		/* 501 character names */
	"---unassigned---",
	"t",
	"o",
	"h",
	"n",
	"m",
	"l",
	"r",
	"g",
	"i",
	"p",
	"c",
	"v",
	"e",
	"z",
	"d",
	"b",
	"s",
	"y",
	"f",
	"x",
	"a",
	"w",
	"j",
	"u",
	"q",
	"k",
	"T",
	"O",
	"H",
	"N",
	"M",
	"L",
	"R",
	"G",
	"I",
	"P",
	"C",
	"V",
	"E",
	"Z",
	"D",
	"B",
	"S",
	"Y",
	"F",
	"X",
	"A",
	"W",
	"J",
	"U",
	"Q",
	"K",
	"_ baseline rule",
	".",
	",",
	"0",
	"1",
	"2",
	"3",
	"4",
	"5",
	"6",
	"7",
	"8",
	"9",
	";",
	":",
	"$",
	"+",
	"m bullet",
	"?",
	"- n dash",
	"*",
	"degree",
	"- minus",
	"+-",
	"divide",
	"times",
	"equals",
	"dagger",
	"double dagger",
	"section",
	"@",
	"&",
	")",
	"(",
	"!",
	". leader",
	"- hyphen",
	"- m dash",
	"n bullet",
	"%",
	"]",
	"[",
	"1/3",
	"2/3",
	"rt '",
	"lf `",
	"1/4",
	"3/4",
	"1/2",
	"/",
	"open star",
	"{",
	"}",
	"|",
	"paragraph",
	"filled square",
	"left triangle",
	"right triangle",
	"' foot",
	"\" inches",
	"filled star",
	"tick,check",
	"# sharp",
	"registered",
	"copyright",
	"box"
	};

char	*ftchar[256-32]	=	{		/* troff font names */
	"space",
	"!",
	"\"",
	"#",
	"$",
	"%",
	"&",
	"' close",
	"(",
	")",
	"*",
	"+",
	",",
	"- hyphen",
	".",
	"/",
	"0",
	"1",
	"2",
	"3",
	"4",
	"5",
	"6",
	"7",
	"8",
	"9",
	":",
	";",
	"<",
	"=",
	">",
	"?",
	"@",
	"A",
	"B",
	"C",
	"D",
	"E",
	"F",
	"G",
	"H",
	"I",
	"J",
	"K",
	"L",
	"M",
	"N",
	"O",
	"P",
	"Q",
	"R",
	"S",
	"T",
	"U",
	"V",
	"W",
	"X",
	"Y",
	"Z",
	"[",
	"\\",
	"]",
	"^",
	"_ underrule",
	"` open",
	"a",
	"b",
	"c",
	"d",
	"e",
	"f",
	"g",
	"h",
	"i",
	"j",
	"k",
	"l",
	"m",
	"n",
	"o",
	"p",
	"q",
	"r",
	"s",
	"t",
	"u",
	"v",
	"w",
	"x",
	"y",
	"z",
	"{",
	"|",
	"}",
	"~",
	"narrow space",
	"hyphen",
	"bullet",
	"square",
	"3/4 em",
	"rule",
	"1/4",
	"1/2",
	"3/4",
	"minus",
	"fi",
	"fl",
	"ff",
	"ffi",
	"ffl",
	"degree",
	"dagger",
	"section",
	"foot mark",
	"' acute accent",
	"` grave accent",
	"_ underrule",
	"slash (longer)",
	"half nar sp",
	"",
	"alpha",
	"beta",
	"gamma",
	"delta",
	"epsilon",
	"zeta",
	"eta",
	"theta",
	"iota",
	"kappa",
	"lambda",
	"mu",
	"nu",
	"xi",
	"omicron",
	"pi",
	"rho",
	"sigma",
	"tau",
	"upsilon",
	"phi",
	"chi",
	"psi",
	"omega",
	"Gamma",
	"Delta",
	"Theta",
	"Lambda",
	"Xi",
	"Pi",
	"Sigma",
	"",
	"Upsilon",
	"Phi",
	"Psi",
	"Omega",
	"square root",
	"terminal sigma",
	"root en",
	">=",
	"<=",
	"identically equal",
	"minus",
	"approx =",
	"approximates",
	"not equal",
	"right arrow",
	"left arrow",
	"up arrow",
	"down arrow",
	"equal",
	"multiply",
	"divide",
	"plus-minus",
	"cup (union)",
	"cap (intersection)",
	"subset of",
	"superset of",
	"improper subset",
	"improper superset",
	"infinity",
	"partial derivative",
	"gradient(del)",
	"not",
	"integral sign",
	"proportional to",
	"empty set",
	"member of",
	"plus",
	"registered",
	"copyright",
	"box vert rule",
	"cent",
	"dbl dagger",
	"right hand",
	"left hand",
	"math *",
	"bell system sign",
	"or",
	"circle",
	"left top (of big curly)",
	"left bottom",
	"right top",
	"right bot",
	"left center of big curly bracket",
	"right center of big curly bracket",
	"bold vertical",
	"left floor (left bot of big sq bract)",
	"right floor (rb of ])",
	"left ceiling (lt of [)",
	"right ceiling (rt of ])",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	};


main(argc, argv)
char *argv[ ];
{
	register char *p;


	if (argc != 2)
		return(1);

	p = argv[1];
	name[0] = *p;  name[1] = *(p+1);
	wdname[2] = *p;  wdname[3] = *(p+1);
	ftname[2] = *p;  ftname[3] = *(p+1);

	WD = fopen(wdname, "w");
	if (WD == NULL)  {
		printf("Can't make wd table\n");
		exit(1);
		}

	FT = fopen(ftname, "w");
	if (FT == NULL)  {
		printf("Can't make ft table\n");
		exit(1);
		}

	IN = fopen(name, "r");
	if (IN == NULL)  {
		printf("Can't open width file\n");
		exit(1);
		}

	rdwidths();
	wtwd();
	mkft();
	wtft();

	exit(0);
}


rdwidths()
{
	register int i;
	register int n;
	register c;

	for (i=1; i<=118; i++)  {
		n = 0;
		while ((c = getch(IN)) > 0)
			n = n * 10 + c - '0';

		if (n == 0)
			exit(2);

		wd[i] = n;
		}

	return;
}


wtwd()
{
	register int i;


	fprintf(WD, "int	%s[1+118]	=	{\n", name);
	for (i=0; i<=118; i++)
		fprintf(WD, "	%d,		/* %s */\n",
				wd[i]/3, wdchar[i]);
	fprintf(WD, "	};\n");
}


wtft()
{
	register int i;

	fprintf(FT, "char	%sw[256-32]	=	{\n", name);
	for (i=0; i<256-32; i++)
		fprintf(FT, "	%d,		/* %s */\n",
				(ft[i]*2)/3, ftchar[i]);
	fprintf(FT, "	};\n");
}


mkft()
{
	ft[  0] = 12*3/2;
	ft[  1] = wd[ 87];
	ft[  2] = wd[112];
	ft[  3] = wd[115];
	ft[  4] = wd[ 68];
	ft[  5] = wd[ 92];
	ft[  6] = wd[ 84];
	ft[  7] = wd[ 97];
	ft[  8] = wd[ 86];
	ft[  9] = wd[ 85];
	ft[ 10] = wd[ 73];
	ft[ 11] = wd[ 69];
	ft[ 12] = wd[ 55];
	ft[ 13] = wd[ 89];
	ft[ 14] = wd[ 54];
	ft[ 15] = wd[102];
	ft[ 16] = wd[ 56];
	ft[ 17] = wd[ 57];
	ft[ 18] = wd[ 58];
	ft[ 19] = wd[ 59];
	ft[ 20] = wd[ 60];
	ft[ 21] = wd[ 61];
	ft[ 22] = wd[ 62];
	ft[ 23] = wd[ 63];
	ft[ 24] = wd[ 64];
	ft[ 25] = wd[ 65];
	ft[ 26] = wd[ 67];
	ft[ 27] = wd[ 66];
	ft[ 28] = 0;
	ft[ 29] = wd[ 79];
	ft[ 30] = 0;
	ft[ 31] = wd[ 71];
	ft[ 32] = wd[ 83];
	ft[ 33] = wd[ 47];
	ft[ 34] = wd[ 42];
	ft[ 35] = wd[ 37];
	ft[ 36] = wd[ 41];
	ft[ 37] = wd[ 39];
	ft[ 38] = wd[ 45];
	ft[ 39] = wd[ 34];
	ft[ 40] = wd[ 29];
	ft[ 41] = wd[ 35];
	ft[ 42] = wd[ 49];
	ft[ 43] = wd[ 52];
	ft[ 44] = wd[ 32];
	ft[ 45] = wd[ 31];
	ft[ 46] = wd[ 30];
	ft[ 47] = wd[ 28];
	ft[ 48] = wd[ 36];
	ft[ 49] = wd[ 51];
	ft[ 50] = wd[ 33];
	ft[ 51] = wd[ 43];
	ft[ 52] = wd[ 27];
	ft[ 53] = wd[ 50];
	ft[ 54] = wd[ 38];
	ft[ 55] = wd[ 48];
	ft[ 56] = wd[ 46];
	ft[ 57] = wd[ 44];
	ft[ 58] = wd[ 40];
	ft[ 59] = wd[ 94];
	ft[ 60] = 0;
	ft[ 61] = wd[ 93];
	ft[ 62] = 0;
	ft[ 63] = wd[ 53];
	ft[ 64] = wd[ 98];
	ft[ 65] = wd[ 21];
	ft[ 66] = wd[ 16];
	ft[ 67] = wd[ 11];
	ft[ 68] = wd[ 15];
	ft[ 69] = wd[ 13];
	ft[ 70] = wd[ 19];
	ft[ 71] = wd[  8];
	ft[ 72] = wd[  3];
	ft[ 73] = wd[  9];
	ft[ 74] = wd[ 23];
	ft[ 75] = wd[ 26];
	ft[ 76] = wd[  6];
	ft[ 77] = wd[  5];
	ft[ 78] = wd[  4];
	ft[ 79] = wd[  2];
	ft[ 80] = wd[ 10];
	ft[ 81] = wd[ 25];
	ft[ 82] = wd[  7];
	ft[ 83] = wd[ 17];
	ft[ 84] = wd[  1];
	ft[ 85] = wd[ 24];
	ft[ 86] = wd[ 12];
	ft[ 87] = wd[ 22];
	ft[ 88] = wd[ 20];
	ft[ 89] = wd[ 18];
	ft[ 90] = wd[ 14];
	ft[ 91] = wd[104];
	ft[ 92] = wd[106];
	ft[ 93] = wd[105];
	ft[ 94] = 0;
	ft[ 95] = 6*3/2;
	ft[ 96] = wd[ 89];
	ft[ 97] = wd[ 70];
	ft[ 98] = wd[118];
	ft[ 99] = wd[ 90];
	ft[100] = wd[ 53];
	ft[101] = wd[ 99];
	ft[102] = wd[101];
	ft[103] = wd[100];
	ft[104] = wd[ 75];
	ft[105] = wd[ 19] + wd[  9];
	ft[106] = wd[ 19] + wd[  6];
	ft[107] = wd[ 19] + wd[ 19];
	ft[108] = wd[ 19] + wd[ 19] + wd[  9];
	ft[109] = wd[ 19] + wd[ 19] + wd[  6];
	ft[110] = wd[ 74];
	ft[111] = wd[ 80];
	ft[112] = wd[ 82];
	ft[113] = wd[ 80];
	ft[114] = 0;
	ft[115] = 0;
	ft[116] = wd[ 53];
	ft[117] = wd[102];
	ft[118] = 10;
	ft[119] = 0;
	ft[120] = 0;
	ft[121] = 0;
	ft[122] = 0;
	ft[123] = 0;
	ft[124] = 0;
	ft[125] = 0;
	ft[126] = 0;
	ft[127] = 0;
	ft[128] = 0;
	ft[129] = 0;
	ft[130] = 0;
	ft[131] = 0;
	ft[132] = 0;
	ft[133] = 0;
	ft[134] = 0;
	ft[135] = 0;
	ft[136] = 0;
	ft[137] = 0;
	ft[138] = 0;
	ft[139] = 0;
	ft[140] = 0;
	ft[141] = 0;
	ft[142] = 0;
	ft[143] = 0;
	ft[144] = 0;
	ft[145] = 0;
	ft[146] = 0;
	ft[147] = 0;
	ft[148] = 0;
	ft[149] = 0;
	ft[150] = 0;
	ft[151] = 0;
	ft[152] = 0;
	ft[153] = 0;
	ft[154] = 0;
	ft[155] = 0;
	ft[156] = 0;
	ft[157] = 0;
	ft[158] = 0;
	ft[159] = 0;
	ft[160] = 0;
	ft[161] = 0;
	ft[162] = wd[ 75];
	ft[163] = 0;
	ft[164] = 0;
	ft[165] = 0;
	ft[166] = 0;
	ft[167] = 0;
	ft[168] = 0;
	ft[169] = 0;
	ft[170] = wd[ 79];
	ft[171] = wd[ 78];
	ft[172] = wd[ 77];
	ft[173] = wd[ 76];
	ft[174] = 0;
	ft[175] = 0;
	ft[176] = 0;
	ft[177] = 0;
	ft[178] = 0;
	ft[179] = 0;
	ft[180] = 0;
	ft[181] = 0;
	ft[182] = 0;
	ft[183] = 0;
	ft[184] = 0;
	ft[185] = 0;
	ft[186] = 0;
	ft[187] = 0;
	ft[188] = wd[ 69];
	ft[189] = wd[116];
	ft[190] = wd[117];
	ft[191] = wd[106];
	ft[192] = 0;
	ft[193] = wd[ 81];
	ft[194] = 0;
	ft[195] = 0;
	ft[196] = wd[ 73];
	ft[197] = 0;
	ft[198] = 0;
	ft[199] = 0;
	ft[200] = 0;
	ft[201] = 0;
	ft[202] = 0;
	ft[203] = 0;
	ft[204] = 0;
	ft[205] = 0;
	ft[206] = 0;
	ft[207] = 0;
	ft[208] = 0;
	ft[209] = 0;
	ft[210] = 0;
	ft[211] = 0;
	ft[212] = 0;
	ft[213] = 0;
	ft[214] = 0;
	ft[215] = 0;
	ft[216] = 0;
	ft[217] = 0;
	ft[218] = 0;
	ft[219] = 0;
	ft[220] = 0;
	ft[221] = 0;
	ft[222] = 0;
	ft[223] = 0;
}


getch(f)
FILE *f;
{
	char c;

	if ((c = getc(f)) == EOF)
		return(0);
	if (c == '\n')
		return(-1);
	return(c);
}
