/*
 *   MCS 8400 text file decoder.
 */

int	cmd;
int	arg;
int	c;
int	longform;


main()
{
	for (;;)  {
		longform = 0;
		if (!getcmd())
			return(0);

		if (!cmd)
			/* Null command - ignore */
			continue;

		if (cmd & 0x80)
			/* Special command */
			getarg();

		/* getarg may turn off the special command feature */
		if (cmd & 0x80)  switch (cmd)  {
			case 0x80:
				printf("Start of take %d\n", arg);
				break;

			case 0x81:
				printf("End of take\n");
				break;

			case 0x83:
				printf("Reverse type ");
				if (arg)
					printf("on\n");
				else
					printf("off\n");
				break;

			case 0x85:
				printf("Initialise reverse lead mode\n");
				break;

			case 0x87:
				printf("Point size ");
				size2(arg/4);
				printf("\n");
				break;

			case 0x88:
				printf("Set size ");
				size8(arg);
				printf("\n");
				break;

			case 0x89:
				printf("Vertical move forward ");
				size16(arg);
				printf("\n");
				break;

			case 0x8a:
				printf("Vertical move backward ");
				size16(arg);
				printf("\n");
				break;

			case 0x8b:
				printf("Horizontal position ");
				size18(arg);
				printf("\n");
				break;

			case 0x8c:
				printf("Rule width ");
				size18(arg);
				printf("\n");
				break;

			case 0x8d:
				printf("Rule depth ");
				size16(arg);
				printf("\n");
				break;

			case 0x8e:
				printf("Insert rule & move to ");
				size18(arg);
				printf("\n");
				break;

			case 0x8f:
				printf("Slant ");
				size4(arg);
				printf("\n");
				break;

			case 0x99:
				printf("Font %d\n", arg);
				break;

			case 0x9b:
				printf("Move right ");
				size18(arg);
				printf("\n");
				break;

			case 0x9c:
				printf("Move left ");
				size18(arg);
				printf("\n");
				break;
			}
		else  {
			/* Normal character */
			printf("Character %d  ", cmd);
			if (longform)
				size18(arg);
			printf("\n");
			}
		}
}


getcmd()
{
	c = getch();
	if (c < 0)
		return(0);

	cmd = c;
	return(1);
}

getarg()
{
	arg = getch();
	c   = getch();

	if (!(arg & 0x80))
		/* Long character form */
		longform++;

	arg &= ~0x80;
	arg = (arg << 8) | c;
	return;
}

getch()
{
	register int k;

	while ((k = getchar()) == '\n' || k == 0x0e);
	if (k < 0)
		return(-1);
	return((to(k)<<4) | to(getchar()));
}

to(n)
{
	if (n >= '0' && n <= '9')
		return(n - '0');
	if (n >= 'A' && n <= 'F')
		return(n - 'A' + 10);
	return(0);
}

size2(a)
{
	if (a & 01)
		printf("%d.5 points ", a>>1);
	else
		printf("%d points ", a>>1);
}

size4(a)
{
}

size8(a)
{
}

size16(a)
{
	if (!(a % 16))
		printf("%d points ", a/16);
	else
		printf("%d %d/16 points ", a/16, a%16);
}

size18(a)
{
	if (!(a % 18))
		printf("%d points ", a/18);
	else
		printf("%d %d/18 points ", a/18, a%18);
}
