h56217
s 00185/00000/00000
d D 1.1 82/08/02 15:48:25 cecily 1 0
e
u
U
t
T
I 1
#include	<stdio.h>
#include	<signal.h>

#define		TRUE		1
#define		FALSE		0
#define		NMOUNT		32
#define		FNS		128


/*
 *   mount command: examine mount table, or mount given device.
 */

struct	m	{
	char	sp[FNS];
	char	dp[FNS];
	char	cp[FNS];
	char	fp[FNS];
	}	m[NMOUNT];

char	*dev;
char	*dir;
char	*com;
char	path[128];
char	flags[26];


main(argc, argv)
char *argv[ ];
{
	register struct m *p;
	register int nmount;
	register int ro;
	register int up;
	register int i;
	register char *f;

	signal(SIGHUP, SIG_IGN);
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	signal(SIGTERM, SIG_IGN);

	/*  get all of mount table  */
	nmount = 0;
	p = &m[0];
	while (getmtab(p->sp, p->dp, p->cp, p->fp) >= 0)  {
		nmount++;
		p++;
		}

	if (argc < 2)  {
		/*  print mount table  */
		p = &m[0];
		while (nmount--)  {
			printf("%s\t%s\t", p->sp, p->dp);
			if (in('r', p->fp))
				str("read-only");
			if (p->cp[0])
				str(p->cp);
			str("\n");
			p++;
			}
		exit(0);
		}

	/*
	 *   mount device and update table
	 */
	dev = dir = NULL;
	ro = up = FALSE;
	for (i=1; --argc; i++)
		if (*argv[i] == '-')  switch (*(argv[i]+1))  {
			case 'u':
				/* update only */
				up = TRUE;
				break;

			case 'r':
				/* mount read-only */
				ro = TRUE;
				break;

			case 'c':
				/* comment */
				com = argv[i]+2;
				if (!*com)
					if (argc)  {
						com = argv[++i];
						argc--;
						}
				break;

			default:
				fprintf(stderr, "%s: -%c unknown\n", argv[0], *argv[i]+1);
				exit(1);
			}

		else  {
			if (!dev)
				dev = argv[i];
			else if (!dir)
				dir = argv[i];
			else
				fprintf(stderr, "%s: too many names\n", argv[0]);
			}

	/*  mount device  */
	if (!dev)  {
		fprintf(stderr, "%s: device required\n", argv[0]);
		exit(1);
		}

	if (*dir != '/')  {
		register FILE *pipe;
		register char *p;
		register c;

		pipe = popen("pwd", "r");
		if (pipe == NULL)  {
			fprintf(stderr, "%s: can't find pathname\n", argv[0]);
			exit(1);
			}
		else  {
			p = &path[0];
			while ((c = getc(pipe)) != '\n')
				*p++ = c;
			*p++ = '/';
			*p++ = NULL;
			dir = strcat(path, dir);
			}
		}

	if (!up)
		if (mount(dev, dir, ro) < 0)  {
			perror("mount");
			exit(1);
			}

	/*  update mount table  */
	p = &m[0];
	while (nmount--)  {
		putmtab(p->sp, p->dp, p->cp, p->fp);
		p++;
		}

	f = flags;
	if (ro)
		*f++ = 'r';

	putmtab(dev, dir, com, flags);

	exit(0);
}

in(c, s)
register char c;
register char *s;
{
	while (*s)  {
		if (*s == c)
			return(TRUE);
		s++;
		}

	return(FALSE);
}

str(s)
register char *s;
{
	static	int	sep	=	FALSE;

	if (sep  &&  *s  &&  *s != '\n')
		printf(", ");
	if (*s)
		sep++;

	while (*s)  {
		if (*s == '\n')
			sep = FALSE;
		putchar(*s++);
		}

	return;
}
E 1
