&version 2
&trace &all off
&ready_proc off
&-

&goto &ec_name

&label update

&- Usage: ec update MODULE LIB
&- Where:
&- MODULE is the pathname of the element to update.
&-    If a suffix is not given it is assumed to be a bound_xxx_ type of 
&-    element and bound_xxx_.**.s.archive, bound_xxx_.**.archive, and
&-    bound_xxx_ are updated into the source, object and executable
&-    libraries.  All matching elements are found in the directory
&-    containing MODULE (the working directory if not a pathname).
&-    If a suffix is present, then only that segment is updated.
&- LIB is the library: one of HARD, SSS, TOOLS, UNB, INCL, INFO, or a path.
&-    If a path, then that is the target directory.
&-    If not a path, LIB is the name of a standard system library.

&if &[nless &n 2] &then &do
      &print &ec_name.ec: Incorrect number of arguments supplied.
      &print Usage:  ec &ec_name MODULE LIB {-update_seg_args}
      &quit
&end

&set MODULE &1
&set LIB &2
&set Special false

&print Updating &(MODULE) into &(LIB).

&if &[nequal 0 [index [entry &(MODULE)] "."]]
&then &set Single false
&else &set Single true

&if &[equal &(LIB) SSS] &then &do
      &set SOURCE >ldd>sss>source
      &set OBJECT >ldd>sss>object
      &set EXEC   >sss
&end
&else &if &[equal &(LIB) TOOLS] &then &do
      &set SOURCE >ldd>tools>source
      &set OBJECT >ldd>tools>object
      &set EXEC   >tools
&end
&else &if &[equal &(LIB) UNB] &then &do
      &set SOURCE >ldd>unbundled>source
      &set OBJECT >ldd>unbundled>object
      &set EXEC   >unb
&end
&else &if &[equal &(LIB) HARD] &then &do
      &set SOURCE >ldd>hard>source
      &set OBJECT >ldd>hard>object
      &set EXEC   >ldd>hard>execution
&end
&else &if &[equal &(LIB) INFO] &then &do
      &set SOURCE >doc>info
      &set Special true
&end
&else &if &[equal &(LIB) INCL] &then &do
      &set SOURCE >ldd>include
      &set Special true
&end
&else &do
      &if &[equal 0 [search &(LIB) <>]] &then &do
      	  &print &ec_name.ec: Unknown library name. &(LIB)
	  &quit
      &end
      &set SOURCE &(LIB)
      &set Special true
&end

&if &(Special) &then &do
      ec &ec_dir>update_ &(MODULE) &(SOURCE) &rf3
&end
&else &if &(Single) &then &do
      &if &[not &(Special)] &then &do
      	  &print &ec_name.ec: Single modules require a pathname for the library.
	  &quit
      &end
      ec &ec_dir>update_ &(MODULE) &(LIB) &rf3
&end

&else &do
      &- This is (possibly) a multi-element installation (eg. bound_pl1_)
      ec &ec_dir>update_ ([segs &(MODULE)                                  -absp]) &(EXEC)
      ec &ec_dir>update_ ([segs &(MODULE).**.s.arc*                        -absp]) &(SOURCE)
      ec &ec_dir>update_ ([segs [do &(MODULE)&&1.arc* ("" .(1 2 3 4 5 6))] -absp]) &(OBJECT)
      &- we do get more that just a single archive in a bound unit, but < 7
&end

&quit

&label update_

&- Internal support for update.ec

&if &[nless &n 2] &then &do
      &print &ec_name.ec: Wrong number of arguments supplied.
      &quit
&end

&set Entry &[entry &1]
&if &[nequal 0 [index &(Entry) .]]
&then &set US_ARGS -ss
&else &if &[nless 0 [index &(Entry) .archive]]
&then &set US_ARGS -ac
&else &set US_ARGS ""

&if &[exists segment &2>&(Entry)]
&then update_seg replace &1 &2>== &(US_ARGS) &rf3
&else update_seg add     &1 &2>== &(US_ARGS) &rf3

&quit
