/**********************************************************************/
/*   Multics Standard Tape declarations for 32-bit systems            */
/**********************************************************************/

dcl 1 stand_label_record   based unaligned,        /* Multics std tape label */
      2 head               like mstr_header,       /* tape record header */
      2 installation_id    bit (32*9),             /* inst. that created tape */
      2 tape_reel_id       bit (32*9),             /* tape reel name */
      2 volume_set_id      bit (32*9),             /* name of the volume set */
      2 pad (1000)         bit (36),               /* record body */
      2 trail              like mstr_trailer;      /* record trailer */

dcl 1 mstr_header          based unaligned,        /* Multics std tape rec hdr */
      2 c1                 bit (36),               /* constant = 670314355245(8)*/
      2 uid                bit (72),               /* unique ID */
      2 rec_within_file    bit (18),               /* phys. rec. # within file */
      2 phy_file           bit (18),               /* phys. file # on tape */
      2 data_bits_used     bit (18),               /* # of bits of data in rec */
      2 data_bit_len       bit (18),               /* bit length of data space */
      2 flags,                                     /* record flags */
        3 admin            bit (1),                /* admin record flag */
        3 label            bit (1),                /* label record flag */
        3 eor              bit (1),                /* end-of-reel record flag */
        3 pad1             bit (11),
        3 set              bit (1),                /* ON if any of following set */
        3 repeat           bit (1),                /* repeated record flag */
        3 padded           bit (1),                /* record contains padding flg */
        3 eot              bit (1),                /* EOT reflector enc flg */
        3 drain            bit (1),                /* synchronous write flg */
        3 continue         bit (1),                /* continue on next reel flg */
        3 pad2             bit (4),
      2 header_version     bit (3),                /* current header version num */
      2 repeat_count       bit (9),                /* repetition count */
      2 checksum           bit (36),               /* checksum of header and trlr */
      2 c2                 bit (36);               /* constant = 512556146073(8) */

dcl 1 mstr_trailer         based unaligned,        /* Multics std tape record trlr*/
      2 c1                 bit (36),               /* constant = 107463422532(8) */
      2 uid                bit (72),               /* unique ID (matches header) */
      2 tot_data_bits      bit (36),               /* tot data bits wr on log tape*/
      2 pad_pattern        bit (36),               /* padding pattern */
      2 reel_num           bit (12),               /* reel sequence # */
      2 tot_file           bit (24),               /* phys. file number */
      2 tot_rec            bit (36),               /* phys. record # for log tape */
      2 c2                 bit (36);               /* constant = 265221631704(8) */

dcl 1 mst_label            based unaligned,        /* Bootable Tape Label    */
      2 xfer_vector        (4),
        3 lda_instr        bit(36),
        3 tra_instr        bit(36),
      2 head               like mstr_header,       /* tape record header */
      2 installation_id    bit (32*9),             /* inst. that created tape */
      2 tape_reel_id       bit (32*9),             /* tape reel name */
      2 volume_set_id      bit (32*9),             /* name of the volume set */
      2 fv_overlay   (0:31),
        3 scu_instr        bit(36),
        3 dis_instr        bit(36),
      2 fault_data      (8)bit(36),
      2 boot_pgm_path      bit(168*9),
      2 userid             bit(32*9),
      2 label_version      bit(36),
      2 output_mode        bit(36),
      2 boot_pgm_len       bit(36),
      2 copyright          bit(56*9),
      2 pad            (13)bit(36),
      2 boot_pgm      (840)bit(36),
      2 trail              like mstr_trailer;      /* record trailer */

dcl 1 volume_identifier    based,                  /* tape volume info */
      2 installation_id    bit (32*9),             /* installation that created tape */
      2 tape_reel_id       bit (32*9),             /* tape reel name */
      2 volume_set_id      bit (32*9);             /* name of the volume set */

dcl  (
      header_c1            init ('670314355245'),
      header_c2            init ('512556146073'),
      trailer_c1           init ('107463422532'),
      trailer_c2           init ('265221631704'),
      label_c1             init ('000004235000')
      )                    char(12) static;

dcl   LABEL_VERSION        fixed bin static init (3); /* current label version */
dcl   HEADER_VERSION       fixed bin static init (1); /* current header version */


