$PASCAL ',4,109 91781-16023 REV.2540 000000'$  {        NAME:         ROUTE.PAS 
  SOURCE:       91781-18023 

  RELOC:        91781-16023 
   PGMR:         P.T.C.    PURPOSE:      RJE post processor to rename files   DATE:         <851016.0826>                                                                 } $RECURSIVE OFF$ $RANGE off$  $HEAP 0$      PROGRAM route;      {    ROUTE is a post-processor for the RJE/1000 II subsystem which   supports the relocation of incoming print/punch streams.  The   post-processor uses a special comment card in the source JCL,    called the //*USER card, to determine the destination of the    stream.  Only host streams which contain the //*USER card in    the listing of the JCL may be redirected by ROUTE.       The Pascal constant "max_lines_read" determines the bounds on    the number of records in the host's stream which are to be    searched for the //*USER card.  This constant may be changed  
  to suit the users needs. 
        The //*USER card contains three parameters which determine the      destination of the stream, special functions to perform during    the relocation, and the name of a second post-processor which    may be scheduled after the successful completion of ROUTE.    The later two parameter may be omitted if desired.       The //*USER card is designed to appear like other JCL control    statements and must meet the following conditions:       1. The letters //*USER must start in column 1 of the JCL.   2. The //*USER card must be typed in all capital letters.    3. A parameter string follows the //*USER identifier, sep-      arated by at least on blank.   4. The parameters are to be separated by a single comma      with no imbedded blanks.    5. A comment field may follow the parameters, separated by       at least one blank.    6. The entire card must not exceed 80 columns in length, but       it is possible to continue the statement on another line.   7. If the statement is continued on another line, the split      in the first line may only occur between parameters, and      the comma MUST NOT be omitted.  The //*USER identifier       must appear in column 1 of all continued lines.       The 3 parameters are keyword parameters and are not position-   ally dependant.  They can be used anywhere in the operand   field with respect to one another.  There is no need to indi-   cate the absence of a parameter, but parameters may only be   listed once.  The following example of the //*USER card shows   the format of the parameters.  The "filename", "xx" and   "progname" below are to be filled in by the user.       //*USER DEST=filename,PARM=xx,CHAIN=progname    COMMENT FIELD        DEST=filename : The DEST parameter specified the destination     file for the incoming stream.        PARM=xx : The PARM parameter is a numeric value which deter-    mines the special functions to perform during the routing of    the stream.  If this parameter is omitted, a default value     of 0 is used.  The following numbers are legal:          0 : Perform a simple file copy      1 : Copy the file and purge the source      2 : Overwrite the existing file during the copy.      3 : Copy the file overwriting an existing copy and purge  
         the source. 
      CHAIN=progname : The CHAIN parameter determines the file name     of a second post-processor which will run after ROUTE has      terminated normally.  ROUTE passes this second post-processor     the new name of the stream as a run-string parameter.  The     second post-processor will NOT run if ROUTE has not succes-     sfully copied the stream.                                                                      }   $PAGE$     LABEL 99;         CONST      max_inp          = 80;        {maximum input character count}      max_buff         = 544;       {dcb buffer, smallest is 288}    buff_count       = 4;         {number of buffers in DCB}    param_pos        = 1;         {parm position in runstring}     error_lu         = 1;         {LU to send error messages}  !   valid_ftype      = 3;         {Only type 3 files are processed} ! !   E_O_F            = -1;        {end of file length from FmpRead} !    user_card        = '***USER'; {appearance of user card in JCL}      blank            = ' ';       {a blank character}     open_option      = 'RO';      {open for read of existing file}      option_0         = 'a';       {FmpCopy ascii file option}    option_1         = 'ap';      {FmpCopy ascii,purge option}     option_2         = 'ad';      {FmpCopy ascii,overwrite option}       option_3         = 'apd';     {FmpCopy ascii,purge,overwrite}      max_lines_read   = 150;       {line scanning limit}    max_parms        = 3;         {maximum number of user parms}    delimiter        = ',';       {delimiter in user card}    destination      = 'DEST=';   {destination identifier}    copy_option      = 'PARM=';   {copy option identifier}    chain_parm       = 'CHAIN=';  {chain program identifier}    err_header       = 'ROUTE error on '; {error message header}     error_1          = 'Bad RJE parameter';    error_2          = 'Bad //*USER card parameter';    error_3          = 'Non type 3 file ';     error_4          = 'DEST= parameter not found';     error_5          = 'Duplicate Parameter';      TYPE     int              = -32768..32767;    rmpar_type       = ARRAY[1..5] OF int;    xluex_cntwd      = ARRAY[1..2] OF int;     op_str           = STRING[4];    str80            = STRING[80];     str135           = STRING[135];     str256           = STRING[256];     pac80            = PACKED ARRAY[1..80] OF CHAR;    pac135           = PACKED ARRAY[1..135] OF CHAR;     dcb_type         = ARRAY[1..max_buff] OF int;    parsed_parms     = ARRAY[1..max_parms] OF str80;     VAR     error            : int;         {error code from fmp calls}    parms            : rmpar_type;  {parameters}     console          : xluex_cntwd; {Conole LU}    userout          : text;        {user's output file}    found            : BOOLEAN;     {true if user card detected}    open_ops         : op_str;      {open options for host file}    option           : op_str;      {option in FMP copy}     dcb_buffer       : dcb_type;    {2 DCBs for FMP copy}    dcb              : dcb_type;    {DCB of host's input file}    ftype            : int;         {file type of opened file}     user_parms       : str256;      {the parameters for user card}     inp_buf          : pac135;      {buffer read from FmpRead}     inp_rec          : str135;      {record read from host's file}      error_str        : str135;      {output error string}     error_buff       : pac135;      {error message printed}     error_msg_len    : int;         {length of error message}     old_file_name    : pac80;       {name of file in runstring}     file_name_length : int;         {length of file name}     old_file_str     : str80;       {name of file in runstring}    new_file_str     : str80;       {name of file to be created}      chain_name       : str80;       {name of next post processor}     parm_list        : parsed_parms;{array of parsed parameters}     run_string       : str135;      {run string for FmpRunProg}      run_name         : str80;       {the RTE name for scheduling}     d                : int;         {dummy variable}       {**************************************************************}          PROCEDURE print $ALIAS 'XLUEX'$    (    icode       : int;         {request code}          cntwd       : xluex_cntwd; {control words}         bufr        : pac135;      {buffer}         buf_len     : int);        {length of buffer}     EXTERNAL;     FUNCTION Pas_Parameters 
   $ALIAS 'Pas.Parameters'$ 
   (    position    : int;         {number of returned parms}      VAR parameter   : pac80;       {actual returned parameter}           length      : int): int;   {maximum length of parameter}      EXTERNAL;      FUNCTION FmpCopy  
   $FIXED_STRING ON$ 
    (    source      : str80;       {name of source file}     VAR err1        : int;         {error code}         dest        : str80;       {destination file}     VAR err2        : int;         {error code}     VAR buffer      : dcb_type;    {DCB buffer}         length      : int;         {length of buffer}          option      : op_str):int; {copy option}      $FIXED_STRING OFF$     EXTERNAL;      $PAGE$      FUNCTION FmpOpen  
   $FIXED_STRING ON$ 
   (VAR dcb         : dcb_type;    {DCB buffer}     VAR error       : int;         {error code}          filename    : str135;      {file name}         options     : op_str;      {open options}          buffers     : int):int;    {number of DCB buffers} 
   $FIXED_STRING OFF$ 
    EXTERNAL;     FUNCTION FmpClose    (VAR dcb         : dcb_type;    {DCB buffer}     VAR error       : int):int;    {error code}     EXTERNAL;      FUNCTION FmpRead  
   $FIXED_STRING ON$ 
   (VAR dcb         : dcb_type;    {DCB buffer}     VAR error       : int;         {error Code}     VAR line        : pac135;      {string input}         maxlength   : int):int;    {maximum record} 
   $FIXED_STRING OFF$ 
    EXTERNAL;      FUNCTION FmpRunProgram 
    $FIXED_STRING ON$ 
     (   run_str      : str135;      {Run string}     VAR return_parms : rmpar_type;  {Return parameters}     VAR name         : str80):int;  {run string parameters}      $FIXED_STRING OFF$     EXTERNAL;      $PAGE$      PROCEDURE open_host_stream; $DIRECT$     {Open the host's printer stream and determine the end of file}      BEGIN    {open host's printer stream}    open_ops:=open_option;     ftype:=FmpOpen(dcb,error,old_file_str,open_ops,buff_count);    IF ftype <> valid_ftype THEN        IF ftype>0 THEN  {Invalid file type}         BEGIN 	          error:=3; 	 	          goto 99; 	        END        ELSE             {FMP error}         BEGIN           error:=ftype;  	          goto 99; 	        END    ELSE error:=0;      {Opened correctly}  END;      PROCEDURE get_file_name;  $DIRECT$     { return the file name found in the run string that was      initiated by RJE during post-processsor scheduling.}      VAR  pnum,maxlen  : int;     {parameter position, maximum length}        t            : int;     {used for PAC to string converstion}      BEGIN        {get file name from run string that RJE created}         old_file_str:='????'; 	   pnum:=param_pos; 		   maxlen:=max_inp; 	   file_name_length:=Pas_Parameters(pnum,old_file_name,maxlen);        {check for file name and convert to STRING if present}        IF file_name_length < 0 THEN   {file name not present}     BEGIN         error:=1;        GOTO 99;     END    ELSE                           {convert to STRING}     BEGIN         old_file_name[file_name_length+1]:=' ';        SETSTRLEN(old_file_str,0);         STRWRITE(old_file_str,1,t,old_file_name);      END;  END;         PROCEDURE trim_and_cat(start:int;VAR done:BOOLEAN);    {remove //*USER identifier and comments from card, leave     only the parameters.  Concatenate the string to the      user_parms variable.  If a comma is the last character      then there are more user cards to find.}      VAR       x   : int;       {index into a string}     BEGIN     {remove //*USER identifier}     STRDELETE(inp_rec,1,start+STRLEN(user_card)-1);        {remove leading and trailing blanks}     inp_rec:=STRLTRIM(inp_rec);     inp_rec:=STRRTRIM(inp_rec);        {remove any comments if present}     x:=STRPOS(inp_rec,blank);    IF x<>0 THEN       STRDELETE(inp_rec,x,STRLEN(inp_rec)-x+1);        {concatenate input record to parameter string}     user_parms:=user_parms+inp_rec;         {check for more user cards by checking for comma}    IF STRLEN(inp_rec) <> 0 THEN       IF inp_rec[STRLEN(inp_rec)]<>delimiter THEN          done:=TRUE         {no comma, no more cards}        ELSE           done:=FALSE        {comma, expect more cards}    ELSE       done:=TRUE;           {null line, must be done}  END;      $PAGE$     PROCEDURE read_host_file(VAR done:BOOLEAN);   {locate user card in hostfile text and return flag}     VAR    count,i     : int;       {counter}     index       : int;       {identifier index in input record}    user_col    : int;       {copy of index}     found       : BOOLEAN;   {true when a user card is found}    length      : int;       {length of the line read}    end_of_file : BOOLEAN;   {true if length -1 on read}     BEGIN     user_parms:='';         {initialize parameter string}    found:=FALSE;           {set flags and counters}    done:=FALSE;     end_of_file:=FALSE;     count:=0;        WHILE (count<max_lines_read) AND (NOT found) AND          (NOT end_of_file) DO     BEGIN        {read a record from host's stream}         count:=count+1;         length:=FmpRead(dcb,error,inp_buf,135);         IF error<>0 THEN GOTO 99;         IF length = E_O_F THEN end_of_file:=TRUE;             IF NOT end_of_file THEN         BEGIN             {map buffer into string variable}             SETSTRLEN(inp_rec,135);             FOR i:=1 TO length DO inp_rec[i]:=inp_buf[i];            SETSTRLEN(inp_rec,length);                 {look for //*USER identifier in record}            user_col:=STRPOS(inp_rec,user_card);                IF user_col <> 0 THEN    {USER card found}             BEGIN     
               found:=TRUE; 
                   {create parameter string from USER card}                trim_and_cat(user_col,done);                    {look for more USER cards}                 WHILE (NOT done) AND (NOT end_of_file) DO 
                BEGIN 
                       {read next line}                     length:=FmpRead(dcb,error,inp_buf,135);                     IF error<>0 THEN GOTO 99;                     IF length = E_O_F THEN end_of_file:=TRUE;                         IF NOT end_of_file THEN                     BEGIN                         {map buffer into string variable}                         SETSTRLEN(inp_rec,135);  "                       FOR i:=1 TO length DO inp_rec[i]:=inp_buf[i]; "                       SETSTRLEN(inp_rec,length);                             {look for //*USER identifier in record}                         index:=STRPOS(inp_rec,user_card);      !                       IF index=user_col THEN  {another USER card} ! !                          trim_and_cat(index,done)  {add to parms} !                         ELSE                    {not a USER card}                            done:=TRUE;          {quit reading}                     END; {of NOT end_of_file}                 END; {of WHILE}             END; {of user card found}         END; {of NOT end_of_file} 	    END; {of WHILE} 	 END;         PROCEDURE set_defaults;  $DIRECT$    {set up default values for the creation of the new file}      VAR   i : int;        {loop counter}     BEGIN    option:=option_0;  {standard Fmp Copy}    new_file_str:='';  {No new file name for copy}    chain_name:='';    {No second post processor name}    FOR i:=1 TO max_parms DO parm_list[i]:='';  END;      $PAGE$     PROCEDURE parse_out_parameters;  $DIRECT$    {break up user card into parameters}     VAR     ct,l      : int;       {counter and location pointer}     BEGIN    ct:=0;    REPEAT       ct:=ct+1;            {look for parameter delimeter}        l:=STRPOS(user_parms,delimiter);            IF l<>0 THEN       {delimeter found, line contains }                           {multiple parameters.           }         BEGIN           {separate and remove parameter}           parm_list[ct]:=STR(user_parms,1,l-1);            STRDELETE(user_parms,1,l);         END            ELSE               {delimeter NOT found, only 1    }                           {parameter on the line          }            parm_list[ct]:=user_parms;            {remove leading and trailing blanks}       parm_list[ct]:=STRLTRIM(parm_list[ct]);       parm_list[ct]:=STRRTRIM(parm_list[ct]);         UNTIL (ct >= max_parms) OR (l=0);  END;      $PAGE$      PROCEDURE set_up_parameters;  $DIRECT$     {set the values for the creation of the new file}      VAR   dest_set,               {true when file name is found}        parm_set,               {true when parm number is found}       chain_set  : BOOLEAN;   {true when program name is found}       i,t,opt    : int;       {loop and work variables}       p          : str80;     {parameter}     BEGIN    {initialize flags which determine if a parameter is set}     dest_set:=FALSE;parm_set:=FALSE;chain_set:=FALSE;         {check each parameter in parms array} 
   FOR i:=1 TO max_parms DO 
    BEGIN        p:=parm_list[i];            IF p<>'' THEN  {there is a parameter to check}             {check destination parameter}         IF (STRPOS(p,destination) = 1) THEN         BEGIN                {check for duplicate parm} 
           IF dest_set THEN 
            BEGIN                 error:=5;                GOTO 99;             END            ELSE                dest_set:=TRUE;                 {set flag}                STRDELETE(p,1,STRLEN(destination)); {remove DEST=}            new_file_str:=p;                    {store parm}         END             {check operation number for FmpCopys in PARM parameter}        ELSE IF (STRPOS(p,copy_option)=1) THEN         BEGIN                {check for duplicate parm} 
           IF parm_set THEN 
            BEGIN                 error:=5;                GOTO 99;             END            ELSE                parm_set:=TRUE;                 {set flag}                STRDELETE(p,1,STRLEN(copy_option)); {remove PARM=}            opt:=ORD(p[1])-ORD('0');      {convert to INTEGER}                 CASE opt OF                   0 : option:=option_0;                   1 : option:=option_1;                   2 : option:=option_2;                   3 : option:=option_3;                   OTHERWISE BEGIN                               error:=2;                                GOTO 99;                            END;            END;         END             {check chain program parameter}         ELSE IF (STRPOS(p,chain_parm)=1) THEN         BEGIN                {check for duplicate parm}             IF chain_set THEN             BEGIN                 error:=5;                GOTO 99;             END            ELSE                chain_set:=TRUE;                  {set flag}                  STRDELETE(p,1,STRLEN(chain_parm));    {remove CHAIN=}             chain_name:=p;                        {store parm}         END             {otherwise illegal parameter}        ELSE         BEGIN  
           error:=2; 
	           GOTO 99; 	         END;      END;         {make sure DEST parameter is set}    IF NOT dest_set THEN     BEGIN         error:=4;        GOTO 99;      END;  END;      $PAGE$      PROCEDURE find_user_card; $DIRECT$    {get the desired new name from the text in the JCL  
    of the host's stream.} 
    VAR err : int;     {dummy error code}     BEGIN         {look for user card and create parameter string if found}    read_host_file(found);         IF found THEN   {set up global variables from parameters}     BEGIN  
       set_defaults; 
        parse_out_parameters;        set_up_parameters;         error:=FmpClose(dcb,err);         IF (error<>0) and (error<>-7) THEN GOTO 99;     END    ELSE            {no //*USER card in search area, QUIT! }     BEGIN         error:=0; 	       parms[1]:=0; 	       GOTO 99;      END;  END;          PROCEDURE create_new_file;  $DIRECT$     {create a new copy of the host's file using FmpCopy call}      VAR   err1,err2       : int;         {error codes}       buflen          : int;         {length of dcb buffer}     BEGIN  
   buflen:=max_buff; 
    error := FmpCopy(old_file_str,err1,new_file_str,err2,                      dcb_buffer,buflen,option);    IF error <> 0 THEN GOTO 99  END;      $PAGE$     PROCEDURE chain_next_processor;  $DIRECT$     {initiate the next post processor if program name not null}     BEGIN 
   IF chain_name <> '' THEN 
    BEGIN  
       {set up run string} 
       run_string:='RU,'+chain_name+','+new_file_str;             {initialize scheduled name}        run_name:=STRRPT(' ',5);            {schedule program}        error:=FmpRunProgram(run_string,parms,run_name);             IF error <> 0 THEN GOTO 99;      END;  END;      $PAGE$     
BEGIN   { main-line } 
       {initialize control words for error messages to console}     console[1]:=error_lu;    console[2]:=0;        get_file_name;  
   open_host_stream; 
 	   find_user_card; 		   create_new_file; 	    chain_next_processor;      99:     {Jump here for error exit}        IF (error <> 0) OR (parms[1] <>0) THEN     BEGIN        {set up error message}         old_file_str:=STRRTRIM(old_file_str);         error_str:=err_header+old_file_str+' : ';            {determine type of message and print it}         IF error<0 THEN           STRWRITE(error_str,STRLEN(error_str),d,' FMP error ', 
                   error:1) 
           ELSE           CASE error OF               1 : error_str:=error_str+error_1;               2 : error_str:=error_str+error_2;               3 : error_str:=error_str+error_3;               4 : error_str:=error_str+error_4;               5 : error_str:=error_str+error_5; 	          OTHERWISE 	                 error_str:=error_str+'Undetermined error';            END; {of CASE}          STRREAD(error_str,1,d,error_buff);       error_msg_len:=STRLEN(error_str);      print(2,console,error_buff,error_msg_len);      END;      END. 