$PASCAL ',4,109 91781-16004 REV.2427 000000'$  $RECURSIVE OFF$ $HEAP 0$  {    NAME:         CON.PAS 
  SOURCE:       91781-18004 

  RELOC:        91781-16004 
 
  PGMR:         N.N. 
  PURPOSE:      RJE Console Service Routine   DATE:         <840920.1534>  }       PROGRAM con;      {      This source file provides a simple example of controlling     RJE/1000 II through programmatic EXEC and FMP calls. It     is an installation-specific implementation of a "console"    function. Although the 2780/3780 workstation definition does !   not include an operator's console, the function can be simulated !   by placing a host (i.e. JES2) command in a file, sending the     file to the host with "RJE SEND", and retrieving the resulting     output file.         Data may arrive asynchronously from the host at any time.     In order to capture the correct output file, this program    waits until the reader queue is empty and the link is idle    before issuing the SEND request. It then polls the printer     file assignment until it increments (indicating that a file     has returned) and assumes that this file is the command    response. Note that this approach is not necessarily valid     if link traffic is heavy.      }  LABEL 99;   TYPE                                         { primitive types }     integer     = -32768..32767;    dbl_int     = -2147483648..2147483647;     byte        = 0..255;     xlu_arr     = array[1..2] OF integer;    string_descriptor = dbl_int;     rmpar_type  = array[1..5] OF integer;    string80    = packed array[1..80] OF char;      $page$      "{ For programmatic RJE status calls, there are three possible buffer "   formats... }      TYPE #   device_status = record           { description of a virtual device } #                   header:     integer;     {HP internal use only}                     file_num:   integer;     {file sequence number}   #                  rec_num:    integer;     {number of records in file} #                  q_file:     string80;    {output file name} "                  pgm_file:   string80;    {post-process type 6 file} "                   reserved:   integer;     {HP internal use only}   $                  class:      integer;     {assigning program's class #} $                  open_time:  dbl_int;     {$TIME of last open}                     close_time: dbl_int;     {$TIME of last close}  	               END; 	     TYPE    monitor_config  = record    { RJExx configuration data }                   monitor_num:   integer;  {subsystem number}                    monitor_sec:   integer;  {security code}                    lu_r:          xlu_arr;  {PSI read LU}                   lu_w:          xlu_arr;  {PSI write LU}                   linktype:      integer;  {2780 or 3780}                   maxblock:      integer;  {max block size}                    maxrec:        integer;  {max record size}                    truncate:      integer;  {0= append} #                  host_id:       string80; {config file comment string} # !                  log_file:      string80; {current log-file name} !
                 END; 
     TYPE    link_statistics = packed record   { PSI data }                  header   : dbl_int;   {HP internal use only}                  brdtype  : byte;      {this is rje firmware}                   linkstat : byte;      {link status}                   revcode  : integer;   {revision code}                   lts_file : integer;   {files sent (Etx's Ack'd)}                    lts_gr   : integer;   {garbled responses}                   lts_rt   : integer;   {receive time-outs}                   lts_nakr : integer;   {naks received}                   lts_bbr  : integer;   {bad blocks received} "                 lts_bsr  : integer;   {blocks successfully received} "                  lts_bss  : integer;   {blocks successfully sent}   
                END; 
 TYPE     status_response_type = record CASE integer OF                   0: (LS: link_statistics);                   1: (DV: device_status);                  2: (MC: monitor_config);  
                END; 
     $page$     CONST status_response_length = -89;  	      comma = ','; 	 
      reader_stat  = 'RD'; 
 
      printer_stat = 'PR'; 
 
      link_stat    = 'LS'; 
      idle = 4;       temp_file_name = 'rjtemp::0';        ascii_specifier = 'A';     VAR temp_file, output_file, userin, userout : text;      length, error : integer;  &    run_string, runname, jes_command, current_printer_file, line : string80; &    passwd, n : string80;     parms : rmpar_type;     sd_runstring, sd_runname : string_descriptor;      status_buf : status_response_type;      $page$      PROCEDURE exec14(    ecode, rcode : integer;                  VAR buffer : status_response_type;                      length : integer);            $ALIAS 'exec'$ EXTERNAL;      PROCEDURE recover_buffer(VAR buff : status_response_type);       BEGIN       exec14(14,1,buff,status_response_length);      END;      FUNCTION StrDsc80(buff : string80;                    start, n : integer) : string_descriptor;          $ALIAS 'StrDsc'$ EXTERNAL;     FUNCTION TrimLen(sd : string_descriptor) : integer;  	         EXTERNAL; 	     PROCEDURE append (VAR destination : string80; source : string80);   VAR d_len, s_len, ptr : integer; BEGIN       d_len := TrimLen(StrDsc80(destination,1,80));      s_len := TrimLen(StrDsc80(source,1,80));  "     for ptr := 1 to s_len DO destination[d_len+ptr] := source[ptr]; " END;     PROCEDURE initialize_stat_runstring; $DIRECT$ BEGIN       run_string := 'RU,RJE,STAT,';  
     append(run_string,n); 
      append(run_string,comma);      append(run_string,passwd);       append(run_string,comma);  END;     PROCEDURE initialize_send_runstring; $DIRECT$ BEGIN       run_string := 'RU,RJE,SEND,';  
     append(run_string,n); 
      append(run_string,comma);      append(run_string,passwd);       append(run_string,comma);      append(run_string,temp_file_name);       append(run_string,comma);       append(run_string,ascii_specifier);  END;     FUNCTION FmpRunProgram(    runstring : string_descriptor;                         VAR     parms : rmpar_type;  "                       VAR   runname : string_descriptor) : integer; " 	         EXTERNAL; 	     $page$     PROCEDURE set_up_string_descriptors; $DIRECT$     BEGIN       sd_runname := StrDsc80(runname,1,80);      sd_runstring := StrDsc80(run_string,1,80);    END;     PROCEDURE get_user_inputs; $DIRECT$     BEGIN      reset(userin,'1');  
     rewrite(userout,'1'); 
      prompt(userout,'Subsystem number? ');       readln(userin,n);      prompt(userout,'Security code? '); 
     readln(userin,passwd); 
      prompt(userout,'Host command? ');       readln(userin,jes_command);    END;      PROCEDURE create_temp_file; $DIRECT$     BEGIN           rewrite(temp_file,temp_file_name,'NOCCTL');       writeln(temp_file,jes_command);       close(temp_file);    END;     PROCEDURE wait_until_reader_is_idle; $DIRECT$     BEGIN      initialize_stat_runstring;       append(run_string,reader_stat);      REPEAT         BEGIN          error := FmpRunProgram(sd_runstring,parms,sd_runname);          IF (error <> 0) or (parms[1] <> 0) THEN GOTO 99;         recover_buffer(status_buf);         END       UNTIL status_buf.dv.file_num = 0;    END;     PROCEDURE wait_until_link_is_idle; $DIRECT$     BEGIN      initialize_stat_runstring;       append(run_string,link_stat);      REPEAT         BEGIN          error := FmpRunProgram(sd_runstring,parms,sd_runname);          IF (error <> 0) or (parms[1] <> 0) THEN GOTO 99;         recover_buffer(status_buf);         END        UNTIL status_buf.ls.linkstat = idle;    END;      PROCEDURE get_current_printer_filename; $DIRECT$     BEGIN      initialize_stat_runstring;      append(run_string,printer_stat);      error := FmpRunProgram(sd_runstring,parms,sd_runname);      IF (error <> 0) or (parms[1] <> 0) THEN GOTO 99;       recover_buffer(status_buf);       current_printer_file := status_buf.dv.q_file;    END;      PROCEDURE send_console_command; $DIRECT$     BEGIN      initialize_send_runstring;      error := FmpRunProgram(sd_runstring,parms,sd_runname);      IF (error <> 0) or (parms[1] <> 0) THEN GOTO 99;    END;     PROCEDURE wait_until_job_received; $DIRECT$     BEGIN      REPEAT         BEGIN          initialize_stat_runstring;          append(run_string,printer_stat);          error := FmpRunProgram(sd_runstring,parms,sd_runname);          IF (error <> 0) or (parms[1] <> 0) THEN GOTO 99;         recover_buffer(status_buf);         END       UNTIL current_printer_file <> status_buf.dv.q_file;    END;     PROCEDURE output_response_to_terminal; $DIRECT$    VAR c_pos : integer;     BEGIN      reset(output_file,current_printer_file);       WHILE not eof(output_file) DO         BEGIN         readln(output_file,line);  $        length := TrimLen(StrDsc80(line,1,80)); { skip first two chars } $        for c_pos := 3 to length DO           write(userout,line[c_pos]);         writeln(userout);        END;       close(output_file);    END;      $page$      
   BEGIN    { main } 
       set_up_string_descriptors;        get_user_inputs;       create_temp_file;        wait_until_reader_is_idle;        wait_until_link_is_idle;       get_current_printer_filename; 
      send_console_command; 
       wait_until_job_received;        output_response_to_terminal;     99: { Jump here for error exit. }      IF (error <> 0) OR (parms[1] <> 0)     THEN writeln(userout,'Error encountered.');     END  .  