"{ 24998-18583 REV.2440 <850128.1010>                                } ""{                                                                   } ""{ This is an option recognized by the rev code 2101 PASCAL compiler } ""{ It will only compile those routines which are actually called,    } ""{ rather than all that are declared.                                } " 	PROGRAM HOUSE_AGP; 	    #{_____________________________________________________________________} ##{                                                                     } ##{                 H o u s e            D e m o                        } ##{                 ____________________________                        } ##{                                                                     } ##{  This program draws a house.  It appears that a person walks around } ##{  the house, then into the house, turns around inside and walks out  } ##{  again.  The whole sequence is repeated 2 times.  This is           } ##{  accomplished through the generation of multiple images of the      } ##{  house from different points of view.                               } ##{                                                                     } ##{  Running Sequence:                                                  } ##{                  CI>  HOUSE_AGP.RUN                                 } ##{_____________________________________________________________________} #         { Type declarations neccesary for AGP procedure definitions  }  { Include file is part of AGP product                        } !{ Actually there are 3 include files available for pascal programs} ! $LIST OFF$  $INCLUDE 'PAGP1.PASI'$ $LIST ON$        TYPE      string8 = PACKED ARRAY [1..8] OF CHAR;         CONST        two_pi = 6.2832;       pi     = 3.14159; !      graphics_lu = 1;   { Graphics LU                            } !!      repetitions = 2;   { number of times to repeat the sequence } !!      wsp_name = STRING8 [ 'WSP.RUN ' ]; { name of the WSP used   } !!      wsp_len = 8;       { character length of the WSP used       } !!      images = 10;       { number of images comprising a sequence } !      turn_increments_inside_house = 5;       steps_to_house = 5;       walk_out_increment = 3;             VAR !      i, j, n,           { Loop counters                          } !!      num_of_times : INT;{ number of times to repeat the sequence } !!      ilist : INT_LIST;  { dummy integer array                    } !!      aspect_ratio : REAL_LIST; { Aspect ratios                   } !!      xref,              { X view reference point                 } !!      yref,              { Y view reference point                 } !!      zref,              { Z view reference point                 } !!      x,                 { X coordinate of a point                } ! "      z,                 { Z coordinate of a point                }  " "      fraction,          { fraction of the viewplane distance     }  " 
      viewplane_distance,  
 "      window   : REAL;   { window bounds                          }  "     #{                                                                   }  # #{ ----------------------------------------------------------------- }  # "{ PASCAL procedure definitions of AGP routines                    }  " #{                                                                   }  # PROCEDURE J3DRW   	  $ALIAS 'J3DRW'$  	   ( x,      y,      z : REAL );   EXTERNAL;       PROCEDURE J3MOV   	  $ALIAS 'J3MOV'$  	   ( x,      y,      z : REAL );   EXTERNAL;       PROCEDURE JASPK   	  $ALIAS 'JASPK'$  	   ( xsize,  
    ysize : REAL );  
EXTERNAL;      PROCEDURE JBATC;   $ALIAS 'JBATC'$ EXTERNAL;      PROCEDURE JBEGN;   $ALIAS 'JBEGN'$ EXTERNAL;     PROCEDURE JDINT   $ALIAS 'JDINT'$   ( id,     wsplen : int; 
    wspnam : string8; 
     outlu, 	    contrl : int ); 	EXTERNAL;     PROCEDURE JEND;    $ALIAS 'JEND'$ EXTERNAL;      PROCEDURE JIWS    $ALIAS 'JIWS'$    (     id,           opcode,           isize,          rsize   : int;      VAR ilist   : int_list;       VAR rlist   : real_list );  EXTERNAL;       PROCEDURE JNEWF;  	  $ALIAS 'JNEWF'$  	 EXTERNAL;           PROCEDURE JPROJ   	  $ALIAS 'JPROJ'$  	 	  ( opcode : INT;  	     du,       dv,   
    dn     : REAL ); 
 EXTERNAL;       PROCEDURE JR3DR   	  $ALIAS 'JR3DR'$  	   ( dx,       dy,   	    dz  : REAL );  	 EXTERNAL;       PROCEDURE JUPDT;  	  $ALIAS 'JUPDT'$  	 EXTERNAL;       PROCEDURE JVDIS   	  $ALIAS 'JVDIS'$  	 	  ( dist : REAL ); 	 EXTERNAL;       PROCEDURE JVPLN   	  $ALIAS 'JVPLN'$  	   ( xnrm,       ynrm,       znrm,       xup,      yup,  	    zup  : REAL ); 	 EXTERNAL;       PROCEDURE JVREF   	  $ALIAS 'JVREF'$  	   ( x,      y,      z  : REAL );  EXTERNAL;       PROCEDURE JWEND   	  $ALIAS 'JWEND'$  	   ( id : int );   EXTERNAL;       PROCEDURE JWIND   	  $ALIAS 'JWIND'$  	   ( wumin,      wumax,      wvmin, 	    wvmax : REAL ); 	EXTERNAL;     PROCEDURE JWOFF   $ALIAS 'JWOFF'$   ( id : int ); EXTERNAL;      PROCEDURE JWON    $ALIAS 'JWON'$   ( id : int ); EXTERNAL;      { In this program actual values are passed in the graphics   }  {subroutines.  This type of coding is acceptable on the 1000 }  {even though Fortran requires that subroutine parameters be  }  {passed by reference and not by value.                       }  {____________________________________________________________}  {                                                            }  {                       H  o  u  s  e                        }  {                       _____________                        }  {                                                            }  {  This subroutine draws a house complete with door, window  }  {  and path.  The house is not a segment but is drawn within }  {  a batch of updates so that it will not be output to the   }  {  device until all vectors are in the segment display area  }  {  (remember that primitives outside of a segment are stored }  {  in the segment display area during a batch of updates).   }  {  This improves perceived performance.                      }  {                                                            }  {  The front lower left corner of the house is situated at   }  {  ( 0.0, 0.0, 30.0 ).  The house extends from 0.0 to 16.0   }  {  in the X direction, 0.0 to 16.0 in the Y direction, and   }  {  30.0 to 54.0 in the Z direction.                          }  {____________________________________________________________} 
PROCEDURE house_subr; 
        VAR        j : INT;      { Loop counter }      BEGIN  { house }         JBATC;      JNEWF;          { DRAW MAIN PART OF THE HOUSE }     J3MOV(0.0,0.0,30.0);      JR3DR(16.0,0.0,0.0);      JR3DR(0.0,10.0,0.0);      JR3DR(-8.0,6.0,0.0);      JR3DR(-8.0,-6.0,0.0);     JR3DR(0.0,-10.0,0.0);     J3MOV(0.0,0.0,54.0);      JR3DR(16.0,0.0,0.0);      JR3DR(0.0,10.0,0.0);      JR3DR(-8.0,6.0,0.0);      JR3DR(-8.0,-6.0,0.0);     JR3DR(0.0,-10.0,0.0);     J3MOV(0.0,10.0,54.0);     JR3DR(16.0,0.0,0.0);      J3MOV(0.0,0.0,30.0);      JR3DR(0.0,0.0,24.0);      J3MOV(16.0,0.0,30.0);     JR3DR(0.0,0.0,24.0);   
   J3MOV(16.0,10.0,30.0);  
    JR3DR(0.0,0.0,24.0);      J3MOV(8.0,16.0,30.0);     JR3DR(0.0,0.0,24.0);      J3MOV(0.0,10.0,30.0);     JR3DR(0.0,0.0,24.0);          { DOOR AND WINDOW  }      J3MOV(7.0,0.0,30.0);      JR3DR(0.0,7.0,0.0);     JR3DR(2.0,0.0,0.0);     JR3DR(0.0,-7.0,0.0);      J3MOV(2.0,4.0,30.0);      JR3DR(4.0,0.0,0.0);     JR3DR(0.0,3.0,0.0);     JR3DR(-4.0,0.0,0.0);      JR3DR(0.0,-3.0,0.0);          { FLOOR }     FOR j := 1 TO 3 DO BEGIN         J3MOV(J*4.0,0.0,30.0);  
      JR3DR(0.0,0.0,24.0); 
    END;  { FOR }     FOR j := 1 TO 6 DO BEGIN         J3MOV(0.0,0.0,30.0 + (J*4.0));  
      JR3DR(16.0,0.0,0.0); 
    END;  { FOR }         { Path }      J3MOV(7.0,0.0,30.0);   
   JR3DR(0.0,0.0,-2000.0); 
    J3MOV(9.0,0.0,30.0);   
   JR3DR(0.0,0.0,-2000.0); 
       JUPDT;      END; { house }              BEGIN { Main Demo Code }      %   JBEGN;                                 { Initialize AGP               } % &   JDINT ( 1,wsp_len,wsp_name,graphics_lu,0); { Initialize graphics display} & &   JWON ( 1 );                            { Enable the display for output  } &        !   { inquire the maximum aspect ratio for the specified graphics  } !!   { display and set the aspect ratio accordingly                 } !        JIWS ( 1, 254, 0, 2, ilist, aspect_ratio );     JASPK ( 1.0, aspect_ratio[2] );          "   {  Set the window to have the same aspect ratio as the virtual }  " "   {  coordinate system.                                          }  "        window := 7.0;   { Window sized for good view of house  }     JWIND ( -window, window,              -window*aspect_ratio[2], window*aspect_ratio[2] );                  { Now let us take the walk around the house }         FOR num_of_times := 1 TO repetitions DO BEGIN      !      { Set up the initial conditions :                          } ! !      { The view reference point is in the middle of the house.  } ! !      { The view distance is 30 world coordinate units away from } ! !      { the view reference point since the house is 24 units in  } ! !      { depth this is 6 units from the front of the house.       } ! !      { The type of projection is perspective and the center of  } ! !      { projection is 15 units behind the viewplane.             } !           xref:=8.0;        yref:=8.0;  	      zref:=42.0;  	       JVREF ( xref, yref, zref );         viewplane_distance := 30.0;         JVDIS ( viewplane_distance );         JPROJ ( 1, 0.0, 0.0, -15.0 );       !      { Walk around the house :                                  } ! !      { This is accomplished simply by moving the viewplane      } ! !      { normal in a circle around the house ( i.e. rotating the  } ! !      { viewplane about the view reference point. )              } ! !      {                                                          } ! !      { images is the number of increments ( i.e. the number of  } ! !      { frames for this portion of the walking sequence          } !           FOR i := 0 TO images DO BEGIN            fraction := i/images;           z := COS ( two_pi * fraction );           x := SIN ( two_pi * fraction );           JVPLN ( x, 0.0, z, 0.0, 1.0, 0.0);   
         HOUSE_SUBR; 
       END;                { For the final picture use the exact beginning value }             z := 1.0;         x := 0.0;         JVPLN ( x, 0.0, z, 0.0, 1.0, 0.0 );        HOUSE_SUBR;              "      { Walk into the house :                                     }  " "      { This is accomplished by moving the viewplane towards the  }  " "      { view reference point (i.e. decreasing the viewplane       }  " "      { distance).                                                }  "           FOR i := 0 TO steps_to_house DO BEGIN   %         JVDIS ( viewplane_distance*((steps_to_house-i)/steps_to_house));  % 
         HOUSE_SUBR; 
       END;          "      { Turn around and look out the front :                      }  " "      { This is accomplished by rotating the viewplane about the  }  " "      { view reference point ( i.e. moving the viewplane normal   }  " "      { around a circle.                                          }  "           FOR i := 1 TO turn_increments_inside_house DO BEGIN            fraction := i/turn_increments_inside_house;           z := COS ( pi*fraction );           x := SIN ( pi*fraction );           JVPLN ( x, 0.0, z, 0.0, 1.0, 0.0 );  
         HOUSE_SUBR; 
       END;          "      { Walk out of the house :                                   }  " "      { Move view reference point out along the path ( in this    }  " "      { case you cannot just change the viewplane distance since  }  " "      { the viewplane would cross over the view reference point.  }  " "      { The viewplane cannot be behind the view reference point). }  "           n := 20;        i := 1;         REPEAT           JVREF( xref, yref, zref-i );   
         HOUSE_SUBR; 
          i := i + walk_out_increment;   	      UNTIL i > n; 	        END;  { FOR }             JWOFF(1);   { Disable graphical output }      JWEND(1);   { Terminate the WSP        }      JEND;       { Teminate AGP           }       END. 