# {********************************************************************} # $PASCAL '91751-1X033 REV.5020 <900221.1128>' # {********************************************************************} ## {                                                                    } ## {    SOURCE: 91751-18033                                             } ## {    RELOC.: 91751-1X033                                             } ## {                                                                    } ## {  ***************************************************************   } ## {  * (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1982.  ALL RIGHTS     *   } ## {  * RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,      *   } ## {  * REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT*   } ## {  * THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.       *   } ## {  ***************************************************************   } ## {                                                                    } ## {--------------------------------------------------------------------} ## {                                                                    } ## {  Contains the following procedures and functions :                 } ## {                                                                    } ## {  - XLOGPK                                                          } ## {  - XPKTHD                                                          } ## {  - XPKT : - VCSEARCH                                               } ## {           - SETDIAG                                                } ## {           - PRINTCAUSEDIAG                                         } ## {           - P_LEVEL_TREATMENT :                                    } ## {                   - DECODE_CALL                                    } ## {                   - PROCESS_CALL_FACILITIES :                      } ## {                         - FC_SELECT                                } ## {                         - F_REV_CHARG_SELECT                       } ## {                         - F_CUG                                    } ## {                         - F_PACKET_SIZE                            } ## {                         - F_WINDOW_SIZE                            } ## {                         - F_RPOA                                   } ## {                                                                    } ## {                   - PROCESS_CALL : - SEARCH_FREE_PAD_EQT           } ## {                                    - SEARCH_HTOHEQT                } ## {                                                                    } ## {                   - PROCESS_CALL_COLLISION                         } ## {                   - SVCP3_CALLCONF                                 } ## {                                                                    } ## {           - D_LEVEL_TREATMENT                                      } ## {           - P_INT_PKT                                              } ## {           - P_INTCONF_PKT                                          } ## {           - P_DATA_RR_RNR : - SETUP_EMA_STORAGE                    } ## {                             - P_DATAPKT                            } ## {                                                                    } ## {  - PDSUP : - SETDIRECTWRITEQBITREQ                                 } ## {            - SETDIRECTWRITEREQ                                     } ## {            - SETDIRECTREADREQ                                      } ## {            - SETDIRECTQBITREADREQ                                  } ## {            - SETLINKUPMSG                                          } ## {            - XPOST                                                 } ## {            - PCLEANUP                                              } ## {            - PCLEARVC                                              } ## {            - PUNSOLQBITDATA                                        } ## {            - PSETREADPARMMSG                                       } ## {            - PGETDC2                                               } ## {            - PPARMLINKUP                                           } ## {            - PINVITCLEAR                                           } ## {            - PGETTERMSTRAP                                         } ## {            - SELECT_PROCESS                                        } ## {                                                                    } ## {--------------------------------------------------------------------} # $page$ # {--------------------------------------------------------------------} ## {                                                                    } ## { HISTORY :                                                          } ## {                                                                    } ## { Original  : 2201                                                   } ## { Change #1 : 2401                                                   } ## {   .access to CUD                                                   } ## {   .user acces to Q-bit data packets                                } ## {   .flow control enhancement (imposed to segment XNET)              } ## {   .no automatic pool vc deallocation                               } ## {   .RR sending                                                      } ## {   .Flow control with a window size equal to 1                      } ## { Change #2  : 2440                                                  } ## {   .PASCAL 2440 support                                             } ## { Change #3 : 5.0          BG                                        } ## {   .Reject packet decoding corrected from type 8 to 9.  (M6)        } ## {   .Add processing for acknowledgement of empty data packets. (M10) } ## {   .Program unit XPKT has been moved to XSEG4 segment to reduce     } ## {    overall Xnet size.                                              } ## {   .Update noabort error processing. (M28)                          } ## {   .Add a reset of VCTO timer in P_leveltreatment when a clear,     } ## {    clearconf, call or callconf packet is received. (M37)           } ## { Change #4 : 5.1          BG                                        } ## {   .Add an otherwise statement in PDSUP for the case of task. (M61) } ## {   .Add sending linkdown cause 'network ready' to each EQT of       } ## {    a network when it becomes ready. This to allow for automatic    } ## {    reenabling of VCs after any network failure. (M62)              } ## { Change #5 : 5.2          BG                                        } ## {   .Add block mode feature in PAD support. (M77)                    } ## {   .Add SetDirectReadReq procedure.        (M77)                    } ## {   .Add PDSUP Task 5.                      (M77)                    } ## {   .Moved procedures VCSEARCH and SETUP_EMA_STORAGE from XNETM      } ## {    to XSEG4, to save code space.                        (M80)      } ## {                                                                    } ## {********************************************************************} #     
 $STANDARD_LEVEL 'HP1000'$ 
 
 $SEGMENT , RECURSIVE OFF$ 
 $HEAP 2$   $RANGE OFF$   $CDS OFF$ 	 $HEAP_DISPOSE OFF$ 	     PROGRAM    XSEG4  ; { Dummy name }      { includes  XTBLG.PASI, XTBLV.PASI, XNETG.PASI }  $LIST OFF$    {path directory must be provided in the installation procedure}   $INCLUDE 'XTBLG.PASI'$  $INCLUDE 'XTBLV.PASI'$  $INCLUDE 'XNETG.PASI'$   $LIST ON$           $HEAPPARMS OFF$  procedure CNUMD (n: word; var Nbconv: pa6c);   external; {RTE decimal to ASCII conversion}      # procedure CNUM ( n : word ; var nbconv : pa6c ) ; $DIRECT$ external ; # #                                                      {M61 BG 19JUL88} #      procedure  XEXEC2  $ alias 'EXEC' {write} $    (icode,icnwd: word; ibuf: XMSGtype; ilen: word);   external;      " procedure EXEC2 $alias 'EXEC' {write}$ {special for internal trace} "   (icode, icnwd: word; ibuf:pa75c; ilen:word);  #  external;                                           {M61 BG 19JUL88} #    " Function  XEXEC18 $alias 'EXEC'{class write}$ {special for messages} "    (icode,icnwd: word; ibuf: XMSGtype; ilen,ip1,ip2,iclass: word)    : word {Reg A only} ;   external;      ! procedure XWR0  $ alias 'EXEC'  {class I/O write/read} , NOABORT$ !"   ( icode,icnwd: word;VAR ibuf:ibuftype; ilen,ip1,ip2,iclass: word); "   external;   {used in XLGPK for XPLOG/XTLOG implementation}       procedure MSGwrite(lu:word; msg1,msg2,msg3,msg4,msg5: pa15C);   external;       procedure XMSGWR (msglu:word;msgindex:byte;lunb: word); $direct$    external;       procedure XSEND      ( MessageType : XSENDmsg;         EPTR : EqtPtrType;        EQTid : bits2; {1=WriteEqt; 2=ReadEqt}        W3value,       W4value : word );   external;  $page$ " procedure EQTCLEAR ( ep: EqtPtrType; EQTid, Status : word); $direct$ "  external;      procedure ESTABLISHCIRCUIT (ep: EqtPtrType);  $direct$   external;      $skip_text on$        {M80 BG 16FEB90}  
 procedure  VCSEARCH 
    ( NP: NetwPtrType; IVC: word; var VCP: VCptrType); $direct$   external; $skip_text off$       procedure  LINKUP (eqtptr:EqtPtrType);   $direct$   external;       procedure  LINKDOWN                             {M62 BG 19JUL88}       (eqtptr : EqtPtrType ; reason : word ) ; $direct$  external ;       procedure  P1SETUP ( vcp: VCptrType );  $direct$   external;      procedure  D1CLEANUP (vcp: VCptrType);  $direct$   external;       procedure  D1SETUP ( vcp: VCptrType );   $direct$   external;       $skip_text on$                                  {M80 BG 16FEB90}    procedure SETUP_EMA_STORAGE ( EQTPTR: EQTPTRtype );  $direct$   external;   $skip_text off$     
 Procedure XPKT;   $direct$ 
  Forward;   {needed because called in PKTHD}  $page$       {*****************************}   {    XLGPK                    }   {*****************************}       PROCEDURE  XLGPK  ;              $direct$       { Used to log packets received for later use by XPLOG/XTLOG }   { Only logs non data packets.                               }   { Called from PKTHD if error, and from XPKT.                }      $skip_text on$                            {M28 BG 23feb87}    LABEL 77,88; { needed for exec with no abort bit }   $skip_text off$       CONST NoAbort20 = 20-32768; {exec code 20 with no abort bit set}       VAR LOGBUF : ibuftype; I,K : word;       BEGIN        { Note : called in PKTHD and in XPKT }         With  NETWP^ do begin "      LOGBUF.W[0] := - (CardWriteLU-SessionBit+1); {negative read lu} "      LOGBUF.W[1] :=  LOGACT;        {LOGBUF.W[2]  UNDEFINED}        LOGBUF.W[3] := - LogHDRL ;        LOGBUF.W[4] :=  LOGPKTB01;        LOGBUF.W[5] :=  LOGPKTB23;       { Fourth byte significant only if extd numb }            If XNETip1 = IP1RestNonDataPKT        then begin  {copy rest of pkt into LOGBUF} "         LOGBUF.W[3] := LOGBUF.W[3] - XNETtlog ; {real length of PKT} "         LOGBUF.B[11] := PKTHEADER.PKTbyte4.B ;          K := 12;          For I:= XNETibufByteIndex to XNETtlog-1 do           begin            LOGBUF.B [K] := XNETIBUF.B[I];  
           K := K+1; 
	         end {for}; 	      end {IF xnetIP1};            I := LOGBUF.W[3] - 8; {PKT bytes length + 4 words}           XWR0 (NoAbort20,0,LOGBUF, I, 0,0, LOGCLASS+NoWaitBit) ;          $skip_text on$                          {M28 BG 23FEB87}       Goto  77; {aborted}        Goto  88; {Normal return; if no SAM available, just ignore}            77: {aborted: class nb invalid; turn tracing OFF}          LogClass := 0;           XMSGWR (1 {LU}, TracingOff, 0);       88: 	    $skip_text off$ 	           begin  { no abort error processing }        {} { aborted: class nb invalid; turn tracing OFF }       {} LogClass := 0;        {} XMSGWR (1 {LU}, TracingOff, 0);       end ;  { end of no abort error processing }           { Normal return; if no SAM available, just ignore }      
   end {with Netwp}; 
 end {XLGPK};       $Title 'PKTHD' , page $   {*****************************************************}   Procedure    PKTHD  ;            $direct$   {*****************************************************}        {Decodes and verifies first 3 (or 4) bytes of incoming packet }     {and decides either to call XPKT to process                   }     {                or to read the rest of the packet first.     }              LABEL  "     88, {end of decode header phase (used to simplified structure)} "     77; {end of VC test (used to simplify structure) }         VAR          Error, LengthNeeded :word; I : byte;     
     ConvPKT : record 
"                 { convenient to decode first two bytes of a packet } "                 case boolean  of                     false: ( W : word);                    true : (field: packed record                                     Q ,                                    D : boolean;                                   PN : bits2;                                   VCN: bits12                                  end) 	               end; 	        TYPE ConvPKTtypetag = 0..4;  
         bits15= 0..32767; 
        VAR ConvPKTtypeByte :             record {convenient to decode packet type}                case ConvPKTtypeTag of                  0 : ( B  : byte);   {1 word !}                  1 : ( W1 : packed record                                 dummy1: bits15;                                 BIT0  : bits1                             end);                  2:  ( W2 : packed record                                  dummy2 : bits11;                                  Lower5 : bits5                             end);  !                 3 : (PRMPS : packed record {normal pkt numbering} !                            dummy3: byte;                                  PR: bits3;                                  M : boolean;                                  PS: bits3;                                 B0: bits1                               end); !                 4 : (PSB0 : packed record {extended pkt numbering} !                             dummy4 : byte;                                 PS : bits7;                                  B0 : bits1                              end) 	               end; 	 $page$    CONST PktTypeTableLength = 11;        TYPE  pktrow = array [1..2] of word;  "         PKTtypeTableType = array [1..Pkttypetablelength] of pktrow; "        CONST PktTypeTable = PKTtypetabletype   [                      {CCITT type  ; length needed (in bytes)}             pktrow [     ResetPkt ,  2   ],             pktrow [ ResetConfPkt ,  0   ],             pktrow [     ClearPkt ,  2   ],             pktrow [ ClearConfPkt ,  0   ],             pktrow [      CallPkt ,  96  ],             pktrow [  CallConfPkt ,  80  ],             pktrow [   RestartPkt ,  2   ],             pktrow [  RestConfPkt ,  0   ],             pktrow [ InterruptPkt ,  1   ],             pktrow [   IntConfPkt ,  0   ],             pktrow [      DiagPkt ,  4   ]   ];         VAR  MSG : pa15C; {TEST ONLY}  $page$  
  BEGIN    {*** PKTHD ***} 
      With NETWP^, PKTheader do begin         { For XPLOG/XTLOG: always }     { (short; safer in case Tracing set just after) }           LOGHDRL := XNETtlog; {between 1 and 4!}           LOGPKTB01 := XNETIBUF.W[0];          LOGPKTB23 := XNETIBUF.W[1]; {even if tlog<4}          If LogAct>=32767 then LogAct:=0 else LogAct:=LogAct+1;         If XNETmoreDataOnCard=0 then GlobalRead:= ReadHeader;         If XNETtlog <= 1 {pkt length <= 1 byte !}         then begin Error := 38; goto 88  end;       Error := 0;  LengthNeeded := 0; {changed later if necessary}       !  {--------------------------------------------------------------} ! !  {Obtain packet header, decode, verify and store into PKTHEADER:} ! !  {--------------------------------------------------------------} !        ConvPKT.W := XNETIBUF.W[0]; {separate into subfields}     Qbit := ConvPKT.Field.Q;    { Q bit }     PKTVC:= ConvPKT.field.VCN;  { VC number }         If XNETtlog <=2 {Pkt length <= 2 bytes; no type!}        then begin          PKTtype := -1;          goto 77 ; {CHECK VC}        end;     !    ConvPKTtypeByte.B := XNETIBUF.B[2]; { separate into subfields } !    
    {pkt numbering: } 
         If ConvPKT.field.PN <> 1 {01} then           begin             Error:=40 ; 
            goto 88 ; 
          end ;         {If extended pkt numbering: test PN=2 and           }     { also store XNETIBUF.B[3] in PKTheader.PKTbyte4.B  }         {-----------------------------------------------}     {Decode packet type into a more convenient code:}     {-----------------------------------------------}       With ConvPKTtypeByte do begin          If W1.BIT0 = 0  	        then begin 	        {}  PKTtype := DataPkt;  "        {}  {M bit, P(S) and P(R) values (if normal pkt numbering):} "        {}     Mbit:= PRMPS.M ;          {}     XNETPS := PRMPS.PS;          {}     XNETPR := PRMPS.PR ;   
        {}  Goto 77  
         end;          {Check Q bit: (should not be set in non data packet) }              If Qbit then begin  Error:=40; goto 77 end;    $page$           {Check first if RR (more frequent):}               If W2.Lower5 = 1   { RR ? }               then begin                {} PKTtype:= RRpkt;  !             {} XNETPR:= PRMPS.PR; {assuming normal pkt numbering} !              {} Goto 77   	             end;  	             {Explore packet type table:}                For I:=1 to PKTtypeTableLength do begin                 {}  if B = PKTtypeTable[ I ,1]                {}  then begin                {}       PKTtype:= B;   "              {}       If ( B = RestartPkt ) or ( B = RestConfPkt )  "               {}         then                 {}            If PKTVC <> 0 then PKTtype := -2 ;                {}       LengthNeeded := PKTtypeTable[ I,2];                {}       goto 77 
              {}  end 
               end {for};              {Not found in table; could still be RNR or REJECT}                  If W2.Lower5 = 5   { RNR ? }              then begin               {} PKTtype := RNRpkt; !             {} XNETPR:= PRMPS.PR;  {assuming normal pkt numbering} !             {} Goto 77              end; !            $skip_text on$                          {M6 BG 06NOV85} !              If W2.Lower5 = 8 then 
            $skip_text off$ 
              If W2.Lower5 = 9 then  
               begin 
                  PKTtype := REJECTpkt;  
                 goto 77 ; 
	               end; 	                 {Unknown packet:}  PKTtype := -1               end {with convpkttypebyte};          77:  {end of decode packet type}         {-----------------------------------------------}     {test if VC belongs to subscribed VC (or is 0): }     {-----------------------------------------------}     If (FirstPVC<=PKTVC) and (PKTVC<=LastPVC) then goto 88;     If (FirstSVC2w<=PKTVC) and (PKTVC<=LastSVC2w) then goto 88;     If (FirstSVCin<=PKTVC) and (PKTVC<=LastSVCin) then goto 88;      If (FirstSVCout<=PKTVC) and (PKTVC<=LastSVCout) then goto 88;         {verify only now if VC=0:}      If ( PKTVC = 0 ) and        (( PKTtype = RestartPkt ) or          ( PKTtype = RestConfPkt ) or          ( PKTtype = DiagPkt ))  	    then  goto 88; 	        {incorrect VC number:} Error := 36;         88: {end of decode and verify header}  $page$     If error <> 0     then begin { error= 40 if wrong GFI }     {}         { 36 if unassigned VC; 38 if too short }      {}  If MsgLu <> 0 then begin {test only}      {}    CNUMD(error,nbconv); {test only}  "    {}    Msgwrite(msglu,' XPKT:','PKT HEADER ERR=',nbconv,' ',' '); "     {}  end;     {}  { Could also send a DIAG packet with "error" value}     {}  If XNETmoreDataOnCard = 1  then GlobalRead := RFlush;      {}     {}  If LogClass <> 0 then  XLGPK ;  {For XPLOG/XTLOG}      {}     end "    else begin {PKT header has now been stored into NETWP^.PKTHeader} "    {}If Msglu <> 0 then begin  {test only}      {}  Case  PKTtype of  {Test only: print type }      {}     0: msg:= ' DATA';  
    {}     1: msg:= ' RR'; 

    {}     5: msg:= ' RNR'; 
     {}     9: msg:= ' REJECT';      {}    11: msg:= ' CALL' ;       {}    15: MSG:= ' CALL CONF';       {}    19: MSG:= ' CLEAR';       {}    23: MSG:= ' CLEAR CONF';     {}    27: MSG:= ' RESET';      {}    31: MSG:= ' RESET CONF';     {}    35: MSG:= ' INTERRUPT';      {}    39: MSG:= ' INT CONF';      {}   241: MSG:= ' DIAG';     {}   251: MSG:= ' RESTART';     {}   255: msg:= ' REST CONF';     {}    -1: MSG:= ' UNKNOWN';      {}    -2: MSG:= ' REST(VC>0)'; 	    {}  END {CASE}; 	    {}  CNUMD (PKTVC, nbconv);  {test only}     {}  Msgwrite ( Msglu, ' XPKT:   PKT=', MSG,      {}             '       VC=', nbconv, ' '); 
    {}end {if msglu}; 
 $page$      {}  If PKTtype = datapkt  	    {}  then begin 	     {}              {------------------}      {}        XPKT  {  Process Packet  }      {}              {------------------}     {}  end      {}  else begin   { not a data packet }      {}      XNETibufByteIndex:=0; {convenient init for XPKT}      {}      If XNETmoreDataOnCard = 1       {}      then begin      {}      {} XNETpktTooShort := 0;      {}      {} If LengthNeeded > 0  #    {}      {} then begin {read rest of packet before processing pkt}  #     {}      {}    XNETpktTooLong := 0;      {}      {}    GlobalRead := ReadRest;       {}      {}    GRP1 := LengthNeeded  	    {}      {} end 	    {}      {} else begin  { length needed <= 0 }      {}      {}    XNETpktTooLong := 1;      {}      {}    GlobalRead := Rflush;       {}      {}           {------------------}       {}      {}    XPKT   {  Process packet  }       {}      {}           {------------------}   	    {}      {} end 	     {}      end       {}      else begin  { no more data on card }      {}      {}   XNETpktTooLong := 0; {readHeader already set}      {}      {}   If LengthNeeded > 0 then XNETpktTooShort := 1       {}      {}                       else XNETpktTooShort := 0;        {}      {}         {------------------}      {}      {}   XPKT  {  Process Packet  }     {}      {}         {------------------}     {}      end     {}  end     end     {Note: Globalread is set in ALL cases, except if DataPkt}  	  end {with Netwp} 		  end  { PKTHD }  ; 	 $Title 'XPKT' , page $ # {********************************************************************} #
 PROCEDURE    XPKT  ; 
# {********************************************************************} ## {                                                                    } ## {  - XPKT : - VCSERACH                                               } ## {           - SETDIAG                                                } ## {           - PRINTCAUSEDIAG                                         } ## {           - P_LEVEL_TREATMENT :                                    } ## {                   - DECODE_CALL                                    } ## {                   - PROCESS_CALL_FACILITIES :                      } ## {                         - FC_SELECT                                } ## {                         - F_REV_CHARG_SELECT                       } ## {                         - F_CUG                                    } ## {                         - F_PACKET_SIZE                            } ## {                         - F_WINDOW_SIZE                            } ## {                         - F_RPOA                                   } ## {                                                                    } ## {                   - PROCESS_CALL : - SEARCH_FREE_PAD_EQT           } ## {                                    - SEARCH_HTOHEQT                } ## {                                                                    } ## {                   - PROCESS_CALL_COLLISION                         } ## {                   - SVCP3_CALLCONF                                 } ## {                                                                    } ## {           - D_LEVEL_TREATMENT                                      } ## {           - P_INT_PKT                                              } ## {           - P_INTCONF_PKT                                          } ## {           - P_DATA_RR_RNR : - SETUP_EMA_STORAGE                    } ## {                             - P_DATAPKT                            } ## {                                                                    } ## { Process a packet; either a complete non data packet                } ## {    or a complete Qbit data packet                                  } ## {    or the first 3 (or 4) bytes of a non-Qbit data packet.          } ## {                                                                    } ## { Note: First 3 (or 4) bytes already decoded in Network PKTHEADER    } ## {                                       and in XNETPR & XNETPS       } ## {      Rest of packet in XNETIBUF; (XNETtlog bytes)                  } ## {                                                                    } ## {********************************************************************} #       VAR  ContinuePandD , MustSendSoftError  : boolean;         PacketCode : -2..255;      $page$       {*****************************************************}   {                                                     }   {                    VCSEARCH                         }   {                                                     }   { Find a VC tbl, given a network ptr and a VC number. }   { Sequential search over circular list of VC tables   }   { of this network.                                    }   {                                                     }   { Called from XPKT main                               }   {                                                     }   {*****************************************************}     	 PROCEDURE VCSEARCH 	           ( NP  : NetwPtrType ; { identifies the network }               IVC : word   ;      { VC number } !             var VCP : VCptrType { result: ptr on VC rec if found } !!                                 {       : NIL if VC not found    } !            ); $direct$        VAR  VCfound    : boolean;        V          : VCptrType ;         LoopLimit  : VCptrtype;       BEGIN     
    VCfound := false; 
    V := NP^.FirstVC ;  {never NIL}  
    LoopLimit := V ; 
         repeat      {}     {}   if V^.VCnb = IVC     {}      then  VCfound := true      {}      else  V := V^.NextVC      {}     until ( VCfound or ( V = LoopLimit )) ;            if VCfound 	      then VCP := V 	
      else VCP := NIL 
    	  end {VCSEARCH } ; 	     $page$    {****************************************************}  !  PROCEDURE  SETDIAG (diag: word; var finaldiag: byte) ;  $direct$ !   {****************************************************}       { Sets FinalDiag equal to diag or       }   { to appropriate value if pkt incorrect }        Label 77; {used to simplify structure}       BEGIN          {PacketCode already set by XPKT main }              If PacketCode = -2 { Rest/restConf with VC<>0}          then begin FinalDiag:= 41;  goto 77 end;             If PacketCode = -1 {unknown type}         then begin FinalDiag:= 33 ; goto 77  end;              If (Diag=27) or (Diag=28) {state d1 or d2}  	        then begin 	            If (PacketCode=CallPkt) or (PacketCode=CallConfPkt)              or (PacketCode=ClearPkt) or (PacketCode=ClearConfPkt)              then begin FinalDiag:=35; goto 77 end;                  If PacketCode=RejectPkt             then begin FinalDiag:=37; goto 77 end          end;              If PacketCode = RejectPkt           then begin FinalDiag:= 33; goto 77 end;      
        If XNETpktTooLong=1 
         then begin FinalDiag := 39 ; goto 77  end;             FinalDiag := Diag ; {unchanged}       77:       end {SETDIAG} ;  $page$    {********************************************************}  #  PROCEDURE  PRINTCAUSEDIAG (MsgLu:word; X25msgindex:byte );  $direct$ #   {********************************************************}     #  {Print X25msgindex 'packet' received and Network LU number, on MSGLU} #   {Print Cause, Diag for received Restart,Clear and Reset}    {Print also VC# for Clear and Reset} 
  {If no diag, sets diag=0} 
 !  {If no cause, sets cause=0 (since we always accept these pkts) } !   {Note: should work without change whatever pkt numbering is}        VAR  C,D : word;  I : 0..4096;        CauseChar, DiagChar, VCchar: pa6c;       BEGIN        With Netwp^ do begin      {Print first line with type of pkt and VC number:}         XMSGWR ( msglu, X25MSGindex, CardWriteLU );     {Print second line with Cause, diag and VC number:}         XMSG := X25MSGCauseDiagPattern;        {set C and D equal to Cause and Diag of incoming pkt:}          If XNETpktTooShort = 0           then begin {diag in incoming pkt}              C := PKTheader.PKTbyte4.B;              D := XNETIBUF.B [ XNETIBUFbyteIndex ];           end  
         else begin  
             D := 0; {no diag}  
            If XNETtlog = 3 
            then {no cause in PKT} C := 0              else C:= PKTheader.PKTbyte4.B;          end;             CNUMD ( C, CauseChar );         CNUMD ( D, DiagChar ); {convert in decimal chars}            For I:= 4 to 6 do {print only last three digits}         begin           XMSG[ CauseCharOffset + I ] := CauseChar [ I ];            XMSG[ DiagCharOffset  + I ] := DiagChar  [ I ] ;        end;              CNUMD(PKTheader.pktVC,VCchar); {convert in decimal chars}         For I := 3 to  6 do {print only last 4 digits}             XMSG[ VCcharOffset + I ] := VCchar [ I ];     "    {Try to send msg first with Class write; }  {Note:same as XMSGWR} "     {If no SAM, send it with Direct Write    }     #    If XEXEC18 (18,msglu,XMSG,-XMSGlength,ip1ToIgnore,0,XNETclassNb) <0 ##    then XEXEC2 ( 2, MsgLu, XMSG,- XMSGlength); {no SAM;use direct I/O} #        {Recovery message if Restart received:}     If (X25MsgIndex = RestartInitiated) and (X25R = R1)      then begin        If XEXEC18 ( 18, MsgLu, Recovery, -RecoveryLength,                                Ip1ToIgnore,0,XNETclassNb) < 0        then XEXEC2 ( 2, Msglu, Recovery, -RecoveryLength );                                    {no SAM; use direct I/O}      end;  
   end {with Netwp}; 
  end {PrintCauseDiag};  $page$ # {********************************************************************} # PROCEDURE   P_LEVEL_TREATMENT ;                 $direct$ # {********************************************************************} ## {                                                                    } ## {           - P_LEVEL_TREATMENT :                                    } ## {                   - DECODE_CALL                                    } ## {                   - PROCESS_CALL_FACILITIES :                      } ## {                         - FC_SELECT                                } ## {                         - F_REV_CHARG_SELECT                       } ## {                         - F_CUG                                    } ## {                         - F_PACKET_SIZE                            } ## {                         - F_WINDOW_SIZE                            } ## {                         - F_RPOA                                   } ## {                                                                    } ## {********************************************************************} #       TYPE CUDarraytype = packed array [0..16] of byte ;     
  VAR   error : word; 
        CallingAdd, CalledAdd : NetworkaddressType;          CallingAddLength, CalledAddLength : 0..4095;          FacilityIndex, FacilityLength : 0..4095;         CallType : (HtoHCall, PadCall);          CUDarray : CUDarraytype;      $ title 'P_LEVEL_TREATMENT' , page $  {******************************************************}  " PROCEDURE DECODE_CALL ( var error: word; var diag: byte);  $direct$ " {******************************************************}          { Decode  CALL and CALL CONF packets:              }      {    Calling and called addresses                  }      {    Call Type (always set to HtoH if CALL CONF)   }      { Note: just skips over facilities.                }      { Called from PROCESS_CALL and SVCP3_CALLCON       }       LABEL 66;  "       {end of Decode_Call (used to simplify structure with errors)} "      VAR Index, K , IndexBCD, I ,L: 0..4095;      BEGIN { Note: error=19 clear cause "local procedure error" }         FOR I := 0 TO 16 do CUDarray[I] := 0;         Error := 0;  "   If XNETpktTooShort=1 then begin diag:=38; error:=19; goto 66 end; "    {Note: no Check if too long ????}       Index := XNETibufByteIndex;             { already set for normal/extd pkt numbering }       With Netwp^.PKTheader.PKTbyte4 do begin         CallingAddLength:= BCD [0];         CalledAddLength:=  BCD [1];   end {with};    K:= (CallingAddLength + CalledAddLength + 1) DIV 2 ;       If Index+K > XNETtlog   {too short for address fields?}    then begin diag:=38 {pkt too short}; error:=19; goto 66 end;     
  {Extract Called address:} 
     IndexBCD := Index + Index;                  { *2 to Change byte index in BCD digit index }      CalledAdd := ZeroNetwAdd ; 
     If CalledAddLength > 0 
     then begin            CalledAdd.Add[1] := CalledAddLength;           For I:= 2 to CalledAddLength+1 do           begin                CalledAdd.Add [I]:= XNETIBUF.BCD [IndexBCD];                IndexBCD := IndexBCD +1;            end;      end;    {Extract Calling Address:}      CallingAdd:= ZeroNetwAdd ;       If CallingAddLength > 0       then begin             CallingAdd.Add[1] := CallingAddLength;            For I:= 2 to CallingAddLength+1 do            begin                 CallingAdd.Add [I] := XNETIBUF.BCD [IndexBCD];                IndexBCD := IndexBCD + 1;             end;       end;          Index:=Index+K; {skip over addresses}   $page$      {Facility length field:}         If Index >= XNETtlog   {end of packet ?}        then begin             FacilityLength:=0;              CallType:= HtoHCall; {default}   	         goto 66;  	       end;        FacilityLength:= XNETIBUF.B [index] ;         Index:= Index + 1;             If Index+FacilityLength > XNETtlog   {packet too short ?}          then begin diag:=38; error:=19; goto 66 end;         {Memorize index of first facility field:}        FacilityIndex:= Index;         Index:= Index + FacilityLength; {skip over Facility fields}      
   {Call User Data field:} 
 
      If Index >= XNETtlog 
       Then {no call user data} CallType:= HtoHCall {default}        else begin               L := XNETtlog - Index;  {CUD field length}                    IF L > 16  {CUD too long}               THEN begin diag:=64; error:=19; goto 66 end;                    If XNETIBUF.B[Index]=1                Then CallType:= PADCall               else CallType:= HtoHcall;                   CUDarray[0] := L;                  FOR I:=1 TO L do begin                  CUDarray[I] := XNETIBUF.B[Index] ;                  Index := Index + 1 ;              end; {FOR}        end;{else}     66:   end { Decode_Call } ;  $page$   {*****************************************************}     PROCEDURE PROCESS_CALL_FACILITIES                     $direct$      (var error: word; var diag: byte; PktType: word);   {*****************************************************}         {Use PKTType= CallPkt or CallConfPkt, depending upon pkt type}    {Note: sets error=cause code and Diag=diag code.}         TYPE  byteConvTag = 0..3;        VAR   BYTECONV : packed record             case  ByteConvTag  of                 0: ( B : byte);                 1: ( Lcode: bits2; Fcode: bits6);                  2: ( bit87: bits2; Reserved: bits5; bit1: bits1);                  3: ( LeftHalf, RightHalf : bits4)            end;          VAR Fcode, Lcode : byte;        {******************} #   PROCEDURE FC_SELECT ( var IncFC: byte; DesFC, STDFC: byte); $direct$ #   {******************}          { FLOW CONTROL SELECTION }      { Subroutine used by F_PACKET_SIZE and F_WINDOW_SIZE }          { Flow-control negotiation for packet size and window size: }       { According to Incoming value (IncFC),                      }       {              Desired Value (DesFC),                       }       {              CCITT standard value (STDFC),                }       { stores the accepted value into IncFC.                     }          BEGIN           If IncFC <> STDFC        then begin 
      {}   If IncFC < STDFC 
      {}   then begin 
 #      {}   {}   If IncFC <= DesFc  {note: always true for window size} #      {}   {}   then {select min of DesFC and STDFC:}       {}   {}      If DesFC < STDFC        {}   {}        then IncFC := DesFC        {}   {}        else IncFC := STDFC       {}   {}   {else accept IncFC}        {}   end        {}   else begin  { IncFc > STDFC }       {}   {}   If DesFC <= IncFC        {}   {}   then  { select max of DesFC and STDFC: }       {}   {}      If DesFC < STDFC        {}   {}        then IncFC := STDFC        {}   {}        else IncFC := DesFC       {}   {}   {else accept IncFC}        {}   end       end       { else always accept, IncFC = STDFC }      
    end {FC_SELECT}; 
 $ subtitle 'PROCESS_CALL_FACILITIES' , page$    {********************************}    PROCEDURE F_REV_CHARG_FAST_SELECT;  $direct$    {********************************}         BEGIN           If  PktType=CallConfPkt       then  begin {not valid} error:=3; diag:= 65 end      else begin      {} ByteConv.B := XNETIBUF.B [ FacilityIndex ];      {}       {} If ByteConv.bit1= 1  {Reverse Charging requested ? }  	     {} then begin 	      {}  {}  If not EQTPTR^.Facilities.ARbit        {}  {}  then begin {Not subscribed} Error:=25; diag:=66 end        {} end;      {}      {} If ByteConv.Bit87 <> 0  {fast select requested ?}       {} then begin {not supported} error:=41; diag:=65 end      {}      end;     end {F_REV_CHARG_FAST_SELECT} ;         {***************************}     PROCEDURE F_THROUGHPUT_CLASS;  $direct$     {***************************}        VAR W : bits4;         BEGIN      
     With EQTPTR^ do begin 
 !       If Facilities.TCbit  {throughput negotiation subscribed ? } !       then begin            {accept values; no need to verif(not used later on)}             EffectivePTW.B [2] := XNETIBUF.B [ FacilityIndex ];  #                     { order: From called (left) From calling (right)} #           If PktType = CallPkt             then begin {Must exchange IN & OUT values}                With EffectivePTW do begin                 W:= inThcl; inThcl:=outTHcl; outTHcl:=W;              end {with}             end         end         else begin error:=3; diag:=65 end          end {with}         END {F_THROUGHPUT_CLASS};  $page$  
   {***************} 
    PROCEDURE F_CUG ;  $direct$  
   {***************} 
        BEGIN           If  PktType = CallConfPkt      then begin {illegal:} error:=3; diag:=65 end       {else just ignore, since checked by network???}        END {F_CUG};             {*************************}     PROCEDURE F_BILATERAL_CUG ;  $direct$     {*************************}         BEGIN  {facility not supported}          If PktType = CallConfPkt      then begin Error:=3; Diag:= 65 end 	     {else ignore!} 	     
   END {F_BILATERAL_CUG} ; 
 $page$    {**************************************}     PROCEDURE F_PACKET_SIZE ;  $direct$    {**************************************}         VAR  OUTPS,INPS,W:  byte;         BEGIN      
     With EQTPTR^ do begin 
          If Facilities.PSbit  {pkt size negotiation subscribed ?}   	        then begin 	         {}   {Extract values as if CALL pkt received:}  !        {}     OUTPS  := XNETIBUF.B [FacilityIndex]; {From called} ! "        {}     INPS := XNETIBUF.B [FacilityIndex + 1];{from calling} "        {}   If  PktType= CallPkt         {}   then begin         {}   {} {Check if values are in legal range: 4..10} !        {}   {} If (OUTPS<4) or (OUTPS>10) or (INPS<4) or (INPS>10) !        {}   {} then begin { illegal:} error:=3; diag:=66 end  
        {}   {} else begin 
        {}   {}   {Process OUT PKT size:}          {}   {}     FC_SELECT (OUTPS,DesiredPTW.OUTpktSize,7);          {}   {}                               {modifies OUTPS}         {}   {}     EffectivePTW.OUTpktSize := OUTPS;          {}   {}   {Process IN PKT size:}          {}   {}     FC_SELECT ( INPS, DesiredPTW.INpktSize,7);          {}   {}                                {modifies INPS}          {}   {}     EffectivePTW.INpktSize := INPS 	        {}   {} end 	         {}   end         {}   else begin {Call Conf PKT} !        {}   {} {exchange IN & OUT:} W:=INPS; INPS:=OUTPS;OUTPS:=W; !!        {}   {} {Check if values are compatible with those in call} !         {}   {}  With EffectivePTW do  begin "        {}   {}   If   ( (( OUTpktSize <= OUTPS ) and ( OUTPS <= 7 )) "#        {}   {}       or (( 7 <= OUTPS ) and ( OUTPS <= OUTpktSize )) ) # !        {}   {}    and ( (( INpktSize <= INPS ) and ( INPS <= 7 )) ! "        {}   {}       or (( 7 <= INPS ) and ( INPS <= INpktSize )) ) "         {}   {}     then begin {indicated values are ok}         {}   {}          OUTpktSize:=OUTPS;         {}   {}          INpktSize :=INPS         {}   {}     end          {}   {}     else begin          {}   {}          error:=3; diag:= 66         {}   {}     end 
        {}   {}  end {with} 
         {}   end         end         else begin Error:=3; diag:=65 end       end {with EQTPTR}     END {F_PACKET_SIZE} ;      $page$     {***********************}     PROCEDURE F_WINDOW_SIZE ;  $direct$     {***********************}        VAR  OUTWS,INWS, W : byte;         BEGIN      
     With EQTPTR^ do begin 
          If Facilities.WSbit  {wdw size negotiation subscribed ?}   	        then begin 	         {}   {Extract values as if CALL pkt received:}  "        {}     OUTWS := XNETIBUF.B [FacilityIndex];    {from called} ""        {}     INWS  := XNETIBUF.B [FacilityIndex + 1];{from calling} "        {}   If  PktType= CallPkt         {}   then begin         {}   {} { check if values are in legal range: }         {}   {} { 1..7 (if normal pkt nb)             }  "        {}   {} If ((OUTWS<1) or (OUTWS>7) or (INWS<1) or (OUTWS>7)) "        {}   {} then begin {illegal} error:=3; diag:=66 end  
        {}   {} else begin 
        {}   {}   {Process OUT WDW size:}  !        {}   {}     FC_SELECT ( OUTWS, DesiredPTW.OUTwdwSize, 2 ); ! !        {}   {}                                 { modifies OUTWS } !        {}   {}     EffectivePTW.OUTwdwSize := OUTWS;          {}   {}   {Process IN WDW size:}          {}   {}     FC_SELECT ( INWS, DesiredPTW.INwdwSize,2);          {}   {}                                {modifies INWS}          {}   {}     EffectivePTW.INwdwSize := INWS 	        {}   {} end 	         {}   end         {}   else begin {Call Conf PKT} "        {}   {} {exchange IN & OUT:} W:=INWS; INWS:=OUTWS; OUTWS :=W; "!        {}   {} {Check if values are compatible with those in call} !         {}   {}  With EffectivePTW do  begin  "        {}   {}   If   ( (( OUTwdwSize <= OUTWS ) and ( OUTWS <= 2)) "#        {}   {}       or (( 2 <= OUTWS ) and ( OUTWS <= OUTwdwSize )) ) # !        {}   {}    and ( (( INwdwSize <= INWS ) and ( INWS <= 2 )) ! "        {}   {}       or (( 2 <= INWS ) and ( INWS <= INwdwSize )) ) "         {}   {}     then begin {indicated values are ok}         {}   {}          OUTwdwSize:=OUTWS;         {}   {}          INwdwSize :=INWS         {}   {}     end          {}   {}     else begin          {}   {}          error:=3; diag:= 66         {}   {}     end 
        {}   {}  end {with} 
         {}   end         end         else begin Error:=3; diag:=65 end       end {with EQTPTR}         END {F_WINDOW_SIZE} ;      $page$ 
   {****************} 
   PROCEDURE F_RPOA ;  $direct$ 
   {****************} 
       BEGIN  {facility not supported }          If PktType = CallConfPkt      then begin 	       Error := 3 ; 		       Diag := 65 ; 	      end ;       {else  ignore ! }        END {F_RPOA} ;      $ page $   {*******************************}   BEGIN { PROCESS_CALL_FACILITIES }   {*******************************}          { Called from PROCESS_CALL and SVCP3_CALLCONF    }      { On incoming call and call confirmation packets }          If  PktType = Callpkt {initialize with default values}         then EQTPTR^.EffectivePTW := NETWP^.DefaultPTW;             { used in XDISP to send call confirmation }         Error:=0;         While (FacilityLength>0) and (Error=0) do begin        ByteConv.B := XNETIBUF.B [FacilityIndex] ;        If ByteConv.B = 0 {"National facility marker" ?}        then  FacilityLength:=0  {terminate without error}        else begin #       {} Fcode:= ByteConv.Fcode;     { bits <1:6> to speed up access } ##       {} Lcode:= ByteConv.Lcode + 1; { bits <7:8>          "         } #       {}{--------------------------------------------------}        {}{  Process ONE facility:                           }        {}{--------------------------------------------------}        {} FacilityIndex:= FacilityIndex+1;{Skip over code byte}         {} Case Lcode of    {Note: Lcode=value found in pkt + 1 !}         {} 	       {}  1: begin 	        {}        If FacilityIndex >= XNETtlog  {end of pkt?}        {}        then begin  Error:=3; Diag:=38 end 
       {}        else 
       {}         {}  Case Fcode of         {}         {}    1: F_REV_CHARG_FAST_SELECT;  { 00000001 }          {}         {}    2: F_THROUGHPUT_CLASS;       { 00000010 }          {}         {}    3: F_CUG ;                   { 00000011 }          {}         {}    otherwise error:=3; Diag:=65         {}         {}  end {case Fcode}  	       {}     end; 		       {}  2: begin 	       {}        If FacilityIndex+1 >= XNETtlog {end of pkt?}         {}        then begin Error:=3; Diag:=38 end 
       {}        else 
       {}         {}  Case Fcode of         {}         {}     1:  F_BILATERAL_CUG;        { 01000001 }          {}         {}     2:  F_PACKET_SIZE;          { 01000010 }          {}         {}     3:  F_WINDOW_SIZE;          { 01000011 }          {}         {}     4:  F_RPOA;                 { 01000100 }          {}         {}     Otherwise  Error:=3; Diag:=65         {}         {}  end {case Fcode}  	       {}     end; 	 !       {}  Otherwise {invalid facility request} error:=3; Diag:=65 !       {} 
       {} end {case Lcode}; 
       {}  FacilityIndex:= FacilityIndex + Lcode;         {}                  { code byte already skipped }         {} {--------------------------------------------------}         {}  FacilityLength := FacilityLength-Lcode -1 ;         {}                    { here must count code byte }         end     end {while}    end {Process_Call_Facilities};   $ subtitle ' ' , page $  {****************************************}  PROCEDURE  PROCESS_CALL (vcptr:VCptrType);      $direct$  {****************************************}       { Process a CALL on an SVC in state P1    }   { ( or P3 or P5 via CALL_COLLISION)       }   { There is NO associatedEQT at this point.}       LABEL 888; {End of Process_call (used to simplify structure)}       VAR I:byte;      $ subtitle 'PROCESS_CALL' , page $     {*****************************************************} "   PROCEDURE SEARCH_FREE_PADEQT (var eqtptr: EqtPtrType) ;   $direct$ "    {*****************************************************}          VAR FOUND : boolean;         BEGIN         {Explore list of EQT tables:} 
      Found := false; 
       EQTPTR := NETWP^.FirstPADeqt; {could be nil}           While (Not Found) and ( EQTPTR<>nil) do begin        {} With EQTPTR^ do begin        {} {} {Is it "free" ?}        {} {} If  AssociatedVC=nil        {} {} then FOUND:=true       {} {} else EQTPTR:= Nexteqt 	      {} end {with} 	      end{while};         {Here EQTPTR=nil if no free pad eqt; <>nil if found }         END {Search_free_padeqt};  $page$   {*********************************************}    PROCEDURE SEARCH_HTOHEQT                            $direct$     ( var CallingAdd: NetworkAddressType; var EQTPTR:EqtPtrType );    {*********************************************}       LABEL {used to simplify structures}           66, 88;   VAR  Equal, CAleLA : boolean;          I: byte;       BEGIN           {Search for an SVC EQT with an address equal to CallingAdd:}      EQTPTR:= NETWP^.FirstSVCeqt; {could be nil}     While  EQTPTR <> nil do begin      {} With EQTPTR^ do begin      {}   If EqtType = svcEqtType 	    {}   then begin 	     {}   {} {Compare CallingAdd and Remote:}      {}   {}     Equal:=true; I:=1;      {}   {}     While (equal) and (I<=4) do       {}   {}     {} If CallingAdd.W [I] = Remote.W [I]       {}   {}     {}     then I:=I+1      {}   {}     {}     else Equal:=false      {}   {}     ; {end while}       {}   {}       {}   {}  If Equal       {}   {}    then goto 66 {found: exit from loop}       {}   {}    else EQTPTR:= NextEQT      {}   end      {}   else EQTPTR:=nil {end of SvcEqts}     {}      {} end {with EqtPtr};     end {while};      {EQTPTR always Nil at this point.}           {No SVC eqt with this address}     {Try to find a free (not down) pool eqt:}         EQTPTR := Netwp^.FirstPoolEQT; {could be nil}         While EQTptr <> nil  do begin      {}     {}  with EQTPTR^, EQText do begin      {}  {}     {}  {} If EQTtype = PoolEqtType     {}  {} then      {}  {}   If (( AssociatedVC = nil) AND     {}  {}       ( Remote.W[1] = DummyNetwAdd.W[1]) AND      {}  {}       ( Downflag = false )) !    {}  {}   then goto 88 { found: exit from pool loop and Search } !    {}  {}   else EQTPTR := NextEqt     {}  {} else     {}  {}   EQTPTR := nil ; {end of Pool Eqts}      {}  {}  	    {}  end {with} 	     {}      end {while};         {EQTPTR always nil at this point}     
  Goto  88 {end of search}; 
 $page$   66:     With EQTPTR^ do begin            { we have found an SVC eqt with the same address }     If AssociatedVC = nil     then begin {This EQT is "free"}     {}   If not EstCircReceived      {}   then  EQTPTR := nil {consider as not found}     {}   {else  : EQT acceptable}     end     else begin {There is already ANOTHER VC associated}      {} With AssociatedVC^ do begin      {}   case X25P  of     {}     P3: begin {Wait Call Conf} !    {}         {This is NOT the CCITT collision,but parallel calls} !    {}         {     on different VCs.}  "    {}         {XNET decision rule: accept if CallingAdd > LocalAdd} "     {}           I := 1;  !    {}           CAleLA := true; {assume Calling Add <= Local Add} !    {}           With NETWP^ do begin      {}            While (( CAleLA ) and ( I <= 4 )) do     {}            {} If CallingAdd.W [I] <= LocalAddr.W [I]     {}            {}    then I := I+1      {}            {}    else CAleLA := false ;     {}            { end while }     {}           end {with Netwp^};      {}       {}         If CAleLA {CallingAdd Lower or equal Local Add ?}      {}         then {reject this call}  EQTPTR := nil      {}         else begin {accept this call}      {}         {}   X25P := p8; {send clear on "old" vc}     {}         {}   Cause := 0;      {}         {}   diag := 0; { ????? }     {}         {}   PKTwriteNeeded := true;      {}         {}   AssociatedEqt := nil ; { cut links }      {}         {}   AssociatedVC  := nil ;     {}         {}   { Could be waiting for reset conf (D3), }      {}         {}   { cancel timer & decrease timer counters }      {}         {}   if VCTO <> -1  then     { M37 BG 26AUG87 } 
    {}         {}     begin 
    {}         {}       VCTO := -1;      {}         {}       RetryCtr := 0;       {}         {}       NETWP^.X25TOctr := NETWP^.X25TOctr - 1 ;       {}         {}       GlobalTOctr := GlobalTOctr - 1 ;  
    {}         {}     end; 
 	    {}         end 	     {}         end {P3};  #    {}     P5: begin { Send Call} {Nothing done at this point: cancel} #     {}           X25P := P1;     {}           CallRetryCtr := 0;     {}           PKTwriteNeeded := false;     {}           {cut links:}     {}                AssociatedEQT := nil;     {}                AssociatedVC := nil     {}         end {P5} ;  
    {}     Otherwise 
    {}         EQTPTR:= nil {EQT not able to receive this call}  
    {}    end {case X25P}; 
     {} end {with associatedVc}     end      end {with EqtPtr};   88:   END {SEARCH_HTOHEQT};      $page$    {**************************************}  
  BEGIN {  PROCESS_CALL  } 
   {**************************************}        { Called from CALL_COLLISION and P_LEVEL_TREATMENT }        With VCPTR^ do begin      "     If VCtype = svcout then { may not receive a call on 1 way out } "        begin  
         Diag := 34; 
         X25P := p8 { send clear };  	         goto 888; 	       end;           DECODE_CALL ( error, diag) ; {does not decode facilities}  "        {sets: CallingAdd,CalledAdd; FacilityIndex&length; CallType} "         {sets error=0 if no problem, error<>0 if problem!}          If error <> 0 then         begin          Cause := error ;           X25P := P8 { send clear } ; 	         goto 888 ; 	       end;      
     If CallType = PADcall 
         then SEARCH_FREE_PADEQT (EQTPTR)         else SEARCH_HTOHEQT (Callingadd, EQTPTR);      
     If EQTPTR = nil 
         then begin {no acceptable EQT to receive the call}            Cause := 1 ; { clear "number busy" }           diag := 64 ; { call setup problem }           X25P := p8 ; { send clear }  
          goto 888 ; 
         end;           {Link together VC and EQT:}          EQTPTR^.AssociatedVC := VCPTR;          AssociatedEQT := EQTPTR;          PROCESS_CALL_FACILITIES ( error, diag , CallPkt );          If error <> 0 then         begin          Cause := error ;           X25P := P8 { send clear } ; 	         goto 888 ; 	       end;           {Call may be accepted:}         {Update address if not svceqttype:}         {Update incoming call user data field:}            With EQTPTR^ , EQText do begin                If EQTtype <> SVCeqtType                then begin                   Remote := CallingAdd;                   {should we also update CUGnumber ???}  	              end; 	              CUDin := zeroCUD;                If CUDarray[0] <> 0  {CUD present in incoming call}                 Then begin                  CUDin.length := CUDarray[0];                  FOR I := 1 TO CUDarray[0] do                      CUDin.B[I] := CUDarray[I];  	              end; 	              {else no incoming CUD received}            end {with EQTPTR, EQText};            X25P := p2 {send call conf};            {Note: LinkUp to DVX only when enter state P4}        888: PKTwriteNeeded := true;      
   end {with VCPTR}; 
      end { Process_call };   $ subtitle ' ' , page $    {************************************}    PROCEDURE  CALL_COLLISION  ;                    $direct$    {************************************}        {Process CCITT-defined collision on an SVC }       VAR EP1 : EqtPtrType;       BEGIN        With VCPTR^ do begin     {VC may be in state P3 (wait call conf) or P5 (send call) }           {verify if this VC may legally receive a call:}  !      If VCtype = svcout { may not receive a CALL on a 1 way out } !       then begin       {}   X25P := p8 {send clear};        {}   Diag := 34;       {}   PKTwriteNeeded := true       end        else begin        {} {CCITT rule: DTE may ignore the call}        {} If NETWP^.DCE 	      {} then begin 	       {}    EP1 := AssociatedEQT; {save for later use}       {}    {cut links:} EP1^.AssociatedVC:= nil;        {}                 AssociatedEQT := nil;        {}       {}    PROCESS_CALL ( VCPTR );        {}        {}    If AssociatedEqt = nil       {}    then begin {re-link with initial Eqt}        {}    {}   AssociatedEqt := EP1;        {}    {}   EP1^.AssociatedVC := VCPTR;       {}    {}  {reset call retry count:}       {}    {}   CallRetryCtr := Netwp^.CallRetryNb       {}    end        {}    else        {}    {} if AssociatedEQT <> EP1  
      {}    {} then  
       {}    {}     ESTABLISHCIRCUIT ( EP1 )         {}    {}     {else call has satisfied same Eqt}         {} end        {}       end 	   end {with VCPTR} 	   end {Call_collision };  $page$    {************************************}   PROCEDURE  SVCP3_CALLCONF ;                $direct$    {************************************}       BEGIN        With VCPTR^ do begin      
      If XNETpktTooShort=0 
       then begin       {} DECODE_CALL ( error, diag );        {} 
      {} If error = 0 
 !      {} then PROCESS_CALL_FACILITIES (error, diag, CallConfPkt ); !      end       else Error := 0; {only 3 or 4 bytes in call conf pkt}     	      If error <> 0 	      then begin { reject the call conf }       {}   Cause := error; {diag already set}        {}   X25P  := p8 {send clear};        {}   PKTwriteNeeded := true;       end       else begin {circuit is now established}        {}   X25P := p4;        {}       {}   D1CleanUp (VCPTR);        {}        {}   LINKUP ( AssociatedEQT );        {}       {}   If Netwp^.GlobalRead = NoRead then CurrentNet:=-1;        {}        end;     end {with};   END { SVCP3_CALLCONF };  $page$    {******************************************}    BEGIN  { P_LEVEL_TREATMENT }    {******************************************}        {Note: Clear and clear conf packets will be accepted even  }    {      if they are either too long or too short.           }        With NETWP^, VCPTR^ do begin      !       EQTPTR := AssociatedEQT ; {convenient init (could be nil) } !         Cause := 19; { Clear Local proc error (convenient init) }             If X25P = p4 { Data transfer ready }        then begin          {}         {} If  VCtype = pvc  then ContinuePandD := true 
        {} else begin 
          {}      {----------------------------------------------}            {}      {             SVC_P4     Data Transfer Ready   }            {}      {----------------------------------------------}            {}      { Note : there is always an Associated EQT     }           {}         {}       Case PacketCode of          {}          {}          {}         ClearPkt: begin          {}          {}       PrintCauseDiag ( 1 ,ClearReceived );          {}          {}       X25P := p6 ; { send clear conf }          {}          {}       PKTwriteNeeded := true;  #        {}          {}       AssociatedEqt^.EstCircReceived := false ; # #        {}          {}       { Could be waiting for reset conf (D3), } ##        {}          {}       { cancel timer & decrease timer counters } ##        {}          {}       if VCTO <> -1  then     { M37 BG 26AUG87 } #         {}          {}         begin          {}          {}           VCTO := -1;         {}          {}           RetryCtr := 0;         {}          {}           X25TOctr := X25TOctr - 1 ;          {}          {}           GlobalTOctr := GlobalTOctr - 1 ;          {}          {}         end;         {}          {}     end;          {}          {}          {}         CallPkt, CallConfPkt, ClearConfPkt:          {}          {}     begin          {}          {}       SETDIAG ( 23, Diag );         {}          {}       X25P := p8 { send clear };          {}          {}       PKTwriteNeeded := true;  #        {}          {}       AssociatedEqt^.EstCircReceived := false ; # #        {}          {}       { Could be waiting for reset conf (D3), } ##        {}          {}       { cancel timer & decrease timer counters } # #        {}          {}       if VCTO <> -1  then    { M37 BG 26AUG87 } #         {}          {}         begin          {}          {}           VCTO := -1;         {}          {}           RetryCtr := 0;         {}          {}           X25TOctr := X25TOctr - 1 ;          {}          {}           GlobalTOctr := GlobalTOctr - 1 ;          {}          {}         end;         {}          {}     end;          {}          {}          {}         Otherwise  ContinuePandD := true;          {}          {}          {}       end {case};           {}      {----------------------------------------------}            {}      {----------------------------------------------}          {} end;          {}         end  { if x25p = p4 }            else begin                { Flush possible data packet (others already flushed):}             If XNETmoreDataOnCard = 1 then GlobalRead := RFlush;      "          { Note: DataAvailable not yet set in EQT,so do not change} "    !          If PacketCode = ClearPkt { done here to save code space } !              then PrintCauseDiag ( 1 ,ClearReceived );               Case X25P  of                {}              p1: begin {--- VC Not established  --- SVC_P1 ---}                {}  Case PacketCode of               {}     {}                {}    CallPkt:               {}     {}   PROCESS_CALL (VCPTR);               {}    ClearPkt:               {}     {}   X25P := p6; {send clear conf}               {}    Otherwise                {}     {}   SETDIAG ( 20, DIAG);               {}     {}   X25P:= p8 {send clear};               {}  end {case};               {}  PktWriteNeeded := true;               {}end {p1};                {}              p2: begin    {--- Send Call Conf --- SVC_P2 ---}                {}  If PacketCode = ClearPkt                {}     { accepted even if too short/long }               {}  then  X25P:= p6 {send clear conf}                {}  else begin                {}  {}   SETDIAG( 21, Diag);                {}  {}   X25P:= p8 {send clear};                {}  end;               {}  PKTwriteNeeded := true;               {}end {p2};                {}              p3: begin    {--- Wait Call Conf --- SVC_P3 ---}                {}  Case PacketCode of                {}     CallPkt:   CALL_COLLISION ;                {}                {}     CallConfPkt: SVCP3_CALLCONF ;                {}                {}     ClearPkt: begin               {}            X25P := p6 {send clear conf};                {}            PKTwriteNeeded := true                {}            end;                {}     Otherwise                {}            SETDIAG ( 22, diag);                {}            X25P := p8 {send clear};                {}            PKTwriteNeeded := true                {}  end {case};   !              {}  If X25P <> p3 {Call_collision may keep state p3} ! "              {}  then begin {cancel timer and decrease TO counters} "               {}     VCTO := -1;                {}     X25TOctr := X25TOctr - 1;                {}     GlobalTOctr := GlobalTOctr - 1                 {}  end                {}end {p3};                {} !            p5: begin    {--- Send Call (not CCITT) --- SVC_P5 ---} !              {}  Case PacketCode  of               {}     {}               {}    CallPkt:   CALL_COLLISION ;               {}     {}                {}    ClearPkt:  begin                {}     {}   X25P:= p6 {send clear conf};                {}     {}   PktWriteneeded := true               {}     {}        end;               {}    Otherwise               {}     {}   SETDIAG( 20, Diag);               {}     {}   X25P := p8 {send clear} ;                {}     {}   PKTwriteNeeded := true                {}  end {case}               {}end {p5};                {}             p6: begin    {--- Send Clear Conf --- SVC_P6 ---}               {}  If PacketCode <> ClearPkt                {}  then begin                {}  {}   SetDiag ( 25, Diag );                {}  {}   X25P := p8 {send clear} ;               {}  {}   PKTwriteNeeded := true 
              {}  end 
              {}end {p6};                {}             p7: begin    {--- Wait Clear Conf --- SVC_P7 ---}                {}  Case PacketCode of               {}     {}                {}    ClearPkt, ClearConfPkt :  "              {}     {} begin  {Pkt accepted even if too long/short} "               {}     {}   P1SETUP ( VCPTR );                {}     {}   { sets X25P either to p1 or p5 }  #              {}     {}   If ( X25P = p1 ) and ( GlobalRead = Noread ) #               {}     {}      then CurrentNet := - 1;  !              {}     {}   {cancel timer and decrease TO counters:} !               {}     {}      VCTO := -1;               {}     {}      RetryCtr := 0;                {}     {}      X25TOctr := X25TOctr - 1;               {}     {}      GlobalTOctr := GlobalTOctr - 1                {}     {} end;               {}    Otherwise               {}     {} If ( XNETmoreDataOnCard = 0 ) and                {}     {}    ( GlobalRead = NoRead )                {}     {} then CurrentNet := - 1                {}  end { case } 
              {}end { p7 }; 
               {}              p8: begin    {--- Send Clear --- SVC_P8 ---}                {}  If PacketCode = ClearPkt                {}  then begin               {}    X25P := p6 { send clear conf };                {}    PKTwriteNeeded := true ;               {}    { Could be waiting for reset conf (D3), }                {}    { cancel timer & decrease timer counters }                {}    if VCTO <> -1  then     { M37 BG 26AUG87 } 
              {}      begin 
              {}        VCTO := -1;                {}        RetryCtr := 0;                {}        X25TOctr := X25TOctr - 1 ;                {}        GlobalTOctr := GlobalTOctr - 1 ;  
              {}      end; 
               {}  end;               {}  {ignore if not clear}               {}  {cause now changed to local proc error}                {}end {p8}           end {case X25P}  
       end {if X25P} 
   end {with Netwp,VCptr}    end { P_LEVEL_TREATMENT };   $ title 'XPKT' , page $   {*****************************************}    PROCEDURE  D_LEVEL_TREATMENT  ;                 $direct$   {*****************************************}        {Note: Reset and Reset Conf packets will be accepted even  }    {      if they are too long or too short.                  }       BEGIN          With VCPTR^ do begin         ContinuePandD := false; {will be changed if needed}         Cause :=5; {Reset Local Proc Error  (convenient init) } 
        Case X25D  of 
 #                        {--------------------------------------------} # #          D1 : begin    {     D1 Level  (data level ready)           } # #                        {--------------------------------------------} #                  Case PacketCode  of                      {}                     ResetPkt: "                    {}  begin {Note: cause of Reset is NOT processed} "                    {}    PrintCauseDiag(  1   ,ResetReceived);                     {}    X25D := d2; {send reset conf}                     {}    PKTwriteNeeded := true;                     {}    MustSendSoftError := true                      {}  end; 
                   DataPkt, 
 
                   RRpkt,  
 
                   RNRpkt, 
                    InterruptPkt,                     IntConfPkt :    ContinuePandD := true;                       {}                     Otherwise                      {}      SETDIAG ( 27, diag );                       {}      X25D := d4 {send reset};                      {}      PKTwriteNeeded := true;                      {}      MustsendSoftError := true                   end {case PacketCode}                 end {D1};  #                        {--------------------------------------------} # #          D2 : begin    {     D2  Level  (send Reset Conf)           } # #                        {--------------------------------------------} #                  If PacketCode <> ResetPkt 
                 then begin 
                 {}     If XNETmoreDataOnCard = 1                  {}       then NETWP^.Globalread := Rflush;                   {}     SETDIAG ( 28 , diag );                  {}     X25D := d4 {send Reset} ;                  {}     PKTwriteNeeded := true;                   {}     MustSendSoftError:= true                  {}   end !                 else {ignore} PrintCauseDiag ( 1, ResetReceived ); !	               end; 	 $page$  #                        {--------------------------------------------} # #          D3 : begin    {     D3  Level  (wait reset Conf)           } # #                        {--------------------------------------------} #                 Case PacketCode of                      {}                     ResetPkt,                     ResetConfPkt:                      {} begin                       {}   If PacketCode=ResetPkt  "                     {}     then PrintCauseDiag( 1, ResetReceived ); "                      {}   D1SETUP ( VCPTR );                      {} "                     {}   {Cancel timer and decrease timer counters:} "                     {}   VCTO := -1;                       {}   RetryCtr := 0;                       {}   With Netwp^ do                       {}     X25TOctr := X25TOctr -1;                       {}   GlobalTOctr := GlobalTOctr - 1 ;                       {} end;                      {}                     Otherwise                       {}   With Netwp^ do                      {}     If XNETmoreDataOnCard = 1                      {}       then GlobalRead := Rflush                      {}       else if GlobalRead = NoRead                       {}              then CurrentNet := -1 ;                      {}   { keep VCTO timer running } 
                 end {case} 
                end {D3};  #                        {--------------------------------------------} # #          D4 : begin    {     D4  Level  (send Reset)                } # #                        {--------------------------------------------} # #                 {Note: this is not a CCITT state; needed for NO SAM } #                  Case PacketCode  of                      {}                     ResetPkt: begin                       {}     PrintCauseDiag ( 1 , ResetReceived );                       {}     X25D := D2 { send reset conf };                     {}     PKTwriteNeeded := true                     {}   end;                      {}                    ResetConfPkt:  SETDIAG ( 27, diag );                      {}            { modify previous diag }                      {}                     Otherwise                     {}    If XNETmoreDataOnCard = 1                     {}       then NETWP^.GlobalRead := Rflush                      {}                    { Note that cause is now set }                    { to local procedure error.  }                      {} 
                 end {case} 
               end {D4}         end {case X25D}  
    end {with VCPTR} 
   end { D_LEVEL_TREATMENT  } ;  $page$   {*************************************}    PROCEDURE  P_INT_PKT  ;                   $direct$   {*************************************}        VAR INTcause : word;       BEGIN         With  VCPTR^ do begin        { We have here X25D = d1 }           If X25RI = NotInterrupted        then begin           X25RI := SendIntConf;          {Prepare Interrupt cause (convert into word):}             INTcause:= Netwp^.PKTheader.PKTbyte4.B;  "         XSEND( InterruptMsg, AssociatedEQT, 2{readEqt}, INTcause,0) "      end        else begin !         { Illegal interrupt pkt (previous one not confirmed yet) } !          X25D := d4 {send reset} ; 
         Diag := 44 ; 
          MustSendSoftError := true        end;           PKTwriteNeeded := true;      
   end {with VCptr}; 

  end { P_INT_PKT } ; 
 $page$   {*************************************}    PROCEDURE  P_INTCONF_PKT  ;               $direct$   {*************************************}       BEGIN         With  VCPTR^ do begin      
     If X25EI= WaitIntConf 
     then begin         X25EI := NotInterrupting;        { complete "send int" request on   }        { write Eqt (if not cleared by F0):} "       If AssociatedEQT^.WriteReadEqt[1].ReqState = CompleteWaitState "!         then XSEND ( NormalCompMsg,AssociatedEQT, 1{writeEqt},0,0) !      end      else begin  {illegal packet}        X25D := d4 {send reset};        Diag := 43 ;{CCITT code}         PKTwriteNeeded := true;         MustSendSoftError := true       end      
   end {with VCptr}  
 
  end  { P_INTCONF_PKT } ; 
 $page$    {**************************************}    PROCEDURE  P_DATA_RR_RNR  ;               $direct$    {**************************************}         LABEL 88; {end of P_DATA_RR_RNR (used to simplify structure) }        VAR TSTMOD, TSTMOD2: boolean; limit : byte;      
 $ title 'P_DATA_RR_RNR' $ 
    "  {*****************************************************************} ""  {                                                                 } ""  {} PROCEDURE SETUP_EMA_STORAGE ( EQTptr : EQTPTRtype ); $direct$ {} ""  {                                                                 } ""  {  Prepare parameters needed to issue a VMAIO Read                } ""  {  to move data from the card to an EMA buffer.                   } ""  {                                                                 } ""  {  Called from XPKT/P_DATA_RR_RNR/P_DATAPKT  ( 3 times )          } ""  {                                                                 } ""  {*****************************************************************} "      BEGIN          With NETWP^,EQTPTR^,Nextfreebuffer^ DO BEGIN            GlobalRead := CardEMAread ;  { Type of global read }             GRP2 := PKTsizetable[ EffectivePTW.Inpktsize ];                                       { maximum read byte length }         GRPP := Nextfreebuffer; { EMA buffer address }             Respeqt := EQTptr;  { EQT responsible for global read }      	    END ; { with } 	      END ; { Setup_ema_storage }           {*************************************}   PROCEDURE  P_DATAPKT  ;                $direct$   {*************************************}        BEGIN { Process incoming data packet }         With NETWP^ , VCPTR^ do begin      If FlushData { Set in procedure flush_message. }      then begin   { Flush data packets until end of message }       {} AssociatedEQT^.sendRR:=true;  	     {} PRTS:=RPS; 	     {} Pktwriteneeded:=true;       {} If Not PKTheader.Mbit then FlushData := false;       {}                             { end of message }       {} Globalread := Rflush ; { Flush card active input buffer }        {}                        { not all port buffers.          }        end      else begin       {} With AssociatedEQT^,WriteReadEQT[2] do begin       {}  If ReqState = ReadState       {}                  {-----------------}       {}  then begin      {  Read  Pending  }       {}                  {-----------------}      {}      If ((PKTheader.Qbit) and       {}         (AssociatedEQT^.eqttype = PADeqttype))       {}      then begin { do not accept: no type ahead }      {}      {}   If XNETmoredataOnCard = 1       {}      {}     then GlobalRead := RFlush;      {}      {}   Diag := 27; { Pkt type invalid for state D1 }       {}      {}   X25D := D4 { send reset };      {}      {}   PKTwriteNeeded := true;      {}      {}   MustSendSoftError := true       {}      end        {}      else begin  { not a Q-bit data packet for PAD EQT }       {}      {} If XNETmoreDataOncard = 1  
     {}      {} then begin 
      {}      {}   DataAvailable := true;       {}      {}   MSGinProgress := true;       {}      {}   SETUP_EMA_STORAGE ( AssociatedEQT );       {}      {}   Setup_ema_user := true ;  { transfer from EMA }        {}      {}            { to user's buffer in SAM can occur. }  	     {}      {} end 	     {}      {}      {}      {}else begin  { empty data pkt !!! }      {}      {}       {}      {} $SKIP_TEXT ON$            {M10 BG 06feb86}       {}      {}   If Not PKTheader.Mbit  {end of message?}       {}      {}   then begin      {}      {}      MSGinProgress:= false;       {}      {}      XSEND ( NormalCompMsg, AssociatedEQT,      {}      {}              2{read}, 0, EQTtlog) 
     {}      {}   end 
     {}      {} $SKIP_TEXT OFF$      {}      {} !     {}      {} if  EMAcounter = 0  then { nothing in EMA buffers } !     {}      {}      {}      {}  begin { discard & acknowlegde it }       {}      {}        { even if MSGinprogress }      {}      {}    pktwriteneeded := true ;      {}      {}    sendRR := true ;       {}      {}    PRTS := RPS ;  
     {}      {}  end 
     {}      {} !     {}      {} else { EMAcounter <> 0 , something in EMA buffers } !     {}      {}       {}      {}  begin        {}      {}    { acknowledgement of previous pkt will take }       {}      {}    { this empty pkt in effect }       {}      {}    lastbufferfilled^.PR := RPS ;      {}      {}  !     {}      {}    { if incoming empty data pkt has Mbit cleared } ! !     {}      {}    { and if message was expected to continue,    } !     {}      {}    { then process 'end of message'. }      {}      {}    If (( Not PKTheader.Mbit ) and      {}      {}          lastbufferfilled^.Mbit )       {}      {}     then begin      {}      {}      lastbufferfilled^.Mbit := PKTheader.Mbit ;      {}      {}      MSGinProgress:= false;       {}      {}      XSEND ( NormalCompMsg, AssociatedEQT,       {}      {}              2{read}, 0, EQTtlog);      {}      {}     end      {}      {}       {}      {}  end   { emacounter <> 0 }      {}      {}       {}      {}end   { empty data packet }   {end M10 BG 06feb86}       {}      {}      {}      end  { if pktheader.Qbit ... }      {}       {}  end  { reqstate = readstate }  $page$                     {-------------------}      {}  else begin {  no Read pending  }      {}             {-------------------}       {}       If XNETmoreDataOnCard=1 { not empty data pkt ? }       {}       then begin       {}       {}       {}       {}  DataAvailable:=true;       {}       {}  RespEqt:= AssociatedEQT;      {}       {}            { eqt responsible for card lock }       {}       {}       {}       {}  { set timer suppressed }      {}       {}  If PKTheader.Qbit       {}       {}  then begin      {}       {}     if associatedeqt^.eqttype = padeqttype      {}       {}     then begin       {}       {}        { Q bit data for PAD is not stored }       {}       {}        { into EMA but into XNETIBUF.      }       {}       {}        MsgInProgress := true;  #     {}       {}        XSEND ( QbitDataMsg, AssociatedEqt, 2, 0, 0 ); #     {}       {}        Pktwriteneeded := true;       {}       {}        PRTS := RPS;       {}       {}        SendRR := true       {}       {}     end       {}       {}     else begin  { not a PAD EQT }      {}       {}        { Q bit data for H-to-H is stored }      {}       {}        { into an EMA buffer.             }      {}       {}        SETUP_EMA_STORAGE(AssociatedEQT); "     {}       {}        { Setup_ema_user = false; transfer from EMA } ""     {}       {}        { to user's buffer in SAM cannot occur yet. } ""     {}       {}        { Setup_ema_user will be set when Read req. } ""     {}       {}        { is received by scheduler.                 } "      {}       {}        if not msginprogress       {}       {}        then begin      {}       {}        {} msginprogress:=true;  $     {}       {}        {} XSEND ( Qbitdatamsg, Associatedeqt, 2, 0, 0 ) $
     {}       {}        end 
      {}       {}     end       {}       {}      {}       {}  end   { if pktheader.Qbit }       {}       {}      {}       {}  else begin     { not a Qbit data packet }       {}       {}       {}       {}     SETUP_EMA_STORAGE ( AssociatedEQT ) ;  !     {}       {}     { setup_ema_user = false; transfer from EMA } ! !     {}       {}     { to user's buffer in SAM cannot occur yet. } !      {}       {}  "     {}       {}     If Not MSGinProgress  {first pkt of a message?} "     {}       {}     then begin       {}       {}     {} MSGinProgress := true;      {}       {}     {}           { DataAvailable already set } "     {}       {}     {} XSEND ( DataPktMsg, AssociatedEqt, 2, 0, 0 ); "      {}       {}     end      {}       {}     { else MSGinProgress is set          }      {}       {}     { - Packet after a partial read:     }      {}       {}     {   wait for a new read request.     }      {}       {}     { - Or a new message is coming in.   }      {}       {}     {   The data indication message      }      {}       {}     {   will be set upon completion of   }      {}       {}     {   the read of the previous message }      {}       {}     {   in ema_user_transfer.            }       {}       {} 
     {}       {}  end 
      {}       {}       {}       end  { not empty data packet }       {}       {} !     {}       else begin  { empty data packet }    {M10 BG 06feb86} !      {}       {}  "     {}       {} if  EMAcounter = 0  then { nothing in EMA buffers } "      {}       {}  begin { discard & acknowlegde it }      {}       {}        { even if MSGinprogress }       {}       {}    pktwriteneeded := true ;       {}       {}    sendRR := true ;      {}       {}    PRTS := RPS ; 
     {}       {}  end 
      {}       {} !     {}       {} else { EMAcounter <> 0, something in EMA buffers } !      {}       {}      {}       {}  begin       {}       {}    { acknowledgement of previous pkt will take }        {}       {}    { this empty pkt in effect }      {}       {}    lastbufferfilled^.PR := RPS ;       {}       {} !     {}       {}    { if incoming empty data pkt has Mbit cleared } !!     {}       {}    { and if message was expected to continue,    } !     {}       {}    { ... declare 'end of message'. }       {}       {}    if (( Not PKTheader.Mbit ) and       {}       {}          lastbufferfilled^.Mbit ) "     {}       {}      then lastbufferfilled^.Mbit := PKTheader.Mbit ; "
     {}       {}  end 
      {}       {}  !     {}       end  { empty data packet }      {end M10 BG 06feb86} !      {}  end       {} end {with associatedEqt}       end  
    end {with Netwp} 
 
  END { P_DATAPKT }; 
 $page$   {*************************************************} 
  BEGIN {  P_DATA_RR_RNR  } 
  {*************************************************}        With  VCPTR^ do begin   {here we have X25P=p4 and X25D=d1}           If XNETpktTooLong=1        then begin        {}    Diag:= 39;        {}    X25D := D4 {send reset};         {}    PKTwriteNeeded := true;        {}    MustsendSoftError := true;        {} Goto 88        end;           {check P(R) value:}          TSTMOD:=(epr<=XNETpr); TSTMOD2:=(XNETpr<=eps);           If (epr<=eps)           then TSTMOD := TSTMOD and TSTMOD2           else TSTMOD := TSTMOD or TSTMOD2;           If not TSTMOD 	         then begin 	          {}   If XNETmoreDataOnCard =1            {}     then NETWP^.GlobalRead := RFlush;           {}   Diag := 2;           {}   X25D := D4 {send Reset};            {}   PKTwriteNeeded := true;           {}   MustSendSoftError := true;  
          {} Goto 88 
         end;       EPR := XNETPR; {update}  $page$       Case PacketCode  of            {}          DataPkt: begin            {}  {verify P(S) (stored in XNETPS): }  !          {}  Limit:= RPR+AssociatedEQT^.EffectivePTW.InWDWsize-1; !           {}  If Limit>=8 then Limit:=Limit-8; {128 if extd numb}              {}  TSTMOD := (RPR<=XNETPS); TSTMOD2:=(XNETPS<=Limit);            {}  If (RPR<=Limit)            {}  then TSTMOD:= TSTMOD and TSTMOD2           {}  else TSTMOD := TSTMOD or TSTMOD2;            {}            {}  If (XNETPS=RPS)  and  TSTMOD           {}  then begin {pkt acceptable}            {}  {}  {PM 11/82 (must at least send RR)}            {}  {}  IF AssociatedEQT^.writereadEQT[1].Reqstate           {}  {}     = Writestate            {}  {}  then PKTwriteNeeded := true;            {}  {}  {If normal pkt numbering:}           {}  {}    If XNETPS<7 then RPS:=XNETPS+1 else RPS:=0; 
          {}  {}  P_DATAPKT 
           {}  {}           {}  end             {}  else begin { DATA pkt not acceptable: wrong P(S) }              {}  {}  { Reject packet cannot be sent as it is not  }              {}  {}  { accepted by all PSNs.                      }            {}  {}  If XNETmoreDataOnCard = 1           {}  {}    then NETWP^.GlobalRead:=RFlush;            {}  {}  Diag := 1;            {}  {}  X25D := D4 {send reset};           {}  {}  PKTwriteNeeded := true;           {}  {}  MustSendSoftError := true ;           {}  end  
          {}end {DataPkt}; 
           {}  $page$          RRpkt:   begin           {} X25RNR := false;  {cancel possible previous RNR}  !          {} {beware: XNETPR could be the same as in previous RNR} !           {} {Check if window has changed to set PKTwriteNeeded:}            {}   With AssociatedEQT^ do           {}   {}  If WriteReadEqt[1].Reqstate = WriteState           {}   {}  then begin             {}   {}    Limit := EPR + EffectivePTW.OUTWDWsize -1 ;             {}   {}    If Limit >= 8             {}   {}      then Limit := Limit -8; {128 if extd num}            {}   {}    TSTMOD:=(EPR<=EPS); TSTMOD2:=(EPS<=Limit);            {}   {}    IF EPR <= Limit            {}   {}       then TSTMOD := TSTMOD  and TSTMOD2           {}   {}       else TSTMOD := TSTMOD  or  TSTMOD2;            {}   {}    If TSTMOD then PKTwriteNeeded := true ;           {}   {}  end {if WriteReadEqt};           {} end {RRpkt};            {}          RNRpkt:  begin            {}       X25RNR:=true;  !          {}       If Netwp^.GlobalRead=NoRead then CurrentNet:=-1 !           {}     end {RNRpkt};            {} 
      end {case PacketCode} 
    end {with VCPTR}; 
    88:   END { P_DATA_RR_RNR } ;      
 $ title ' ' , page$ 
  {*******************************}  	 BEGIN {   XPKT  } 	  {*******************************}          With Netwp^, PKTheader  do begin            If LogClass <> 0 then XLGPK ;   { For XPLOG/XTLOG}            PacketCode := PKTtype; {to save access time}             If PacketCode = DiagPkt        then begin            {Should process here diag pkt}           If GlobalRead=NoRead then CurrentNet:= -1         end        else begin         {-------------------------------------------}         {   Level  R  processing                    }         {-------------------------------------------}  !            {Note: Restart and RestartConf Packets will always be} ! "            {      accepted even if they are too long or too short.} "
         Case X25R of 
 "             {}         {------------------------------------------} " "           R1: begin    {      R1 STATE      Packet level ready    } " "             {}         {------------------------------------------} "              {}  Case  PacketCode of               {}     {}              {}    RestartPkt : begin               {}     {}  PrintCauseDiag(1,RestartReceived);               {}     {}  X25R := R2 ;{send rest conf}              {}     {}  GenResCause := RestartReceived;              {}     {}  GlobalWrite := WHandshakeCardWrite;               {}     {}                     { state = ready }               {}     {}          end;               {}     {}              {}    RestConfPkt: begin  !             {}     {}  GWcause := 1; {Restart "local Proc Error"} !             {}     {}  GWdiag := 17;               {}     {}  X25R := R4; {send restart}               {}     {}  GenResCause := RestartInitiated;              {}     {}  GlobalWrite := WHandshakeCardWrite;              {}     {}                    { state = ready } !             {}     {}  XMSGWR( 1, RestartInitiated, CardWriteLU ); !             {}     {}         end;               {}     {}               {}    Otherwise  $page$ !             {}     {---------------------------------------------} !!             {}     {      P and D Levels  Processing             } !!             {}     {---------------------------------------------} !             {}  "             {}      {find corresponding VC table (always exists   } " "             {}      {since VC belongs to subscribed VC).          } "              {}        VCSEARCH ( Netwp, PKTvc, VCPTR );              {}               {}      ContinuePandD := false;              {} "             {}      P_LEVEL_TREATMENT ; {process according to X25P } "             {}              {}      If ContinuePandD              {}      then begin              {}               {}        MustSendSoftError := false;               {}   #             {}        D_LEVEL_TREATMENT ; {process according to X25D} #              {}                {}        If continuePandD                {}        then begin   
             {}        {}  
              {}        {} Case PacketCode  of   
             {}        {}  
              {}        {}   InterruptPkt:  P_INT_PKT ;              {}        {}               {}        {}   IntConfPkt : P_INTCONF_PKT ;              {}        {} !             {}        {}   DataPkt, RRpkt, RNRpkt:  P_DATA_RR_RNR; !             {}        {} end              {}        {} 
             {}        end; 
             {}              {}        If MustSendSoftError              {}        then begin  #             {}             { send SoftError completion on both EQTs } #             {}        {}With VCPTR^ do begin               {}        {}  MSGinProgress := false;               {}        {}  { since we init a RESET }  #             {}        {}  EQTCLEAR (AssociatedEQT,1,SoftErrorStatus); # #             {}        {}  EQTCLEAR (AssociatedEQT,2,SoftErrorStatus); #             {}        {}end {with Vcptr}  
             {}        end 
             {}    end;               {}   {---------------------------------------------}                {}   {   end of P and D levels processing          }                {}   {---------------------------------------------}   
             {}   {} 
              {}  end {case PacketCode }                {}                {}end {R1};               {}    $page$   "                        {------------------------------------------} " "           R2: begin    {        R2 STATE        (send rest conf)  } " "             {}         {------------------------------------------} "              {}  If PacketCode <> RestartPkt 
             {}  then begin 
              {}    GWcause :=1; {Restart "local Proc Error"}              {}    SETDIAG ( 18, GWdiag);               {}    X25R := R4 ; {send restart}              {}    GenResCause := RestartInitiated; "             {}    GlobalWrite := WHandshakeCardWrite; {state= ready} "              {}    XMSGWR( 1, RestartInitiated, CardWriteLU );  #             {}    If XNETmoreDataOnCard = 1 then GlobalRead:= RFlush; # 
             {}  end 
             {}  else  { ignore this Restart:         }              {}        { must still send restart conf }              {}        PrintCauseDiag(1, RestartReceived );               {}end {R2}; "             {}         {-------------------------------------------} ""           R3: begin    {        R3 STATE         (wait Rest conf)  } ""             {}         {-------------------------------------------} "             {}  Case  PacketCode  of               {}     {}               {}    RestartPkt,               {}    RestConfPkt :               {}     {} begin               {}     {}    If PacketCode=RestartPkt  #             {}     {}       then PrintCauseDiag(1, RestartReceived ); #             {}     {}    X25R := R1;               {}     {}    {Clean up already done by all LinkDown}               {}     {}    GlobalWrite := NoWrite;  #             {}     {}    {To cancel possible 'Wrestart' due to timer} # !             {}     {}    {Cancel timer and decrease TO counters:} !              {}     {}       RestConfWaitTO := -1;               {}     {}       X25TOctr:= 0;              {}     {}       {mutually exclusive with others}              {}     {}       GlobalTOctr := GlobalTOctr - 1 ;               {}     {}    XMSGWR ( 1, NetworkReady,CardWriteLu );   #             {}     {}    EQTPTR := FirstEqt ;        {M62 BG 19JUL88} #             {}     {}    while  ( EQTPTR <> NIL ) do              {}     {}    begin              {}     {}      LINKDOWN ( EQTPTR, NetworkReady ) ;              {}     {}      EQTPTR := EQTPTR^.NextEqt ;  #             {}     {}    end; { while }              {M62 BG 19JUL88} #
             {}     {} end; 
              {}     {}               {}    Otherwise    {maintain in state R3}               {}     {} {check if need to flush:}               {}     {}   If XNETmoreDataOnCard = 1              {}     {}    then GlobalRead := Rflush              {}     {}    else if GlobalRead = NoRead               {}     {}           then CurrentNet:=-1              {}   end {case PacketCode}               {}end {R3};               {}      {-----------------------------------}             Otherwise {      R4  STATE    (send restart)  }               {}      {-----------------------------------}  #             {} {all pkts can be ignored; just check if need to flush} #              {}      If XNETmoreDataOnCard = 1               {}        then GlobalRead := Rflush  "             {}        else if Globalread=NoRead then CurrentNet:=-1 " 
          end {case X25R}; 
          {-----------------------------------------}           {  End of Level  R  Processing            }           {-----------------------------------------}         end  
    end {with Netwp} 
 end {XPKT} ;   {end of program unit  XPKT}          $PAGE$  $ HEAPPARMS OFF$ # {********************************************************************} ## {                                                                    } ## {    ******************   PAD  SUPPORT   ************************    } ## {                                                                    } ## {!}  PROCEDURE  PDSUP   $direct$                                   {!} ## {!}    ( var  TASK  : byte;                                        {!} ## {!}      var  IBUF  : ibuftype;                                    {!} ## {!}      var  ILEN  : word;                                        {!} ## {!}      var  IMMRQ : bitsword   );                                {!} ## {                                                                    } ## {    TASK = 0 : new request from DVX00 :                             } ## {                   .  CN25B Inform driver of terminal strap change  } ## {                   .  CN32B Clear Circuit                           } ## {                   .  CN36B Set Binary Read Length                  } ## {                   .  CN37B Set Read Type                           } ## {                   .  Others : just forward to XNET.                } ## {           1 : any request to give to XNET ?                        } ## {           2 : give Q bit data                                      } ## {           3 : unsolicited event occured message :                  } ## {                   . -1 : Normal request completion msg             } ## {                   . -2 : Direct read completion msg                } ## {                   .  2 : Link Up message                           } ## {                   .  3 : Link Down message                         } ## {                   .  4 : Interrupt packet received                 } ## {                   .  5 : Unsolicited Data message                  } ## {                   . 13 : Q Bit Data message                        } ## {                   . 15 : Establish Circuit error msg               } ## {                   . others : just forward to DVX00                 } ## {           4 : give direct data                                     } ## {           5 : Look up incoming user data for block mode support    } ## {                                              and character editing } ## {          99 : do not forward unsolicited event to DVX00 for :      } ## {                   .  2 : Link Up indication message                } ## {                   . 13 : Q bit Data indication message             } ## {                   . CN 25B GetTermStrap ProcStep 0.2 and 2         } ## {                                                                    } ## {       Buffer on "event occured"         Buffer on input/output     } ## {                                                                    } ## {    IBUF W0 : XNET security code     IBUF W0 : XNET security code   } ## {    IBUF W1 : Message Type           IBUF W1 : 0                    } ## {    IBUF W2 : EQT address            IBUF W2 : EQT address          } ## {    IBUF W3 : status                 IBUF W3 : Req code and subf.   } ## {    IBUF W4 : message byte length    IBUF W4 : 0 / buffer address   } ## {    IBUF W5 : 1st message word       IBUF W5 : 0 / pos. byte length } ## {                                                                    } ## {    PDSreq contains the new request code and subf. from IBUF.W3     } ## {    PDSreqPARM contains the new request parameter from IBUF.W4      } ## {                                                                    } ## {    IMMRQ bit 0 = 1 : More ReQuest bit, list of PDSUP requests for  } ## {                      XNET is not empty. Set at end of task 3.      } ## {    IMMRQ bit 1 = 1 : Flush unexpected PAD message ( Q bit packet ) } ## {                      when received on a non idle EQT.              } ## {                      May be set only after unsolicited data.       } ## {                                                                    } ## {    PAD MESSAGE CODE IDENTIFICATION:                                } ## {     - 0 Parameter indication PAD message                           } ## {     - 1 Invitation to clear PAD message                            } ## {     - 2 Set PAD message                                            } ## {     - 3 Indication of Break PAD message                            } ## {     - 4 Read PAD message                                           } ## {     - 5 Error PAD message                                          } ## {     - 6 Set and Read PAD message                                   } ## {                                                                    } ## {    GLOBAL VARIABLES ACCESSED:                                      } ## {     - Read  :   none                                               } ## {     - Write :                                                      } ## {               - NETWPT                                             } ## {               - CURRENTNET                                         } ## {               - EQTPTR                                             } ## {               - WriteReadEQTindex                                  } ## {               - FirstPDSupreq                                      } ## {               - LastPDSupreq                                       } ## {                                                                    } ## {  Terminal_status format:  ( field of eqtptr^.eqtext record )       } ## {    - bit 1 - Block mode (1), Character mode (0); set with CN25B.   } ## {    - bit 2 - Page mode (1), Line mode (0); set with CN25B.         } ## {    - bit 3 - InhHndShk(G) (0): no (1): yes i.e. DC2 hndshk or none } ## {    - bit 4 - InhDC2(H) (0): no, (1): yes, i.e. DC1 handshk or none } ## {    - bit 8 - enable echo received characters ( = 1 )               } ## {    - bit 9 - enable character editing ( = 1 )                      } ## {    - bit15 - end transfer on "CR" ( = 1 )                          } ## {                                                                    } ## {  PDSUP is called from Data_Pkt_Write in XDISP    task 2 and task 4 } ## {                  from XRECV                                 task 1 } ## {                  from XSEND phase 3                         task 3 } ## {                  from P_Newrequest in XSCH                  task 0 } ## {                  from Transfer_req/EMA_User_transfer/XDISP  task 5 } ## {                                                                    } ## {********************************************************************} #      CONST     #   DoNotForward = 99; { special value to return in TASK parm if event } ##                      { or completion must not be forwarded to DVX00. } #    Forward = 3 ;     ReqLength = 12 ;   {for all requests transmitted to XNET}     EventLength = -12; { for all events transmitted to DVX}      QbitDataPos = 10 ; { index of Qbitdata in directReadCompmsg }      P2  = 2 ;     P3  = 3 ;     P4  = 4 ;    P15 = 15 ;      $page$        {----------------------------------------}    { types and constants for PAD parameters:}    {----------------------------------------}          CONST  TotalPadParmNb = 10 ;{Nb of X25/1000 std PAD parms}         TYPE   parmTableType = array [1..TotalPadParmNb] of byte;         CONST  ParmTableRef = ParmTableType [   {CCITT ref codes}                { List of X.3 parameters that are referenced }                  1    {escape to command level}                , 2    {local echo by the PAD}                 , 3    {data forwarding char}                 , 4    {idle timer}                 , 6    {Suppression of service signals}                , 7    {action on break options}                 , 8    {discard output}                , 15   {editing}                 , 16   {Character delete}                , 17   {line delete}                                        ];          CONST ParmTableFixedValues = ParmTableType [ "               { X25/1000 standard default values of X.3 parameters } "                 0    {ref 1 : escape not possible}                 , 1    {ref 2 : echo on }                 , 2    {ref 3 : data forwarding char = CR }                 , 0    {ref 4 : idle timer disabled } !               , 0    {ref 6 : PAD service signals not transmitted} !               , 1    {ref 7 : send Interrupt pkt on break}                 , 0    {ref 8 : normal data delivery}                , 1    {ref 15: editing ON }                , 8    {ref 16: BS }                , 127  {ref 17: DEL}                                                ];      #    VAR  ParmTableValue : ParmTableType; {to contain effective values} #     "    CONST { to define bit of ParmChangeMask associated to this ref } "           ref1  =  1 ;            ref2  =  2 ;            ref3  =  3 ;            ref4  =  4 ;            ref6  =  5 ;            ref7  =  6 ;            ref8  =  7 ;            ref15 =  8 ;      
  var  INDEX, I : 0..4096; 
       dummy : bitsword ;    {added M77 BG 21APR89}  $page$  {********************************}  PROCEDURE  SetDirectWriteQbitReq ;  $direct$  {********************************}      " { This request is generated by PDSUP when it needs to send Q-bit  } " " { data to the PAD. XNET will obtain the data itself from PDSUP    } " " { via a call with task = 2 "Give Q-bit Data".                     } "      { Called from Task 0 CN32B clear VC         }   { Called from Task 0 CN37B set read type    }   { Called from PUnsolQbitData, ProcStep 2    }   { Called from PParmLinkUp, ProcStep 0       }   { Called from PParmLinkUp, ProcStep 4       }   { Called from PGetTermStrap ProcStep 0,3,11 }   { Called from PGetDC2 ProcStep 1            }        BEGIN { Prepare a "direct Qbit Write" subfunction 2 into IBUF }          $skip_text on$                          {M77}     WriteReadEQTindex := 1 {write eqt};  	   $skip_text off$ 	         IBUF.W [0] := XNETsecCode;  
    IBUF.W [1] := 0; 
    IBUF.W [2] := EQTPTR^.WriteEQTadd ;  $    IBUF.W [3] := 130; { 202B subf = 2 in bits 10-6; f = 2 in bits 1-0 } $     IBUF.W [4] := 0 ;  { buffer address in SAM }      IBUF.W [5] := 0 ;  { buffer length }          ILEN := Reqlength;        END { SetDirectWriteQbitReq };           {*******************************}   PROCEDURE  SetDirectQbitReadReq ;  $direct$   {*******************************}     " { This request is generated by PDSUP when it needs to read Q-bit   } "" { data. It may be sent only after "unsolicited Q-bit Data" arrival.} "" { Note that the Q-bit data length must be at most 128 bytes.       } "" { If incoming Q-bit data message is longer than 128 bytes, then the} "" { direct Q-bit read request will be completed with soft error and  } "" { Tlog = 0.                                                        } "      { Called from PUnsolQbitData, ProcStep 0    }   { Called from PSetReadParmMsg, PocStep 1    }   { Called from PParmLinkUp, ProcStep 2       }   { Called from PGetTermStrap ProcStep 1,5,13 }     ! BEGIN  { Prepare a Direct Q bit Read Req subfunction 1 into IBUF } !        $skip_text on$                          {M77}    WriteReadEQTindex := 2 { read eqt };  	   $skip_text off$ 	        IBUF.W [0] := XNETsecCode ;  
   IBUF.W [1] := 0 ; 
   IBUF.W [2] := EQTPTR^.ReadEqtAdd ;      IBUF.W [3] := 65 ; { subf = 1 (bits 10-6); f = 1 (bits 1-0) }     IBUF.W [4] := 0 ;  { buffer address in SAM }    IBUF.W [5] := 0 ;  { buffer length }         ILEN := ReqLength ;       END { SetDirectQbitReadReq };          {**************************} ! PROCEDURE  SetDirectWriteReq ;  $direct$    {added M77 BG 20APR89} ! {**************************}      # { This request is generated by PDSUP when it needs to send normal   } # # { data ( not Q-bit ) to the PAD terminal. XNET will obtain the data } # # { itself from PDSUP via a call with task = 4  "Give Direct Data".   } #      { Called from PGetTermStrap ProcStep 7                      }   { for Control 25B to inform driver of terminal strap change }        BEGIN { Prepare a "direct Write" subfunction 3 into IBUF }         $skip_text on$                          {M77}     WriteReadEQTindex := 1 { write eqt };  	   $skip_text off$ 	        IBUF.W [0] := XNETsecCode ; 
    IBUF.W [1] := 0 ; 
    IBUF.W [2] := EQTPTR^.WriteEQTadd ;  "    IBUF.W [3] := 194 ; { subf = 3 in bits 10-6; f = 2 in bits 1-0 } "     IBUF.W [4] := 0 ;  { buffer address in SAM }      IBUF.W [5] := 0 ;  { buffer length }          ILEN := Reqlength;        END { SetDirectWriteReq };           {***************************} " PROCEDURE  SetDirectReadReq ;  $direct$       {Added M77 BG 28APR89} "  {***************************}     " { This request is generated by PDSUP when it needs to read data.   } "" { It may be sent only after "Unsolicited Data" arrival.            } "" { Note that the data length must be at most 128 bytes.             } "" { If incoming data message is longer than 128 bytes, then the      } "" { direct read request will be completed with soft error and Tlog=0.} "     { Called from PGetTermStrap ProcStep 9 }  { Called from PGetDC2 ProcStep 0       }      BEGIN  { Prepare a Direct Read Req subfunction 2 into IBUF }         $skip_text on$                          {M77}     WriteReadEQTindex := 2 ; { read eqt }  	   $skip_text off$ 	        IBUF.W [0] := XNETsecCode ;  
   IBUF.W [1] := 0 ; 
   IBUF.W [2] := EQTPTR^.ReadEqtAdd ;     IBUF.W [3] := 129 ; { subf = 2 (bits 10-6); f = 1 (bits 1-0) }      IBUF.W [4] := 0 ;   { buffer address in SAM }     IBUF.W [5] := 0 ;   { buffer length }         ILEN := ReqLength ;      
 END { SetDirectReadReq }; 
         {**************************}   PROCEDURE  SetLinkUpMsg  ;   $direct$  {**************************}       { Prepare a Link Up Msg into IBUF }  { after receipt of a Normal or direct completion msg }       { Called from PSetReadParmMsg, ProcStep 2 }   { Called from PParmLinkUp,     ProcStep 3 }       BEGIN         IBUF.W [1] := LinkUpMsg ;  
   IBUF.W [3] := 0 ; 
 
   IBUF.W [4] := 0 ; 
 
   IBUF.W [5] := 0 ; 
        ILEN := EventLength ;     
 END { SetLinkUpMsg}; 
 $page$   {***************************}   PROCEDURE   XPOST  ;   $direct$   {***************************}      " { Insert EQT into list of EQTs that have a req to give to XNET    } " " { Pointers FirstPDSreq, LastPDSreq, EQTPtrType are global to XNET } " " { They are initialized by XNET but only used in PDSUP.            } "     { Called from PUnsolQbitData,  ProcStep 1    }  { Called from PParmLinkUp, ProcStep 3        }  { Called from task 3: LinkUpMsg              }  { Called from task 3: QbitDataMsg ( twice )  }  { Called from PGetTermStrap ProcStep 2,6,10  }       BEGIN         If LastPDSreq = NIL      then                       { insert as first (and only) EQT }  
      FirstPDSreq := EQTPTR 
   else                       { insert after last }        LastPDSreq^.EQText.NextPDSreq := EQTPTR;                                   {EQT becomes new last one:}     LastPDSreq := EQTPTR;    EQTPTR^.EQText.NextPDSreq := nil ;                                  { ?? could be done at init only }       END { XPOST };  $page$  {****************************************************}   PROCEDURE  PcleanUp; $direct$  {****************************************************}      { Clean up PDSUP area, except CircuitStateUP } ! { Note: no need to remove from list of req to give to xnet       } !! {       because it will be done automatically on "any req" entry.} !      { Called from  Select_process:                              }   {  - CN32B Clear VC if circuit is not open                  }   {  - If new request from DVX is neither CN32B, CN36B, CN37B }   { Called from Task 3  LinkDownMsg                           }   { Called from PUnsolQbitData ProcStep 1, unknown Q-bit data }   { Called from PSetReadParmMsg ProcStep 2,                   }   {  completion of Q-bit msg read                             }   { Called from PparmLinkUp ProcStep 3,                       }   {  if direct read completion and ParmChangeMask = 0         }   { Called from PinvitClear on completion of Q-bit write      }   { Called from PGetTermStrap ProcStep 14                     }   { Called from Task 5 Look up incoming data.                 }       BEGIN       With  EQTPTR^,EQText do begin     
     ProcState := S0; 
     PADMsgExpected := false;       TermMsgExpected := false ;           {M77 BG 21APR89}      PDSreq := 0;       end {with};     	 END  { PcleanUp }; 	     $page$  {****************************************************}  PROCEDURE  PClearVC ; $direct$  {****************************************************}      { Called from  Select_Process :                      }  {   - Task 3  DirectReadCompMsg                      }  {   - PUnsolQbitData ProcStep 1  Error PAD message   }      BEGIN { Process used to send a "clear Circuit" request }         With EQTPTR^,EQText  do begin          Case  ProcStep  of             0 : begin {entry on "give req to XNET" event}              {prepare a CN 32 request:}             $skip_text on$                          {M77}              WriteReadEQTindex := 1 {on write eqt}; 
            $skip_text off$ 
              IBUF.W[0] := XNETsecCode;               IBUF.W[1] := 0;              IBUF.W[2] := writeEQTadd ;  #             IBUF.W[3] := 1667 ; {subf 32B (bits 10-6);f 3 (bits 1-0)} #              IBUF.W[4] := 0;               IBUF.W[5] := 0;               ILEN := ReqLength ; 
             ProcStep := 1; 
           end;      !       1 : begin {entry on "normal comp" event (CN32 completion) } !             Task := DoNotForward; {"link down" will come soon}              ProcState := S0;            end;       end {case};      
   end {with EQTPTR} 
 	 END { PClearVC }; 	     $page$   {***************************************}   PROCEDURE  PUnsolQbitdata ;      $direct$   {***************************************}      { Process unsol Q bit Data arrival on idle EQT }      $ { Called from Task 3  DirectReadCompMsg, and PAD message is not       } $ $ {   Parameter Indication, and EQT already processing unsolicited data } $ $ { Called from Task 3  QbitDataMsg when Q-bit data received when not   } $ $ {   expected on idle EQT.                                             } $      BEGIN       With EQTPTR^,EQText  do begin      Case  ProcStep  of           0: begin  { entry on "give req to XNET" }            SetDirectQbitReadReq ;            ProcStep := 1;          end;      #      1: begin  { entry on "direct read compl" (Qbit data available) } #              Task := DoNotForward;                { Analyze the just received PAD message code }            Case IBUF.B [QbitDataPos] of                 3,  { Indication of BREAK PAD msg }             5:  { Error PAD msg }  
               begin 
 !                 { we should print code and invalid msg if error } !                  ProcState := SClearVC ;                   ProcStep := 0 ;                   XPOST ; 	               end; 	            Otherwise { just ignore }  PcleanUp                end ; {case}          end;            2: begin {entry on "give req to XNET"}           SetDirectWriteQbitReq ;            ProcState := SSetReadParmMsg ; 
          ProcStep:=0 
         end;         end {case ProcStep}     	  end {with EQTPTR} 	      END { PUnsolQbitData };  $page$  {************************************}   PROCEDURE  PSetReadParmMsg ; $direct$  {************************************}      { Send & process set/read parm PAD msg 6 }  { Write Q bit req already sent to XNET   }      { Called from Select_Process:  }  {  - CN37B set read type       }  {  - PUnsolQbitData ProcStep 2 }  {  - PParmLinkUp    ProcStep 4 }      VAR  I, L, QbitDataX : 0..4096 ;        Error : boolean;       BEGIN       With EQTPTR^,EQText  do begin 
   Case  ProcStep  of 
     0: begin  { entry on "give Qbit data"  or "normal comp msg" }          If Task = 2 { give Q bit data }         then begin  { Prepare Q bit Data: }              IBUF.B[ index ] := 6; {set/read parm msg code}             Index := index + 1;              ILEN := 1;             If PDSreq <> 0  { EQT has PAD request }             then begin {prep for CN 37 "set read type"}                 $skip_text on$                          {M77}              {}   WriteReadEQTindex := 2 {on read eqt};                 $skip_text off$              {} 
            {}{echo:} 
            {}   IBUF.B [index] := P2; { echo }              {}   IBUF.B[index+1] := PDSreqPARM.BIT8;              {}                      { 1: echo on; 0: off }  %            {}   terminal_status.bit8 := PDSreqPARM.BIT8; {M77 BG 19OCT89} %            {}   Index := index+2 ;              {}   Ilen := ilen +2 ;              {}              {}{editing:}              {}   IBUF.B [index] := P15 ; { editing }              {}   IBUF.B[index+1] := PDSreqPARM.BIT9;              {}                      { 1: enable; 0:disable }  %            {}   terminal_status.bit9 := PDSreqPARM.BIT9; {M77 BG 19OCT89} %            {}   Index := index + 2 ;             {}   Ilen := ilen + 2 ;             end             else  { PDSreq = 0 : EQT idle }  "            {} begin {prep for std parm after link up & after break} "            {}  ParmTableValue := ParmTableFixedValues;              {}             {}  {set specific parms according to Facilities:}               {}    {PAD Msg suppression (default: "suppress" ) :}  "            {}    If not Facilities.PDM then ParmTableValue[ref6]:=1; " "            {}    {Escape from data transfer possible (default: no)} "             {}    If Facilities.ESC then ParmTableValue[ref1]:=1;               {}  I :=1;              {}              {}  While  ParmChangeMask.W <> 0  do              {}  begin               { any change bit still set? }              {}    If ParmChangeMask.bit [ I ] = 1              {}    then begin             {}       IBUF.B[ index ] := parmTableRef [ I ];             {}       IBUF.B[index+1] := parmTableValue [ I ];              {}       index := index + 2; ILEN := ilen + 2;             {}       ParmChangeMask.bit [ I ]:=0;              {}    end;  
            {}    I:= I+1; 

            {}  end {while} 
            end; { if pdsreq <> 0 }            {do not change ProcStep to cover No Sam situation}         end 
        else  { Task <> 2 } 
          begin  !          { entry on "normal completion" event (Qbit data write) } !          Task := DoNotForward;           PADmsgExpected := true;            ProcStep := 1;          end;      
       end {step 0}; 
 $page$         1: begin  { entry on "give req" event }          SetDirectQbitReadReq ;           ProcStep := 2 ;        end;              2: begin        { entry on "direct read completion" event (Q bit Data) }               If PDSreq <> 0  {any req still here?}          then begin {yes: it is CN 37B}           {} {change into a "normal comp" msg:}          {}   IBUF.W[1] := NormalCompMsg;          {} {Note: next lines contain code to verify if error.}  !         {} {Remove comments if we decide to test for such errors} !         {}  { Error:= false; } #         {}  { L:= IBUF.W[4] - 1;} {total Q bit data length - msg code} #         {}  { QbitDataX := QbitDataPos + 1;} {skip msg code}          {}  { While  L > 0  do begin }  !         {}  {   If IBUF.B [ QbitDataX ] >= 128 } {error bit set?} !         {}  {   then begin error:= true; L:=0  end } !         {}  {   else begin L:=L-2; QbitDataX := QbitDataX+2; end } !         {}  { end ;  }          {}  { If error }          {}  {  then IBUF.W[3] := HardErrorStatus }           {}  {  else IBUF.W[3] := 0; }  !         {} IBUF.W[3] := 0; {remove this line if error test lines} !          {} IBUF.W[4] := 0; {tlog} 
         {} IBUF.W[5] := 0; 
          {} ILEN := EventLength;  
         {} PcleanUp 
          end "         else begin {no req: link up process; accept even if errors!} "          {}    SetLinkUpMsg; {change into "link up" msg}          {}    ProcState := S0;           end 	       end {step 2} 	   end {case}  
  end {with EQTPTR^} 
 end { PSetReadParmMsg };  $page$  {************************************}  PROCEDURE  PParmLinkUp ;    $direct$  {************************************}       { Process used on Link Up Event to set PAD parms to default }   { configuration values.                                     }   { The PAD is first asked to send all its parameters values, }   { and then PDSUP modifies only the values of the parameters }   { which differ from default configuration values.           }      ! { Called from Select_Process, initialized by Task 3 - LinkUpMsg } !     
 VAR   L : -2..4095; 
       RefCode, I, QbitDataX : 0..4095;       BEGIN        With EQTPTR^,EQText do begin      Case  ProcStep  of           0: begin  { entry on "give req to XNET" }            SetDirectWriteQbitReq;            ProcStep := 1;         end { step 0 };          1: begin {entry on "give Qbit Data"  or "normal comp msg"}           If Task = 2 {"give Q bit data"}  
          then begin 
               {Place PAD msg 4 "read parm":}                IBUF.B[index] := 4; {"read parm" msg code}                ILEN := 1;                 {do not change ProcStep to cover No Sam situation}            end  !          else begin {entry on "normal compl" event (Write Qbit) } !              Task := DoNotForward;               PADmsgExpected := true;  
             ProcStep :=2; 
          end 
        end {step 1}; 
         2: begin {entry on "give req to XNET"}            SetDirectQbitReadReq ;           ProcStep := 3 ; 
        end {step 2}; 
 $page$      3: begin {entry on "direct read compl" event (Qbit data) }           If IBUF.W [ 1 ] = DirectreadCompMsg  #         then begin {this is the event we are waiting for: process it} # #           { Process PAD parm received to see if changes are needed: } # #           L:= IBUF.W[4] -1 ; {total Qbit data length - msg code byte} #             QbitDataX := QbitDataPos + 1 ; { skip msg code byte }  #           ParmChangeMask.W := 0 ; { clean up mask, default no change } #               { Set default X.3 parameter values }            ParmTableValue := ParmTableFixedValues ;                 { Set specific values according to Facilities:}             { P6 PAD service signals : 0 = suppress }             {                          1 = transmit }              If Not Facilities.PDM then ParmTableValue[ref6] := 1;       "           { P1, Escape from Data transfer: 0 = escape not allowed } " "           {                                1 = escape allowed     } "           If Facilities.ESC then ParmTableValue [ref1] := 1;                  While  L > 0  do begin {go over each parm}              {} RefCode := IBUF.B[QbitDataX];               {} {search into parmtableref (backwards!!) :}              {} I := TotalPadParmNb ;              {}               {} While ( I >= 1) do begin               {}  If RefCode = ParmTableRef [ I ]               {}    then begin {found: check value} !             {}      If IBUF.B [ QbitDataX+1 ] <> ParmTableValue[I] !#             {}        then {change needed} ParmChangeMask.bit[I] := 1; #             {}      I:= 0; {to stop iteration}               {}    end              {}    else I := I - 1;               {} end {while};              {}              {} QbitDataX := QbitDataX + 2;  
             {} L := L -2; 
             end {while L>0};                If ParmTableFixedValues [ ref2 ] = 1              then  terminal_status.bit8 := 1   { echo on  }              else  terminal_status.bit8 := 0 ; { echo off }            If ParmTableFixedValues [ ref3 ] = 2              then  terminal_status.bit15 := 1   { end on CR }             else  terminal_status.bit15 := 0 ; { no end on CR }           If ParmTableFixedValues [ ref15 ] = 1  !            then  terminal_status.bit9 := 1   { editing enabled  } ! !            else  terminal_status.bit9 := 0 ; { editing disabled } !     #          If ParmChangeMask.W <> 0  { as specified in EQTPTR^.EQText } #          then begin {must send modif to PAD}           {} Task := DoNotForward ;            {} XPOST {must send write Qbit data} ;            {} ProcStep := 4 ;           end  
          else begin 
                 SetLinkUpMsg ; 
                 PcleanUp ; 
	               end; 	         end  { DirectReadCompMsg }              { else : normal comp, just forward }     
        end {step 3}; 
       $page$      4: begin { entry on "give req to XNET" }  !              { Case where PAD X.3 parameters need to be changed } !          SetDirectWriteQbitReq ;            ProcState := SSetReadParmMsg ;           ProcStep := 0 ;         end { step 4 };      
    end { case ProcStep }; 
  end { with EQTPTR } 
  END { PParmLinkUp } ;      $page$  {************************************}  PROCEDURE  PInvitClear  ;   $direct$  {************************************}      { Prepare an "invitation to clear" PAD msg }      { Initiated from CN32B Clear Circuit }       BEGIN          If  Task = 2 {give Q bit data}      then begin {entry on "give Q bit data" }            {prepare "invit. to clear" pad msg 1:}                IBUF.B[index] := 1 {"invitation to clear" code};                ILEN := 1;         end "     else  {entry on task 3: completion of Qbit write (of pad msg 1)} "        begin            {change into a normal CN 32 completion:}               IBUF.W[3] := 0 {status}; {should already be 0 ??}              IBUF.W[4] := 0 {tlog};              PcleanUp ;        end;     
 end { PInvitClear }; 
 $page$  {************************************}    PROCEDURE  PGetTermStrap ;   $direct$    {added M77 BG 20APR89}   {************************************}        { Initiated from CN25B Inform Driver of Terminal Strap Change }     { with a "Direct Q bit Write" request to XNET.                }     { Before reading the terminal status, the PAD parameters are  }     { modified to disable echoing and editing. Original settings  }     { are restored afterwhile.                                    }     {                                                             }     { Step 0.1 - Task 2:                                          }     {         Give Q bit data to be sent to the PAD:              }     {          Read parameter message P2 "echo",                  }     {          P3 "data forwarding char.", P4 "idle timer",       }     {          P15 "editing".                                     }     { Step 0.2 - Task 3:                                          }     {         Completion of the Q bit write request               }     {         Wait for the Q bit message indication ( PAD parms ).}     { Task 3: Qbit Data Messsage indication.                      }     {         XPOST: link EQT into waiting list for XNET.         }     { Step 1  Task 1: "Give request to XNET"                      }     {         Send a direct Q bit Read request.                   }     { Step 2  Task 3:                                             }     {         Completion of the Q bit read request                }     {         Process Parameter Indication message (0) received   }     {         from PAD. Save current parameter setting into       }     {         ParmChangeMask.bit[ref2 ] = 1 if P2 echo enabled    }     {         ParmChangeMask.bit[ref3 ] = 1 if P3 is not "CR"     }     {         ParmChangeMask.bit[ref4 ] = 1 if P4 idle timer <> 0 }     {         ParmChangeMask.bit[ref15] = 1 if P15 editing enable }     {         Eventually process PAD parameter error indication.  }     {         XPOST: link EQT into waiting list for XNET.         }     { Step 3  Task 1: "Give request to XNET"                      }     {         Send a direct Q bit Write request.                  }     { Step 4.1 Task 2: "Give Q bit Data"                          }     {         Place a "Set and Read parameter" message (6)        }     {         Set P2  =  0 "echo disabled"                        }     {         Set P3  =  2 "data forwarding char = CR"            }     {         Set P4  =  0 "idle timer disabled" if char. mode.   }     {                 = 10 "timer = 0.5 seconds"                  }     {                      in block page or block line mode.      }     {         Set P15 =  0 "editing disabled"                     }     {         Note: if editing is enabled, the PAD will not take  }     {               account of the idle timer. X.28 1984 P3.6.1.3 }     { Step 4.2 Task 3: Completion of Q bit Write request          }     {         Wait for the PAD to return its parameters.          }     { Task 3: Qbit Data Messsage indication.                      }     {         XPOST: link EQT into waiting list for XNET.         }     { Step 5  Task 1: "Give request to XNET"                      }     {         Send a direct Q bit Read request.                   }     { Step 6  Task 3: Completion of Q bit Read request            }     {         Eventually process PAD parameter error indication.  }     {         XPOST: link EQT into waiting list for XNET.         }     { Step 7  Task 1: "Give request to XNET"                      }     {         Send a direct Write request.                        }     { Step 8.1 Task 4: "Give Direct Data"                         }     {         Give direct data to be sent to the PAD terminal:    }     {         "primary terminal status request (Esc ^ DC1)".      }     {         Direct write for the PAD terminal.                  }     { Step 8.2 Task 3: Normal Completion Message.                 }     {         Completion of the direct write request.             }     {         Wait for the terminal to return its status.         }     { Task 3: Unsolicited Data indication message.                }     {         XPOST: link EQT into waiting list for XNET.         }     { Step 9  Task 1: "Give request to XNET".                     }     {         Issue a direct read request to get the status.      }     {         Read request will be completed with "CR" in char.   }     {         mode or block line mode, and with "RS" in block     }     {         page mode when the idle timer pops.                 }     { Step 10 Task 3: Normal Completion of direct read request.   }     {         Analyze the primary terminal status.                }     {         Block mode is 2nd bit of 4th status byte,           }     {         save it into EQTPTR^.EQTEXT.Terminal_Status.Bit1.   }     {         Line/Page mode is 4th bit of 2nd status byte,       }     {         save it into EQTPTR^.EQTEXT.Terminal_Status.Bit2.   }     {         InhDC2(H) is 4th bit of 3rd status byte,            }     {         save it into EQTPTR^.EQTEXT.Terminal_Status.Bit3.   }     {         InhHndShk(G) is 3rd bit of 3rd status byte,         }     {         save it into EQTPTR^.EQTEXT.Terminal_Status.Bit4.   }     {         XPOST: link EQT into waiting list for XNET.         }     { Step 11 Task 1: "Give request to XNET"                      }     {         Send a direct Q bit Write request.                  }     { Step 12.1 Task 2: "Give Q bit Data"                         }     {         Place a "Set and Read parameter" message (6)        }     {         If terminal is in Block mode                        }     {         then if terminal is in Page mode                    }     {                then  ( terminal in block page mode )        }     {                  Set P2  =  0 "echo disabled"               }     {                  Set P3  =  0 "none"                        }     {                  Set P4  = 10 "idle timer 0.5 sec"          }     {                  Set P15 =  0 "editing disabled"            }     {                  Note: if editing is enabled, the PAD will  }     {                        not take account of the idle timer.  }     {                        ( CCITT X.28 1984 P 3.6.1.3 )        }     {                else  ( terminal in block line mode )        }     {                  Set P2  = 0 "echo disabled"                }     {                  Set P3  = 2 "forwarding char CR"           }     {                  Set P4  = 0 "idle timer disabled"          }     {                  Set P15 = 1 "editing enabled"              }     {         else  ( terminal in character mode )                }     {                  Set P2  = 1 "echo enabled"                 }     {                  Set P3  = 2 "forwarding char CR"           }     {                  Set P4  = 0 "idle timer disabled"          }     {                  Set P15 = 1 "editing enabled"              }     {         end if                                              }     { Step 12.2 Task 3: Completion of Q bit Write request         }     {         Wait for the PAD to return its parameters.          }     { Task 3: Qbit Data Messsage indication.                      }     {         XPOST: link EQT into waiting list for XNET.         }     { Step 13  Task 1: "Give request to XNET"                     }     {         Send a direct Q bit Read request.                   }     { Step 14 Task 3: Completion of Q bit Read request            }     {         Eventually process PAD parameter error indication.  }     {         Complete the control request 25B to DVX.            }     {         Return the current read type in TLOG (IBUF.W[4]).   }     {                                                             }     { The following code is for implementation of V+ but not used.}     {                                                             }     { Step 15 Task 1, Give request to XNET.                       }     {         Prepare a "direct write" request to PAD terminal.   }     { Step 16 - Task 4:                                           }     {         Give direct data to be sent to the PAD terminal:    }     {         - "Inhibit Handshake(G) (Esc &s1G)".                }     {         - "Inhibit DC2(H) (Esc &s1H)".                      }     { Step 16.2 - Task 3:                                         }     {         Completion of the direct write request              }     {         Complete the control request 25B to DVX.            }       
 VAR   L : -2..4095; 
       RefCode, I, QbitDataX : 0..4095;         P2_found, P3_found, P4_found, P15_found : boolean ;       BEGIN        With  EQTPTR^, EQText  do  begin 
   Case  ProcStep  of 
          0: begin { entry on "give Qbit Data"  or "normal comp msg" }            If Task = 2 { "give Q bit data" }            then begin  { step 0.1 }                { Place PAD msg 4 "read parm": }               { requesting to read parameter 2 and 15 }               IBUF.B[index]   :=   4 ; { "read parm" msg code }               IBUF.B[index+1] :=  P2 ; { "echo" }                IBUF.B[index+2] :=   0 ;                IBUF.B[index+3] :=  P3 ; { "Data forwarding char" }                 IBUF.B[index+4] :=   0 ;               IBUF.B[index+5] :=  P4 ; { "idle timer" }                IBUF.B[index+6] :=   0 ;                IBUF.B[index+7] := P15 ; { "editing" }                IBUF.B[index+8] :=   0 ;               ILEN := 9 ;  !              { do not change ProcStep to cover No Sam situation } !          end             else    { entry on "normal compl" event (Write Qbit) }               begin { step 0.2 }                Task := DoNotForward ;                PADmsgExpected := true ;               ProcStep := 1 ;             end          end ; { step 0 }          1: begin { entry on "give req to XNET" }            SetDirectQbitReadReq ;           ProcStep := 2 ;          end ; { step 1 }            2: begin { entry on "direct read compl" event (Qbit data) }               { Process PAD parm received to save current setting }               { of P2 echo and P15 editing into ParmChangeMask.   }   #           L:= IBUF.W[4] -1 ; {total Qbit data length - msg code byte} #             QbitDataX := QbitDataPos + 1 ; { skip msg code byte }             ParmChangeMask.W := 0 ; { clean up }                While  L > 0  do begin { go over each parmeter }             {} { look at each parm nb / parm value couple }             {} RefCode := IBUF.B[QbitDataX] ; { get parm nb }            {}             {}  { is this parameter the P2 echo ? }             {}  If RefCode = P2             {}    then begin { found: check value and save it }             {}      If IBUF.B [ QbitDataX+1 ] = 1 { echo on ? }             {}        then  ParmChangeMask.bit[ref2] := 1 ;            {}      P2_found := true ; { to stop iteration }  
           {}    end 
           {}  !           {}  { is this parameter the P3 data forwarding char ? } !           {}  else If RefCode = P3             {}    then begin { found: check value and save it }             {}      If IBUF.B [ QbitDataX+1 ] <> 2 { CR }             {}        then  ParmChangeMask.bit[ref3] := 1 ;            {}      P3_found := true ; { to stop iteration }  
           {}    end 
           {}             {}  { is this parameter the P4 idle timer ? }            {}  else If RefCode = P4             {}    then begin { found: check value and save it }            {}      If IBUF.B [ QbitDataX+1 ] <> 0 { enabled }             {}        then  ParmChangeMask.bit[ref4] := 1 ;            {}      P4_found := true ; { to stop iteration }  
           {}    end 
           {}             {}  { is this parameter the P15 editing ? }             {}  else If RefCode = P15             {}    then begin { found: check value and save it }             {}      If IBUF.B [ QbitDataX+1 ] = 1 { editing on ? }             {}        then  ParmChangeMask.bit[ref15] := 1 ;             {}      P15_found := true ; { to stop iteration }             {}    end ;            {}             {} QbitDataX := QbitDataX + 2 ;            {} L := L -2 ;            {}             end ; { while L > 0 }                if ( not P2_found or not P3_found or                 not P4_found or not P15_found )              then begin                { error: at least one parameter is missing !!! }                { or error returned by the PAD.                }  	             end ; 	               Task := DoNotForward ;           ProcStep := 3 ;           XPOST ;              end ; { step 2 }          3: begin { entry on "give req to XNET" }           SetDirectWriteQbitReq ;           ProcStep := 4 ;          end ; { step 3 }          4: begin  { entry on "give Qbit data"  or "normal comp msg" }          If Task = 2 { give Q bit data }          then begin  { step 4.1 }             {}   IBUF.B[ index ] := 2 ; { set parm msg code }             {}  $skip_text on$                          {M77}              {}   WriteReadEQTindex := 2 {on read eqt};             {}  $skip_text off$              {}             {}   IBUF.B [index+1] :=  P2 ; { "echo" }             {}   IBUF.B [index+2] :=   0 ; { echo off }             {}   terminal_status.bit8 := 0 ; { echo off } "            {}   IBUF.B [index+3] :=  P3 ; { "Data forwarding char" } "            {}   IBUF.B [index+4] :=   2 ; { "CR" }              {}   terminal_status.bit15 := 1 ; { "CR" }             {}   IBUF.B [index+5] :=  P4 ; { "idle timer" } "            {}  $skip_text on$                                  {M77} " $            {}   if  terminal_status.bit1 = 1  { Block line/page mode? } $             {}   then  IBUF.B [index+6] := 10   { 0.5 sec. }              {}   else  IBUF.B [index+6] :=  0 ; { disabled }             {}  $skip_text off$              {}   IBUF.B [index+6] := 10 ; { 0.5 sec. }               {}   {  Note: if editing is enabled, the PAD will  }                {}   {        not take account of the idle timer.  }                {}   {        ( CCITT X.28 1984 P 3.6.1.3 )        }               {}   IBUF.B [index+7] := P15 ; {editing ref}             {}   IBUF.B [index+8] :=   0 ; { editing disabled }              {}   terminal_status.bit9 := 0 ; { editing disabled }               {}   Ilen := 9 ;              {}               { do not change ProcStep to cover No Sam situation }            end          else   { Task <> 2 } 
         begin { step 4.2 } 
!           { entry on "normal completion" event (Qbit data write) } !            Task := DoNotForward;            $skip_text on$             PADmsgExpected := true;  
           ProcStep := 5 ; 
          $skip_text off$  
           ProcStep := 7 ; 
 	           XPOST ; 	         end;            end ; { step 4 }         5: begin  { entry on "give req" event }          SetDirectQbitReadReq ;           ProcStep := 6 ;         end; { step 5 }          6: begin           { entry on "direct read completion" event (Q bit Data) }            {} {change into a "normal comp" msg:}          {} {Note: next lines contain code to verify if error.}  !         {} {Remove comments if we decide to test for such errors} !         {}  { Error:= false; } #         {}  { L:= IBUF.W[4] - 1;} {total Q bit data length - msg code} #         {}  { QbitDataX := QbitDataPos + 1;} {skip msg code}          {}  { While  L > 0  do begin }  !         {}  {   If IBUF.B [ QbitDataX ] >= 128 } {error bit set?} !         {}  {   then begin error:= true; L:=0  end } !         {}  {   else begin L:=L-2; QbitDataX := QbitDataX+2; end } !         {}  { end ;  }          {}  { If error }          {}  {  then IBUF.W[3] := HardErrorStatus }           {}  {  else IBUF.W[3] := 0; }          {}          {}  Task := DoNotForward ;           {}  ProcStep := 7 ;  
         {}  XPOST ; 
         {}          end ; { step 6 }          7: begin { entry on "give req to XNET" }           SetDirectWriteReq ;           ProcStep := 8 ;          end ; { step 7 }          8: begin { Entry on "give direct data" or "normal comp" msg }                { Same ProcStep to take care of No Sam situation.  }               If Task = 4  { entry on "give direct data" }            then begin  { Step 8.1 }               { Prepare a "primary terminal status request" }               { Index points to the byte position in IBUF   }               { where the data has to be stored into.       }                IBUF.B[ index ]     := 27 {  33B = Esc } ;                IBUF.B[ index + 1 ] := 94 { 136B = ^   } ;                IBUF.B[ index + 2 ] := 17 {  21B = DC1 } ;                 ILEN := 3 ;  { send three bytes }               { Do not change ProcStep to cover No Sam situation }              end  { task = 4 }               else  { Task <> 4 }             begin  { Step 8.2 } #             { entry on task 3: completion of direct write (of Esc ^) } # #             Task := DoNotForward ;  { other request to be generated } #              TermMsgExpected := true ;               ProcStep := 9 ; { next step in sequence }     "             { Wait for the primary terminal status data indication } "               end ;  { if Task = 4 }             end ;  { procstep 8 }         9: begin { Entry on task 3 "Unsolicited data message" }              { Primary terminal status data has arrived.  }              { Issue a direct read to get it.             }                  SetDirectReadReq ;              ProcStep := 10 ; { next step in sequence }             end ;  { procstep 9 }         10: begin { Entry on task 3 "NormalComplMsg" read complet.}               { Expect to get "Esc \", 7 bytes of status plus }               { terminator. Example: Esc \ ? 0 0 ? 4 6 0 CR   }  #              { Terminator is CR in character mode, RS in block mode } #               dummy.w := LastBufferfilled^.bwords[1] ;             if  dummy.w = 7004  { 015534B = "Esc \" } 
           then begin 
"             { Block mode is second bit of 4th terminal status byte } "             dummy.w := LastBufferfilled^.bwords[3] ;                terminal_status.bit1 { block_mode } := dummy.bit1 ;   #             { Line/page mode is 4th bit of 2nd terminal status byte } #             dummy.w := LastBufferfilled^.bwords[2] ;  "             terminal_status.bit2 { line_page_mode } := dummy.bit3 ; " "             { InhHndShk(G) is 3rd bit of 3rd terminal status byte } "             dummy.w := LastBufferfilled^.bwords[3] ; !             terminal_status.bit3 { InhHndShk(G) } := dummy.bit10 ; !              { InhDC2(H) is 4th bit of 3rd terminal status byte }               dummy.w := LastBufferfilled^.bwords[3] ;                terminal_status.bit4 { InhDC2(H) } := dummy.bit11 ;             end ;  { if lastbufferfilled }             { else unknown primary terminal status format.}             { Output error message ???                    }     $           Task := DoNotForward ;  { Do not send unsol. data indication } $           ProcStep := 11 ; { next step in sequence }  	           XPOST ; 	     
         end ; { step 10 } 
        11: begin { entry on "give req to XNET" }           SetDirectWriteQbitReq ;  
          ProcStep := 12 ; 
        end ; { step 11 }           12: begin { Entry on "give Qbit data" or "normal comp" msg }   !              { Same ProcStep to take care of No Sam situation.  } !             If Task = 2  { entry on "give Qbit data" }             then begin  { Step 12.1 }              IBUF.B[ index ] := 2 ; { set parm msg code }  
            $skip_text on$ 
             WriteReadEQTindex := 2 ; {on read eqt} 
            $skip_text off$ 
                 if  terminal_status.bit1 = 1  { Block mode ? }              then                 if terminal_status.bit2 = 1  { block Page mode ? }                    then begin  { Block Page mode }  
                   {echo:} 
                   IBUF.B [index+1] := P2 ;    { echo ref }                    IBUF.B [index+2] :=  0 ;    { echo off }                    terminal_status.bit8 := 0 ; { echo off }                    { data forwarding character: DC2 }                     IBUF.B [index+3] := P3  ;                    IBUF.B [index+4] :=  0  ;   { none }                    terminal_status.bit15 := 0; { not "CR" }                    { idle timer }                     IBUF.B [index+5] := P4  ; "                   IBUF.B [index+6] := 10  ;   { idle timer 0.5 sec } " !                   {  Note: if editing is enabled, the PAD will  } ! !                   {        not take account of the idle timer.  } ! !                   {        ( CCITT X.28 1984 P 3.6.1.3 )        } !                   { editing: }                     IBUF.B [index+7] := P15 ;   { editing ref } !                   IBUF.B [index+8] :=   0 ;   { editing disabled } !!                   terminal_status.bit9 := 0 ; { editing disabled } !                    Ilen := 9 ;  
                 end 
	               else 	                 begin  { Block Line mode }  
                   {echo:} 
                   IBUF.B [index+1] := P2 ;    { echo ref }                    IBUF.B [index+2] :=  0 ;    { echo off }                    terminal_status.bit8 := 0 ; { echo off }                     { data forwarding character: CR }                     IBUF.B [index+3] := P3  ;                    IBUF.B [index+4] :=  2  ;   { CR }                    terminal_status.bit15 := 1; { "CR" }                    { idle timer }                     IBUF.B [index+5] := P4  ;  #                   IBUF.B [index+6] :=  0  ;   { idle timer disabled } #                   { editing: }                     IBUF.B [index+7] := P15 ;   { editing ref }  !                   IBUF.B [index+8] :=   1 ;   { editing enabled } ! !                   terminal_status.bit9 := 1 ; { editing enabled } !                    Ilen := 9 ;  
                 end 
           else  { Character mode }  	             begin 	                { echo: }                IBUF.B [index+1] := P2 ;    { echo ref }                IBUF.B [index+2] :=  1 ;    { echo off }                terminal_status.bit8 := 1 ; { echo enabled }                 { data forwarding character: CR }                 IBUF.B [index+3] := P3  ;                IBUF.B [index+4] :=  2  ;   { CR }                terminal_status.bit15 := 1; { "CR" }                { idle timer }                 IBUF.B [index+5] := P4  ;  !               IBUF.B [index+6] :=  0  ;   { idle timer disabled } !
               { editing: } 
                IBUF.B [index+7] := P15 ;   { editing ref }                 IBUF.B [index+8] :=   1 ;   { editing enabled }                 terminal_status.bit9 := 1 ; { editing enabled }  
               Ilen := 9 ; 
             end ;  { if block mode }         end 
        else  { Task <> 2 } 
          begin { step 12.2 }  !          { entry on "normal completion" event (Qbit data write) } !         $skip_text on$           Task := DoNotForward;           PADmsgExpected := true;  
          ProcStep := 13 ; 
         end;             end ; { procstep 12 }          13: begin  { entry on "give req" event }          SetDirectQbitReadReq ;          ProcStep := 14 ;        end; { step 13 }         14: begin        { entry on "direct read completion" event (Q bit Data) }           {} {change into a "normal comp" msg:}          {} {Note: next lines contain code to verify if error.}  !         {} {Remove comments if we decide to test for such errors} !         {}  { Error:= false; } #         {}  { L:= IBUF.W[4] - 1;} {total Q bit data length - msg code} #         {}  { QbitDataX := QbitDataPos + 1;} {skip msg code}          {}  { While  L > 0  do begin }  !         {}  {   If IBUF.B [ QbitDataX ] >= 128 } {error bit set?} !         {}  {   then begin error:= true; L:=0  end } !         {}  {   else begin L:=L-2; QbitDataX := QbitDataX+2; end } !         {}  { end ;  }          {}  { If error }          {}  {  then IBUF.W[3] := HardErrorStatus }           {}  {  else IBUF.W[3] := 0; }         $skip_text off$          {}           {}  { complete the control request 25B, forward to DVX }           {}  IBUF.W[1] := NormalCompMsg ;           {}  IBUF.W[3] := 0 { status } ;           {}  { set TLOG to current read type }           {}  { bit13 end transfer on control-D }           {}  { bit10 end transfer on specified character }           {}  IBUF.W[4] := 9216 ; { 022000B }           {}  if terminal_status.bit15 = 1  { end on "CR" }           {}    then IBUF.W[4] := IBUF.W[4] - 32768 ;           {}  if terminal_status.bit9 = 1 { editing enabled }           {}    then IBUF.W[4] := IBUF.W[4] + 512 ;          {}  if terminal_status.bit8 = 1 { echo enabled }           {}    then IBUF.W[4] := IBUF.W[4] + 256 ;          {}  IBUF.W[5] := 0 ;           {}  ILEN := EventLength ;          {}  PcleanUp ;          {}          end ; { else }  
         end ; { step 14 } 
        $    { The following code was intended to implement the VPLUS block mode } $$    { But is presently not used.                                        } $        $SKIP_TEXT ON$     { *** NOT USED *** }      15: begin { entry on Task 1: "Any request to give to XNET?" }                SetDirectWriteReq ;          ProcStep := 16 ; { next step in sequence }             end ; { procstep 15 }      !    16: begin { Entry on "give direct data" or "normal comp" msg } !              { Same ProcStep to take care of No Sam situation.  }               If Task = 4  { entry on "give direct data" }             then begin  { Step 16.1 }              { prepare an "Inhibit Handshake(G)" Esc &s1G }              { and a "Inhibit DC2(H)" Esc &s1H            }              { combined into  Esc &s1g1H                  }              { Index points to the byte position in IBUF  }              { where the data has to be stored into.      }                 IBUF.B[ index ]     :=  27 {  33B = Esc } ;                 IBUF.B[ index + 1 ] :=  38 {  46B = &   } ;                 IBUF.B[ index + 2 ] := 115 { 163B = s   } ;                 IBUF.B[ index + 3 ] :=  49 {  61B = 1   } ;                 IBUF.B[ index + 4 ] := 103 { 147B = g   } ;                 IBUF.B[ index + 5 ] :=  49 {  61B = 1   } ;                 IBUF.B[ index + 6 ] :=  72 { 110B = H   } ;                ILEN := 7  ;  { send seven bytes }               { Do not change ProcStep to cover No Sam situation }              end  { task = 4 }               else  { Task <> 4 }            begin  { Step 16.2 }               { entry on task 3: completion of direct write }              { complete the control request 25B }              IBUF.W[1] := NormalCompMsg ;               IBUF.W[3] := 0 { status } ;               IBUF.W[4] := 0 { tlog } ;              IBUF.W[5] := 0 ;               ILEN := EventLength ;              PcleanUp ;            end ;  { if Task = 4 }            end ;  { procstep 16 }  
     $SKIP_TEXT OFF$ 
        Otherwise  	   end ;  { case } 	      end ;  { with eqtptr^, eqtext }      END { PGetTermStrap };  $page$  $SKIP_TEXT ON$                { *** NOT USED NOW *** }  {****************************************************}   PROCEDURE  PGetDC2 ; $direct$  {****************************************************}      { Process used in block page mode to read the DC2  }  { character and send a DC1 trigger character.      }      { Called from  Select_Process : Task 3  DataPktMsg }  {         when DC2 is expected, in block page mode }       BEGIN         With EQTPTR^,EQText  do begin          Case  ProcStep  of            0 : begin { entry on Task 1 "give req to XNET" event }              SetDirectReadReq ; { to read the DC2 char. } 
             ProcStep := 1; 
 
           end; { step 0 } 
    !       1 : begin { entry on "normal comp" event (read completion) } !               if EQTPTR^.NextBufferToRead^.Bbytes[1] = 18 { DC2 }               then  
               begin 
                  { read DC2 and discard it }  
               end ; 
               { else received character is not the expected DC2 }                 { ignore for now.                                 }               Task := DoNotForward ;               ProcStep := 2 ;  
             XPOST ; 
 
           end; { step 1 } 
           2: begin { entry on "give req to XNET" }             SetDirectWriteReq ; 
            ProcStep := 3 ; 
 
          end ; { step 2 } 
           3 : begin { entry on task 4 "give direct data" }              If Task = 4  { entry on "give direct data" }                then begin  { Step 3.1 }                   IBUF.B[index] := 17 ; { "DC1" }                   ILEN := 1 ; { send one byte }                 end  { task = 4 }                   else  { Task <> 4 }                 begin  { Step 3.2 }  %                 { entry on task 3: completion of direct write (of DC1 ) } %                  Task := DoNotForward ;  { our own request }                  PcleanUp ; { end of sequence }                   { Wait for data from terminal in block mode }                end ;  { if Task = 4 }             end ;  { procstep 3 }     	     end { case } ; 	        end { with EQTPTR }      END { PGetDC2 };  $SKIP_TEXT OFF$               { *** NOT USED NOW *** }          {****************************************************}   PROCEDURE  SELECT_PROCESS  ;   $direct$  {****************************************************}       { Mainly used to complete the pending request }   { and take appropriate action.                }      { Called from Task 1 "any request to give to XNET"   }  { Called from Task 2 "Give Q-bit data"               }  { Called from Task 3 "event occured" : NormalCompMsg }  {                                      DirectCompMsg }  {                                      DataPktMsg    }  { Called from Task 4 "Give Direct data"              }       BEGIN        Case  EQTPTR^.EQText.ProcState  of             SCleanUp        :  PcleanUp ;        SParmlinkUp     :  PParmLinkUp ;        SSetReadParmMsg :  PSetReadParmMsg ;         SUnsolQbitData  :  PUnsolQbitData ;         SClearVC        :  PClearVC ;        SInvitClear     :  PInvitClear ;         SGetTermStrap   :  PGetTermStrap ;  {added M77 BG 20APR89}         $SKIP_TEXT ON$      { *** NOT USED NOW *** }         SGetDC2         :  PGetDC2 ;        {added M77 BG 20APR89}  
      $SKIP_TEXT OFF$ 
       Otherwise  { S0 : do nothing }        end {case}      end { SELECT_PROCESS};  $page$ " {******************************************************************} " BEGIN { PDSUP  body  } " {******************************************************************} "       Case  TASK  of               {---------------------------------}      0: begin { task = "New Request from DVX00" }               {---------------------------------}      !        { Note: Only control requests are transmitted to PDSUP.  } ! !        {       On exit, XNET executes the request found in IBUF } !            With  EQTPTR^,EQText do begin                 PDSreq := IBUF.W[3];  { request code and subfunction }       "           Case RequestSubf  of  { RequestSubf already set by XSCH } " %                         {-----------------------------------------------} % %              21: begin  { CN 25B inform driver of terminal strap change } % %                         {-----------------------------------------------} % %                    If CircuitStateUP               {added M77 BG 21APR89} %                     then begin  !                       { Change req into a "Write Q-bit" request.} ! !                       { XNET will come back with a task 2 :     } ! !                       {                       "Give Q-bit Data" } !                       ProcState := SGetTermStrap ;                         ProcStep := 0 ;                         SetDirectWriteQbitReq ;                     end                      else  ProcState := SCleanUp;  { VC not open }                     end {CN 25};                          {----------------------}               26: begin  { CN 32B Clear Circuit }                          {----------------------}  $                    { Change the request into an "invitation to clear" } $ $                    { PAD message, which is sent to the PAD via a      } $ $                    { Q-bit write.                                     } $ $                    { The user request 32B is completed when PDSUP is  } $ $                    { reentered to complete the Q-bit write.           } $                    If CircuitStateUP                      then begin                        ProcState := SInvitClear ;                         ProcStep := 0 ;                         SetDirectWriteQbitReq ;                     end                      else  ProcState := SCleanUp;  { VC not open }                     end {CN 32};                           {-------------------------------}                30: begin  { CN 36B Set Binary Read Length }                           {-------------------------------}  !                    { Not supported: change request into a NO OP } !                     PDSreq := 0;                       IBUF.W[3] := 0 ; {subf = 0 and f = 0}                       IBUF.W[4] := 0;                       IBUF.W[5] := 0;                    end {CN 36};                           {-----------------------------}               31: begin   { CN 37B Set Read Type        }                           {-----------------------------}  !                  { Only ECHO (bit8) /EDITING (bit9) changes are } ! !                  { supported. Others read types are ignored.    } ! !                  { Change request to "Set and Read parameters"  } ! !                  { XNET will come back with a task 2 :          } ! !                  {                            "Give Q-bit Data" } !     #                    PDSreqPARM.W := IBUF.W[4] ; {parm word of request} #                    ProcState := SSetReadParmMsg;                      ProcStep := 0;                      SetDirectWriteQbitReq;                       end { CN 37 } ;                    Otherwise { do nothing; transmit to XNET }                          { CN00  system clear }                         { CN16B Send Interrupt Packet }                          { CN26B Flush Input Buffer }                         { CN31B Establish Virtual Circuit }                         { CN32B Clear Virtual Circuit }                         { CN34B Set Port Parameters }                          PDSreq := 0;                         ProcState := SCleanUp ;            end {case RequestSubf}         end {with EQTPTR} 
        end {task 0}; 
 $page$               {---------------------------------------}      1: begin { task = "Any request to give to XNET?" }               { XNET detected IMMRQ.bit0 was 1.       }               { Was this EQT previously linked by     }               { XPOST ?                               }               { Set up NETWP and EQTPTR to point to   }               { First EQT in the list of requests     }               { waiting to be transported to XNET.    }               {---------------------------------------}           ILEN := 0; {convenient init};           If FirstPDSreq <> nil    { list non empty ? }  
          then begin 
          {} EQTPTR := FirstPDSreq;            {} SELECT_PROCESS;           {} If ILEN > 0 {req given?}           {} then begin { set NETWP and CurrentNet}           {}    NETWP := EQTPTR^.NetwResp ; 
          {}    I:=1; 
           {}    While ( NetwPtrTbl[I] <> NETWP ) do I := I+1 ;           {}    Currentnet:= I;           {} end;            {} { take this EQT out of list, even if ILEN = 0 }           {}    FirstPDSreq := EQTPTR^.EQText.NextPDSreq;            {}    If FirstPDSreq = nil then LastPDSreq := nil;            end;            { else list is empty: do nothing }     
        end {task 1}; 
                   {-------------------------------------------------}        2: begin { - TASK = "Give Qbit Data"               XNET is }                 {   processing the Direct Qbit Write subf. 2.     }                 { - INDEX points to the byte position in XNETIBUF }                 {   where the Q-bit data has to be stored.        }                 { - ILEN will be returned equal to the byte       }                 {   length of the Q-bit data.                     }                 {-------------------------------------------------}                index := ILEN ;           Ilen := 0;  { convenient init } "          SELECT_PROCESS ;  { EQTPTR^.EQText.ProcState already set  } ""                            { when new control request was received,} ""                            { or when unsolicited event occured.    } "            end { task 2 };  $page$                {--------------------------------------}       3: begin { task = "Event occured message"  or   }                {        Completion of pending request }                {--------------------------------------}         IMMRQ.W := 0; { appropriate bits set only if needed }         Case  IBUF.W[1]  of  { message type }           {-1} NormalCompMsg :    SELECT_PROCESS  ;           {-2} DirectReadCompMsg: begin              { If incoming Q-bit data packet is longer than }              { 128 bytes, then the direct read request will }              { be completed with soft error and Tlog = 0.   }              if  IBUF.W[3] <> 0  then     { status not zero }              {}   begin                {added M77 BG 27APR89}             {}     With  EQTPTR^, EQText do begin              {}       ProcState := SClearVC ;              {}       procStep := 0 ;              {}     end ;  { with }  
            {}     XPOST ; 
 
            {}   end 
                else  { no soft error }  !            { if first PAD msg byte = "param indication" PAD msg } !             If IBUF.B[ QbitDataPos ] = 0             then SELECT_PROCESS              else { PAD message is not "param indication" }                begin { this msg is never expected !!}                 With EQTPTR^,EQText  do                   begin #                    If ProcState = SUnsolQbitData {already in charge ?} ##                    then  PUnsolQbitData { unexpected msg on idle eqt } #                    else  { ProcState is not SUnsolQbitData } 
                      begin 
                       {} Task := DoNotForward; !                      {} { if 1st PAD msg byte is "error PAD msg" } !                       {} If IBUF.B [ QbitDataPos ] = 5  $                      {} then  { Clear circuit } { ignore if not error } $                       {}$skip_text on$  {M77 BG 06NOV89} "                      {} ProcState := SClearVC ; procStep := 0; XPOST "                      {}$skip_text off$                        {}   begin                        {}     ProcState := SClearVC ;                        {}     procStep := 0 ;                        {}     XPOST ;                        {}   end ;                       end                    end { with }                end ;  { if ibuf.b [ Qbitpos ] = 0 }                               end;  { DirectReadCompMsg }           { 2} LinkUpMsg:         begin             With EQTPTR^, EQText do             begin               CircuitStateUP := true;               Task := DoNotForward;               ProcState := SParmLinkUp;                ProcStep := 0; 
              XPOST ; 
            end { with Eqtptr }                               end;  { LinkUpMsg }           { 3} LinkDownMsg:       begin             EQTPTR^.EQText.CircuitStateUP := false;              PcleanUp ;                               end;  { LinkDownMsg }           { 4} InterruptMsg:      begin                                { just forward }                              end;  { InterruptMsg }      !     { 5} DataPktMsg:      begin            {added M77 BG 21APR89} ! "            { The incoming packet has not been read into EMA yet ! } "            with  EQTPTR^, EQText  do             begin               If  TermMsgExpected  	              then 	                begin  { i.e. PAD terminal status }                    TermMsgExpected := false ;                    Task := DoNotForward ;                   XPOST { must send direct read on this EQT } 
                end ; 
                   $SKIP_TEXT ON$             { *** NOT USED NOW *** }                else     { not waiting for a terminal message } 
                begin 
    #                  { If in block page mode, check if first char is DC2 } #                   if  (( terminal_status.bit1 = 1 { block mode })   "                      and ( terminal_status.bit2 = 1 { page mode })) "                   then                     begin                       if  DC2_expected  { has been set in }                       then              { DATA_PKT_WRITES }                         begin  $                          Task := DoNotForward ; { DC2 not seen by DVX } $                           ProcState := SGetDC2 ;                            ProcStep := 0;                           XPOST ; 
                        end 
                      { else block mode data for the application }                       end  { block page mode }                     { else   terminal in character mode }                      { RECEIVED FIRST PACKET OF A NEW MESSAGE }                      { JUST FORWARD THE DATA INDICATION,      }                      { keep Task = 3 for this.                } !                end ;  { else, not waiting for a terminal message } !              $SKIP_TEXT OFF$             { *** NOT USED NOW *** }                  end ;  { with eqtptr^ }                                  end;  { DataPktMsg }           {13} QbitDataMsg:       begin  "            { The incoming packet has not been read into EMA yet ! } "            With EQTPTR^, EQText do             begin                { never forward this event: } Task := DoNotForward;                    If PADmsgExpected                then begin                {}  PadMsgExpected := false;               {}  XPOST { must send Qbit read }               end  !              else begin  { Qbit data received when not expected } !              {}  If PDSreq = 0  { idle EQT ? }                {}  then begin                {}     ProcState := SUnsolQbitData ;                {}     ProcStep := 0 ;                {}     XPOST ; {send Q bit Read} 
              {}  end 
               {}  else  { EQT not idle } !              {}    {ignore (even if error):} IMMRQ.bit1:=1 {flush} !              end             end { with Eqtptr }                                end { QbitDataMsg };          {15} EstCircErrorMsg:    begin                EQTPTR^.EQText.CircuitStateUP := false ;                                end ;  { EstCircuitMsg }                Otherwise { just forward }              end ; { case ibuf.w[1] }             { If the request list is not empty, }         { then set the "more request" bit.  }         { PDSUP will be reentered later,    }         { upon task 1 "Any req for XNET ?". }          If FirstPDSreq <> nil  then  IMMRQ.bit0 := 1 ;            end ; { task 3 }                    {-------------------------------------------------}        4: begin { - TASK = "Give Direct Data"                     }                 {   XNET is processing the Direct Write subf. 3.  }                 { - INDEX points to the byte position in XNETIBUF }                 {   where the data has to be stored into.         }                 { - ILEN will be returned equal to the byte       }                 {   length of the data stored by PDSUP.           }                 {-------------------------------------------------}                                              {added M77 BG 20APR89}            index := ILEN ;           Ilen := 0;  { convenient init } "          SELECT_PROCESS ;  { EQTPTR^.EQText.ProcState already set  } ""                            { when new control request was received.} "            end { task 4 };                    {-------------------------------------------------}        5: begin { - TASK = "Look Up Incoming User Data"           }                 {-------------------------------------------------}                                              {added M77 BG 28APR89}                 with  EQTPTR^, EQText, LastBufferFilled^  do           begin                 { If in block page mode                         }             {  then begin                                   }             {         if  first byte = 'DC2'  process it    }             {         if last byte = 'RS' set End_Of_Record }             {                    flag in EMA buffer header. }             {       end                                     }             {  else character or block line mode do nothing.}                  if (( terminal_status.bit1 = 1 )     { block mode ? }                   and ( terminal_status.bit2 = 1 )) { Page mode ? }               then 	              begin 	                 $SKIP_TEXT ON$               { *** NOT USED *** }                    if { LastBufferFilled^.} Bbytes[1]  = 18 {'DC2'}   
                then 
                  begin                      ProcState := SGetDC2 ;                      ProcStep := 2; 
                    XPOST ; 
 !                    Task := DoNotForward ; { Dispatcher will not } ! !                                           { transfer DC2 to SAM } !
                  end 
 
                else 
                $SKIP_TEXT OFF$  #                  if { LastBufferFilled^.} Bbytes[length]  = 30 {'RS'} # "                  then { LastBufferFilled^.} End_Of_Record := true ; "              end ; { block page mode }                  { else  character mode }  !            { If in editing mode, check for edit/line del. chars } !              end ; { with eqtptr^, lastbufferfilled^ }             end { task 5 };         Otherwise   { unknown task }                  {M61 BG 19JUL88}           temp1_pa75c := ERRMSG8 ; { "PDSUP GOT AN UNKNOWN TASK" }      temp1_bytesword.LB := TASK ; $     cnum ( temp1_bytesword.W, nbconv ) ; { conversion decimal to ASCII } $     strmove ( 6, nbconv, 1, temp1_pa75c, ERRMSGlength +1 ) ;       msglength := errmsglength + 6 ;        EXEC2 (2,1{lu}, temp1_pa75c, 0 ) ;          { skip a line }  !     EXEC2 (2,1{lu}, temp1_pa75c, -msglength ) ; { output message } !       EXEC2 (2,1{lu}, temp1_pa75c, 0 ) ;          { skip a line }          end ; { case TASK }       end ; { PDSUP }      
 . { end of module XSEG4 } 
