#{*********************************************************************} # $PASCAL '91751-16220 REV.5020 <891110.1007>' #{*********************************************************************} ##{                                                                     } ##{      SOURCE: 91751-18220                                            } ##{      RELOC.: 91751-16220                                            } ##{      PGMR  : B.G.                                                   } ##{                                                                     } ##{   ***************************************************************   } ##{   * (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1987.  ALL RIGHTS     *   } ##{   * RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,      *   } ##{   * REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT*   } ##{   * THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.       *   } ##{   ***************************************************************   } ##{                                                                     } ##{*********************************************************************} ##{                                                                     } ##{  PROGRAM TO SURVEY X.25 NETWORKS AND RESTART THEM                   } ##{  IF THEY BECOME NOT READY.                                          } ##{                                                                     } ##{  This program has to be scheduled after that the X.25/1000          } ##{  subsystem is initialized.                                          } ##{                                                                     } ##{  This program will execute periodically until a break is sensed.    } ##{                                                                     } ##{  The first scheduling parameter is the name of the file containing  } ##{  the list of parameters defined as follows :                        } ##{                                                                     } ##{  - The first parameter is the time period to elapse between two     } ##{    consecutive executions of this program                           } ##{    ( in minutes and greater than 1 ).                               } ##{                                                                     } ##{  - The next parameter is the total number of networks (LAP-B cards) } ##{    on this system ( range 1 to 16 ).                                } ##{                                                                     } ##{  - The next parameters are the list of network write LUs.           } ##{                                                                     } ##{                                                                     } ##{  e.g.   CI>  XQ SRVEY PARAMETER_FILE_NAME                           } ##{                                                                     } ##{                                                                     } ##{  The errors possibly reported by this program are those described   } ##{  in the reference manual about procedures GETNETWSTATE and          } ##{  ENABLNETWORK.                                                      } ##{                                                                     } ##{*********************************************************************} ##{                                                                     } ##{ History:                                                            } ##{                                                                     } ##{   Original version:   Rev 5.0                                       } ##{                                                                     } ##{   Revision #1       5.2  ( B.G.)                                    } ##{    .Provide the parameters from an external file rather than        } ##{     have the customer edit the source file for the number of        } ##{     networks and the list of network LUs.  (M74)                    } ##{                                                                     } ##{*********************************************************************} #    $STANDARD_LEVEL 'HP1000'$ $CDS OFF$ $RECURSIVE OFF$     PROGRAM SRVEY ;         CONST        MaxNbofNetworks = 16 ;      
  { network states } 
 
  unknown           = -1 ; 
 
  ready             =  0 ; 
 
  carderror         =  1 ; 
 
  handshakewithcard =  2 ; 
       out_lu = 1 ;  
  string_max_Length = 80 ; 
   integer_string_Length = 9 ;       TYPE       states = unknown .. handshakewithcard ;    shortinteger = -32768 .. 32767 ;    A3W  = array [ 1..3  ] of shortinteger ;    A5W  = array [ 1..5  ] of shortinteger ;    A6W  = array [ 1..6  ] of shortinteger ;   A30C = packed array [ 1..30 ] of char ;    ANetworks = array [ 1..MaxNbofNetworks ] of shortinteger ;        string_max = PACKED ARRAY [ 1..string_max_length ] OF CHAR ;  $  integer_string  = PACKED ARRAY [ 1..integer_string_length  ] OF CHAR ; $    VAR     	  break : boolean ; 	  parms : A5W ;  	  progname : A3W ; 		  time_buf : A30C ; 	  dummy, NetwLu, error, delay, I,    new_year, previous_year, NbOfNetworks : shortinteger ;   NetworkStateTbl : A6W ;   NetworkTable : ANetworks ;  { Table of Network LU's }    new_state, previous_state : states ;   new_time, previous_time : A5W ; #  log_string, data_file_name, temp_string1, temp_string2 : string_max ; #   srvey_parms : text ;         Function  pas_parameters $ ALIAS 'Pas.Parameters' $                     (     position : shortinteger ;                      VAR parameter : string_max ;  !                         length : shortinteger  ) : shortinteger ; ! $                                                              external ; $Procedure EXEC6  $alias 'EXEC'$                  ( code, prog : shortinteger ) ; external ;     Procedure EXEC12 $alias 'EXEC'$           ( code : shortinteger ;              progname : A3W ;             units, often, delay : shortinteger ) ; external ;      Procedure read_write_line $ ALIAS 'EXEC' $                    ( code , cntwd1 : shortinteger ;                       VAR bufr : string_max ;                       VAR bufln : shortinteger ) ; external ;     Procedure FTIME            ( var time_buf : A30C ) ; external ;      Function IFBRK : shortinteger ; external ;     Procedure detach_from_session $alias 'DTACH'$             ( var dummy : shortinteger ) ; external ;      {********* PROCEDURES FROM THE X.25/1000 LIBRARY ************}      Procedure GetNetwState ( NwLu : shortinteger ;                           var NetworkStateTbl : A6W ;                            var error : shortinteger ) ; external ;       Procedure EnablNetwork ( NwLu : shortinteger ;                            var error : shortinteger ) ; external ;       {************************************************************}          $ {*********************************************************************} $ $ {                                                                     } $ $ { FUNCTION   >>> STRLEN <<<                                           } $ $ {                                                                     } $ $ { ** This function returns the number of characters in the string.    } $ $ { ** Trailing blanks may be counted up to character '\' .             } $ $ { ** Character '\' at the end of string may be used as a delimiter    } $ $ { ** when trailing blanks are desired. ( usefull to merge 2 strings ) } $ $ { ** The delimiter character is defined as a constant.                } $ $ {                                                                     } $ $ { External Type declarations :   string_max                           } $ $ {                                                                     } $ $ { Global Variables accessed  :                                        } $ $ {                                                                     } $ $ {   READ  :  string_max_length                                        } $ $ {                                                                     } $ $ {   WRITE :  NONE                                                     } $ $ {                                                                     } $ $ { Procedures and Functions referenced :  NONE                         } $ $ {                                                                     } $ $ {*************************************************** update 13 JUN 89 } $          FUNCTION STRLEN ( string : string_max ) : INTEGER ;      & CONST  { the delimiter character is also defined identically in STRAPPEND } &        string_delimiter_character = '\' ;        VAR         index  :  INTEGER ;       BEGIN         index := string_max_length ;          { start counting down from end of string }      WHILE (( index > 0 )  AND  ( string [ index ] = ' ' ))         DO  index := index - 1 ;      
   IF (( index > 0 )  AND  
        ( string [ index ] = string_delimiter_character ))        THEN  index := index - 1 ;       
   STRLEN := index ; 
      END ;            {  enf of function STRLEN  }                          $ {*********************************************************************} $ $ {                                                                     } $ $ { PROCEDURE  >>> LOG_MESSAGE <<<                                      } $ $ {                                                                     } $ $ { ** This procedure outputs messages onto the standard device.        } $ $ { ** It handles character messages only.                              } $ $ { ** This procedure uses EXEC 2 in replacement of WRITELN and saves   } $ $ { ** about 6 pages of program space.                                  } $ $ { ** The total log_string size is specified by the constant           } $ $ { ** string_max_length.                                               } $ $ { ** Unused space in that string is filled up with blank characters.  } $ $ {                                                                     } $ $ { External Type declarations :   string_max , shortinteger            } $ $ {                                                                     } $ $ { Global Variables accessed  :                                        } $ $ {                                                                     } $ $ {   READ  :  out_lu ( Logical Output Device )                         } $ $ {                                                                     } $ $ {   WRITE :  NONE                                                     } $ $ {                                                                     } $ $ { Procedures and Functions referenced :  STRLEN , read_write_line     } $ $ {                                                                     } $ $ {*************************************************** update 10 AUG 84 } $      PROCEDURE log_message ( log_string : string_max ) ;       CONST         write_exec_code = 2 ;       VAR         write_cntwd , log_string_neg_char_length  : shortinteger ;        BEGIN      !   {*                                                           *} ! !   {*  WRITELN ( LOD , log_string : STRLEN ( log_string ) ) ;   *} ! !   {*                                                           *} ! !   {*  The WRITELN statement may be used in replacement of the  *} ! !   {*  following EXEC call, but the program size will increase  *} ! !   {*  by about 6 pages.                                        *} !     
   write_cntwd := out_lu ; 
 '                         { bit15 : driver bypass bit reset                  }  ' '                         { bit14 : non_buffered bit reset                   }  ' '                         { bit13 : no user error handling                   }  ' '                         { bit12 : no double buffer mode                    }  ' '                         { bit10 : no transparency mode -> add CR/LF        }  ' '                         { bit8  : keyboard input echo mode : N/A           }  ' '                         { bit6  : BInary transmit reset -> transmit ASCII  }  ' '                         { bit0-5: out_lu   -> Logical Output Device        }  '            log_string_neg_char_length :=  - STRLEN ( log_string ) ;       '   read_write_line ( write_exec_code , write_cntwd ,               { EXEC 2 }  '                       log_string , log_string_neg_char_length ) ;            END ;     {  end of procedure log_message  }                       $ {*********************************************************************} $ $ {                                                                     } $ $ { PROCEDURE  >>> SPACE_LINES <<<                                      } $ $ {                                                                     } $ $ { ** This procedure skips as many lines as specified on the standard  } $ $ {                                                           device.   } $ $ { External Type declarations :   NONE                                 } $ $ {                                                                     } $ $ { Global Variables accessed  :                                        } $ $ {                                                                     } $ $ {   READ  :  NONE                                                     } $ $ {                                                                     } $ $ {   WRITE :  log_string                                               } $ $ {                                                                     } $ $ { Procedures and Functions referenced :  LOG_MESSAGE                  } $ $ {                                                                     } $ $ {*************************************************** update 13 AUG 84 } $      PROCEDURE space_lines ( nb_of_lines_to_space :INTEGER ) ;       VAR         I : INTEGER ;       BEGIN         log_string := '  \' ;     IF  nb_of_lines_to_space > 0  THEN        FOR  I := 1 TO nb_of_lines_to_space  DO         BEGIN           log_message ( log_string ) ;          END ;       END ;     {  end of procedure space_lines  }               $ {*********************************************************************} $ $ {                                                                     } $ $ { FUNCTION    >>> ITOC <<<                                            } $ $ {                                                                     } $ $ { ** Integer to character conversion.  ( left justified )             } $ $ { ** The string is 11 ASCII character long.                           } $ $ { ** ( defined by the constant  integer_string_length )               } $ $ {                                                                     } $ $ { External Type declarations :  integer_string                        } $ $ {                                                                     } $ $ { Procedures and Functions referenced :   NONE                        } $ $ {                                                                     } $ $ { Global Variables accessed  :                                        } $ $ {                                                                     } $ $ {   READ ONLY :  integer_string_length                                } $ $ {                                                                     } $ $ {   MODIFIED  :  NONE                                                 } $ $ {                                                                     } $ $ {**************************************************** update 9 MAR 84 } $      FUNCTION ITOC ( number : INTEGER ) : integer_string ;       TYPE          string10 = PACKED ARRAY [ 1..10 ] OF CHAR ;       CONST         base = 10 ;     zero_nine = string10 [ '0123456789' ] ;       VAR      
   I , J , lsd : INTEGER ; 
    string , string2 : integer_string ;     negatif : BOOLEAN ;       BEGIN         ITOC := ' ' ;  	   string := ' ' ; 	 
   string2 := ' ' ;  
    negatif := FALSE ;          IF number < 0  THEN       BEGIN         negatif := TRUE ;         number := - number ;        END ;         I := integer_string_length ;       $   {********** convert number to char. string right justified *********} $    REPEAT   "       lsd := ( number MOD base ) + 1 ;  { least significant digit } "        string [ I ] := zero_nine [ lsd ] ;  
       I := I - 1 ;  
        number := number  DIV  base ;     UNTIL  (( number = 0 ) OR ( I <= 0 )) ;         { remove leading spaces }     I := 1 ;      WHILE  (( I <= integer_string_length )  AND  "           ( string [ I ] = ' ' ))  DO  I := I + 1 ; { skip blanks } " 
   string2 := ' ' ;  
    J := 1 ;   
   IF  negatif  THEN 
      BEGIN         string2 [ J ] := '-' ;   
       J := J + 1 ;  
      END ;         WHILE (( I <= integer_string_length )  AND             ( J <= integer_string_length ))  DO        BEGIN         string2 [ J ] := string [ I ] ;  
       I := I + 1 ;  
 
       J := J + 1 ;  
      END ;      
   ITOC := string2 ; 
      END ;  {  end of the procedure  ITOC  }                      $ {*********************************************************************} $ $ {                                                                     } $ $ { FUNCTION   >>> STRAPPEND <<<                                        } $ $ {                                                                     } $ $ { ** This function merges two strings of characters.                  } $ $ { ** The resulting string may be one of the parameter strings.        } $ $ { ** If trailing blanks are desired at the end of any string, then    } $ $ { ** Character '\' may be used as delimiter ( defined as a constant ).} $ $ { ** The delimiting character is defined twice in STRLEN & STRAPPEND  } $ $ {                                                                     } $ $ { External_type_declarations : string_max                             } $ $ {                                                                     } $ $ { Global Variables accessed  :                                        } $ $ {                                                                     } $ $ {   READ  :  string_max_length                                        } $ $ {                                                                     } $ $ {   WRITE :  NONE                                                     } $ $ {                                                                     } $ $ { Procedures and Functions referenced :  STRLEN                       } $ $ {                                                                     } $ $ {*************************************************** update 19 JUN 84 } $         # FUNCTION STRAPPEND ( string1 , string2 : string_max ) : string_max ;  #     % CONST  { the delimiter character is also defined identically in STRLEN }  %        string_delimiter_character = '\' ;        VAR     I , L1 , L2 , L3 , L4 : INTEGER ;     merge_string : string_max ;       BEGIN         L1 := STRLEN ( string1 ) ;      L2 := STRLEN ( string2 ) ;   	   L4 := L1 + L2 ; 	     '   { check for last character of second string to be the delimiter character } '    { if any, then it has to be included in the merged string }  &   IF  ( L2 + 1 <= string_max_length )  THEN  { no need if string is full }  &      IF  string2 [ L2 + 1 ] = string_delimiter_character  THEN         L2 := L2 + 1 ;       &   L3 := L1 + L2 ; { expected resulting string length, including optional }  & &                                                    { delimiter character }  &    IF  L3 > string_max_length  THEN        BEGIN  '       log_string := 'STRAPPEND : MERGED STRING TOO LONG : L1 , L2 , L3 : ' ;  '        log_message ( log_string ) ;          log_string := ITOC ( L1 ) ;         log_message ( log_string ) ;          log_string := ITOC ( L2 ) ;         log_message ( log_string ) ;          log_string := ITOC ( L3 ) ;         log_message ( log_string ) ;          log_string := 'STRING1 :' ;         log_message ( log_string ) ;          log_message ( string1 ) ;         log_string := 'STRING2 :' ;         log_message ( log_string ) ;          log_message ( string2 ) ;  
       space_lines ( 1 ) ; 
      END ;         merge_string := string1 ;         FOR  I := 1 TO L2  DO        merge_string [ I + L1 ] := string2 [ I ] ;      '   L3 := STRLEN( merge_string ) ; { optional trailing delimiter not included } '        IF  L3 <> L4   THEN       BEGIN  "       log_string := 'STRAPPEND INCONSISTANCIES , L1 , L2 , L3 : ' ; "        log_message ( log_string ) ;          log_string := ITOC ( L1 ) ;         log_message ( log_string ) ;          log_string := ITOC ( L2 ) ;         log_message ( log_string ) ;          log_string := ITOC ( L3 ) ;         log_message ( log_string ) ;          log_string := 'STRING1 :' ;         log_message ( log_string ) ;          log_message ( string1 ) ;         log_string := 'STRING2 :' ;         log_message ( log_string ) ;          log_message ( string2 ) ;  
       space_lines ( 1 ) ; 
      END ;         STRAPPEND := merge_string ;       END ;           {  end of the function STRAPPEND  }                  $ {*********************************************************************} $ $ {                                                                     } $ $ { PROCEDURE     >>>  RETRIEVE_SCHEDULING_PARAMETERS  <<<              } $ $ {                                                                     } $ $ { Expected scheduling parameters are :                                } $ $ {   1) Data file name                                                 } $ $ {                                                                     } $ $ { External Type declarations : string_max, shortinteger               } $ $ {                                                                     } $ $ { Global Variables accessed  :                                        } $ $ {                                                                     } $ $ {   READ  :  NONE                                                     } $ $ {                                                                     } $ $ {   WRITE :  NONE                                                     } $ $ {                                                                     } $ $ { Procedures and Functions referenced : pas_parameters, strappend     } $ $ {                                       log_message, space_lines      } $ $ {                                                                     } $ $ {*************************************************** update 01 SEP 89 } $    &PROCEDURE retrieve_scheduling_parameters ( var data_file_name : string_max ); & {----------------------------------------}     CONST        file_name_path_length = 63 ;     VAR       I , length : shortinteger ;    parameter_error , check_next_parameter : BOOLEAN ;    parameter_string, graph_dev_LU_char : string_max ;     BEGIN        parameter_error := FALSE ;    check_next_parameter := TRUE ;       { ***  retrieve scheduling parameter 1  *** }     #  length := pas_parameters ( 1 , data_file_name , string_max_length ) ; #      if  length < 0  then   { no one parameter has been passed }         begin       parameter_error := true ;       space_lines ( 1 ) ;        log_string := '>> SRVEY : PARAMETER FILE NAME IS MISSING' ;         log_message ( log_string ) ;       space_lines ( 1 ) ; $      log_string := '           e.g.  CI> XQ SRVEY /SYSTEM/SRVEY_PARMS' ; $       log_message ( log_string ) ;       space_lines ( 1 ) ; 	      log_string := 	 #       '           Parameter file contains the following parameters' ; #       log_message ( log_string ) ; 	      log_string := 	&  '           - Delay between two executions of this program ( in minutes )'; &       log_message ( log_string ) ; 	      log_string := 	        '           - Number of networks ( 1 .. 16 )' ;        log_message ( log_string ) ; 	      log_string := 	 !       '           - First network write lu number ( 2 .. 254 )' ; !       log_message ( log_string ) ; 	      log_string := 	
       '           - ...' ; 
       log_message ( log_string ) ; 	      log_string := 	        '           - Last network write lu number ( 2 .. 254 )' ;         log_message ( log_string ) ;       space_lines ( 1 ) ; 	      log_string := 	&   '           Errors possibly reported by this program are those explained'; &       log_message ( log_string ) ; 	      log_string := 	&       '           in the reference manual for procedures GetNetwState and' ; &       log_message ( log_string ) ; 	      log_string := 	       '           EnablNetwork in paragraph network survey.' ;        log_message ( log_string ) ;     end      $  else  if  (( length = 0 ) or ( length > file_name_path_length ))  then $        begin       parameter_error := true ;       space_lines ( 1 ) ; &      log_string := '>> SRVEY : SCHEDULING PARAMETER IS MISSING OR TOO LONG'; &       log_message ( log_string ) ;     end ;      %{ else  0 < parameter length < file_name_path_length : data_file_name ok } %       if  parameter_error   then     begin       space_lines ( 1 ) ;        exec6 ( 6 , 0 ) ; { stop program }     end ;      END ;  { end of procedure retrieve_scheduling_parameters }             PROCEDURE GET_PARAMETERS_FROM_FILE ( var Delay : shortinteger ;  #                                     var NbofNetworks : shortinteger ; #"                                     var NetworkTable : ANetworks ) ; "    VAR     
  missing_parms : boolean ; 
 
  I : shortinteger ; 
    BEGIN       reset ( srvey_parms, data_file_name ) ;       if  EOF ( srvey_parms )      then       begin         missing_parms := true ; 
        log_string := 
 "         '>> SRVEY : FIRST PARAMETER IS MISSING IN PARAMETER FILE' ; "         log_message ( log_string ) ;       end      else       begin          readln ( srvey_parms , delay ) ;     
        if  delay < 1  then 
          begin             space_lines ( 1 ) ;  "            log_string := '>> SRVEY : DELAY PARAMETER IS < 1 :  \' ; "             temp_string2 := ITOC ( delay ) ; !            log_string := STRAPPEND ( log_string , temp_string2 ) ; !             log_message ( log_string ) ;             space_lines ( 1 ) ;              exec6 ( 6 , 0 ) ; { stop program }           end          else           begin             space_lines ( 1 ) ;               log_string := '>> SRVEY : DELAY PARAMETER IS :  \' ;               temp_string2 := ITOC ( delay ) ; !            log_string := STRAPPEND ( log_string , temp_string2 ) ; !             temp_string2 := ' MINUTES' ; !            log_string := STRAPPEND ( log_string , temp_string2 ) ; !             log_message ( log_string ) ;           end ;       end ;        if EOF ( srvey_parms )      then       begin         missing_parms := true ; 
        log_string := 
"         '>> SRVEY : SECOND PARAMETER IS MISSING IN PARAMETER FILE' ; "         log_message ( log_string ) ;       end      else       begin         readln ( srvey_parms , NbofNetworks ) ;     %        if  ( NbofNetworks < 1 ) or ( NbofNetworks > MaxNbofNetworks ) then %          begin             space_lines ( 1 ) ;             log_string := "      '>> SRVEY : ACCEPTABLE NUMBER OF NETWORKS 1 to 16. RECEIVED \'; "            temp_string2 := ITOC ( NbofNetworks ) ; !            log_string := STRAPPEND ( log_string , temp_string2 ) ; !             log_message ( log_string ) ;              exec6 ( 6 , 0 ) ; { stop program }           end          else           begin               log_string := '>> SRVEY : NUMBER OF NETWORKS :  \' ;              temp_string2 := ITOC ( NbofNetworks ) ; !            log_string := STRAPPEND ( log_string , temp_string2 ) ; !             log_message ( log_string ) ;           end ;       end ;       for  I := 1 to NbofNetworks  do     begin        if not EOF ( srvey_parms )        then         begin            readln ( srvey_parms , NetworkTable[ I ] ) ; #          if  ( NetworkTable[I] < 1 ) or ( NetworkTable[I] > 254 ) then #            begin               space_lines ( 1 ) ; 
              log_string := 
#               '>> SRVEY : ACCEPTABLE NETWORK LU 2 to 254. RECEIVED \'; #               temp_string2 := ITOC ( NetworkTable[ I ] ) ; "              log_string := STRAPPEND ( log_string , temp_string2 ) ; "               log_message ( log_string ) ;               space_lines ( 1 ) ;                exec6 ( 6 , 0 ) ; { stop program }             end            else             begin                 log_string := '>> SRVEY : NETWORK WRITE LU :  \' ;                 temp_string2 := ITOC ( NetworkTable[ I ] ) ; "              log_string := STRAPPEND ( log_string , temp_string2 ) ; "               log_message ( log_string ) ;             end         end        else         begin           missing_parms := true ;           log_string := "           '>> SRVEY : MISSING NETWORK LU NUMBER IN PARAMETER FILE' ; "           log_message ( log_string ) ;         end ;     end ;       close ( srvey_parms ) ;       if  missing_parms  then     begin       space_lines ( 1 ) ;        exec6 ( 6 , 0 ) ; { stop program }     end ;     END ;  { procedure get_parameters }             BEGIN  { main }       retrieve_scheduling_parameters ( data_file_name ) ;      !  get_parameters_from_file ( delay, NbofNetworks, NetworkTable ) ; !      detach_from_session ( dummy ) ;      	  break := false ; 	          REPEAT   { until break sensed }         I := 0 ;  { index to NetworkTable }         REPEAT { until all networks scanned }      	      I := I + 1 ; 	           NetwLu := NetworkTable [ I ] ;           GetNetwState ( NetwLu, NetworkStateTbl, error ) ;           if  error = 0   { any error ? }        then         begin               Case  NetworkStateTbl [ 1 ]  of     	            ready : 		              begin 	                 new_state := ready ; 	              end ; 	                 handshakewithcard : { ignore } ;                 carderror : 	              begin 	 #                ftime ( time_buf ) ; { request formatted system time } #                 new_state := carderror ;                 space_lines ( 1 ) ; !                log_string := '>> SRVEY : RESTARTING NETWORK LU ' ; !                temp_string1 := ITOC ( NetwLu ) ; #                log_string := STRAPPEND ( log_string , temp_string1 ) ; #                 temp_string2 := '   \' ; #                log_string := STRAPPEND ( log_string , temp_string2 ) ; #                 temp_string2 := time_buf ; #                log_string := STRAPPEND ( log_string , temp_string2 ) ; #                 log_message ( log_string ) ;                 space_lines ( 1 ) ;                  EnablNetwork ( NetwLu, error ) ;                  if  error <> 0  then                   begin                     { output an error message }                     space_lines ( 1 ) ;                     log_string :=  $                     '>> SRVEY : ERROR WHILE RESTARTING NETWORK ON LU '; $                    temp_string1 := ITOC ( NetwLu ) ; %                    log_string := STRAPPEND ( log_string , temp_string1 ) ; %                     temp_string2 := '   ERROR  \'; %                    log_string := STRAPPEND ( log_string , temp_string2 ) ; %                     temp_string2 := ITOC ( error ) ; %                    log_string := STRAPPEND ( log_string , temp_string2 ) ; %                     log_message ( log_string ) ;                     space_lines ( 1 ) ;                   end ;                end ; { case carderror }                 otherwise { unknown } 	              begin 	                 new_state := unknown ;                 space_lines ( 1 ) ;                 log_string :=  &              '>> SRVEY : RECEIVED AN UNKNOWN NETWORK STATE ON NETWORK LU '; &                temp_string1 := ITOC ( NetwLu ) ; #                log_string := STRAPPEND ( log_string , temp_string1 ) ; #                 log_message ( log_string ) ;                 space_lines ( 1 ) ; 	              end ; 	           end ; { case }              end   { if error = 0 }            else  if  error = -1  then 	              begin 	                { ignore, X.25/1000 subsystem not initialized }               end            else           begin             { output an error message }             space_lines ( 1 ) ;             log_string :=  #            '>> SRVEY : ERROR WHILE REQUESTING NETWORK STATE ON LU \'; #            temp_string1 := ITOC ( NetwLu ) ; !            log_string := STRAPPEND ( log_string , temp_string1 ) ; !             temp_string2 := '   ERROR \' ; !            log_string := STRAPPEND ( log_string , temp_string2 ) ; !             temp_string2 := ITOC ( error ) ; !            log_string := STRAPPEND ( log_string , temp_string2 ) ; !             log_message ( log_string ) ;             space_lines ( 1 ) ;           end ;         UNTIL  ( I = nbofnetworks ) or ( error = -1 ) ;          { set in time list and suspend }      progname[1] := 0 ; progname[2] := 0 ; progname[3] := 0 ;     exec12 ( 12, progname, 3 { in minutes}, 0, -delay ) ;         if ifbrk < 0  then  break := true ;        UNTIL  break ;       ftime ( time_buf ) ;  { request formatted system time } 
  space_lines ( 1 ) ; 
  log_string := '>> SRVEY : PROGRAM STOP     \' ;    temp_string2 := time_buf ;   log_string := STRAPPEND ( log_string , temp_string2 ) ;    log_message ( log_string ) ; 
  space_lines ( 1 ) ; 
    END .  { end of program SRVEY } 