"$cds on $ $range off$ $DEBUG ON $ $HEAP_DISPOSE OFF$ $TRACE_BACK ON $ "$HEAP 1$ $HEAPPARMS OFF$ $LINESIZE 255$ $tables on$  $TITLE 'VCPMT GM Marion VCP     '$  $SUBTITLE 'Traceing Routines    '$  $AUTOPAGE$  $PASCAL ',4,80 92078-16118 REV.5020 <900111.1548>'  {    NAME:   vcpmt_trace       SOURCE: 92078-18118       RELOC:  92078-16118      PGMR:   mh      !  **************************************************************** ! !  * (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1989.  ALL RIGHTS      * ! !  * RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       * ! !  * REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT * ! !  * THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.        * ! !  **************************************************************** ! }   {   vcp program tracing routines     } 	MODULE vcpmt_trace; 	    { These routines handle tracing for    Virtual Control Panel Monitor programs       }      IMPORT $SEARCH 'TRY_RECOVER.REL'$ try_recover,         $SEARCH 'vcp_DECLS.REL'$ vcp_decls,         $SEARCH 'TEST_PROCS.REL'$ test_procs;          EXPORT        VAR trace_level: shortint;       trace_file: text; 
      trace_maj_seq: 0..99; 

      trace_min_seq: 0..99; 
       trace_string: string[512];        trace_str: trace_string_type; { 72 }  
      trace_pos: shortint; 
    FUNCTION trace_post(t_number: shortint): boolean;      PROCEDURE trace_write;      PROCEDURE trace_close;     &PROCEDURE trace_control(level: shortint; file_name_buff: file_path_name_type; &                        length: shortint;                         set_err_print: boolean;                         err_print_lu: shortint;                          VAR error: boolean);         IMPLEMENT     $INCLUDE 'VCPMT_MESSAGES.pasi'$  $INCLUDE 'vcp_EXTERNALS.pasi'$          PROCEDURE trace_close;      " { Called to close any open trace file, first checks the trace level "   to assure that a file was open, then closes the trace file }       BEGIN 
    IF trace_level > 0 THEN 
      BEGIN          TRY;           close(trace_file,'SAVE');          IF recover THEN; { ignore the error on close }        END;    END;      PROCEDURE trace_write;     #{ appends the global trace_str to the global trace_string and marks the #  end of each sub string with DLE CR. Any occurance of DLE in %  the trace string has a DLE inserted in front of it. In trace post all DLE % &  and following characters are deleted unless the following character is DLE &%  in which case only the first DLE is deleted. The substrings (exclusive of % '  trailing DLE CR) are written as individual records to the trace and/or error '   error files.     &  Any string which would extend beyond the end of trace_string (either passed & &  in or extended by DLE insertion) will be truncated. Substrings are limited &  to 72 characters each }        CONST DLE = chr(16);          CR  = chr(13);        VAR   start: shortint;          max: shortint;  
        esc_pos: shortint; 
         sleng: shortint;          pos: shortint;         spos: shortint;  
        inserts: shortint; 
      BEGIN     trace_str := strrtrim(trace_str);     sleng := strlen(trace_str);     
    IF sleng > 0 THEN 
      BEGIN          max := strmax(trace_string);          start := strlen(trace_string);             IF (start + sleng) > max THEN { truncate the string }           sleng := max - start;         IF sleng > 0 THEN           BEGIN             setstrlen(trace_str,sleng);              spos := 1;             pos := start + 1;             inserts := 0;                 esc_pos := strpos(trace_str,DLE);  %            IF esc_pos > 0 THEN    { move one at a time looking for DLEs } %	              BEGIN 	                     WHILE spos <= sleng DO                   BEGIN !                    strwrite(trace_string,pos,pos,trace_str[spos]); !                    IF trace_str[spos] = DLE THEN 
                      BEGIN 
                        pos := pos + 1;                         trace_string := trace_string + DLE;                         inserts := inserts + 1;  %                        IF (sleng + inserts) > 72 THEN sleng := sleng - 1; % 
                      END; 
                    spos := spos + 1;                    END; { WHILE }                   END              ELSE   { move trace_str the easy way }               trace_string := trace_string + trace_str;                  trace_string := trace_string + DLE + CR;            END;        END;  
    trace_str := ''; 
	    trace_pos := 1; 	   END;         FUNCTION trace_post(t_number: shortint): boolean;      % { Appends the global trace_string to the message from the trace_error_msg %$   array indexed by the number. If the number is zero no message is used. $ %   Posts the contents of the trace_string in sequenced strings. Depends on % $   trace_string being separated into 72 or fewer character substrings by $%   trace_write. Substrings are delimited by DLE CR. If a DLE occurs, delete % %   it and the following character unless the following character is a DLE. %    If the following character is a CR, terminate the record.    Returns true if successful, false if trace file access fails  '   If the t_number is negative, prints the message on the global error_printer '#   file, If trace level is > 0, prints the message in the trace file. } #       CONST DLE = chr(16);          CR  = chr(13);        VAR trace_buffer: trace_buffer_type;        error_buffer: trace_buffer_type;        msg_string: trace_string_type;  
      pos: shortint; 
       t_pos: shortint; 
      error: boolean; 
 
      max: shortint; 
 
      done: boolean; 
      BEGIN 	    error := false; 	     trace_buffer := trace_buffer_init;     trace_maj_seq := (trace_maj_seq + 1) mod 100;     trace_min_seq := 0;      trace_buffer[3] := chr(ord('0')+trace_maj_seq div 10);      trace_buffer[4] := chr(ord('0')+trace_maj_seq mod 10); 
    msg_string := ''; 
    pos := 1;         IF t_number <> 0 THEN       BEGIN         IF (t_number < min_err_number) OR            (t_number > max_trace_number) THEN           t_number := min_err_number - 1;             strwrite(msg_string,1,t_pos,trace_error_msg[t_number]);         msg_string := strrtrim(msg_string);          t_pos := strlen(msg_string);      &        { note, trace_error_msg strings end in DLE if they are to be records &&          by themselves and don't end in DLE if they expect to be continued } &            IF msg_string[t_pos] = DLE THEN            trace_string := msg_string + CR + trace_string          ELSE            trace_string := msg_string + ' ' + trace_string;        END;         IF t_number <= 0 THEN       BEGIN         writeln(error_printer);         msg_string := '';         IF t_number <> 0 THEN  &          strwrite(msg_string,1,t_pos,'VCPMT ERROR ',t_number:1,':',DLE,CR); &         trace_string := msg_string + trace_string;        END;          max := strlen(trace_string);          WHILE (pos < max) AND NOT error DO       BEGIN         setstrlen(trace_buffer,strmax(trace_buffer)); 	        t_pos := 9; 	         trace_buffer[6] := chr(ord('0')+trace_min_seq div 10);          trace_buffer[7] := chr(ord('0')+trace_min_seq mod 10);          done := false;             WHILE (pos < max) AND NOT done DO           BEGIN                 IF (trace_string[pos] = DLE) THEN 	              BEGIN 	                IF pos < max THEN                   BEGIN                     pos := pos + 1;                       IF trace_string[pos] = CR THEN done := true;   "                    IF trace_string[pos] <> DLE THEN pos := pos + 1; "
                  END 
                 ELSE done := true;  	              END; 	                IF (NOT done) AND (pos <= max) THEN 	              BEGIN 	                trace_buffer[t_pos] := trace_string[pos];                 t_pos := t_pos + 1;                 pos := pos + 1;               END                END;              setstrlen(trace_buffer,t_pos - 1);             IF trace_level > 0 THEN           BEGIN              TRY;               writeln(trace_file,trace_buffer); 
            IF recover THEN 
	              BEGIN 	                 trace_close;                 trace_level := 0;                  error := true;  	              END; 	           END;             IF t_number <= 0 THEN           BEGIN             error_buffer := trace_buffer;              strdelete(error_buffer,1,8);              IF trace_min_seq <> 0 THEN                error_buffer := '    ' + error_buffer;              writeln(error_printer,error_buffer);            END;             trace_min_seq := (trace_min_seq + 1) mod 100;        END; { WHILE pos < max }         trace_string := '';      trace_post := NOT error; 
  END; { trace_post } 
    &PROCEDURE trace_control(level: shortint; file_name_buff: file_path_name_type; &                        length: shortint;                         set_err_print: boolean;                         err_print_lu: shortint;                          VAR error: boolean);      "  { opens, closes, and sets trace level, file_name_buff must contain "!    a valid file path name or ascii lu number if level changes from ! '    0 to > 0. Opens file error_printer to the err_print_lu for printing errors '%    even if trace level is 0. Must be entered first with set_err_print true %     to initialize error_printer and other global variables }     
  VAR  pos: shortint; 
       file_name: string[64];       BEGIN 	    error := false; 	 
    trace_str := ''; 
    trace_string := ''; 	    trace_pos := 1; 	    IF set_err_print THEN       BEGIN          file_name := '';         strwrite(file_name,1,pos,err_print_lu);          TRY;           rewrite(error_printer,file_name);         IF RECOVER THEN           BEGIN             rewrite(error_printer,'1');             IF trace_post(-15) THEN 	              BEGIN 	                 trace_close;                 trace_level := 0;  	              END; 	           END;        END;      IF level <= 0 THEN       BEGIN  
        trace_close; 
        trace_level := 0;       END      ELSE       BEGIN          IF trace_level > 0 THEN trace_close;         trace_level := level;          file_name := '';         strwrite(file_name,1,level,file_name_buff);          setstrlen(file_name,length);         file_name := strrtrim(strltrim(file_name));         IF strlen(file_name) <= 0 THEN error := true ELSE           BEGIN 
            error := false; 
             TRY;                append(trace_file,file_name,'SHARED'); 
            IF recover THEN 
	              BEGIN 	                trace_level := 0;                  IF trace_post(-12) THEN;                  error := true;  	              END; 	           END;        END;    END; { trace_control }      END.     