&$cds on $ $range off$ $DEBUG ON $ $HEAP_DISPOSE OFF$ $HEAP 1$ $HEAPPARMS OFF$ & $TRACE_BACK ON $ $tables on$  $AUTOPAGE$ $TITLE 'TRY-RECOVER Module '$  $SUBTITLE 'Error Recovery Routines'$  $PASCAL ',4,80 92078-16114 REV.5020 <900111.1547>'  {    NAME:   try_recover       SOURCE: 92078-18114       RELOC:  92078-16114      PGMR:   mh      !  **************************************************************** ! !  * (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1989.  ALL RIGHTS      * ! !  * RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       * ! !  * REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT * ! !  * THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.        * ! !  **************************************************************** ! }  {   try - recover error trapping routines     } 	MODULE try_recover; 	       { These routines handle error recovery for Pascal/1000 programs       $    When attempting an operation that may cause a program aborting error $"    execute TRY befor the operation and IF RECOVER THEN ... after the ""    operation. RECOVER is a boolean function that will return true if " #    error recovery is required and false if no error occured since the ##    last TRY. TRY and RECOVER are used in pairs, surrounding a block of ##    code to be attempted with error recovery. Each execution of RECOVER #    cancles the previous TRY.          To find out what type of error occured the global variable  $    recover_block is a pointer to an error record which contains all the $     information from the error. The fields of recover_block^ are:                 error_type: error_code_type;            error_number: try_rec_int;            error_line: try_rec_int;             error_file: er_file_name;            error_flen: try_rec_int;             error_count: try_rec_int; 
           try_on: boolean; 
 
           error: boolean; 
    $    The first five fields corrspond to the Pas.ErrorCatcher parameters as $ &    described in the Pascal/1000 manual in appendix B under Catching Errors, &      and may be used to determine the type of error that occured.   $    Error_count records the number of errors that have occured since the $ &    last try. ONLY THE FIRST ERROR IS PRESERVED IN RECOVER_BLOCK^. Try_on is & %    used internally to determine if TRY has been invoked. Error is true if %     an error has occured after the last TRY.      #    The error catch routine will abort the program if TRY has not been #$    invoked since the last RECOVER or since the beginning of the program. $     !    The procedure ESCAPE is passed a pointer to an error_block and ! '    will call the pascal error printer to display the error and then terminate ' !    the program. The user is incorraged to examine the contents of !%    recover_block^ and if the error is not one of the expected errors, pass %%    recover_block to ESCAPE to report the error.  ESCAPE with a NIL pointer %     will simply terminate the program with no error message.      }       EXPORT       TYPE try_rec_int = -32768..32767;         error_code_type = (run, ema, io, fmp, seg, warn);         er_file_name = PACKED ARRAY [1..150] OF char;                 error_block_ptr = ^error_block;         
       error_block = RECORD 
           error_type: error_code_type;            error_number: try_rec_int;            error_line: try_rec_int;             error_file: er_file_name;            error_flen: try_rec_int;             error_count: try_rec_int; 
           try_on: boolean; 
 
           error: boolean; 
         END;        VAR  recover_block: error_block_ptr;        PROCEDURE TRY;            FUNCTION RECOVER: boolean;       PROCEDURE ESCAPE(error_block: error_block_ptr);     IMPLEMENT        PROCEDURE error_print $ALIAS 'Pas.ErrorPrinter'$                         (err_type: error_code_type;                          err_numb: try_rec_int;                          err_line: try_rec_int;                           err_file: er_file_name;                           err_flen: try_rec_int);                           EXTERNAL;        PROCEDURE end_program $ALIAS 'EXEC'$ (code: try_rec_int;                                         prog: try_rec_int);                           EXTERNAL;            PROCEDURE TRY;         BEGIN       IF recover_block = NIL THEN new(recover_block);        WITH recover_block^ DO         BEGIN 
          error_count := 0; 
          try_on := true;           error := false;          END;      END; { TRY }        FUNCTION RECOVER: boolean;         BEGIN       RECOVER := false;        IF recover_block <> NIL THEN         BEGIN            WITH recover_block^ DO             BEGIN                IF try_on THEN 
                BEGIN 
                   IF error THEN recover := true;                    try_on := false;                  END; { IF try_on }             END { WITH recover_block^ }          END; { IF recover_block <> NIL } 
     END; { RECOVER } 
          PROCEDURE ESCAPE(error_block: error_block_ptr);         BEGIN        IF error_block <> NIL THEN         BEGIN            WITH error_block^ DO             BEGIN               error_print(error_type,error_number,error_line,                           error_file,error_flen);               end_program(6,0);              END;         END        ELSE          end_program(6,0)      END;         $RANGE OFF$        PROCEDURE error_catch $ALIAS 'Pas.ErrorCatcher'$                         (err_type: error_code_type;                          err_numb: try_rec_int;                          err_line: try_rec_int;                           err_file: er_file_name;                           err_flen: try_rec_int);         BEGIN        IF recover_block <> NIL THEN         BEGIN            WITH recover_block^ DO             BEGIN                IF try_on THEN 
                BEGIN 
                  IF error_count = 0 THEN                     BEGIN                       error_type := err_type;                       error_number := err_numb;                       error_line := err_line;                       error_file := err_file;                       error_flen := err_flen;                       error_count := 1;                        error := true;                     END                    ELSE error_count := error_count + 1; 	                END 	              ELSE { try not on } 
                BEGIN 
 &                  error_print(err_type,err_numb,err_line,err_file,err_flen); &                  end_program(6,0);  
                END; 
            END; { with }         END        ELSE { recover_block = NIL }         BEGIN  "          error_print(err_type,err_numb,err_line,err_file,err_flen); "
          end_program(6,0); 
         END;      END; { error_catch }      $RANGE ON$        END. 