 $PASCAL '24398-16066 REV.5020 <900302.0902>' !(*****************************************************************) !!(*                                                               *) !!(*  (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1986 _ 1986 ALL RIGHTS *) !!(*  RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       *) !!(*  REPRODUCED, OR TRANSLATED TO ANOTHER PROGRAMMING LANGUAGE    *) !!(*  WITHOUT THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD     *) !!(*  COMPANY.                                                     *) !!(*                                                               *) !!(*****************************************************************) !!(*                                                               *) !!(*      NAME:  EXER1                                             *) !!(*    SOURCE:  24398-18066                                       *) !!(*     RELOC:  24398-16066                                       *) !!(*      PGMR:  DAVE GROVES / DISC MEMORY DIVISION  JAN 1986      *) !!(*                                                               *) !!(*****************************************************************) !
(*  Revision History: 
         DATE         PROGRAMER                   DESCRIPTION #   --------    ---------------   -------------------------------------- #"   01/06/86    D. GROVES/DMD     Created EXER1 son process from EXER. " #                                 EXER was too large to accommodate new # !                                 routines for EAGLE and BFD Cache. !    "                                 Created separate source file for the "                                 type declarations.      "                                 Added EAGLE and 7933XP/7935XP Cache "                                  routines.          $   04/14/86    D. Groves/DMD     Removed the input/output specifier from $%                                 the program statement.  And added the file % "                                 identifier to the write statements. "    #                                 Moved ERROR_LOG and ZFLTLOG from EXER. #    %                                 Added RSP, ISP and print_addr  PROCEDUREs. %     #   02-25-87    L. Doner/DMD      Removed Input and Output from program #&                                 statement. Redirected I/O on a few writelns. &     $   02-27-87    L. Doner/DMD      Changed String functions to characters. $        03-03-87    L. Doner/DMD      Removed Main.      #   03-09-87    L. Doner/DMD      Modified ZHELP. Added Readcacheon and #                                  Readcacheoff.  See ZHELP.     "   03-24-87    L. Doner/DMD      Added Number of Write Cache Hits and "$                                 transfered Cachetablearea to Disp_cache- $ "                                 stat_tble. See Disp_cache_stat_tbl. "     #   04-03-87    L. Doner/DMD      Changed formatting on cache hit % 's. #                                  See Disp_cache_stat_tble.     "   06-12-87    L. Doner/DMD      Added variable to Log_header. Prints "                                  either 'Error' or 'Loop'.     #   06-17-87    L. Doner/DMD      Removed 795X from Amigo Clear command, # $                                 Added 795X to SDClear command in ZHELP. $    !   10-09-87    L. Doner/DMD      Fixed bug in ZRDTBLS. See ZRDTBLS. !    #   11-02-87    L. Doner/DMD      Fixed bug in Error_log. See Error_log. #    $   01-28-88    L. Doner/DMD      Moved Zcache_control from Exer to Exer1. $"                                 Also, Checkqstat, Doutil, Xutil, and "                                 Dash_write. Comp = nullcomp.      #   08-20-89    L. Doner/DMD      Moved Zservo code from Exer to Exer1. #     %   09-01-89    L. Doner/DSS      Reduced Zservo code. Moved Zlogcache from %                                 Exer to Exer1.     !   09-11-89    L. Doner/DSS      Moved Zdatalog from Exer to Exer1. !     #   10-03-89    L. Doner/DSS      Added C220X, C2202 to commands. Moved #"                                 Sparesecs from Exer. Created Rfeagle "$                                 and Cache_size. See individual commands. $ #                                 Renamed Prnt_fault_error to Hfr_bits. # %                                 Renamed Prt_error_info to Ert_run_errors. %    %    2-07-90    L. Doner/DSS      Added third parameter to locklu for RTE-6. % $                                 See sparesec, zhelp and ert_run_errors. $     %************************************************************************** %           LINK :  link exer1.lod     %**************************************************************************) %     $CDS OFF  $HEAPPARMS OFF,PARTIAL_EVAL OFF,RECURSIVE OFF$ $HEAP 0,IDSIZE 24,run_string 364,RANGE OFF$  	$HEAP_DISPOSE OFF$ 	     PROGRAM EXER1;     	$ include '[TYPE' $ 	    VAR    f,    crt            : text;    M794X,    M7907,    M791X,    M793X,    M9140,    M9144,    EAGLE,   M795XA,   M795XB,    C220X,    C2202, 
  M795X          : boolean; 
   I              : bytetype;   lu_num         : lu_num_type;   line_cnt,   lu,   da,    cc             : wordtype;   parms          : parm_type;    addrmode       : wordtype; 
  spareblock     : boolean; 

  tape           : boolean; 

  disc           : boolean; 

  controller     : boolean; 
  iobuf          : iobuftype;    buffer         : bufrtype;    comp           : comptype; 
  print_paddr    : boolean; 
   info           : packed array [0..10] of bytetype;    ISP,RSP, 
  ce_mode        : boolean; 
 
  outfile        : char64; 
   phy_sec        : wordtype;      FUNCTION GET_BUF $alias 'PAS.PARAMETERS'$ (pos : wordtype;  &             var buffer : bufrtype; length : wordtype) : wordtype; EXTERNAL; &     PROCEDURE GETCODE $ alias 'EXEC' $  $                  (e, lu : wordtype; b : char2; l : wordtype); EXTERNAL; $     PROCEDURE XUTIL (Var lu, da : wordtype; Var comp : comptype;                   Var iobuf : iobuftype); EXTERNAL;      PROCEDURE XLCRD (Var lu, da : wordtype; Var comp : comptype;                   Var iobuf : iobuftype); EXTERNAL;     "PROCEDURE GET_PARMS $alias 'PAS.NUMERICPARMS'$ (var parms:parm_type); "                    EXTERNAL;     PROCEDURE PRTN (var parms:parm_type); EXTERNAL;      FUNCTION IFBRK : wordtype; EXTERNAL;     PROCEDURE LOCKLU $ alias 'LURQ' $                  (option,luary,num : wordtype); EXTERNAL;          PROCEDURE SPACE $direct$ (i : bytetype); 	  var j : bytetype; 	      begin      for j := i downto 1 do write(f,' ');    end;          FUNCTION UPCASE (c : char) : char; begin   if c in ['a'..'z'] then      upcase:=chr(ord(c)-ord(' '))    else      upcase:=c;  end;          FUNCTION MORE_LINES : boolean; var    c:char2; begin   if (line_cnt > 20) and (outfile[1] = '1') and  {consol}       (buffer[299] = ord('1')) then     begin 	      writeln(crt); 	 '      prompt(crt,'More...(''s'' to stop listing)',chr(27),'A',chr(13));{go up} '      getcode(1,octal('101'),c,-1);  #      prompt(crt,chr(27),'J',chr(13));                  {clear screen} # 	      line_cnt:=0; 	       more_lines:=upcase(c[0]) <> 'S';     end    else 
    more_lines:=true; 
 end;          (**************************************)  (* write byte in two digit hex format *)  (**************************************)  PROCEDURE WRITEHEX $direct$ (hexnum : bytetype);   begin     write(f,' ',HEXCHAR[hexnum div 16],HEXCHAR[hexnum mod 16]);   end;  (* of writehex *)         PROCEDURE INIT_COMP $direct$; "(*******************************************************************) " (*  9-28-89   L. Doner  : Creation. Initializes the complementary  (*                        commands. "(*******************************************************************) "    BEGIN 	  COMP := nullcomp; 	 
  COMP.unitnum := 0; 
   COMP.volumenum := 0;   COMP.address.cylinder := 0;   COMP.address.head := 0; 
  COMP.address.sector := 0; 
 END;           PROCEDURE PRNTADDR $direct$(addr : addrtype; rf_flag : boolean);   %(************************************************************************) % %(*  9-25-89  L. Doner  : Added if rf_flag for physical_sector value.    *) % %(************************************************************************) %          begin      if addrmode = 0 then        writeln(f,'Block Address = ',addr.block:1)      else       begin 	        writeln(f); 	        write(f,'Cylinder = ',addr.cylinder:1);         space(5);         write(f,'Head = ',addr.head:1);          if (spareblock) and (M7907) then           begin             writeln(f);           end          else           begin 
            space(5); 
            write(f,'Sector = ');              if rf_flag and (C220X or EAGLE) then                writeln(f,phy_sec:1)              else               writeln(f,addr.sector:1);            end;        end;    end;  (* prntaddr *)         PROCEDURE PRINT_ADDR $direct$ (index : bytetype);   begin      {Cylinder}      write(f,(((info[0+index] mod 128) * 256) + info[1+index]):4);      space(4);      {Head}     write(f,info[2+index]:2);     space(3);      {Sector}     write(f,info[3+index]:3);    end;   (* of print_addr *)         PROCEDURE WRT_BINARY $direct$ (data_byte : bytetype);   var      K       : erraptype;     J       : wordtype;       begin 
    k.allbits := data_byte; 
     for J := 0 to 7 do           if k.b[J] then write(f,'1')        else write(f,'0'); 
  end;  (* of wrt_binary *) 
        PROCEDURE DISP_CACHE_STAT_TBL $direct$;  %{************************************************************************} % ${* 03-24-87  L. Doner  : Passed cachetablearea to this procedure instead $ {*                       of extablearea. ${*                     : Added new parameter, NCHWRIHITS, number of cache $ {*                       write hits and cache write hit %. {* 03-25-87  L. Doner  : Fixed division by zero bugs.  {* 03-26-87  L. Doner  : Changed result to doubletype. #{* 04-03-87  L. Doner  : Changed formatting on cache hits and result to #{*                       real_result.  $(* 10-05-89  L. Doner  : Added both_page. +32768 was -32768 in 2's comp. $ "(*                       Needed to get upper and lower byte instead. " %{************************************************************************} %  VAR     real_result : real;      x, 
    LU          : wordtype; 
 
    both_page   : integer; 
      begin      LU := parms[3];   (* get passed value of LU *)     "    for x := 0 to 25 do               (* Retreive data from buffer *) "      iobuf.cachetablearea.cachebyte[x] := buffer[x];          with IOBUF.CACHETABLEAREA do       begin 	        writeln(f); 	         writeln(f,'Cache Statistic Table Info');          writeln(f,'--------------------------'); 	        writeln(f); 	        write(f,'Read cache ');         case CACHE_READ_STATUS of           0:  write(f,'enabled');            1:  write(f,'disabled by host');           2:  write(f,'not installed');           3:  write(f,'disabled because of RAM error');          end;          writeln(f,' on LU ',LU:1);              write(f,'Write cache ');          case CACHE_write_STATUS of            0: write(f,'enabled');           1: write(f,'disabled by host');            2: write(f,'not installed');            3: write(f,'disabled because of RAM error');           4: write(f,'unknown status');            5: write(f,'not installed'); 
        end;  (* of case *) 
         writeln(f,' on LU ',LU:1);     	        writeln(f); 	        if (upper_page <> 0) then           begin             both_page := (upper_page * 256) + lower_page;              writeln (f,'Cache page size (bytes) = ',both_page:1);            end          else             writeln (f,'Cache page size (bytes) = ',lower_page:1);          writeln (f,'number of pages = ', NUMPAGES:1); 	        writeln(f); 	        writeln (f,'number of reads = ', NUMREADS:1);          writeln (f,'number of read hits = ', NUMRDHITS:1); 	        writeln(f); 	        writeln (f,'number of writes = ', NUMwriteS:1);          writeln (f,'number of write hits = ', NUMWRIHITS:1); 	        writeln(f); 	         writeln (f,'number of write cache hits = ',NCHWRIHITS:1);  	        writeln(f); 	        if (NUMREADS<>0) then           real_result := (NUMRDHITS * 100) div NUMREADS          else 
          real_result := 0; 
         writeln (f,'read hit %  = ', real_result:1:2);          if (NUMwriteS<>0) then           real_result := (NUMWRIHITS * 100) div NUMwriteS          else 
          real_result := 0; 
         writeln (f,'write hit % = ', real_result:1:2);          if (NUMwriteS<>0) then           real_result := (NCHWRIHITS * 100) div NUMwriteS          else 
          real_result := 0; 
         writeln (f,'write cache hit % = ', real_result:1:2);         if ((NUMREADS + NUMwriteS)<>0) then  "          real_result := (NUMREADS * 100) div (NUMREADS + NUMwriteS) "         else 
          real_result := 0; 
         writeln (f,'read %      = ', real_result:1:2); 
      end; (* of table 7 *) 
   end;  (* of disp_cache_stat_tbl *)         
PROCEDURE ZRDTBLS $direct$; 
 $(**********************************************************************) $ "(* 10-09-87  L. Doner   :  Found a bug in the Runout Table. The loop "#(*                         counted from 0 to 12 instead of 1 to 13. The #!(*                         first item is always 13. ( # of runouts) !"(*  9-27-89  L. Doner   :  Don't print # of secondary spares if Eagle "(*                         or Blitz, always 0 for them.  $(**********************************************************************) $  VAR     I        :wordtype;     J        :wordtype;     K        :wordtype;     index    :bytetype;     count    :wordtype;     tablenum :wordtype;     maxhead  :wordtype;      TBI      :array[0..168] of wordtype;       begin         (*********************************************)     (*  Get the passed data into the good buffer *)     (*********************************************)      for I := 0 to 298 do       iobuf.extablerarea.tbl[I] := buffer[I];         (*********************************)     (* put parms in proper variables *)     (*********************************)     tablenum := parms[4];     maxhead  := parms[5];      
    case tablenum of 
       7:  disp_cache_stat_tbl;            1:  with IOBUF.EXTABLERAREA do             BEGIN             writeln(f,'SPARE TRACK TABLE');             writeln(f);             J:=0;              FOR I:=0 TO MAXHEAD DO 	              BEGIN 	 "              writeln(f,'Head number =',(TBL[J]):3,'             '); "                  if NOT C220X and NOT EAGLE then &              writeln(f,'# of secondary spares =',(TBL[J+1]*256+TBL[J+2]):3); &     #              writeln(f,'# of tracks used =',(TBL[J+3]):3,'        '); #"              writeln(f,'# of logical tracks spared =',(TBL[J+4]):3); "               if (TBL[J+4] > 0) THEN 
                BEGIN 

                writeln(f); 
 "                            { Scaler = which spare track from pool } "                 writeln(f,' CYL      TYPE      SCALAR'); &                writeln(f,'=====   =========   ======');             (*2525*) &                for K := 1 to TBL[J+4] do                    begin  (* write each line *)                     index := K*3+J+2; #                    write(f,((TBL[index] MOD 128)*256+TBL[index+1]):4); #                        space(4);                     if ((M7907) and (TBL[index] >= 128)) then                       write (f,'MAINT    ')  $                    else               { 128 = MSB set in scaler value } $                      if TBL[index+2] >= 128 then                          write(f,'PRIMARY  ')  
                      else 
                        write(f,'SECONDARY');                         space(5);                     writeln(f,((TBL[index+2]) mod 128):3)                    end;  {for K} (* of write each line *)                end;  {if TBL}                J := J+5+TBL[J+4]*3; %              writeln(f);                                          (*2525*) %            end;  {for I}           end;   {with}            2:  with IOBUF.EXTABLERAREA do begin              for I := 0 to 168 do                if TBL[I]>127 then                  TBI[I] := TBL[I] - 256  	              else 	                TBI[I] := TBL[I];                  for I := 0 TO 1 do 	              begin 	
                writeln(f); 
                if I = 0 then                   writeln(f,'Head Alignment Offset table:')  
                else 
                  writeln(f,'Circumferential Skew table:');  "                writeln  (f,'        band  delta band  delta band'); " "                writeln  (f,'  Head    0    0-1    1    1-2    2 '); " "                writeln  (f,'  ====   ===   ===   ===   ===   ==='); "                 for J := 0 to MAXHEAD do                   begin                      if I = 0 then K := 0 else K := 78;                      write(f,'  ',J:2);                     write(f,'    ',TBI[J*6+K]:3);                      write(f,'   ',TBI[J*6+K+1]:3);                      write(f,'   ',TBI[J*6+K+2]:3);                      write(f,'   ',TBI[J*6+K+3]:3);                      write(f,'   ',TBI[J*6+K+4]:3);                     writeln(f);                   end;  {for J}                end;   {for I} $            writeln(f);                                          (*2525*) $             writeln(f,'Current Cylinder Offset table:');             writeln(f,'  Head   Offset');             writeln(f,'  ====   ======'); &            FOR I:=0 TO MAXHEAD DO writeln(f,'   ',I:2,'     ',TBI[I+156]:3); &           end;  {with}            3:  with IOBUF.EXTABLERAREA do             begin               writeln(f);                writeln(f,'Current Configuration Table:');  $              writeln(f,'Transfer length =',TBL[0]*16777216+TBL[1]*65536 $               +TBL[2]*256+TBL[3]);               writeln(f,'Burst length =',TBL[4]);                writeln(f,'Retry time =',TBL[5]*256+TBL[6]);               write(f,'Status mask =');               FOR I:=7 TO 14 DO writeHEX(TBL[I]);               writeln(f);                writeln(f,'RPS Window =',TBL[15]);               writeln(f,'RPS Advance =',TBL[16]);               write(f,'Set release S bit ='); #              if TBL[17]<>0 then writeln(f,'ON') ELSE writeln(f,'OFF'); #              write(f,'Set release T bit ='); #              if TBL[18]<>0 then writeln(f,'ON') ELSE writeln(f,'OFF'); #              write(f,'Option flag =');                writeHEX(TBL[19]);               writeln(f);                write(f,'Burst with EOI ='); #              if TBL[20]<>0 then writeln(f,'ON') ELSE writeln(f,'OFF'); #               write(f,'Return addressing mode ='); $              if TBL[21]<>0 then write(f,'SINGLE') ELSE write(f,'THREE'); $               writeln(f,' vector mode');              end;  (* of table 3 *)       4,5:  begin               writeln(f,'Table not implemented');              end;        6:  with IOBUF.EXTABLERAREA do             begin (* table 6 *)               writeln(f);               writeln(f,'Runout Table:');               writeln(f,'  Head   Offset');               writeln(f,'  ====   ======');               FOR I := 1 to TBL[0] do 
                begin 
                  write(f,'   ',I-1:2);                    if TBL[I] < 128 then                     writeln(f,'     ',TBL[I]:3)                    else                      writeln(f,'     ',(TBL[I] - 256):3);                 end;  {for I}              end;  (* of table 6 *) 
        end;  (* of case *) 
 end;  (* of zrdtbls *)          
PROCEDURE ZSENSE $direct$; 
  var      x :bytetype;   begin      for x := 0 to 6 do       iobuf.extablerarea.tbl[x] := buffer[x];          with iobuf.exsencerarea do       begin 	        writeln(f); 	        writeln  %          (f,'Exhaust air temperature =',SENSOR[3]:3,' (+/-3) degrees C'); %        writeln  &          (f,'Actuator coil temperature =',SENSOR[4]:3,' (+/-3) degrees C'); &"        write(f,'Hardware fault register = '); wrt_binary(sensor[5]); "	        writeln(f); 	         write(f,'R/W fault register = ');  wrt_binary(sensor[6]);  	        writeln(f); 	      end;  (* of with *)   end;  (* of ZSENSE *)          PROCEDURE prntstatus $direct$; #(*********************************************************************) #"(*  1-27-88  L. Doner  :  Added who_from to determine if this routine "  (*                        was called from the father or the son.   (*  9-24-89  L. Doner  :  Added C220X. #(*********************************************************************) #  var      igntgt    : boolean;     i         : wordtype;     j         : wordtype;  
    bits      : erraptype; 

    statusmsg : statustype; 
    who_from  : bytetype;      rf_flag   : boolean;       begin     (*****************************************)     (* reset environment from father program *)     (*****************************************)     addrmode := parms[3];          if parms[4] = 0 then        spareblock := true      else  
      spareblock := false; 
         disc       := false;      tape       := false;      controller := false;  
    case parms[5] of 
       0: disc := true;        1: tape := true;        2: controller := true;       otherwise 	        (* null *); 	     end;         rf_flag := false;       {not rfsector calling prntaddr} 
    who_from := buffer[20]; 

    if (who_from = 99) then 
      for I := 0 to 19 do          statusmsg.unformatted_status.status[I] := buffer[I];         (*************************)     (* start decoding status *)     (*************************)      with statusmsg.unformatted_status do       begin 	        writeln(f); 	         writeln(f,'Status bytes returned (hex):');         for I := 0 to 9 do writehex(status[I]); 	        writeln(f); 	        for I := 10 to 19 do writehex(status[I]); 	        writeln(f); 	       end;          with statusmsg.formatted_status do       with errorstatus do begin       writeln(f);     
      write(f,'Selected '); 
      if TAPE       then write(f,'Tape')       else       if DISC       then write(f,'Disc')       else       if CONTROLLER then write(f,'Controller') else        write(f,'Unknown device');           writeln(f,' unit = ',UNIT:1); &      if UNITS <> 255 then writeln(f,'Unit ',UNITS:1,' with pending status'); &          (*********************************)       (*BEGINING OF STATUS BIT DECODING*)       (*********************************)  
      IGNTGT:=FALSE; 
           if statuswords[0] > 0 then         begin 
          writeln(f); 
          writeln(f,'**REJECT ERRORS**');            if statusbits[2] then writeln(f,'Channel parity');            if statusbits[5] then writeln(f,'Illegal opcode');           if statusbits[6] then writeln(f,'Module addressing');            if statusbits[7] then writeln(f,'Address bounds');            if statusbits[8] then writeln(f,'Parameter bounds');           if statusbits[9] then writeln(f,'Illegal parameter');           if statusbits[10] then writeln(f,'Message sequence');           if statusbits[12] then writeln(f,'Message length');          end;            if statuswords[1] > 0 then          begin (* bits 16 - 31 *) 
          writeln(f); 
           writeln(f,'**FAULT ERRORS**');            if statusbits[17] then             begin  (* statusbit 17 *)               writeln(f,'Cross unit err during COPY DATA');               writeln(f,'Units which had errs are:');                for I:=0 to 5 do if UNITC[I]<>255 then                  writeln(f,'UNIT = ',UNITC[I]:1);               IGNTGT := TRUE;             end;  (* of statusbit 17 *)           if statusbits[19] then writeln(f,'Controller fault');           if statusbits[22] then writeln(f,'Unit fault');            if statusbits[24] then             begin  (* statusbit 24 *)                writeln(f,'Hardware failed diagnostic');                if not IGNTGT then                  begin (* print errors *)                   writeln(f);                    if C220X or EAGLE or M793X or M791X then                      begin  (* 791X/793X *)                        if DIAGD.PARTA<>0 THEN #                        writeln(f,'PART # = ',DIAGD.PARTA:1,' failed'); #                       if DIAGD.PARTB<>0 THEN #                        writeln(f,'PART # = ',DIAGD.PARTB:1,' failed'); #                       if DIAGD.TESTA<>0 THEN #                        writeln(f,'TERR = ',DIAGD.TESTA:1,' returned'); #                       if DIAGD.TESTB<>0 THEN #                        writeln(f,'TERR = ',DIAGD.TESTB:1,' returned'); #                     end;  (* of 791X/793X *)                    if M794X or M795X then                     begin  (* 794X *)                        if DIAGD.PARTA <> 0 then  "                        writeln(f,'FRA # ',DIAGD.PARTA:1,' failed'); "                       if DIAGD.PARTB <> 0 then  "                        writeln(f,'FRA # ',DIAGD.PARTB:1,' failed'); "                      write(f,'Failed subtest = ');                        writehex(DIAGD.TESTA);                       writeln(f);                      end;   (* of 794X *)                   igntgt := true;                 end;  (* of print errors *)              end;  (* bit 24 *)      "          if statusbits[26] or statusbits[27] or statusbits[28] then "            begin               write(f,'Release required for ');                if statusbits[26] then write(f,'OPERATOR REQUEST');   !              if statusbits[27] then write(f,'DIAGNOSTIC RESULT'); !"              if statusbits[28] then write(f,'INTERNAL MAINTENANCE'); "              writeln(f,' before command can be executed');              end;            if statusbits[30] then              writeln(f,'Power fail');            if statusbits[31] then              writeln(f,'Retransmit');          end;  (* statusbits 16-31 *)            if statuswords[2] > 0 then         begin  (* bits 32-47 *) 
          writeln(f); 
          writeln(f,'**ACCESS ERRORS**'); $          if statusbits[32] then writeln(f,'Illegal parallel operation'); $ !          if statusbits[33] then writeln(f,'Uninitialized media'); !#          if statusbits[34] then writeln(f,'No more spares available'); #           if statusbits[35] then writeln(f,'Not ready');            if statusbits[36] then writeln(f,'write protect');            if statusbits[37] then writeln(f,'No data found');  %          if statusbits[40] then writeln(f,'Unrecoverable data overflow'); %           if statusbits[41] then              if not igntgt then 	              begin 	                 writeln(f,'Unrecoverable data');                  writeln(f,'  Address follows:');                  prntaddr(addrn,rf_flag);                 IGNTGT:=TRUE;  	              end; 	           if statusbits[43] then writeln(f,'End of file');            if statusbits[44] then writeln(f,'End of volume');         end;  (* of bits 32-47 *)            if statuswords[3] > 0 then         begin  (* bits 48-63 *) 
          writeln(f); 
           writeln(f,'**INFORMATION ERRORS**');            if statusbits[48] then              writeln(f,'Operator requested release');            if statusbits[49] THEN !            writeln(f,'Release requested for a diagnostic result'); !           if statusbits[50] then  "            writeln(f,'Release requested for internal maintenance'); "           if statusbits[51] then $            writeln(f,'Possible media wear, one or fewer spares remain'); $ "          if statusbits[48] or statusbits[49] or statusbits[50] then "             if NOT IGNTGT then 	              begin 	 "                writeln(f,'Unit requesting release is ',UNITC[0]:1); "                IGNTGT:=TRUE;  	              end; 	           if statusbits[52] then writeln(f,'Latency induced');            if statusbits[55] THEN             writeln(f,'Automatic sparing invoked');  $          if statusbits[57] then writeln(f,'Recoverable data overflow'); $           if statusbits[58] then              if not igntgt then 	              begin 	                writeln(f,'Marginal data error');                  writeln(f,'  Address follows:');                  prntaddr(addrn,rf_flag);                 IGNTGT:=TRUE;  	              end; 	           if statusbits[59] then              if not igntgt then 	              begin 	                 writeln(f,'Recoverable data error');                  writeln(f,'  Address follows:');                  prntaddr(addrn,rf_flag);                 IGNTGT:=TRUE;  	              end; 	$          if statusbits[61] then writeln(f,'Maintenance track overflow'); $        end;  (* of bits 48-63 *)           if (NOT IGNTGT) and (NOT SPAREBLOCK) then         begin 
          writeln(f); 
           writeln(f,'New target address is:');            prntaddr(addrn,rf_flag);          end;            if not SPAREBLOCK then         begin  (* not SPAREBLOCK *)            if C220X or EAGLE or M793X or M791X then             begin 
              I := 0; 
              writeln(f);  
              repeat 
                if DERRORN[I] <> 0 then                   begin                       writeln(f,'DERR ',DERRORN[I]:1,' returned');                     end;                 if (DERRORN[I] = 64) or (DERRORN[I] = 203) then                   begin                     write(f,'Hardware fault reg = ');                     I := I + 1;                     wrt_binary(DERRORN[I]);                     writeln(f,' binary');                     writeln(f);                    end;  {If Derrorn} 
                I := I + 1; 
              until I = 4;  (* end of repeat *)              end;  (* of 791X/793X *)            if M794X or M795X then             begin  (* 794X *)                 if derrorn[0] <> 0 then                   begin                     writeln(f);  !                   write(f,'Fault code =');  writehex(derrorn[0]); !                    writeln(f);                      write(f,'Status = '); wrt_binary(derrorn[1]);                      writeln(f); 
                 end; 
            end;  (* of 794X *)           if M7907 then              begin (* 7907 *)               if derrorn[1] <> 0 then 
                begin 
                  writeln(f);                   write(f,'P7 = ');                   wrt_binary(derrorn[0]);                   writeln(f);                   write(f,'P8 = ');                   writehex(derrorn[1]);                   writeln(f);  
                end; 
            end;  (* of 7907 *)         end; (* not SPAREBLOCK *)      end;   (* of with *)   end;  (* of print status *)              PROCEDURE fault_header $direct$;   begin     writeln  (f,'       Current             Target');     write  (f,'   Cyl  Head  Sect     Cyl  Head  Sect    Fault Code   ');         if ISP then       begin 
        if M7907 then 
           writeln(f,'<  P7  > <  P8  >')          else            writeln(f,'Subtest   Status');       end      else       begin         write(f,'  HFR');          if C220X or EAGLE then            write(f,'    Activity'); 	        writeln(f); 	       end;         write  #(f,'  =================   =================  ============  ========'); #    if C220X or EAGLE or ISP then 
      write(f,' ========'); 
    writeln(f);   end;  (* of fault_header *)          PROCEDURE LOG_HEADER $direct$;  ${**********************************************************************} $ ${* 6-12-87  L. Doner : Added count_type to print either Error or Loop *} $ $(* 9-18-89  L. Doner : Changed above 'Error' to 'Occur'.              *) $ ${**********************************************************************} $var    count_type : bytetype;       begin      count_type := buffer[1];      case count_type of        77:                {Read ERT or Run logs, print 'Occur'}           writeln (f,'       Logical      Error  Occur          ');         99:                {Print option of WTR ERT, print 'Loop'}            writeln (f,'       Logical      Error  Loop           ');       otherwise ;      end;     writeln (f,'   Cyl  Head  Sect  Type   Count   Error  ');     writeln (f,'  ================  =====  =====  ========'); 
  end;  (* of log_header *) 
         PROCEDURE Hfr_bits $direct$; #(*********************************************************************) ##(*  9-26-89  L. Doner  :  Added C220X.                               *) ##(*********************************************************************) #      begin      if C220X or RSP then        begin  (* C220X/791X/793X/EAGLE *) 	        writeln(f); 	        writeln(f,'HFR values:'); 
        if M791X then 
          begin    (* 791X *)             writeln(f,' XXXXXXX0 Destructive write fault');             writeln(f,' XXXXXX1X AGC fault');              writeln(f,' XXXXX0XX Power fail warning');              writeln(f,' XXXX1XXX On track');             writeln(f,' XXX0XXXX Offtrack during write');              writeln(f,' XX1XXXXX Spindle speed OK');              writeln(f,' X1XXXXXX 7912 drive indicator');              writeln(f,' 1XXXXXXX Speed indicator pulses');             writeln(f);  #            writeln(f,'If DERR 64 then an HFR value of 1 in any bit'); # $            writeln(f,'indicates that bit caused the error regardless'); $            writeln(f,'of the sense of the bit'); 
          end;   (* 791X *) 
    
        if M793X then 
 
          begin (* 793X *) 
            writeln(f,' XXXXXXX1 spindle speed is down');             writeln(f,' XXXXXX1X heads are off track');              writeln(f,' XXXX1XXX track follower PLL error');              writeln(f,' XXX1XXXX top door is open');              writeln(f,' XX1XXXXX emergency retract is set');             writeln(f,' X1XXXXXX power failure');             writeln(f,' 1XXXXXXX r/w fault');  
          end;  (* 793X *) 
    
        if EAGLE then 
 
          begin  { eagle } 
            writeln(f,' XXXXXXX1 spindle speed is down');              writeln(f,' XXXXXX1X servo timing error');             writeln(f,' XXXXX1XX heads off track');             writeln(f,' XXXX1XXX AGC error');             writeln(f,' XXX1XXXX sector timing error');              writeln(f,' XX1XXXXX data overrun');              writeln(f,' X1XXXXXX unused');              writeln(f,' 1XXXXXXX unused');  
          end;   { eagle } 
    
        if C220X then 
 
          begin  { C220X } 
 '            writeln(f,' XXXXXXX1 Spindle not up to speed              (ESDI)', ' );  '            writeln(f,' XXXXXX1X Power Fail or Data Path Fault        (CTRL)', ' );  '            writeln(f,' XXXXX1XX Seek Fault or Lost Spindle Lock      (ESDI)', ' );  '            writeln(f,' XXXX1XXX Write Protected                      (ESDI)', ' );  '            writeln(f,' XXX1XXXX Write Fault                          (ESDI)', ' );  '            writeln(f,' XX1XXXXX Interface, Command or Frame error    (ESDI)', ' );  '            writeln(f,' X1XXXXXX Port fault, Command or Frame error   (CTRL)', ' );  '            writeln(f,' 1XXXXXXX Data Clock Fault                     (CTRL)', ' );           end;  { C220X }              if C220X or EAGLE then           begin             writeln(f);             write !            (f,'An (E) after the fault code indicates an Event, '); !	            writeln 	            (f,'and a (F) indicates a Fault.');                 writeln(f);              writeln(f,'Activity indicator values:'); 	            writeln 	
(f,'  0 = no seeks'); 
	            writeln 		(f,'  1 = 1 seek'); 		            writeln 	 
(f,'  2 = 2 seeks'); 
	            writeln 	 
(f,'  3 = 3 seeks'); 
	            writeln 	 
(f,'  4 = 4 seeks'); 
	            writeln 	 (f,'  5 = 5 - 7 seeks                     (1 sec)'); 	            writeln 	(f,'  6 = 8 - 200 seeks                   (1-30 sec)'); 	            writeln 	(f,'  7 = 201 - 2,000 seeks               (30 sec - 5 min)'); 	            writeln 	(f,'  8 = 2,001 - 12,000 seeks            (5 - 30 min)'); 	            writeln 	 (f,'  9 = 12,001 - 25,000 seeks           (30-60 min)'); 	            writeln 	 (f,' 10 = 25,001 - 150,000 seeks          (1-6 hrs)'); 	            writeln 	(f,' 11 = 150,001 - 600,000 seeks         (6-24 hrs)'); 	            writeln 	(f,' 12 = 600,001 - 4,000,000 seeks       (1-7 days)'); 	            writeln 	 (f,' 13 = 4,000,001 - 16,000,000 seeks    (1-4 weeks)'); 	            writeln 	(f,' 14 = 16,000,001 - 100,000,000 seeks  (1-6 months)'); 	            writeln 	 (f,' 15 = > 100,000,000 seeks             ( > 6 months)');            end;  { C220X or EAGLE }        end;   end;  (* of hfr_bits *)         PROCEDURE ERT_RUN_ERRORS $direct$ (logtype:wordtype); #{*********************************************************************} ##{*  9-1-87  L. Doner  : Mod to 795XA/795XB bit 0 in error byte.       } ##{*  9-26-89 L. Doner  : Added C220X.                                  } ##{*  2-07-90 L. Doner  : Moved UNR, add data underrun undetected for   } ##{*                      eagles.                                       } ##{*********************************************************************} #      begin     writeln(f);     writeln(f,'TYPE:');          if RSP or C220X then       begin         writeln(f,'  COR  =  ECC correctable error');         writeln(f,'  UNC  =  ECC uncorrectable error');         writeln(f,'  UNR  =  Unrecoverable error');          if M793X or M791X then            begin  {793X and 791X}             writeln(f,'  CRC  =  Only CRC detected error');             writeln(f,'  F/S  =  Formatter/separator error');            end;   {793X and 791X}        end;  (* RSP or C220X *)         if ISP then       begin         writeln(f,'  REC  =  Recoverable error');         writeln(f,'  M-RE =  Marginal data/retries');        end;  
    if M7907 or M795X then 
       writeln(f,'  UNR  =  Unrecoverable data error');  
    if M794X or M795X then 
      writeln(f,'  M-EC =  Marginal data/ECC corrected');  	    if M795XA then 	       writeln(f,'  FIFO =  FIFO data lost or track offset');  	    if M795XB then 	       writeln(f,'  T-OF =  Track offset invoked');     if M794X then        writeln(f,'  UNC  =  Uncorrectable data error');     writeln(f);     writeln(f,'ERROR BYTE:');      
    if M791X or M793X then 
      begin  #        writeln(f,'XXXXXX00  ECC found correctable error (ERT only)'); #        writeln(f,'XXXXXX01  ECC found uncorrectable error');         writeln(f,'XXXXXX10  ECC did not detect an error');         writeln(f,'XXXXX1XX  Error is in header not body');          writeln(f,'XXXX1XXX  CRC did not detect error');          writeln(f,'XXX1XXXX  First retry did not get data');           writeln(f,'XX1XXXXX  Extra offset was used (ERT only)');          writeln(f,'X1XXXXXX  Formatter/Separator error'); !        writeln(f,'1XXXXXXX  Unrecoverable error (run-time only)'); !      end;  (* of 793X/791X errors *)      
    if C220X or EAGLE then 
      begin         writeln(f,'XXXXXXX0 ECC detected correctable error');         writeln(f,'XXXXXXX1 ECC detected uncorrectable error');          if logtype <> 198 then    {not ert, run}           begin             if eagle then                writeln(f,'XXXXXX1X Data underrun detected')             else  {c220x}               writeln(f,'XXXXXX1X Not used');           end          else                           {ert}            writeln(f,'XXXXXX10 No error detected');         writeln(f,'XXXXX1XX Error in sector header');         writeln(f,'XXXX1XXX Error in sector body');          if logtype <> 198 then           begin (* run log *)  "            writeln(f,'XXX1XXXX Data not recovered on first retry'); "            writeln(f,'XX1XXXXX CRC byte(s) in error');             writeln(f,'X1XXXXXX ECC byte(s) in error');              writeln(f,'1XXXXXXX Unrecoverable error');           end  (* of run log *)          else            begin  (* ERT log *)             writeln(f,'XXX1XXXX Error in CRC byte(s)');             if C220X then                writeln(f,'XX1XXXXX Framing byte error')              else                                       {EAGLE}               writeln(f,'XX1XXXXX Parity bit enabled');             if EAGLE then               writeln(f,'X1XXXXXX Data underrun/overrun fault')              else               writeln(f,'X0XXXXXX Always 0');              writeln(f,'1XXXXXXX Error in ECC parity bytes');           end;   (* of ERT log *)       end;  { C220X and EAGLE }         if ISP then       begin          if M795XA then            writeln(f,'XXXXXXX1  FIFO or track offset');          if M795XB then            writeln(f,'XXXXXXX1  Track offset invoked');          writeln(f,  'XXXXXX1X  REC ');          writeln(f,  'XXXXX1XX  M-RE');          if M794X or M795X then            writeln(f,'XXXX1XXX  M-EC');          if M7907 or M795X then            writeln(f,'XXX1XXXX  UNR')          else           writeln(f,'XXX1XXXX  UNC');         writeln(f,  'XX1XXXXX  Error in data');         writeln(f,  'X1XXXXXX  Error in header');          write  (f,  '1XXXXXXX  '); 
        if M7907 then 
          writeln(f,'Other error'); 
        if M794X then 
           writeln(f,'Address mark error'); 
        if M795X then 
           writeln(f,'No data sync'); 
        if M794X then 
           writeln(f,'00000000  UNC error during write');        end;   end;  (* of ert_run_errors *)             PROCEDURE ZHELP $direct$; %(*************************************************************************) %%(* 3-9-1987   L. Doner  :    Added Readcacheon,  Readcacheoff            *) %%(*                  Also changed cacheon,cacheoff to EAGLE only commands.*) %%(* 6-17-87    L. Doner  : Removed 795X from Amclear, added 795X to SDClear) %%(* 9-24-89    L. Doner  : Added C220X and C2202 (cache version).         *) %%(* 2-07-90    L. Doner  : Changed Diag to non-ce mode.                   *) %%(*************************************************************************) %    var 
  keep_going:boolean; 
    
PROCEDURE writit(s:char72); 
begin  
  if keep_going then 
    begin       keep_going:=more_lines;        if keep_going then 
        writeln(f,s); 
      line_cnt:=succ(line_cnt);     end;  {if keep_going} end;   {writit}       begin   {zhelp} 
    keep_going:=true; 
     line_cnt:=0;     writit('');      if (M7907 or M794X) and ce_mode then       writit('AMCLEAR        - amigo clear selected device');     if C2202 or EAGLE or M793X then         writit('CACHE LOG      - display cache error log');  
    if C2202 or EAGLE then 
      begin #        writit('CACHEON        - enables disc cache (read and write)'); # $        writit('CACHEOFF       - disables disc cache (read and write)'); $       end;     if C2202 then        writit('CACHE SIZE     - set the read cache page size');     if C2202 or EAGLE or M793X then         writit('CACHE STATS    - displays cache statistic table');   #    writit('CHANGE LU      - change the lu that you are working on '); #     writit('CANCEL         - cancel transaction');     writit('CICLEAR        - channel independent clear'); 	    if ce_mode then 	       writit('CLEAR LOGS     - erase logs');      writit('DESCRIBE       - describe selected unit');      writit('DIAG           - perform internal diagnostics');      writit('ERT LOG        - output error rate test log');     writit('EXIT           - exit program or command');      writit('FAULT LOG      - output fault log');     writit('HELP           - output help information'); 	    if ce_mode then 	       writit('INIT MEDIA     - initialize media');     writit('INPUT          - change input file or lu');      writit('OUTPUT         - change output file or lu');      writit('PRESET         - update device logs');     if C2202 or EAGLE or M793X then       begin         writit('READCACHEOFF   - disables read cache');          writit('READCACHEON    - enables read cache');        end;      writit('REQSTAT        - request status');     if C2202 or EAGLE or M793X then        writit('RESET STATS    - clear cache statistics table');     if C220X or RSP or M795X then        writit('REV            - output firmware revision');      if C220X or RSP then          writit('RF SECTOR      - read full sector');      writit('RO ERT         - perform read-only error rate test');      writit('RUN LOG        - output run log data');     if (C220X or RSP or M795X) and ce_mode then       writit('SDCLEAR        - clear selected device');     if M793X then        writit('SENSE          - output sensor data');     if M794X or M7907 or M795X then        writit('SERVO          - perform servo test');  
    if C220X or EAGLE then 
      writit('SERVO          - perform butterfly seek test'); 	    if ce_mode then 	      writit('SPARE          - spare block');      writit('TABLES         - output device tables');      writit('TERM           - input/output at terminal');     writit('UNIT           - set unit number');  
    if C2202 or EAGLE then 
      begin          writit('WRITECACHEOFF  - disables write cache');         writit('WRITECACHEON   - enables write cache');        end; 	    if ce_mode then 	$      writit('WTR ERT        - perform write-then-read error rate test'); $   END;         
PROCEDURE ZRFSECT $direct$; 
  var 
    j           : wordtype; 
     status_bits : erraptype; 
    temp        : bytetype; 
 
    rf_flag     : boolean; 
      begin      (************************************************)      (*  Get the passed data into the correct buffer *)      (************************************************)      for J := 0 to 279 do       iobuf.extablerarea.tbl[J] := buffer[J];      "    for J := 280 to 285 do                  (* get passed address *) "      comp.address.full_addr[J-280] := buffer[J];         addrmode := parms[3];      phy_sec := parms[4];         with IOBUF.EXRFSECTRAREA do       begin          if C220X or EAGLE then            begin (* reorder header bytes *)              temp  := status;  status := pcyl1;              pcyl1 := pcyl2;   pcyl2  := spare;              spare := temp;    temp   := psect;             psect := head;    head   := temp;            end; (* of reorder header bytes *)              status_bits.allbits := status;     	        writeln(f); 	         rf_flag := true;         prntaddr(comp.address,rf_flag);           if NOT C220X and NOT EAGLE and NOT status_bits.b[0] then            writeln(f,'Sector sync bit missing');             write(f,'Physical spare = ');          if C220X or EAGLE then            writeln(f,spare:3)          else            writeln(f,(status mod 128):3);             writeln(f,'Physical sector  = ',psect:3);         writeln(f,'Head = ',(head mod 16):2);          if C220X or EAGLE then  !          writeln(f,'Logical cylinder = ',(pcyl1 * 256 + pcyl2):4) !         else  "          writeln(f,'Physical cylinder = ',(pcyl2 * 256 + pcyl1):4); "            if NOT C220X and NOT EAGLE then           begin              writeln(f,'Logical spare = ',(spare mod 128):1);             if (status mod 128) <> 1 then 	              begin 	$                write(f,'Sector ',(spare mod 128):1,' has been spared '); $                if spare < 128 then                    writeln(f,'(secondary)')  
                else 
                  writeln(f,'(primary)');               end              else                writeln(f,'No sector sparing has occurred');           end  (* not EAGLE or C220X *)          else            begin (* C220X or EAGLE *) "            if ((EAGLE and (spare = 123)) and (NOT status_bits.b[1])) " %            or ((C220X and (spare = 113)) and (NOT status_bits.b[1])) then %              writeln(f,'No sector sparing has occurred')              else 	              begin 	                 write(f,'Sector ',spare:1,' has been spared');                  if status_bits.b[1] then                    writeln(f,'(primary)')  
                else 
                  writeln(f,'(secondary)');  	              end; 	          end;  (* of EAGLE or C220X *)              for J := 1 to 256 do            if J mod 16 = 1 then             begin               writeln(f);               write(f,J:3,':  ');                writehex(DATA[J]);             end            else              writehex(data[J]);  
         writeln(f); 
 	      end;  {with} 	 
  end;  (* of rf sector *) 
     PROCEDURE ERROR_LOG $direct$ (logtype:wordtype);  !{****************************************************************} ! !{*  9-2-87  L. Doner  :  FIFO bit prints out for 795XA's only.  *} ! !{*                       Added T-OF for 795XB 's.               *} ! !{* 11-2-87  L. Doner  :  For 791X and 793X drives, added a check*} ! !{*                       for bit.b[3] set. Print out 'UNC' if it*} ! !{*                       is. (First retry did not get data.)    *} ! !{*  9-27-89 L. Doner  :  Added C220X.                           *} ! !{****************************************************************} !      var     bits    :erraptype; 	    buf     :char4; 	     x       :wordtype;       begin     (*********************************)  &    (* get buffer from passed string *) {197=run log, 198=ert log, in Exer1} &    (*********************************) %    if (logtype <> 197) and (logtype <> 198) then {called by ERT in father} %      for x := 0 to 10 do         info[x] := buffer[x];         space(2);      print_addr(4);     (* print logical address *)     space(2);      bits.allbits := info[8];     if ISP then       begin         if bits.b[7] and M795XA then buf := 'FIFO';         if bits.b[7] and M795XB then buf := 'T-OF';          if bits.b[6]           then buf := 'REC ';         if bits.b[5]           then buf := 'RET';          if bits.b[4] and (M794X or M795X) then buf:='ECC';         if bits.b[3] and (M7907 or M795X) then buf:='UNR ';         if bits.b[3] and  M794X           then buf:='UNC '; 
        write(F,buf); 
       end;      
    if C220X or EAGLE then 
      begin         case (info[8] mod 2) of           0: write(F,'COR ');           1: write(F,'UNC '); 
        end;  (* of case *) 
      end; (* of EAGLE *)     
    if M793X or M791X  then 
       begin  (* 793X/791X *)         if bits.b[0] then           write(f,'UNR ')          else         if bits.b[1] then           write(f,'F/S ')          else         if bits.b[3] then           write(f,'UNC ')          else         case (info[8] mod 4) of            0: if logtype = 197 then write(f,'CRC ')               else write(f,'COR ');           1: write(f,'UNC ');           2: write(f,'CRC ');           3: write(f,'CRC '); 
        end;  (* of case *) 
      end; (* of 793X/791X *)         space(5);     write(f,info[9]:3);  (* occurrence count *)     space(2);      wrt_binary(info[8]);     writeln(f);  
  end;  (* of error_log *) 
        
PROCEDURE ZFLTLOG $direct$; 
 %(************************************************************************) % %(*  9-28-89  L. Doner  :  Added C220X.                                  *) % %(************************************************************************) %      VAR     I        :wordtype;     J        :wordtype;     inum     :wordtype;      K        :erraptype; 
    activity :activitytype; 
      begin      (**********************************************)      (* Get parameters and buffer from data passed *)      (**********************************************)      if parms[3] = 0 then       print_paddr := true      else 
      print_paddr := false; 
         for I := 0 to 298 do       iobuf.extablerarea.tbl[I] := buffer[I];         with iobuf.exfltlograrea do       begin          if parms[4] = 1 then           begin             writeln(f,'# faults logged = ',parms[5]:1);             writeln(f);             fault_header;            end;          for i := 0 to flt[0]-1 do       { for each error }            begin (* display each fault *)  !            FOR inum := 0 TO 10 DO info[inum] := flt[I*11+inum+1]; !             if info[0] >= 128 then 	              begin 	                if print_paddr then                   begin                      write(F,' *');                      print_addr(0); 
                  end 
 
                else 
                   write(F,'  Physical address');               end              else 	              begin 	                space(2);                  print_addr(0);  	              end; 	             if info[4] >= 128 then                begin (* physical address *)                 if print_paddr then                   begin                      write(F,'   *');                      print_addr(4); 
                  end 
 
                else 
                   write(F,'    Physical address');                end  (* of physical address *)              else 	              begin 	                space(4);                  print_addr(4);  	              end; 	             if  ISP then 	              begin 	                space(6);                 writehex(info[8]);        (* error value *)                 if M7907 then                   begin                      space(8);  wrt_binary(info[9]);   (* stat1 *)                      space(3); 
                  end 
 
                else 
                  begin !                    space(9); writehex(info[9]);        (* stat1 *) !                    space(7);                    end;                 writehex(info[10]);       (* stat2 *)  	              end; 	             if C220X or RSP then                begin (* 791X or 793X or EAGLE or C220X *)                 space(3);                  if M793X or M791X then                   begin                     if info[10] <> 0 then                        write(F,'TERR ')                      else                       write(F,'DERR ');                     write(F,info[9]:3);       (* error value *)                     space(6);                     wrt_binary(info[8]);  (* HFR *) 
                  end 
 
                else 
                  begin  (* C220X or EAGLE *)                      case (info[10] mod 2) of                       0:  write(F,'DERR ');                       1:  write(F,'TERR ');                      end;                     write(F,info[9]:3);       (* error value *)                      case (info[10] mod 4) of                       0,1: write(F,' (E)');                       2,3: write(F,' (F)');                      end;                     space(2);                     wrt_binary(info[8]);  (* HFR *)                     space(5);                      with activity do 
                      begin 
                         activity_byte := info[10]; #                        write(F,nibble[0]:2);  (* activity indicator *) # 
                      end; 
                   end;   (* of C220X or EAGLE *)               end;  (* of C220X or 791X or 793X or EAGLE *)             writeln(F);  (* display line *)            end; (* of display each fault *)        end;    end;  (* of zfltlog *)         FUNCTION CHECKQSTAT $direct$ (print_status : boolean) :boolean;  $(**********************************************************************) $  (* 1-26-88  L. Doner  : Modified for son program. (print_status)   $(**********************************************************************) $  begin     if IOBUF.QSTAT=0 then        checkqstat := true      else       begin          if (IOBUF.QSTAT = 1) or (IOBUF.QSTAT = 2) then            if IOBUF.FQSTAT = 0 then             begin                if print_status then 
                begin 
#                  buffer[20] := 7;   {tell prntstatus call is from Son} #                  prntstatus;  
                end; 
            end            else             writeln(f,'Error during Request Status');          checkqstat := false;        end; 
  end;  (* of checkqstat *) 
         PROCEDURE DASH_WRITE $direct$;  var I :bytetype;   begin     for i := 0 to 60 do write(F,'-');     writeln(F);    end;          &FUNCTION DOUTIL $direct$(unum,utype,ulgn:wordtype;uparm1:bytetype) :boolean; &  begin         with IOBUF.EXMISCTAREA do       begin         UTILNUM  := UNUM;  
        UTILTYPE := UTYPE; 
        PARMLGN  := ULGN; 
        PARM1    := UPARM1; 
        EXLGN    := 1024;        end;      XUTIL(LU,DA,COMP,IOBUF);     doutil := checkqstat(true);    end;      PROCEDURE ZCACHE_CONTROL $direct$ (option:wordtype);  '(****************************************************************************) ' '(* 3-6-1987  L. Doner    Original version                                   *) ' '(* 1-28-1988  L. Doner   Moved to son to make father smaller. New Good_end  *) ' '(*                       Bad_end. No Outbuf. Added comp := nullcomp. Endit. *) ' '(****************************************************************************) ' '(* OPTION : Parameter passed to this procedure to indicate utility required.*) '(* ------ (*      1 : Read Cache On  
(*      2 : Read Cache Off 
 
(*      3 : Write Cache On 

(*      4 : Write Cache Off 
(*      5 : Read and write Cache On   (CACHEON)  (*      6 : Read and write Cache Off  (CACHEOFF)  '(****************************************************************************) 'var  	  endit : boolean; 	    	PROCEDURE Good_end; 	Begin   writeln(f);   writeln(f,'CACHE CONTROL UTILITY COMPLETED');   dash_write;    endit := true;  end;      	PROCEDURE Bad_end; 	Begin   writeln(f);    writeln(f,'CACHE CONTROL UTILITY FAILED');   dash_write;    endit := true;  end;     BEGIN   endit := false;  	  lu := buffer[0]; 	 	  da := buffer[1]; 	       init_comp;             { initialize complementary commands }   writeln(f);   dash_write;    case OPTION of      1,2:  writeln(f,'READ CACHE CONTROL UTILITY');     3,4:  writeln(f,'WRITE CACHE CONTROL UTILITY');     5,6:  writeln(f,'CACHE CONTROL UTILITY');    end;                                           {Read Cache Status}    if DOUTIL (196,2,1,7) then                                          {196 = Read Cache Status}                                           {  2 = Device send text }                                           {  1 = # parameters sent}                                           {  7 = Cache table area }         with IOBUF.CACHETABLEAREA do         begin  !          if ((option<>3) and (option<>4)) then    {Reading Cache} !            begin               case CACHE_READ_STATUS of                  0,1: writeln(f);  
                  3: begin 
                        writeln(f);  '                       writeln(f,'Read Cache disabled because of RAM error.'); '                       bad_end;                      end;  
                  2: begin 
                        writeln(f);                         writeln(f,'Read Cache is not installed.');                         bad_end;                      end; 
                  otherwise 
 
                     begin 
                        writeln(f);                        writeln(f,'Unknown Read Cache Status.');                        bad_end;                      end;               end; {case}               if NOT endit then 	              begin 	                if ((option=2) and (cache_write_status=0)) then                   begin                     writeln(f); !                    writeln(f,'Write Cache is currently enabled.'); !#                    writeln(f,'Write Cache must be disabled prior to ', #                    'disabling Read Cache.');                      bad_end;                    end;               end;  {Not endit}             end; {option <>3 and option<>4}     
          if NOT endit then 
          begin %            if ((option<>1) and (option<>2)) then        {Writing to cache} %               case CACHE_write_STATUS of                  0,1: writeln(f);  
                  3: begin 
                        writeln(f);  '                      writeln(f,'Write Cache disabled because of RAM error.'); '                       bad_end;                      end;  
                2,5: begin 
                        writeln(f);  !                       writeln(f,'Write Cache is not installed.'); !                       bad_end;                      end;                 otherwise  
                     begin 
                        writeln(f);                          writeln(f,'Unknown Write Cache status.');                         bad_end;                      end;               end; {case}             end;  {not endit}     
          if NOT endit then 
          begin  %            if ((option=1) or (option=5)) then    {Read Cache On, Cacheon} %              if((option=1) and (cache_read_status=0)) then 
                begin 
                   writeln(f,'Read Cache is already enabled.'); 
                  good_end; 
	                end 	 	              else 	                 if DOUTIL(211,0,1,1) then     {Enable read cache}  %                                              {211 : Cache Control Utility} %%                                              {  0 : No execution message } %%                                              {  1 : # parameters sent    } %%                                              {  1 : Read on, write off   } %                  begin                      writeln(f,'Read Cache is enabled.');                      if (option=1) then good_end; 
                  end 
 
                else 
                   bad_end;   {end if doutil} 
          end;  {Not endit} 
    
          if NOT endit then 
          begin  '            if ((option=3) or (option=5)) then       {Write Cache On, Cacheon} '	              begin 	                if ((option=3) and (cache_read_status<>0)) then                   begin  '                    writeln(f,'Read Cache must be enabled for Write Cache to', '                     ' be enabled.');                      bad_end;                    end;                 if NOT endit then 
                begin 
                   if ((option=3) and (cache_write_status=0)) then                      begin !                      writeln(f,'Write Cache is already enabled.'); !                      good_end;                     end $                  else                               {Enable write Cache} $                    if DOUTIL(211,0,1,3) then &                                                {211 : Cache Control Utility} &&                                                {  0 : No execution message } &&                                                {  1 : # parameters sent    } &&                                                {  3 : Read on, write on    } &
                      begin 
                        writeln(f,'Write Cache is enabled.');                         good_end;                       end                      else    {failed}                        bad_end;                  end; {Not endit}                end;  {option=3 or option=5}            end;   {Not endit}     
          if NOT endit then 
          begin  &            if ((option=4) or (option=6)) then             {write cache off} &              if ((option=4) and (cache_write_status=1)) then 
                begin 
                    writeln(f,'Write Cache is already disabled.');  
                  good_end; 
	                end 	"              else                              {Disable write Cache} "                if DOUTIL(211,0,1,1) then %                                              {211 : Cache Control Utility} %%                                              {  0 : No execution message } %%                                              {  1 : # parameters sent    } %%                                              {  1 : Read on, write off   } %                  begin                      writeln(f,'Write Cache is disabled.');                      if (option=4) then good_end; 
                  end 
                 else  {failed}  
                  bad_end; 

          end;  {Not endit} 
    
          if NOT endit then 
          begin  &            if ((option=2) or (option=6)) then    {Read cache off, Cacheoff} &               if ((option=2) and (cache_read_status=1)) then 
                begin 
                  writeln(f,'Read Cache is already disabled.'); 
                  good_end; 
	                end 	 	              else 	 "                if DOUTIL(211,0,1,0) then       {Disable Read Cache} "%                                              {211 : Cache Control Utility} %%                                              {  0 : No execution message } %%                                              {  1 : # parameters sent    } %%                                              {  0 : Read off, write off  } %                  begin                     writeln(f,'Read Cache is disabled.');                     good_end; 
                  end 
                else   {failed}                    bad_end;         {end if doutil} 
           end; {Not endit} 
         end      {with iobuf.cachetablearea}      else        bad_end; 
END;       {ZCACHE_CONTROL} 
         
PROCEDURE ZSERVO $direct$; 
 &(**************************************************************************) & &(*  8-20-89   L. Doner  : Moved code to son to make father smaller        *) & &(*                        Added Good_end and Bad_end.                     *) & &(*  9-01-89   L. Doner  : Deleted Good_end and Bad_end to save space.     *) & &(**************************************************************************) &    var 
  numseeks : integer; 

  numloop : bytetype; 
    BEGIN  (*ZSERVO*)    numloop := parms[3];  	  lu := buffer[0]; 	 	  da := buffer[1]; 	   init_comp;             { initialize complementary commands }   if doutil(191,2,1,numloop) then     with IOBUF.EXSERVOAREA do      begin               (*decode the bytes retrieved from xutil*)         numseeks := unumseeks;       numseeks := (numseeks * 256) + lnumseeks;       writeln(F);        case completionstatus of          0 : writeln(F,'Number of seeks completed = ',numseeks:1);           1 : writeln(F,'Seek Failure');          2 : writeln(F,'Position Failure');         3 : writeln(F,'Timeout Failure');        end;  (* case *)         begin 	        writeln(f); 	         writeln(f,'SERVO TEST UTILITY COMPLETED');        end;     end   (* of doutil *)    else     begin       writeln(f);       writeln(f,'SERVO TEST UTILITY FAILED');      end;   dash_write;      END;  {ZSERVO}         PROCEDURE ZLOGCACHE $direct$;  #(********************************************************************) #(*  9-01-89  L. Doner  : Moved code from Exer to Exer1. (*  9-25-89  L. Doner  : Added C2202.  #(********************************************************************) #  begin  
    lu := buffer[0]; 
 
    da := buffer[1]; 
     init_comp;           { initialize complementary commands }     if C2202 or EAGLE or M793X then       begin         if DOUTIL (190, 2, 0, 0) then            with IOBUF.CACHELOGAREA do             begin               writeln(F);               writeln(F,'Cache Memory Error Test Log');               writeln(F,'==========================='); #              writeln(F,'Number of cache memory correctable errors = ', #                          corrs:1); $              writeln(F,'Number of cache memory uncorrectable errors = ', $                          uncorrs:1);               writeln(f);                writeln(f,'READ CACHE ERROR LOG COMPLETED');             end            else  	             begin 	 
               writeln(f); 
                writeln(f,'READ CACHE ERROR LOG FAILED');              end; 	        dash_write; 	      end      else         begin  
         writeln(f); 
         writeln(f,'Command not supported for this device.');        end;    end;          PROCEDURE ZDATALOG $direct$; #(*********************************************************************) ##(* 6-12-87  L. Doner : Sent a code to Log_header to let it know to   *) ##(*                     print 'Error' above 'Count'.                  *) ##(* 8-23-89  L. Doner : Added errors and a check if no errors on all  *) ##(*                     heads, just print out 'no error' message.     *) ##(*                     This is for Northern Telecom, shortens output.*) ##(* 9-11-89  L. Doner : Moved code from Exer to Exer1.                *) ##(* 9-22-89  L. Doner : Added C220X.                                  *) ##(*********************************************************************) # (*  logtype of 197 = Run log  *)  (*  logtype of 198 = Ert log  *)  (******************************)       VAR 
    k           : wordtype; 
     logtype,     start_head, 
    end_head    : wordtype; 

    inum        : bytetype; 
     found_error,      bad_end,  
    errors      : boolean; 
      begin          logtype := parms[3]; 
    start_head := parms[4]; 
    end_head := parms[5];  
    lu := buffer[0]; 
 
    da := buffer[1]; 
         init_comp;         { initialize complementary commands }     found_error := false;  
    errors := false; 

    bad_end := false; 
     repeat             { for each head } $      if doutil(logtype,2,1,start_head) then with IOBUF.EXDATALOGRAREA do $         begin    (* display head info *) $        if (numaddr <> 0)  then  { if there are any errors on this head } $          begin 
            errors := true; 
            writeln(F);              writeln(F,'Head # = ',start_head:1); "            writeln(F,'# sectors read = ',numsect:1); {for each head} "             if C220X or RSP then 	              begin 	$                writeln(F,'Correctable errors = ',numcor:1);  {each head} $ %                writeln(F,'Uncorrectable errors = ',err[0]:1); {each head} % 	              end; 	"            if (numaddr > 0) then   {numaddr = number of log entries} "	              begin 	                 writeln(F,'Error addresses logged = ',numaddr:1);                   found_error := true; 
                writeln(F); 
                buffer[1] := 77;  {77 = print 'Occur' } 
                log_header; 
                 for K := 0 to numaddr-1 do                   begin   { display error byte info }                            { 10 bytes of data in every log entry }  $                    for inum := 0 to 9 do info[inum] := err[K*10+inum+1]; $                    error_log(logtype);                   end;    (* display error *)                end    (* of error address logged *)              else                writeln(f,'  No errors logged');           end   { if there are errors }          end   { of display head info }        else          bad_end := true;           start_head := start_head + 1;     until start_head > end_head;   { end of repeat loop }         if found_error and NOT bad_end then       begin 	        writeln(f); 	         ert_run_errors(logtype);        end;          if NOT errors and NOT found_error and NOT bad_end then       begin 	        writeln(f); 	         writeln(f,'  No errors logged');        end;     	    if bad_end then 	      parms[4] := 98    { bad end }      else        parms[4] := 99;   { good end }        end;   (* datalog *)      PROCEDURE CACHE_SIZE $direct$;  #(********************************************************************) # (*  9-27-89  L. Doner  : Creation.  #(********************************************************************) #    VAR 	   page  : integer; 	 
   csize : wordtype; 
    BEGIN  	  LU := buffer[0]; 	 	  DA := buffer[1]; 	 
  csize := parms[3]; 
     $  init_comp;                         {initialize complementary commands} $ &  if DOUTIL (212, 0, 1, csize) then            { 212 : Set Read Cache Size } & &    begin                                      {   0 : No execution message} & &      writeln(f);                              {   1 : # of parameters sent} & &      case csize of                            {csize: Read Cache page size} &        2 : page := 4096;         3 : page := 8192;  
        4 : page := 16384; 
 
        5 : page := 32768; 
      otherwise  	      end;  {case} 	       writeln(f,'Read Cache Page Size = ',page:1,' bytes.');       writeln(f);       writeln(f,'SET READ CACHE SIZE COMPLETED');     end 
  else   { command failed } 
    begin       writeln(f);        writeln(f,'SET READ CACHE SIZE FAILED');      end;   dash_write;  END;          FUNCTION RFEAGLE $direct$ : boolean; #(*********************************************************************) # !(*  9-28-89   L. Doner  : Creation. Do the Eagle Read Full Sector. ! #(*                        Do the zero length read before calling this. #(*                        Must set address before calling this. #(*********************************************************************) #    BEGIN    if C220X or EAGLE then     with IOBUF.EAGLERFAREA do     begin 
      utilnum := 163; 
 
      utiltype := 2; 
	      parmlgn := 6; 	       address.cylinder := comp.address.cylinder;        address.head     := comp.address.head;        address.sector   := comp.address.sector;        msg_len          := 300;  %      comp.address.sector := 0;     { can't leave a physical sector here } %      XUTIL(lu, da, comp, iobuf);       rfeagle := checkqstat(true);     {did it work or not}     end    else     writeln(f,'RFEAGLE is for the C220X and EAGLEs only.');      END;         PROCEDURE SPARESECS $direct$;  %(************************************************************************) %"(*  9-28-89  L. Doner  : Moved code from father, Exer, to son, Exer1. "(* 10-04-89  L. Doner  : Added C220X and Eagle. #(*  2-07-90  L. Doner  : Added rte6 and icon for locklu calls on RTE-6. # %(************************************************************************) %VAR      i,j,      maxcyl    : integer;      cyl,      cylinder  : cyltype;     hd,     flag1     : bytetype;      break,     failed,     sparesec,      anyspares : boolean;     rte6,     icon,     maxsec,     maxhead   : wordtype;      char9     : packed array [1..9] of char;      status_bits : erraptype;     BEGIN  	  LU := buffer[0]; 	 	  DA := buffer[1]; 		  rte6 := parms[3]; 	
  maxcyl := parms[4]; 
   maxhead := parms[5];       cyl := 0;    hd := 0;   flag1 := 0; 
  anyspares := false; 
  break := false;  	  failed := false; 	   init_comp;           { initialize complementary commands }    COMP.addressmode := 1;  { 3 vector } 
  COMP.address.sector := 0; 
   COMP.setlength := 1;    if M795XB then     COMP.length := 1      {1 block} 
  else   { C220X or EAGLE } 
    begin       COMP.length := 0;     {0 length read} 	      if EAGLE then 	
        maxsec := 123 
       else             { C220X }          maxsec := 113; 
    end; { C220X or EAGLE } 
      writeln(f);   writeln(f,'Location of spared sectors:');   writeln(f);    writeln(f,'      LOGICAL            SPARE');   writeln(f,'  CYL   HEAD  SECT       TYPE');   writeln(f,'==================      =========');   writeln(f);     
  repeat    {cylinder loop} 
    repeat  {head loop}       COMP.address.cylinder := cyl;        COMP.address.head := hd;        XLCRD(lu,da,comp,iobuf);           { Locate and Read } %      if checkqstat(true) then           { Locate and Read was successful } %      begin  
      if M795XB then 
      begin          if (rte6 = 0) then  { rtea } 	          icon := 1 	         else                { rte6 } $          icon := 2048 + 1;        { set bit 12 for disk locks on RTE-6 } $        locklu(icon,LU,1);  { lock the LU }           if doutil(213,2,0,0) then        { Read Headers = 213  }              with IOBUF.readheadr do        { 2 = device send text}            begin 	            i := 1; 		            j := 1; 	!            repeat                { Only 1 sector spared per track} !               if (data[j+5] = 255) then   { no errors in sector }                   if (data[j+3] = 255) then  { a spared sector }                   begin                      anyspares := true;                     flag1 := data[j+4];  &                                        {Sector's address is in next sector} &!                                        {because of sector shuffle} !                    j := j + 6;                      if (data[j] <> 0) then $                      cylinder := (((data[j] mod 128) * 256) + data[j+1]) $                     else                        cylinder := data[j+1];                      write(f,' ',cylinder:4);                     space(4);                     write(f,data[j+2]:2);                     space(4);                     write(f,data[j+3]:2);                     space(4);                      if (flag1 >= 128) then                       flag1 := flag1 - 128;                     if (flag1 >= 64) then                        flag1 := flag1 - 64;                     if (flag1 >= 32) then                        flag1 := flag1 - 32;                     if (flag1 >= 16) then                        flag1 := flag1 - 16;                      if (flag1 = 8) or (flag1 = 9) then                       writeln(f,'    PRIMARY');                      if (flag1 = 4) or (flag1 = 5) then                        writeln(f,'   SECONDARY');                   end; { spare sector }                    i := i + 1;     {Count sectors: 1 to 64}                   j := J + 6;     {Check next sector}                   if (ifbrk < 0) then                      break := true;             until (flag1 <> 0) or (i >= 64) or break;             flag1 := 0;           end  { With }          else            failed := true;   { Doutil }              if (rte6 = 0) then  { rtea } 	          icon := 0 	         else                { rte6 } 
          icon := 2048 + 0; 
         locklu(icon,LU,1);     { unlock the LU }  
      end   {M795XB} 
          else   {C220X or Eagle}       begin  
        sparesec := false; 
        if NOT rfeagle then     {Do the Read Full Sector}           failed := true;         with IOBUF.blitzrfarea do         begin            status_bits.allbits := status;  $          if (C220X and (spare = 113)) or (EAGLE and (spare = 123)) then $            begin  $              if status_bits.b[1] then   {bit 6 is set - primary sector} $                 begin                    {0..7 are reversed}                   sparesec := true;                   char9 := ' PRIMARY '; 	                end 	 %                    {The spare sector 113 or 123 can not be spared by the} % !            end     {Field as they can't spare a physical sector.} !          else    {There is a spare sector}             begin               sparesec := true; #              if status_bits.b[1] then  {bit 6 is set - primary sector} #                char9 := ' PRIMARY '    {0..7 are reversed}               else                    {bit 6 is 0 }                 char9 := 'SECONDARY';              end;  
          if sparesec then 
            begin                anyspares := true;                if (lcyl1 <> 0) then                 cylinder := (((lcyl1 mod 128) * 256) + lcyl2)  	              else 	                 cylinder := lcyl2; !              write(f,' ',cylinder:4,'    ',head:2,'    ',spare:3); !               if (spare = maxsec) then !                write(f,'*     ')    {this is a physical sector * } ! 	              else 	                space(6);                writeln(f,char9)              end;  {sparesec}            if (ifbrk < 0) then   { check for break flag } 
            break :=  true; 
        end;   {with iobuf.blitzrfarea}       end;   {C220X or Eagle  (for loop)}      
      end   { XLCRD good } 
     else       failed := true;     { XLCRD }     	      hd := hd + 1; 	     until (hd = maxhead + 1) or break or failed;     	    cyl := cyl + 1; 	     hd := 0;    until (cyl = maxcyl + 1) or break or failed;        if NOT anyspares and NOT break and NOT failed then     begin       writeln(f);       writeln(f,'There are no spare sectors.');      end;       writeln(f);   if break then     writeln(f,'READ SPARED SECTORS ABORTED');    if NOT failed and NOT break then     writeln(f,'READ SPARED SECTORS COMPLETED');    if failed then      writeln(f,'READ SPARED SECTORS FAILED');   dash_write;      END;         &(****************************************main*******************************) &    begin   {exer1}      	  M794X  := false; 	 	  M7907  := false; 	 	  M791X  := false; 	 	  M793X  := false; 	 	  M9140  := false; 	 	  M9144  := false; 	 	  EAGLE  := false; 	 	  M795X  := false; 	 	  C220X  := false; 	 	  C2202  := false; 	       get_parms(parms);   (* get passed parms *)  
  ce_mode := parms[3] = 1; 
   rewrite(crt,'1','shared');   cc := get_buf(-1,buffer,bufrlen); 
  for i := 1 to 64 do 
    outfile[i] := chr(buffer[i+299]);    if outfile[1] in ['1'..'9'] then     rewrite(f,outfile,'shared')    else     append(f,outfile,'shared');   (***************************************)   (* determine the model number of drive *)   (***************************************)  	  case parms[2] of 	     0: M794X  := true;      1: M7907  := true;      2: M791X  := true;      3: M793X  := true;      4: M9140  := true;      5: M9144  := true;      6: EAGLE  := true;      7: M795XA := true;      8: M795XB := true;      9: C220X  := true;     10: C2202  := true; 
  end;  (* of case *) 
      if M795XA or M795XB then M795X := true;    if C2202 then C220X := true;    ISP:= M7907 or M794X or M795X;    RSP:= M791X or M793X or EAGLE;  
  (**********************) 
 
  (*  determine command *) 
 
  (**********************) 
 	  case parms[1] of 	    1: ZHELP;  
    2: fault_header; 
 	    3: log_header; 	     4: hfr_bits;      5: ert_run_errors(parms[3]);  	    6: prntstatus; 	
    7: disp_cache_stat_tbl; 
     8: zsense;      9: zcache_control(parms[2]);      11: zrdtbls;      12: zrfsect;      13: error_log(parms[3]);      14: zfltlog;     15: zservo;  	    16: zlogcache; 	    17: zdatalog; 	    18: cache_size; 	 	    19: sparesecs; 	    otherwise       (* null *); 
  end;  (* of case *) 
 $  rewrite(f,'1','shared');  {this statement prevents printer page eject} $ 
  parms[1] := ifbrk; 
   prtn(parms);     {Return the parameters to the father}  end. 